/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.utils;

import com.sun.javafx.perf.PerformanceTracker;
import com.sun.management.OperatingSystemMXBean;
import de.gsi.chart.utils.FXUtilities;
import java.lang.management.ManagementFactory;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ExecutionException;
import javafx.animation.AnimationTimer;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.scene.Scene;

public class SimplePerformanceMeter
extends AnimationTimer {
    private OperatingSystemMXBean osBean = ManagementFactory.getPlatformMXBean(OperatingSystemMXBean.class);
    private static PerformanceTracker tracker;
    private final long[] frameTimes = new long[100];
    private int frameTimeIndex = 0;
    private boolean arrayFilled = false;
    private DoubleProperty averageFactor = new SimpleDoubleProperty((Object)this, "averageFactor", 0.01);
    private DoubleProperty frameRate = new SimpleDoubleProperty((Object)this, "frameRate", 0.0);
    private DoubleProperty avgFrameRate = new SimpleDoubleProperty((Object)this, "avgFrameRate", 0.0);
    private DoubleProperty trackerFrameRate = new SimpleDoubleProperty((Object)this, "trackerFrameRate", 0.0);
    private DoubleProperty avgTrackerFrameRate = new SimpleDoubleProperty((Object)this, "avgTrackerFrameRate", 0.0);
    private DoubleProperty processCpuLoad = new SimpleDoubleProperty((Object)this, "processCpuLoad", 0.0);
    private DoubleProperty minProcessCpuLoad = new SimpleDoubleProperty((Object)this, "minProcessCpuLoad", -1.0);
    private DoubleProperty avgProcessCpuLoad = new SimpleDoubleProperty((Object)this, "avgProcessCpuLoad", -1.0);
    private DoubleProperty maxProcessCpuLoad = new SimpleDoubleProperty((Object)this, "maxProcessCpuLoad", -1.0);
    private DoubleProperty systemCpuLoad = new SimpleDoubleProperty((Object)this, "systemCpuLoad", 0.0);
    private DoubleProperty avgSystemCpuLoad = new SimpleDoubleProperty((Object)this, "avgSystemCpuLoad", -1.0);
    private double frameRateLocal;

    public DoubleProperty averageFactorProperty() {
        return this.averageFactor;
    }

    public double getFxFrameRate() {
        return this.fxFrameRateProperty().get();
    }

    public ReadOnlyDoubleProperty fxFrameRateProperty() {
        return this.frameRate;
    }

    public double getAverageFxFrameRate() {
        return this.averageFxFrameRateProperty().get();
    }

    public ReadOnlyDoubleProperty averageFxFrameRateProperty() {
        return this.avgFrameRate;
    }

    public double getActualFrameRate() {
        return this.actualFrameRateProperty().get();
    }

    public ReadOnlyDoubleProperty actualFrameRateProperty() {
        return this.trackerFrameRate;
    }

    public double getAverageFrameRate() {
        return this.averageFrameRateProperty().get();
    }

    public ReadOnlyDoubleProperty averageFrameRateProperty() {
        return this.avgTrackerFrameRate;
    }

    public double getProcessCpuLoad() {
        return this.processCpuLoadProperty().get();
    }

    public ReadOnlyDoubleProperty processCpuLoadProperty() {
        return this.processCpuLoad;
    }

    public double getMinProcessCpuLoad() {
        return this.minProcessCpuLoadProperty().get();
    }

    public ReadOnlyDoubleProperty minProcessCpuLoadProperty() {
        return this.minProcessCpuLoad;
    }

    public double getAverageProcessCpuLoad() {
        return this.averageProcessCpuLoadProperty().get();
    }

    public double getMaxProcessCpuLoad() {
        return this.minProcessCpuLoadProperty().get();
    }

    public ReadOnlyDoubleProperty maxProcessCpuLoadProperty() {
        return this.maxProcessCpuLoad;
    }

    public ReadOnlyDoubleProperty averageProcessCpuLoadProperty() {
        return this.avgProcessCpuLoad;
    }

    public double getSystemCpuLoad() {
        return this.systemCpuLoadProperty().get();
    }

    public ReadOnlyDoubleProperty systemCpuLoadProperty() {
        return this.systemCpuLoad;
    }

    public double getAverageSystemCpuLoad() {
        return this.averageSystemCpuLoadProperty().get();
    }

    public ReadOnlyDoubleProperty averageSystemCpuLoadProperty() {
        return this.avgSystemCpuLoad;
    }

    public void handle(long now) {
        long oldFrameTime = this.frameTimes[this.frameTimeIndex];
        this.frameTimes[this.frameTimeIndex] = now;
        this.frameTimeIndex = (this.frameTimeIndex + 1) % this.frameTimes.length;
        if (this.frameTimeIndex == 0) {
            this.arrayFilled = true;
        }
        if (!this.arrayFilled) {
            return;
        }
        long elapsedNanos = now - oldFrameTime;
        long elapsedNanosPerFrame = elapsedNanos / (long)this.frameTimes.length;
        this.frameRateLocal = 1.0E9 / (double)elapsedNanosPerFrame;
    }

    private void updateProperties() {
        int nCores = this.osBean.getAvailableProcessors();
        this.frameRate.set(this.frameRateLocal);
        this.avgFrameRate.set((double)tracker.getAveragePulses());
        this.trackerFrameRate.set((double)tracker.getInstantFPS());
        this.avgTrackerFrameRate.set((double)tracker.getAverageFPS());
        this.processCpuLoad.set(this.osBean.getProcessCpuLoad() * 100.0 * (double)nCores);
        this.systemCpuLoad.set(this.osBean.getSystemCpuLoad() * 100.0 * (double)nCores);
        double alpha = this.averageFactor.get();
        double oldProcessLoad = this.avgProcessCpuLoad.get();
        if (oldProcessLoad < 0.0) {
            this.avgProcessCpuLoad.set(this.processCpuLoad.get());
        } else {
            this.avgProcessCpuLoad.set((1.0 - alpha) * oldProcessLoad + alpha * this.processCpuLoad.get());
        }
        if (this.minProcessCpuLoad.get() < 0.0) {
            this.minProcessCpuLoad.set(this.processCpuLoad.get());
        } else {
            this.minProcessCpuLoad.set(Math.min(this.minProcessCpuLoad.get(), this.processCpuLoad.get()));
        }
        if (this.maxProcessCpuLoad.get() < 0.0) {
            this.maxProcessCpuLoad.set(this.processCpuLoad.get());
        } else {
            this.maxProcessCpuLoad.set(Math.max(this.maxProcessCpuLoad.get(), this.processCpuLoad.get()));
        }
        double oldSystemLoad = this.avgSystemCpuLoad.get();
        if (oldSystemLoad < 0.0) {
            this.avgSystemCpuLoad.set(this.systemCpuLoad.get());
        } else {
            this.avgSystemCpuLoad.set((1.0 - alpha) * oldSystemLoad + alpha * this.systemCpuLoad.get());
        }
    }

    public void resetAverages() {
        tracker.resetAveragePulses();
        tracker.resetAverageFPS();
        this.minProcessCpuLoad.set(-1.0);
        this.avgProcessCpuLoad.set(-1.0);
        this.maxProcessCpuLoad.set(-1.0);
        this.avgSystemCpuLoad.set(-1.0);
    }

    public SimplePerformanceMeter(Scene scene, long updateDuration) {
        tracker = PerformanceTracker.getSceneTracker((Scene)scene);
        this.start();
        Timer timer = new Timer();
        timer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                try {
                    FXUtilities.runLater(() -> SimplePerformanceMeter.this.updateProperties());
                }
                catch (ExecutionException executionException) {
                    // empty catch block
                }
            }
        }, 0L, updateDuration);
    }
}

