/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.renderer.spi.utils;

import de.gsi.chart.renderer.spi.utils.FillPatternStyle;
import de.gsi.chart.utils.StyleParser;
import de.gsi.dataset.utils.AssertUtils;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.paint.Color;
import javafx.scene.paint.ImagePattern;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;

public final class DefaultRenderColorScheme {
    private static final DefaultRenderColorScheme SELF = new DefaultRenderColorScheme();
    public static final String DEFAULT_FONT = "Helvetia";
    public static final int DEFAULT_FONT_SIZE = 18;
    public static final Color[] MISC = new Color[]{Color.valueOf((String)"#5DA5DA"), Color.valueOf((String)"#F15854"), Color.valueOf((String)"#FAA43A"), Color.valueOf((String)"#60BD68"), Color.valueOf((String)"#F17CB0"), Color.valueOf((String)"#B2912F"), Color.valueOf((String)"#B276B2"), Color.valueOf((String)"#DECF3F"), Color.valueOf((String)"#4D4D4D")};
    public static final Color[] ADOBE = new Color[]{Color.valueOf((String)"#00a4e4"), Color.valueOf((String)"#ff0000"), Color.valueOf((String)"#fbb034"), Color.valueOf((String)"#ffdd00"), Color.valueOf((String)"#c1d82f"), Color.valueOf((String)"#8a7967"), Color.valueOf((String)"#6a737b")};
    public static final Color[] TUNEVIEWER = new Color[]{Color.valueOf((String)"#0000c8"), Color.valueOf((String)"#c80000"), Color.valueOf((String)"#00c800"), Color.ORANGE, Color.MAGENTA, Color.CYAN, Color.DARKGRAY, Color.PINK, Color.BLACK};
    private static final Color[] COLORS = TUNEVIEWER;
    private static Paint[] fillStyles;
    private static double defaultLineWidth;
    private static double lineWidth;
    private static double hatchShiftByIndex;

    private DefaultRenderColorScheme() {
    }

    private static synchronized void init() {
        if (fillStyles != null) {
            return;
        }
        fillStyles = new Paint[COLORS.length];
        for (int i = 0; i < COLORS.length; ++i) {
            DefaultRenderColorScheme.fillStyles[i] = FillPatternStyle.getDefaultHatch((Paint)COLORS[i].brighter(), (double)i * hatchShiftByIndex);
        }
    }

    private static Color getColorModifier(Map<String, List<String>> parameterMap, Color orignalColor) {
        Color color = orignalColor;
        List<String> intensityModifier = parameterMap.get("intensity".toLowerCase(Locale.UK));
        if (color != null && intensityModifier != null && !intensityModifier.isEmpty()) {
            try {
                double intensity = Double.parseDouble(intensityModifier.get(0));
                color = color.deriveColor(0.0, intensity / 100.0, 1.0, intensity / 100.0);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return color;
    }

    public static Color getColor(int index) {
        AssertUtils.gtEqThanZero((String)"color index", (int)index);
        DefaultRenderColorScheme.init();
        return COLORS[index % COLORS.length];
    }

    public static Paint getFill(int index) {
        AssertUtils.gtEqThanZero((String)"fillStyles index", (int)index);
        DefaultRenderColorScheme.init();
        return fillStyles[index % fillStyles.length];
    }

    public static void setGraphicsContextAttributes(GraphicsContext gc, String style) {
        double[] dashPattern;
        Font font;
        Double strokeWidth;
        Color fillColor;
        if (gc == null || style == null) {
            return;
        }
        Color strokeColor = StyleParser.getColorPropertyValue(style, "strokeColor");
        if (strokeColor != null) {
            gc.setStroke((Paint)strokeColor);
        }
        if ((fillColor = StyleParser.getColorPropertyValue(style, "fillColor")) != null) {
            gc.setFill((Paint)fillColor);
        }
        if ((strokeWidth = StyleParser.getFloatingDecimalPropertyValue(style, "strokeWidth")) != null) {
            gc.setLineWidth(strokeWidth.doubleValue());
        }
        if ((font = StyleParser.getFontPropertyValue(style)) != null) {
            gc.setFont(font);
        }
        if ((dashPattern = StyleParser.getFloatingDecimalArrayPropertyValue(style, "strokeDashPattern")) != null) {
            gc.setLineDashes(dashPattern);
        }
    }

    public static void setLineScheme(GraphicsContext gc, String defaultStyle, int dsIndex) {
        AssertUtils.gtEqThanZero((String)"setLineScheme dsIndex", (int)dsIndex);
        DefaultRenderColorScheme.init();
        Map<String, List<String>> map = DefaultRenderColorScheme.splitQuery(defaultStyle);
        Color lineColor = StyleParser.getColorPropertyValue(defaultStyle, "strokeColor");
        Color rawColor = lineColor == null ? DefaultRenderColorScheme.getColor(dsIndex) : lineColor;
        gc.setLineWidth(lineWidth);
        gc.setFill(DefaultRenderColorScheme.getFill(dsIndex));
        gc.setStroke((Paint)DefaultRenderColorScheme.getColorModifier(map, rawColor));
    }

    public static void setFillScheme(GraphicsContext gc, String defaultStyle, int dsIndex) {
        AssertUtils.gtEqThanZero((String)"setFillScheme dsIndex", (int)dsIndex);
        Map<String, List<String>> map = DefaultRenderColorScheme.splitQuery(defaultStyle);
        Color fillColor = StyleParser.getColorPropertyValue(defaultStyle, "fillColor");
        Color rawColor = fillColor == null ? DefaultRenderColorScheme.getColor(dsIndex) : fillColor;
        Color color = DefaultRenderColorScheme.getColorModifier(map, rawColor);
        if (color == null) {
            return;
        }
        ImagePattern hatch = FillPatternStyle.getDefaultHatch((Paint)color.brighter(), (double)dsIndex * hatchShiftByIndex);
        gc.setFill((Paint)hatch);
    }

    public static void setMarkerScheme(GraphicsContext gc, String defaultStyle, int dsIndex) {
        AssertUtils.gtEqThanZero((String)"setMarkerScheme dsIndex", (int)dsIndex);
        Map<String, List<String>> map = DefaultRenderColorScheme.splitQuery(defaultStyle);
        Color color = DefaultRenderColorScheme.getColorModifier(map, DefaultRenderColorScheme.getColor(dsIndex));
        gc.setLineWidth(defaultLineWidth);
        gc.setStroke((Paint)color);
        gc.setFill((Paint)color);
    }

    private static Map<String, List<String>> splitQuery(String styleString) {
        if (styleString == null || styleString.isEmpty()) {
            return Collections.emptyMap();
        }
        return Arrays.stream(styleString.split(";")).map(SELF::splitQueryParameter).collect(Collectors.groupingBy(AbstractMap.SimpleImmutableEntry::getKey, LinkedHashMap::new, Collectors.mapping(Map.Entry::getValue, Collectors.toList())));
    }

    private AbstractMap.SimpleImmutableEntry<String, String> splitQueryParameter(String it) {
        int idx = it.indexOf(61);
        String key = idx > 0 ? it.substring(0, idx) : it;
        String value = idx > 0 && it.length() > idx + 1 ? it.substring(idx + 1) : null;
        return new AbstractMap.SimpleImmutableEntry<String, Object>(key, value);
    }

    static {
        defaultLineWidth = 0.5;
        lineWidth = 1.5;
        hatchShiftByIndex = 1.5;
    }
}

