/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.renderer.spi.utils;

public final class BezierCurve {
    private BezierCurve() {
    }

    public static void calcCurveControlPoints(double[] xData, double[] yData, double[] xControlPoint1, double[] yControlPoint1, double[] xControlPoint2, double[] yControlPoint2, int length) {
        int n = length - 1;
        if (n == 1) {
            xControlPoint1[0] = (2.0 * xData[0] + xData[1]) / 3.0;
            yControlPoint1[0] = (2.0 * yData[0] + yData[1]) / 3.0;
            xControlPoint2[0] = 2.0 * xControlPoint1[0] - xData[0];
            yControlPoint2[0] = 2.0 * yControlPoint1[0] - yData[0];
            return;
        }
        double[] rhs = new double[n];
        for (int i = 1; i < n - 1; ++i) {
            rhs[i] = 4.0 * xData[i] + 2.0 * xData[i + 1];
        }
        rhs[0] = xData[0] + 2.0 * xData[1];
        rhs[n - 1] = (8.0 * xData[n - 1] + xData[n]) / 2.0;
        double[] x = BezierCurve.getFirstControlPoints(rhs);
        for (int i = 1; i < n - 1; ++i) {
            rhs[i] = 4.0 * yData[i] + 2.0 * yData[i + 1];
        }
        rhs[0] = yData[0] + 2.0 * yData[1];
        rhs[n - 1] = (8.0 * yData[n - 1] + yData[n]) / 2.0;
        double[] y = BezierCurve.getFirstControlPoints(rhs);
        System.arraycopy(x, 0, xControlPoint1, 0, n);
        System.arraycopy(y, 0, yControlPoint1, 0, n);
        for (int i = 0; i < n; ++i) {
            if (i < n - 1) {
                xControlPoint2[i] = 2.0 * xData[i + 1] - x[i + 1];
                yControlPoint2[i] = 2.0 * yData[i + 1] - y[i + 1];
                continue;
            }
            xControlPoint2[i] = (xData[n] + x[n - 1]) / 2.0;
            yControlPoint2[i] = (yData[n] + y[n - 1]) / 2.0;
        }
    }

    private static double[] getFirstControlPoints(double[] rhs) {
        int i;
        int n = rhs.length;
        double[] x = new double[n];
        double[] tmp = new double[n];
        double b = 2.0;
        x[0] = rhs[0] / b;
        for (i = 1; i < n; ++i) {
            tmp[i] = 1.0 / b;
            b = (i < n - 1 ? 4.0 : 3.5) - tmp[i];
            x[i] = (rhs[i] - x[i - 1]) / b;
        }
        for (i = 1; i < n; ++i) {
            int n2 = n - i - 1;
            x[n2] = x[n2] - tmp[n - i] * x[n - i];
        }
        return x;
    }
}

