/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.renderer.spi.marchingsquares;

import de.gsi.chart.renderer.spi.marchingsquares.Cell;
import de.gsi.chart.renderer.spi.marchingsquares.GeneralPath;
import de.gsi.chart.renderer.spi.marchingsquares.Grid;
import de.gsi.chart.renderer.spi.marchingsquares.PathGenerator;
import de.gsi.dataset.utils.ProcessingProfiler;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class MarchingSquares {
    private static final ExecutorService ES = Executors.newCachedThreadPool();
    private double[] isovalues;

    private static Grid contour(double[][] data, double isovalue) {
        int rowCount = data.length;
        int colCount = data[0].length;
        Cell[][] cells = new Cell[rowCount - 1][colCount - 1];
        for (int r = 0; r < rowCount - 1; ++r) {
            for (int c = 0; c < colCount - 1; ++c) {
                int ndx = 0;
                double tl = data[r + 1][c];
                double tr = data[r + 1][c + 1];
                double br = data[r][c + 1];
                double bl = data[r][c];
                ndx |= tl > isovalue ? 0 : 8;
                ndx |= tr > isovalue ? 0 : 4;
                ndx |= br > isovalue ? 0 : 2;
                int n = bl > isovalue ? 0 : 1;
                boolean flipped = false;
                if ((ndx |= n) == 5 || ndx == 10) {
                    double center = (tl + tr + br + bl) / 4.0;
                    if (ndx == 5 && center < isovalue) {
                        flipped = true;
                    } else if (ndx == 10 && center < isovalue) {
                        flipped = true;
                    }
                }
                if (ndx == 0 || ndx == 15) continue;
                float left = 0.5f;
                float top = 0.5f;
                float right = 0.5f;
                float bottom = 0.5f;
                switch (ndx) {
                    case 1: 
                    case 14: {
                        left = (float)((isovalue - bl) / (tl - bl));
                        bottom = (float)((isovalue - bl) / (br - bl));
                        break;
                    }
                    case 2: 
                    case 13: {
                        bottom = (float)((isovalue - bl) / (br - bl));
                        right = (float)((isovalue - br) / (tr - br));
                        break;
                    }
                    case 3: 
                    case 12: {
                        left = (float)((isovalue - bl) / (tl - bl));
                        right = (float)((isovalue - br) / (tr - br));
                        break;
                    }
                    case 4: 
                    case 11: {
                        top = (float)((isovalue - tl) / (tr - tl));
                        right = (float)((isovalue - br) / (tr - br));
                        break;
                    }
                    case 5: 
                    case 10: {
                        left = (float)((isovalue - bl) / (tl - bl));
                        bottom = (float)((isovalue - bl) / (br - bl));
                        top = (float)((isovalue - tl) / (tr - tl));
                        right = (float)((isovalue - br) / (tr - br));
                        break;
                    }
                    case 6: 
                    case 9: {
                        bottom = (float)((isovalue - bl) / (br - bl));
                        top = (float)((isovalue - tl) / (tr - tl));
                        break;
                    }
                    case 7: 
                    case 8: {
                        left = (float)((isovalue - bl) / (tl - bl));
                        top = (float)((isovalue - tl) / (tr - tl));
                        break;
                    }
                    default: {
                        String m = "Unexpected cell index " + ndx;
                        throw new IllegalStateException(m);
                    }
                }
                cells[r][c] = new Cell(ndx, flipped, left, top, right, bottom);
            }
        }
        Grid result = new Grid(cells, isovalue);
        return result;
    }

    private static double[][] pad(double[][] data, double guard) {
        int i;
        int rowCount = data.length;
        int colCount = data[0].length;
        double[][] result = new double[rowCount + 2][colCount + 2];
        for (int j = 0; j < colCount + 2; ++j) {
            result[0][j] = guard;
            result[rowCount + 1][j] = guard;
        }
        for (i = 1; i < rowCount + 1; ++i) {
            result[i][0] = guard;
            result[i][colCount + 1] = guard;
        }
        for (i = 0; i < rowCount; ++i) {
            System.arraycopy(data[i], 0, result[i + 1], 1, colCount);
        }
        return result;
    }

    public GeneralPath[] buildContours(double[][] data, double[] levels) throws InterruptedException, ExecutionException {
        long start = ProcessingProfiler.getTimeStamp();
        double min = Double.MAX_VALUE;
        double max = -1.7976931348623157E308;
        int rowCount = data.length;
        int colCount = data[0].length;
        for (int i = 0; i < rowCount; ++i) {
            for (int j = 0; j < colCount; ++j) {
                double here = data[i][j];
                min = Math.min(min, here);
                max = Math.max(max, here);
            }
        }
        this.isovalues = new double[levels.length];
        System.arraycopy(levels, 0, this.isovalues, 0, levels.length);
        GeneralPath[] result = null;
        if (min == max) {
            String m = "All values are equal. Cannot build contours for a constant field";
            throw new IllegalArgumentException("All values are equal. Cannot build contours for a constant field");
        }
        double guard = min - 1.0;
        double[][] padded = MarchingSquares.pad(data, guard);
        result = this.doConcurrent(padded);
        ProcessingProfiler.getTimeDiff((long)start, (String)("built " + levels.length + " contours"));
        return result;
    }

    private GeneralPath[] doConcurrent(double[][] data) throws InterruptedException, ExecutionException {
        ArrayList<Task> workers = new ArrayList<Task>();
        for (int i = 0; i < this.isovalues.length; ++i) {
            workers.add(new Task(i, data, this.isovalues[i]));
        }
        List jobs = ES.invokeAll(workers);
        GeneralPath[] result = new GeneralPath[this.isovalues.length];
        for (Future future : jobs) {
            Result r = (Result)future.get();
            result[((Result)r).ndx] = r.path;
        }
        return result;
    }

    private final class Task
    implements Callable<Result> {
        private final int ndx;
        private final double[][] data;
        private final double level;

        Task(int ndx, double[][] data, double level) {
            this.ndx = ndx;
            this.data = data;
            this.level = level;
        }

        @Override
        public Result call() throws Exception {
            GeneralPath path = null;
            try {
                path = new PathGenerator().generalPath(MarchingSquares.contour(this.data, this.level));
            }
            catch (Exception x) {
                String m = "Failed making contour at index #" + this.ndx + " for level " + this.level + ": " + x.getLocalizedMessage();
                throw new IllegalArgumentException(m, x);
            }
            return new Result(this.ndx, path);
        }
    }

    private static final class Result {
        private final int ndx;
        private final GeneralPath path;
        private String str;

        Result(int ndx, GeneralPath path) {
            this.ndx = ndx;
            this.path = path;
        }

        public String toString() {
            if (this.str == null) {
                this.str = "Result{ndx=" + this.ndx + ", bbox=" + '}';
            }
            return this.str;
        }
    }
}

