/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.renderer.spi.hexagon;

import de.gsi.chart.renderer.spi.hexagon.GridDrawer;
import de.gsi.chart.renderer.spi.hexagon.GridPosition;
import de.gsi.chart.renderer.spi.hexagon.Hexagon;
import de.gsi.chart.renderer.spi.hexagon.HexagonCallback;
import de.gsi.chart.renderer.spi.hexagon.IHexagonCreator;
import de.gsi.chart.renderer.spi.hexagon.IPathInfoSupplier;
import de.gsi.chart.renderer.spi.hexagon.MapGenerator;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import javafx.event.EventHandler;
import javafx.scene.Group;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.image.Image;
import javafx.scene.input.MouseEvent;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;

public class HexagonMap {
    final int hexagonSize;
    int graphicsXpadding = 0;
    int graphicsYpadding = 0;
    private MapGenerator mapGenerator;
    boolean renderCoordinates = false;
    private final GridDrawer gridDrawer = new GridDrawer(this);
    private final HashMap<GridPosition, Hexagon> hexagons = new HashMap();
    List<HexagonCallback> onHexClickedCallback = new LinkedList<HexagonCallback>();
    List<HexagonCallback> onHexEnteredCallback = new LinkedList<HexagonCallback>();
    List<HexagonCallback> onHexExitCallback = new LinkedList<HexagonCallback>();

    public HexagonMap(int hexagonSize) {
        this.hexagonSize = hexagonSize;
    }

    public HexagonMap(int hexagonSize, Image image, int mapWidthInHexes) {
        this.hexagonSize = hexagonSize;
        this.mapGenerator = new MapGenerator(this, image, mapWidthInHexes);
        this.mapGenerator.generate((q, r, imagePixelColor, map) -> {
            Hexagon h = new Hexagon(q, r);
            h.setBackgroundColor(imagePixelColor);
            map.addHexagon(h);
        });
    }

    public HexagonMap(int hexagonSize, Image image, int mapWidthInHexes, IHexagonCreator hexagonCreator) {
        this.hexagonSize = hexagonSize;
        this.mapGenerator = new MapGenerator(this, image, mapWidthInHexes);
        this.mapGenerator.generate(hexagonCreator);
    }

    public void setPadding(int left, int top) {
        this.graphicsXpadding = left;
        this.graphicsYpadding = top;
        for (Hexagon h : this.getAllHexagons()) {
            h.getPoints().removeAll((Collection)h.getPoints());
            h.init();
        }
    }

    public double getPaddingX() {
        return this.graphicsXpadding;
    }

    public double getPaddingY() {
        return this.graphicsYpadding;
    }

    private double getGraphicsHexagonWidth() {
        return Math.sqrt(3.0) / 2.0 * (double)this.hexagonSize * 2.0;
    }

    public int getGraphicsHexagonHeight() {
        return this.hexagonSize * 2;
    }

    public double getGraphicsHorizontalDistanceBetweenHexagons() {
        return this.getGraphicsHexagonWidth();
    }

    public double getGraphicsverticalDistanceBetweenHexagons() {
        return 0.75 * (double)this.hexagonSize * 2.0;
    }

    public Hexagon addHexagon(Hexagon hexagon) {
        hexagon.setMap(this);
        this.hexagons.put(hexagon.position, hexagon);
        return hexagon;
    }

    public void removeHexagon(Hexagon hexagon) {
        hexagon.setMap(null);
        this.hexagons.remove(hexagon.position);
    }

    public Hexagon getHexagonContainingPixel(int x, int y) {
        return this.getHexagon(GridDrawer.pixelToPosition(x, y, this.getGraphicsHexagonHeight(), this.graphicsXpadding, this.graphicsYpadding));
    }

    public Hexagon getHexagon(int q, int r) {
        GridPosition position = new GridPosition(q, r);
        Hexagon result = this.hexagons.get(position);
        return result;
    }

    Hexagon getHexagon(GridPosition position) {
        return this.getHexagon(position.q, position.r);
    }

    Hexagon getHexagonByCube(int x, int y, int z) {
        return this.getHexagon(x, z);
    }

    public Collection<Hexagon> getAllHexagons() {
        return this.hexagons.values();
    }

    public Optional<Double> getImageMapHorizontalRelation() {
        return this.mapGenerator == null ? Optional.empty() : this.mapGenerator.getHorizontalRelation();
    }

    public Optional<Double> getImageMapVerticalRelation() {
        return this.mapGenerator == null ? Optional.empty() : this.mapGenerator.getVerticalRelation();
    }

    public void setRenderCoordinates(boolean b) {
        this.renderCoordinates = b;
    }

    public void setRenderFont(Font font) {
        this.gridDrawer.setFont(font);
    }

    public void render(Group group) {
        this.gridDrawer.draw(group);
    }

    public void render(Canvas canvas) {
        this.gridDrawer.draw(canvas);
    }

    public void renderContour(Canvas canvas) {
        this.gridDrawer.drawContour(canvas);
    }

    public void setOnHexagonClickedCallback(HexagonCallback callback) {
        this.onHexClickedCallback.add(callback);
    }

    public void setOnHexagonEnteredCallback(HexagonCallback callback) {
        this.onHexEnteredCallback.add(callback);
    }

    public void setOnHexagonExitCallback(HexagonCallback callback) {
        this.onHexExitCallback.add(callback);
    }

    public void registerCanvasMouseLiner(final Canvas canvas) {
        canvas.addEventFilter(MouseEvent.MOUSE_MOVED, (EventHandler)new EventHandler<MouseEvent>(){
            Hexagon oldHexagon = null;

            public void handle(MouseEvent me) {
                int y;
                GraphicsContext gc = canvas.getGraphicsContext2D();
                int x = (int)me.getX();
                Hexagon hexagon = HexagonMap.this.getHexagonContainingPixel(x, y = (int)me.getY());
                if (hexagon != null) {
                    if ((this.oldHexagon != null || hexagon == null) && hexagon.equals((Object)this.oldHexagon) || this.oldHexagon != null) {
                        // empty if block
                    }
                    if (this.oldHexagon != null) {
                        gc.save();
                        gc.setFill(this.oldHexagon.getFill());
                        gc.setStroke(this.oldHexagon.getStroke());
                        this.oldHexagon.drawHexagon(gc);
                        gc.restore();
                    }
                } else {
                    if (this.oldHexagon != null) {
                        gc.save();
                        gc.setFill(this.oldHexagon.getFill());
                        gc.setStroke(this.oldHexagon.getStroke());
                        this.oldHexagon.drawHexagon(gc);
                        gc.restore();
                    }
                    this.oldHexagon = null;
                    return;
                }
                this.oldHexagon = hexagon;
                gc.save();
                gc.setFill((Paint)Color.YELLOW.darker());
                gc.setStroke(hexagon.getStroke());
                hexagon.drawHexagon(gc);
                gc.restore();
            }
        });
    }

    static class DefaultPathInfoSupplier
    implements IPathInfoSupplier {
        DefaultPathInfoSupplier() {
        }

        @Override
        public boolean isBlockingPath(Hexagon hexagon) {
            return hexagon == null || hexagon.isBlockingPath();
        }

        @Override
        public int getMovementCost(Hexagon from, Hexagon to) {
            return 1;
        }
    }

    public static enum Direction {
        NORTHWEST,
        NORTHEAST,
        EAST,
        SOUTHEAST,
        SOUTHWEST,
        WEST;

    }
}

