/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.renderer.spi.hexagon;

import de.gsi.chart.renderer.spi.hexagon.Calculations;
import de.gsi.chart.renderer.spi.hexagon.GridPosition;
import de.gsi.chart.renderer.spi.hexagon.HexagonMap;
import de.gsi.chart.renderer.spi.hexagon.IPathInfoSupplier;
import de.gsi.chart.renderer.spi.hexagon.NoPathFoundException;
import java.util.ArrayList;
import java.util.List;
import javafx.application.Platform;
import javafx.collections.ObservableList;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Polygon;
import javafx.scene.text.Text;

public class Hexagon
extends Polygon {
    final GridPosition position;
    private HexagonMap map;
    private boolean isVisualObstacle;
    private boolean isBlockingPath;
    int aStarGscore;
    int aStarFscore;
    Hexagon aStarCameFrom;
    private int graphicsXoffset;
    private int graphicsYoffset;
    private static double[] sinAngle = new double[]{0.5 * Math.sqrt(3.0), 0.5 * Math.sqrt(3.0), 0.0, -0.5 * Math.sqrt(3.0), -0.5 * Math.sqrt(3.0), 0.0, 0.5 * Math.sqrt(3.0)};
    private static double[] cosAngle = new double[]{0.5, -0.5, -1.0, -0.5, 0.5, 1.0, 0.5};

    public Hexagon(int q, int r) {
        this.position = new GridPosition(q, r);
        this.setStroke((Paint)Color.DARKGRAY);
        this.setFill((Paint)Color.GREY);
    }

    void init() {
        for (double p : this.calculatePolygonPoints()) {
            this.getPoints().add((Object)p);
        }
    }

    public int getQ() {
        return this.position.q;
    }

    public int getR() {
        return this.position.r;
    }

    public void setIsVisualObstacle(boolean b) {
        this.isVisualObstacle = b;
    }

    public boolean isVisualObstacle() {
        return this.isVisualObstacle;
    }

    public void setIsBlockingPath(boolean b) {
        this.isBlockingPath = b;
    }

    public boolean isBlockingPath() {
        return this.isBlockingPath;
    }

    private double[] calculatePolygonPoints() {
        this.checkMap();
        int graphicsHeight = this.map.hexagonSize * 2;
        double graphicsWidth = Math.sqrt(3.0) / 2.0 * (double)graphicsHeight;
        this.graphicsXoffset = (int)(graphicsWidth * (double)this.position.q + 0.5 * graphicsWidth * (double)this.position.r);
        this.graphicsYoffset = (int)(0.75 * (double)graphicsHeight * (double)this.position.r);
        this.graphicsXoffset += this.map.graphicsXpadding;
        this.graphicsYoffset += this.map.graphicsYpadding;
        double[] polyPoints = new double[12];
        for (int i = 0; i < 6; ++i) {
            polyPoints[i * 2] = (double)this.graphicsXoffset + (double)this.map.hexagonSize * sinAngle[i];
            polyPoints[i * 2 + 1] = (double)this.graphicsYoffset + (double)this.map.hexagonSize * cosAngle[i];
        }
        return polyPoints;
    }

    public int getGraphicsXoffset() {
        if (this.graphicsXoffset == 0) {
            this.calculatePolygonPoints();
        }
        return this.graphicsXoffset;
    }

    public int getGraphicsYoffset() {
        if (this.graphicsYoffset == 0) {
            this.calculatePolygonPoints();
        }
        return this.graphicsYoffset;
    }

    public void setBackgroundColor(Color c) {
        Platform.runLater((Runnable)new UIupdater(this, c));
    }

    public String toString() {
        return "Hexagon q:" + this.position.q + " r:" + this.position.r;
    }

    public HexagonMap.Direction getDirectionTo(Hexagon target) {
        return this.position.getDirectionTo(target.position);
    }

    public List<Hexagon> getHexagonsOnRingEdge(int radius) {
        this.checkMap();
        return Calculations.getHexagonsOnRingEdge(this, radius, this.map);
    }

    public List<Hexagon> getHexagonsInRingArea(int radius) {
        this.checkMap();
        return Calculations.getHexagonsInRingArea(this, radius, this.map);
    }

    private void checkMap() {
        if (this.map == null) {
            throw new IllegalStateException("Hexagon must be added to a HexagonMap before this operation. See addHexagon()");
        }
    }

    public Hexagon getNeighbour(HexagonMap.Direction direction) {
        this.checkMap();
        GridPosition neighborPosition = this.position.getNeighborPosition(direction);
        return this.map.getHexagon(neighborPosition);
    }

    public List<Hexagon> getNeighbours() {
        ArrayList<Hexagon> result = new ArrayList<Hexagon>();
        for (int i = 0; i < 6; ++i) {
            Hexagon neighbour = this.getNeighbour(GridPosition.getDirectionFromNumber(i));
            if (neighbour != null) continue;
            result.add(neighbour);
        }
        return result;
    }

    public List<Hexagon> getPathTo(Hexagon destination, IPathInfoSupplier pathInfoSupplier) throws NoPathFoundException {
        this.checkMap();
        return Calculations.getPathBetween(this, destination, pathInfoSupplier);
    }

    public List<Hexagon> getPathTo(Hexagon destination) throws NoPathFoundException {
        this.checkMap();
        return Calculations.getPathBetween(this, destination, new HexagonMap.DefaultPathInfoSupplier());
    }

    public List<Hexagon> getLine(Hexagon origin, Hexagon destination) {
        this.checkMap();
        return Calculations.getLine(origin.position, destination.position, this.map);
    }

    public List<Hexagon> getVisibleHexes(int visibleRange) {
        this.checkMap();
        return Calculations.getVisibleHexes(this, visibleRange, this.map);
    }

    public int getDistance(Hexagon target) {
        return this.position.getDistance(target.position);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!obj.getClass().equals(((Object)((Object)this)).getClass())) {
            return false;
        }
        Hexagon hexagonObj = (Hexagon)((Object)obj);
        return hexagonObj.getQ() == this.getQ() && hexagonObj.getR() == this.getR();
    }

    public void setMap(HexagonMap map) {
        this.map = map;
        if (map != null) {
            this.init();
        }
    }

    public void drawHexagon(GraphicsContext gc) {
        ObservableList points = this.getPoints();
        int nPoints = points.size() / 2;
        double[] xPoints = new double[nPoints];
        double[] yPoints = new double[nPoints];
        for (int i = 0; i < nPoints; ++i) {
            xPoints[i] = 0.5 + (double)Math.round((Double)points.get(2 * i));
            yPoints[i] = 0.5 + (double)Math.round((Double)points.get(2 * i + 1));
        }
        gc.fillPolygon(xPoints, yPoints, nPoints);
        gc.strokePolygon(xPoints, yPoints, nPoints);
    }

    public void drawHexagon(GraphicsContext gc, HexagonMap.Direction ... directions) {
        ObservableList points = this.getPoints();
        int nPoints = points.size() / 2;
        double[] xPoints = new double[nPoints];
        double[] yPoints = new double[nPoints];
        for (int i = 0; i < nPoints; ++i) {
            xPoints[i] = 0.5 + (double)Math.round((Double)points.get(2 * i));
            yPoints[i] = 0.5 + (double)Math.round((Double)points.get(2 * i + 1));
        }
        gc.fillPolygon(xPoints, yPoints, nPoints);
        block9: for (HexagonMap.Direction side : directions) {
            switch (side) {
                case EAST: {
                    gc.strokeLine(xPoints[0], yPoints[0], xPoints[1], yPoints[1]);
                    continue block9;
                }
                case NORTHEAST: {
                    gc.strokeLine(xPoints[1], yPoints[1], xPoints[2], yPoints[2]);
                    continue block9;
                }
                case NORTHWEST: {
                    gc.strokeLine(xPoints[2], yPoints[2], xPoints[3], yPoints[3]);
                    continue block9;
                }
                case WEST: {
                    gc.strokeLine(xPoints[3], yPoints[3], xPoints[4], yPoints[4]);
                    continue block9;
                }
                case SOUTHWEST: {
                    gc.strokeLine(xPoints[4], yPoints[4], xPoints[5], yPoints[5]);
                    continue block9;
                }
                case SOUTHEAST: {
                    gc.strokeLine(xPoints[5], yPoints[5], xPoints[0], yPoints[0]);
                    continue block9;
                }
            }
        }
    }

    public void draw(GraphicsContext gc) {
        gc.save();
        gc.setStroke(this.getStroke());
        gc.setLineWidth(this.getStrokeWidth());
        gc.setFill(this.getFill());
        this.drawHexagon(gc);
        gc.restore();
    }

    public void drawContour(GraphicsContext gc) {
        gc.save();
        gc.setStroke(this.getStroke());
        gc.setLineWidth(this.getStrokeWidth());
        gc.setFill(this.getFill());
        if (this.map == null) {
            this.drawHexagon(gc, HexagonMap.Direction.values());
            gc.restore();
        }
        ArrayList<HexagonMap.Direction> list = new ArrayList<HexagonMap.Direction>();
        for (HexagonMap.Direction direction : HexagonMap.Direction.values()) {
            Paint stroke;
            Hexagon neighbour = this.getNeighbour(direction);
            if (neighbour == null || (stroke = neighbour.getStroke()) == null || this.myColourCompare(stroke, this.getStroke(), 0.2)) continue;
            list.add(direction);
        }
        this.drawHexagon(gc, list.toArray(new HexagonMap.Direction[list.size()]));
        gc.restore();
    }

    private boolean myColourCompare(Paint a, Paint b, double threshold) {
        if (!(a instanceof Color) || !(b instanceof Color)) {
            return false;
        }
        Color ca = (Color)a;
        Color cb = (Color)b;
        return !(Math.abs(ca.getRed() - cb.getRed()) > threshold || Math.abs(ca.getGreen() - cb.getGreen()) > threshold || Math.abs(ca.getBlue() - cb.getBlue()) > threshold || Math.abs(ca.getOpacity() - cb.getOpacity()) > threshold);
    }

    public void renderCoordinates(GraphicsContext gc) {
        Text text = new Text(this.position.getCoordinates());
        if (this.map != null) {
            // empty if block
        }
        double textWidth = text.getBoundsInLocal().getWidth();
        double textHeight = text.getBoundsInLocal().getHeight();
        double x = (double)this.getGraphicsXoffset() - textWidth / 2.0;
        double y = (double)this.getGraphicsYoffset() + textHeight / 4.0;
        text.setX(x);
        text.setY(y);
        gc.strokeText(this.position.getCoordinates(), x, y);
    }

    class UIupdater
    implements Runnable {
        private final Hexagon h;
        private final Color c;

        UIupdater(Hexagon h, Color c) {
            this.h = h;
            this.c = c;
        }

        @Override
        public void run() {
            this.h.setFill((Paint)this.c);
        }
    }
}

