/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.renderer.spi.hexagon;

import de.gsi.chart.renderer.spi.hexagon.HexagonMap;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class GridPosition
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -6932865381701419097L;
    protected final int q;
    protected final int r;

    public GridPosition(int q, int r) {
        this.q = q;
        this.r = r;
    }

    public int getQ() {
        return this.q;
    }

    public int getR() {
        return this.r;
    }

    public GridPosition getNeighborPosition(HexagonMap.Direction direction) {
        int i = GridPosition.getNumberFromDirection(direction);
        int[][] neighbors = new int[][]{{0, -1}, {1, -1}, {1, 0}, {0, 1}, {-1, 1}, {-1, 0}};
        int[] d = neighbors[i];
        return new GridPosition(this.q + d[0], this.r + d[1]);
    }

    ArrayList<GridPosition> getPositionsOnCircleEdge(int radius) {
        int i;
        ArrayList<GridPosition> result = new ArrayList<GridPosition>();
        if (radius == 0) {
            result.add(this);
            return result;
        }
        GridPosition h = this;
        for (i = 0; i < radius; ++i) {
            h = h.getNeighborPosition(HexagonMap.Direction.SOUTHWEST);
        }
        for (i = 0; i < 6; ++i) {
            for (int j = 0; j < radius; ++j) {
                result.add(h.clone());
                h = h.getNeighborPosition(GridPosition.getDirectionFromNumber(i));
            }
        }
        return result;
    }

    ArrayList<GridPosition> getPositionsInCircleArea(int radius) {
        ArrayList<GridPosition> result = new ArrayList<GridPosition>();
        for (int i = 0; i <= radius; ++i) {
            ArrayList<GridPosition> positions = this.getPositionsOnCircleEdge(i);
            result.addAll(positions);
        }
        return result;
    }

    private static int getNumberFromDirection(HexagonMap.Direction direction) {
        switch (direction) {
            case NORTHWEST: {
                return 0;
            }
            case NORTHEAST: {
                return 1;
            }
            case EAST: {
                return 2;
            }
            case SOUTHEAST: {
                return 3;
            }
            case SOUTHWEST: {
                return 4;
            }
            case WEST: {
                return 5;
            }
        }
        throw new RuntimeException();
    }

    static HexagonMap.Direction getDirectionFromNumber(int i) {
        switch (i) {
            case 0: {
                return HexagonMap.Direction.NORTHWEST;
            }
            case 1: {
                return HexagonMap.Direction.NORTHEAST;
            }
            case 2: {
                return HexagonMap.Direction.EAST;
            }
            case 3: {
                return HexagonMap.Direction.SOUTHEAST;
            }
            case 4: {
                return HexagonMap.Direction.SOUTHWEST;
            }
            case 5: {
                return HexagonMap.Direction.WEST;
            }
        }
        throw new RuntimeException();
    }

    String getCoordinates() {
        String s = this.q + ", " + this.r;
        return s;
    }

    public static GridPosition hexRound(double q, double r) {
        double cubeX = q;
        double cubeY = r;
        double cubeZ = -cubeX - cubeY;
        long rx = Math.round(cubeX);
        long ry = Math.round(cubeY);
        long rz = Math.round(cubeZ);
        double x_diff = Math.abs((double)rx - cubeX);
        double y_diff = Math.abs((double)ry - cubeY);
        double z_diff = Math.abs((double)rz - cubeZ);
        if (x_diff > y_diff && x_diff > z_diff) {
            rx = -ry - rz;
        } else if (y_diff > z_diff) {
            ry = -rx - rz;
        } else {
            rz = -rx - ry;
        }
        return new GridPosition((int)rx, (int)ry);
    }

    protected GridPosition clone() {
        try {
            return (GridPosition)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            Logger.getLogger(GridPosition.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            GridPosition gridPositionObj = (GridPosition)obj;
            if (gridPositionObj.q == this.q && gridPositionObj.r == this.r) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        int hash = 5;
        hash = 97 * hash + this.q;
        hash = 97 * hash + this.r;
        return hash;
    }

    public boolean isAdjacent(GridPosition otherPosition) {
        for (int i = 0; i < 6; ++i) {
            GridPosition neighbor = this.getNeighborPosition(GridPosition.getDirectionFromNumber(i));
            if (!otherPosition.equals(neighbor)) continue;
            return true;
        }
        return false;
    }

    public HexagonMap.Direction getDirectionTo(GridPosition otherPosition) {
        if (this.equals(otherPosition)) {
            throw new IllegalArgumentException("Other position (" + otherPosition + ") cannot be same as this (" + this + ")");
        }
        GridPosition firstStepInLine = this.line(otherPosition).get(1);
        for (int i = 0; i < 6; ++i) {
            if (!this.getNeighborPosition(GridPosition.getDirectionFromNumber(i)).equals(firstStepInLine)) continue;
            return GridPosition.getDirectionFromNumber(i);
        }
        throw new RuntimeException();
    }

    public ArrayList<GridPosition> line(GridPosition destination) {
        ArrayList<GridPosition> result = new ArrayList<GridPosition>();
        double n = GridPosition.getDistance(this, destination);
        int i = 0;
        while ((double)i < n) {
            double j = i;
            double q_calculated = (double)this.q * (1.0 - j / n) + (double)destination.q * j / n;
            double r_calculated = (double)this.r * (1.0 - j / n) + (double)destination.r * j / n;
            GridPosition p = GridPosition.hexRound(q_calculated, r_calculated);
            result.add(p);
            ++i;
        }
        result.add(destination);
        return result;
    }

    public static int getDistance(GridPosition a, GridPosition b) {
        return (Math.abs(a.q - b.q) + Math.abs(a.r - b.r) + Math.abs(a.q + a.r - b.q - b.r)) / 2;
    }

    public int getDistance(GridPosition target) {
        return GridPosition.getDistance(this, target);
    }

    public String toString() {
        return "GridPosition q=" + this.q + ", r=" + this.r;
    }
}

