/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.renderer.spi;

import de.gsi.chart.Chart;
import de.gsi.chart.axes.Axis;
import de.gsi.chart.renderer.Renderer;
import de.gsi.chart.renderer.spi.AbstractMetaDataRendererParameter;
import de.gsi.chart.ui.geometry.Side;
import de.gsi.dataset.DataSet;
import de.gsi.dataset.DataSetMetaData;
import de.gsi.dataset.utils.ProcessingProfiler;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.List;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.control.Label;
import javafx.scene.image.ImageView;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;

public class MetaDataRenderer
extends AbstractMetaDataRendererParameter<MetaDataRenderer>
implements Renderer {
    protected BorderPane borderPane = new BorderPane();
    protected FlowPane messageBox = new FlowPane();
    protected HBox infoBox = new InfoHBox();
    protected HBox warningBox = new InfoHBox();
    protected HBox errorBox = new InfoHBox();
    protected Chart chart;
    protected List<String> oldInfoMessages;
    protected List<String> oldWarningMessages;
    protected List<String> oldErrorMessages;
    protected final BooleanProperty drawOnCanvas = new SimpleBooleanProperty(this, "drawOnCanvas", true){
        boolean oldValue;
        {
            this.oldValue = true;
        }

        public void set(boolean newValue) {
            if (this.oldValue == newValue) {
                return;
            }
            super.set(newValue);
            this.oldValue = newValue;
            MetaDataRenderer.this.updateInfoBoxLocation();
        }
    };
    protected final ObjectProperty<Side> infoBoxSide = new SimpleObjectProperty<Side>((Object)this, "infoBoxSide", Side.TOP){
        Side oldSide;
        {
            this.oldSide = null;
        }

        public void set(Side side) {
            if (side == null) {
                throw new InvalidParameterException("side must not be null");
            }
            if (this.oldSide != null && this.oldSide == side) {
                return;
            }
            super.set((Object)side);
            this.oldSide = side;
            MetaDataRenderer.this.updateInfoBoxLocation();
        }
    };

    public MetaDataRenderer(Chart chart) {
        this.chart = chart;
        this.updateCSS();
        this.messageBox.getChildren().addAll((Object[])new Node[]{this.errorBox, this.warningBox, this.infoBox});
        this.messageBox.setMouseTransparent(true);
        this.messageBox.setPrefWidth(1000.0);
        this.messageBox.setCache(true);
        chart.getCanvasForeground().getChildren().add((Object)this.borderPane);
        ChangeListener canvasChange = (ch, oldVal, newVal) -> this.borderPane.setPrefSize(chart.getCanvasForeground().getWidth(), chart.getCanvas().getHeight());
        chart.getCanvas().widthProperty().addListener(canvasChange);
        chart.getCanvas().heightProperty().addListener(canvasChange);
        this.setInfoBoxSide(Side.TOP);
    }

    @Override
    protected MetaDataRenderer getThis() {
        return this;
    }

    public BorderPane getBorderPaneOnCanvas() {
        return this.borderPane;
    }

    public FlowPane getMessageBox() {
        return this.messageBox;
    }

    public HBox getInfoBox() {
        return this.infoBox;
    }

    public HBox getWarningBox() {
        return this.warningBox;
    }

    public HBox getErrorBox() {
        return this.errorBox;
    }

    @Override
    public void render(GraphicsContext gc, Chart chart, int dataSetOffset, ObservableList<DataSet> datasets) {
        MetaLabel info;
        VBox msgs;
        ArrayList<String> errorMessages;
        long start = ProcessingProfiler.getTimeStamp();
        ObservableList<DataSet> allDataSets = chart.getAllDatasets();
        boolean singleDS = allDataSets.size() <= 1;
        List<DataSet> metaDataSets = this.getDataSetsWithMetaData((List<DataSet>)allDataSets);
        ArrayList<String> infoMessages = this.isShowInfoMessages() ? this.extractMessages(metaDataSets, singleDS, MsgType.INFO) : new ArrayList<String>();
        ArrayList<String> warningMessages = this.isShowWarningMessages() ? this.extractMessages(metaDataSets, singleDS, MsgType.WARNING) : new ArrayList<String>();
        List<String> list = errorMessages = this.isShowErrorMessages() ? this.extractMessages(metaDataSets, singleDS, MsgType.ERROR) : new ArrayList<String>();
        if (!infoMessages.equals(this.oldInfoMessages)) {
            this.oldInfoMessages = infoMessages;
            this.infoBox.getChildren().clear();
            if (!infoMessages.isEmpty()) {
                msgs = new VBox();
                this.infoBox.getChildren().addAll((Object[])new Node[]{new ImageView(this.imgIconInfo), msgs});
                for (String text : infoMessages) {
                    info = new MetaLabel(text);
                    msgs.getChildren().add((Object)info);
                }
            }
        }
        if (!warningMessages.equals(this.oldWarningMessages)) {
            this.oldWarningMessages = warningMessages;
            this.warningBox.getChildren().clear();
            if (!warningMessages.isEmpty()) {
                msgs = new VBox();
                this.warningBox.getChildren().addAll((Object[])new Node[]{new ImageView(this.imgIconWarning), msgs});
                for (String text : warningMessages) {
                    info = new MetaLabel(text);
                    msgs.getChildren().add((Object)info);
                }
            }
        }
        if (!errorMessages.equals(this.oldErrorMessages)) {
            this.oldErrorMessages = errorMessages;
            if (!errorMessages.isEmpty()) {
                msgs = new VBox();
                for (String text : errorMessages) {
                    info = new MetaLabel(text);
                    msgs.getChildren().add((Object)info);
                }
                this.errorBox.getChildren().setAll((Object[])new Node[]{new ImageView(this.imgIconError), msgs});
            } else {
                this.errorBox.getChildren().clear();
            }
        }
        ProcessingProfiler.getTimeDiff((long)start);
    }

    private List<String> extractMessages(List<DataSet> metaDataSets, boolean singleDS, MsgType msgType) {
        ArrayList<String> list = new ArrayList<String>();
        for (DataSet dataSet : metaDataSets) {
            List msg;
            if (!(dataSet instanceof DataSetMetaData)) continue;
            String dataSetName = dataSet.getName();
            DataSetMetaData metaData = (DataSetMetaData)dataSet;
            switch (msgType) {
                case ERROR: {
                    msg = metaData.getErrorList();
                    break;
                }
                case WARNING: {
                    msg = metaData.getWarningList();
                    break;
                }
                default: {
                    msg = metaData.getInfoList();
                }
            }
            for (String info : msg) {
                if (singleDS) {
                    list.add(info);
                    continue;
                }
                list.add(info + " (" + dataSetName + ")");
            }
        }
        return list;
    }

    protected List<DataSet> getDataSetsWithMetaData(List<DataSet> dataSets) {
        ArrayList<DataSet> list = new ArrayList<DataSet>();
        for (DataSet dataSet : dataSets) {
            if (!(dataSet instanceof DataSetMetaData)) continue;
            list.add(dataSet);
        }
        return list;
    }

    public boolean isDrawOnCanvas() {
        return this.drawOnCanvas.get();
    }

    public void setDrawOnCanvas(boolean state) {
        this.drawOnCanvas.set(state);
    }

    public BooleanProperty drawOnCanvasProperty() {
        return this.drawOnCanvas;
    }

    protected void updateInfoBoxLocation() {
        Side side = this.getInfoBoxSide();
        this.borderPane.getChildren().remove((Object)this.messageBox);
        for (Side s : Side.values()) {
            this.chart.getTitleLegendPane(s).getChildren().remove((Object)this.messageBox);
        }
        if (this.isDrawOnCanvas()) {
            switch (side) {
                case RIGHT: {
                    this.messageBox.setMaxWidth(300.0);
                    this.messageBox.setPrefWidth(200.0);
                    this.borderPane.setRight((Node)this.messageBox);
                    break;
                }
                case LEFT: {
                    this.messageBox.setMaxWidth(300.0);
                    this.messageBox.setPrefWidth(200.0);
                    this.borderPane.setLeft((Node)this.messageBox);
                    break;
                }
                case BOTTOM: {
                    this.messageBox.setPrefWidth(1000.0);
                    this.messageBox.setMaxWidth(2000.0);
                    this.borderPane.setBottom((Node)this.messageBox);
                    break;
                }
                default: {
                    this.messageBox.setMaxWidth(2000.0);
                    this.messageBox.setPrefWidth(1000.0);
                    this.borderPane.setTop((Node)this.messageBox);
                    break;
                }
            }
        } else {
            this.chart.getTitleLegendPane(side).getChildren().add((Object)this.messageBox);
        }
    }

    public final Side getInfoBoxSide() {
        return (Side)((Object)this.infoBoxSideProperty().get());
    }

    public final MetaDataRenderer setInfoBoxSide(Side side) {
        this.infoBoxSideProperty().set((Object)side);
        return this.getThis();
    }

    public final ObjectProperty<Side> infoBoxSideProperty() {
        return this.infoBoxSide;
    }

    @Override
    public ObservableList<DataSet> getDatasets() {
        return FXCollections.observableArrayList();
    }

    @Override
    public ObservableList<DataSet> getDatasetsCopy() {
        return FXCollections.observableArrayList();
    }

    @Override
    public BooleanProperty showInLegendProperty() {
        return null;
    }

    @Override
    public boolean showInLegend() {
        return false;
    }

    @Override
    public Renderer setShowInLegend(boolean state) {
        return this.getThis();
    }

    @Override
    public ObservableList<Axis> getAxes() {
        return FXCollections.observableArrayList();
    }

    @Override
    public Canvas drawLegendSymbol(DataSet dataSet, int dsIndex, int width, int height) {
        return null;
    }

    class InfoHBox
    extends HBox {
        public InfoHBox() {
            this.setMouseTransparent(true);
            this.getChildren().addListener(ch -> {
                if (this.getChildren().isEmpty()) {
                    this.setMinWidth(0.0);
                    this.setSpacing(0.0);
                    this.setPadding(Insets.EMPTY);
                } else {
                    this.setPadding(new Insets(5.0, 5.0, 5.0, 5.0));
                    this.setMinWidth(200.0);
                    this.setSpacing(5.0);
                }
            });
        }
    }

    protected static enum MsgType {
        INFO,
        WARNING,
        ERROR;

    }

    protected class MetaLabel
    extends Label {
        public MetaLabel(String text) {
            super(text);
            this.setMouseTransparent(true);
            this.setMinSize(100.0, 20.0);
            this.setCache(true);
        }
    }
}

