/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.renderer.spi;

import de.gsi.chart.Chart;
import de.gsi.chart.XYChart;
import de.gsi.chart.axes.Axis;
import de.gsi.chart.renderer.Renderer;
import de.gsi.chart.renderer.spi.AbstractDataSetManagement;
import de.gsi.chart.utils.StyleParser;
import de.gsi.dataset.DataSet;
import de.gsi.dataset.utils.ProcessingProfiler;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Collection;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.ObservableList;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.scene.text.TextAlignment;

public class LabelledMarkerRenderer
extends AbstractDataSetManagement<LabelledMarkerRenderer>
implements Renderer {
    private static final String STYLE_CLASS_LABELLED_MARKER = "chart-labelled-marker";
    private static final String DEFAULT_FONT = "Helvetia";
    private static final int DEFAULT_FONT_SIZE = 18;
    private static final Color DEFAULT_GRID_LINE_COLOR = Color.GREEN;
    private static final double DEFAULT_GRID_LINE_WIDTH = 1.0;
    private static final double[] DEFAULT_GRID_DASH_PATTERM = new double[]{3.0, 3.0};
    protected final StringProperty style = new SimpleStringProperty((Object)this, "style", null);
    protected final BooleanProperty verticalMarker = new SimpleBooleanProperty((Object)this, "verticalMarker", true);
    protected final BooleanProperty horizontalMarker = new SimpleBooleanProperty((Object)this, "horizontalMarker", false);
    protected Paint strokeColorMarker = DEFAULT_GRID_LINE_COLOR;
    protected double strokeLineWidthMarker = 1.0;
    protected double[] strokeDashPattern = DEFAULT_GRID_DASH_PATTERM;

    public LabelledMarkerRenderer() {
        this.updateCSS();
        this.setShowInLegend(false);
    }

    @Override
    protected LabelledMarkerRenderer getThis() {
        return this;
    }

    @Override
    public void render(GraphicsContext gc, Chart chart, int dataSetOffset, ObservableList<DataSet> datasets) {
        long start = ProcessingProfiler.getTimeStamp();
        if (!(chart instanceof XYChart)) {
            throw new InvalidParameterException("must be derivative of XYChart for renderer - " + this.getClass().getSimpleName());
        }
        XYChart xyChart = (XYChart)chart;
        ArrayList<DataSet> localDataSetList = new ArrayList<DataSet>((Collection<DataSet>)datasets);
        localDataSetList.addAll((Collection<DataSet>)this.getDatasets());
        if (localDataSetList.isEmpty()) {
            return;
        }
        if (!(xyChart.getXAxis() instanceof Axis)) {
            throw new InvalidParameterException("x-Axis must be a derivative of Axis, axis is = " + xyChart.getXAxis());
        }
        Axis xAxis = xyChart.getXAxis();
        double xAxisWidth = xAxis.getWidth();
        double xMin = xAxis.getValueForDisplay(0.0);
        double xMax = xAxis.getValueForDisplay(xAxisWidth);
        for (int dataSetIndex = localDataSetList.size() - 1; dataSetIndex >= 0; --dataSetIndex) {
            DataSet dataSet = (DataSet)localDataSetList.get(dataSetIndex);
            dataSet.lock();
            int indexMin = Math.max(0, dataSet.getXIndex(xMin));
            int indexMax = Math.min(dataSet.getXIndex(xMax) + 1, dataSet.getDataCount());
            if (indexMax - indexMin <= 0) {
                dataSet.unlock();
                continue;
            }
            if (this.horizontalMarker.get()) {
                this.drawHorizontalLabelledMarker(gc, xyChart, dataSet, indexMin, indexMax);
            }
            if (this.verticalMarker.get()) {
                this.drawVerticalLabelledMarker(gc, xyChart, dataSet, indexMin, indexMax);
            }
            dataSet.unlock();
        }
        ProcessingProfiler.getTimeDiff((long)start);
    }

    protected void drawHorizontalLabelledMarker(GraphicsContext gc, XYChart chart, DataSet dataSet, int indexMin, int indexMax) {
        if (!(chart.getYAxis() instanceof Axis)) {
            throw new InvalidParameterException("y Axis not a Axis derivative, yAxis = " + chart.getYAxis());
        }
        Axis yAxis = chart.getYAxis();
        gc.save();
        this.setGraphicsContextAttributes(gc, dataSet.getStyle());
        gc.setTextAlign(TextAlignment.RIGHT);
        double width = chart.getCanvas().getWidth();
        double lastLabel = -1.7976931348623157E308;
        double lastFontSize = 0.0;
        for (int i = indexMin; i < indexMax; ++i) {
            double screenY = (int)yAxis.getDisplayPosition(dataSet.getY(i));
            String label = dataSet.getDataLabel(i);
            String pointStyle = dataSet.getStyle(i);
            if (pointStyle != null) {
                gc.save();
                this.setGraphicsContextAttributes(gc, pointStyle);
            }
            gc.strokeLine(0.0, screenY, width, screenY);
            if (Math.abs(screenY - lastLabel) > lastFontSize && !label.isEmpty()) {
                gc.save();
                gc.setLineWidth(0.8);
                gc.setLineDashes(new double[]{1.0});
                gc.translate(Math.ceil(screenY + 3.0), Math.ceil(0.99 * width));
                gc.fillText(label, 0.0, 0.0);
                gc.restore();
                lastLabel = screenY;
                lastFontSize = gc.getFont().getSize();
            }
            if (pointStyle == null) continue;
            gc.restore();
        }
        gc.restore();
    }

    protected void drawVerticalLabelledMarker(GraphicsContext gc, XYChart chart, DataSet dataSet, int indexMin, int indexMax) {
        if (!(chart.getXAxis() instanceof Axis)) {
            throw new InvalidParameterException("x Axis not a Axis derivative, xAxis = " + chart.getXAxis());
        }
        Axis xAxis = chart.getXAxis();
        gc.save();
        this.setGraphicsContextAttributes(gc, dataSet.getStyle());
        gc.setTextAlign(TextAlignment.LEFT);
        double height = chart.getCanvas().getHeight();
        double lastLabel = -1.7976931348623157E308;
        double lastFontSize = 0.0;
        for (int i = indexMin; i < indexMax; ++i) {
            double screenX = (int)xAxis.getDisplayPosition(dataSet.getX(i));
            String label = dataSet.getDataLabel(i);
            String pointStyle = dataSet.getStyle(i);
            if (pointStyle != null) {
                gc.save();
                this.setGraphicsContextAttributes(gc, pointStyle);
            }
            gc.strokeLine(screenX, 0.0, screenX, height);
            if (Math.abs(screenX - lastLabel) > lastFontSize && !label.isEmpty()) {
                gc.save();
                gc.setLineWidth(0.8);
                gc.setLineDashes(new double[]{1.0});
                gc.translate(Math.ceil(screenX + 3.0), Math.ceil(0.01 * height));
                gc.rotate(90.0);
                gc.fillText(label, 0.0, 0.0);
                gc.restore();
                lastLabel = screenX;
                lastFontSize = gc.getFont().getSize();
            }
            if (pointStyle == null) continue;
            gc.restore();
        }
        gc.restore();
    }

    protected void setGraphicsContextAttributes(GraphicsContext gc, String style) {
        Color strokeColor = StyleParser.getColorPropertyValue(style, "strokeColor");
        if (strokeColor == null) {
            gc.setStroke(this.strokeColorMarker);
        } else {
            gc.setStroke((Paint)strokeColor);
        }
        Color fillColor = StyleParser.getColorPropertyValue(style, "fillColor");
        if (fillColor == null) {
            gc.setFill(this.strokeColorMarker);
        } else {
            gc.setFill((Paint)fillColor);
        }
        Double strokeWidth = StyleParser.getFloatingDecimalPropertyValue(style, "strokeWidth");
        if (strokeWidth == null) {
            gc.setLineWidth(this.strokeLineWidthMarker);
        } else {
            gc.setLineWidth(strokeWidth.doubleValue());
        }
        Font font = StyleParser.getFontPropertyValue(style);
        if (font == null) {
            gc.setFont(Font.font((String)DEFAULT_FONT, (double)18.0));
        } else {
            gc.setFont(font);
        }
        double[] dashPattern = StyleParser.getFloatingDecimalArrayPropertyValue(style, "strokeDashPattern");
        if (dashPattern == null) {
            gc.setLineDashes(this.strokeDashPattern);
        } else {
            gc.setLineDashes(dashPattern);
        }
    }

    public BooleanProperty horizontalMarkerProperty() {
        return this.horizontalMarker;
    }

    public boolean isHorizontalMarker() {
        return this.horizontalMarker.get();
    }

    public LabelledMarkerRenderer enableHorizontalMarker(boolean state) {
        this.horizontalMarker.set(state);
        return this.getThis();
    }

    public BooleanProperty verticalMarkerProperty() {
        return this.verticalMarker;
    }

    public boolean isVerticalMarker() {
        return this.verticalMarker.get();
    }

    public LabelledMarkerRenderer enableVerticalMarker(boolean state) {
        this.verticalMarker.set(state);
        return this.getThis();
    }

    public StringProperty styleProperty() {
        return this.style;
    }

    public String getStyle() {
        return (String)this.style.get();
    }

    public LabelledMarkerRenderer setStyle(String newStyle) {
        this.style.set((Object)newStyle);
        return this.getThis();
    }

    public final LabelledMarkerRenderer updateCSS() {
        this.strokeColorMarker = DEFAULT_GRID_LINE_COLOR;
        this.strokeLineWidthMarker = 1.0;
        this.strokeDashPattern = DEFAULT_GRID_DASH_PATTERM;
        if (this.getStyle() != null) {
            // empty if block
        }
        return this.getThis();
    }

    @Override
    public Canvas drawLegendSymbol(DataSet dataSet, int dsIndex, int width, int height) {
        return null;
    }
}

