/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.renderer.spi;

import de.gsi.chart.Chart;
import de.gsi.chart.XYChart;
import de.gsi.chart.axes.Axis;
import de.gsi.chart.renderer.Renderer;
import de.gsi.chart.renderer.spi.ErrorDataSetRenderer;
import de.gsi.chart.utils.FXUtilities;
import de.gsi.chart.utils.StyleParser;
import de.gsi.dataset.DataSet;
import de.gsi.dataset.EditableDataSet;
import de.gsi.dataset.utils.ProcessingProfiler;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.scene.canvas.GraphicsContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HistoryDataSetRenderer
extends ErrorDataSetRenderer
implements Renderer {
    private static final Logger LOGGER = LoggerFactory.getLogger(HistoryDataSetRenderer.class);
    protected static final int DEFAULT_HISTORY_DEPTH = 3;
    protected final ObservableList<DataSet> emptyList = FXCollections.observableArrayList();
    protected final ObservableList<DataSet> chartDataSetsCopy = FXCollections.observableArrayList();
    protected final ObservableList<ErrorDataSetRenderer> renderers = FXCollections.observableArrayList();
    protected boolean itself = false;

    public HistoryDataSetRenderer() {
        this(3);
    }

    public HistoryDataSetRenderer(int historyDepth) {
        if (historyDepth < 0) {
            throw new IllegalArgumentException(String.format("historyDepth=='%d' should be larger than '0'", historyDepth));
        }
        for (int i = 0; i < historyDepth; ++i) {
            ErrorDataSetRenderer newRenderer = new ErrorDataSetRenderer();
            newRenderer.bind(this);
            newRenderer.showInLegendProperty().unbind();
            newRenderer.setShowInLegend(false);
            this.renderers.add((Object)newRenderer);
        }
        this.getAxes().addListener(this::axisChanged);
        super.getDatasets().addListener(e -> {
            while (e.next()) {
                if (!e.wasAdded()) continue;
                ObservableList localList = FXCollections.observableArrayList();
                for (Renderer r : this.renderers) {
                    for (DataSet set : r.getDatasets()) {
                        if (this.getDatasets().contains((Object)set)) continue;
                        localList.add((Object)set);
                    }
                }
                if (localList.isEmpty() || this.itself) continue;
                this.itself = true;
                super.getDatasets().addAll((Collection)localList);
                this.itself = false;
            }
        });
    }

    protected void axisChanged(ListChangeListener.Change<? extends Axis> change) {
        while (change.next()) {
            if (change.wasRemoved()) {
                for (ErrorDataSetRenderer renderer : this.renderers) {
                    renderer.getAxes().removeAll((Collection)change.getRemoved());
                }
            }
            if (!change.wasAdded()) continue;
            for (ErrorDataSetRenderer renderer : this.renderers) {
                renderer.getAxes().addAll((Collection)change.getAddedSubList());
            }
        }
    }

    private ObservableList<DataSet> getLocalDataSets() {
        ObservableList retVal = FXCollections.observableArrayList();
        retVal.addAll(this.getDatasets());
        ArrayList<DataSet> removeList = new ArrayList<DataSet>();
        for (Renderer r : this.renderers) {
            removeList.addAll((Collection<DataSet>)r.getDatasets());
        }
        retVal.removeAll(removeList);
        return retVal;
    }

    @Override
    public void render(GraphicsContext gc, Chart chart, int dataSetOffset, ObservableList<DataSet> datasets) {
        long start = ProcessingProfiler.getTimeStamp();
        if (!(chart instanceof XYChart)) {
            throw new InvalidParameterException("must be derivative of XYChart for renderer - " + this.getClass().getSimpleName());
        }
        ObservableList localList = FXCollections.observableArrayList();
        for (Object set : datasets) {
            if (this.getDatasets().contains(set)) continue;
            localList.add(set);
        }
        this.getDatasets().addAll((Collection)localList);
        int dsIndex = 0;
        for (DataSet ds : super.getDatasets()) {
            this.modifyStyle(ds, dataSetOffset + dsIndex);
            ++dsIndex;
        }
        int nRenderer = this.renderers.size();
        for (int index = nRenderer - 1; index >= 0; --index) {
            ErrorDataSetRenderer renderer = (ErrorDataSetRenderer)this.renderers.get(index);
            renderer.render(gc, chart, dataSetOffset, this.emptyList);
        }
        super.render(gc, chart, dataSetOffset, this.emptyList);
        ProcessingProfiler.getTimeDiff((long)start);
    }

    protected void modifyStyle(DataSet dataSet, int dataSetIndex) {
        String style = dataSet.getStyle();
        Map<String, String> map = StyleParser.splitIntoMap(style);
        String stroke = map.get("strokeColor".toLowerCase());
        String fill = map.get("fillColor".toLowerCase());
        String index = map.get("dsIndex".toLowerCase());
        if (stroke == null && fill == null && index == null) {
            map.put("dsIndex", Integer.toString(dataSetIndex));
            dataSet.setStyle(StyleParser.mapToString(map));
        }
    }

    public void shiftHistory() {
        int nRenderer = this.renderers.size();
        if (nRenderer <= 0) {
            return;
        }
        ObservableList<DataSet> oldDataSetsToRemove = ((ErrorDataSetRenderer)this.renderers.get(nRenderer - 1)).getDatasets();
        if (!oldDataSetsToRemove.isEmpty()) {
            try {
                FXUtilities.runAndWait(() -> this.getDatasets().removeAll((Collection)oldDataSetsToRemove));
            }
            catch (InterruptedException | ExecutionException e) {
                LOGGER.error("remove oldDataSetsToRemove ", (Throwable)e);
            }
        }
        ObservableList<DataSet> copyDataSet = this.getDatasetsCopy(this.getLocalDataSets());
        for (int index = nRenderer - 1; index >= 0; --index) {
            ErrorDataSetRenderer renderer = (ErrorDataSetRenderer)this.renderers.get(index);
            boolean isFirstRenderer = index == 0;
            HistoryDataSetRenderer previousRenderer = isFirstRenderer ? this : (ErrorDataSetRenderer)this.renderers.get(index - 1);
            ObservableList<DataSet> copyList = isFirstRenderer ? copyDataSet : previousRenderer.getDatasets();
            int fading = (int)(Math.pow(this.getIntensityFading(), (double)index + 2.0) * 100.0);
            for (DataSet ds : copyList) {
                if (ds instanceof EditableDataSet) {
                    ((EditableDataSet)ds).setName(ds.getName().split("_")[0] + "History_{-" + index + "}");
                }
                String style = ds.getStyle();
                Map<String, String> map = StyleParser.splitIntoMap(style);
                map.put("intensity".toLowerCase(), Double.toString(fading));
                map.put("showInLegend".toLowerCase(), Boolean.toString(false));
                ds.setStyle(StyleParser.mapToString(map));
                if (this.getDatasets().contains((Object)ds)) continue;
                try {
                    FXUtilities.runAndWait(() -> this.getDatasets().add((Object)ds));
                }
                catch (InterruptedException | ExecutionException e) {
                    LOGGER.error("add missing dataset", (Throwable)e);
                }
            }
            try {
                FXUtilities.runAndWait(() -> renderer.getDatasets().setAll((Collection)copyList));
                continue;
            }
            catch (InterruptedException | ExecutionException e) {
                LOGGER.error("add new copied dataset to getDatasets()", (Throwable)e);
            }
        }
    }

    public void clearHistory() {
        for (Renderer renderer : this.renderers) {
            try {
                FXUtilities.runAndWait(() -> {
                    super.getDatasets().removeAll(renderer.getDatasets());
                    renderer.getDatasets().clear();
                });
            }
            catch (InterruptedException | ExecutionException e) {
                LOGGER.error("error in clearHistory()", (Throwable)e);
            }
        }
    }

    private static String setLegendCounter(String oldStyle, int count) {
        Map<String, String> map = StyleParser.splitIntoMap(oldStyle);
        map.put("dsIndex", Integer.toString(count));
        return StyleParser.mapToString(map);
    }
}

