/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.renderer.spi;

import com.sun.javafx.css.converters.BooleanConverter;
import de.gsi.chart.Chart;
import de.gsi.chart.XYChart;
import de.gsi.chart.axes.Axis;
import de.gsi.chart.axes.spi.TickMark;
import de.gsi.chart.renderer.Renderer;
import de.gsi.chart.renderer.spi.utils.DashPatternStyle;
import de.gsi.dataset.DataSet;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.beans.property.BooleanProperty;
import javafx.beans.value.ChangeListener;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.SetChangeListener;
import javafx.css.CssMetaData;
import javafx.css.PseudoClass;
import javafx.css.SimpleStyleableBooleanProperty;
import javafx.css.Styleable;
import javafx.css.StyleableProperty;
import javafx.geometry.VPos;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.shape.Line;
import javafx.scene.text.TextAlignment;

public class GridRenderer
extends Pane
implements Renderer {
    private static final double DEG_TO_RAD = Math.PI / 180;
    private static final String CHART_CSS = Chart.class.getResource("chart.css").toExternalForm();
    private static final String STYLE_CLASS_GRID_RENDERER = "grid-renderer";
    private static final String STYLE_CLASS_MAJOR_GRID_LINE = "chart-major-grid-lines";
    private static final String STYLE_CLASS_MAJOR_GRID_LINE_H = "chart-major-horizontal-lines";
    private static final String STYLE_CLASS_MAJOR_GRID_LINE_V = "chart-major-vertical-lines";
    private static final String STYLE_CLASS_MINOR_GRID_LINE = "chart-minor-grid-lines";
    private static final String STYLE_CLASS_MINOR_GRID_LINE_H = "chart-minor-horizontal-lines";
    private static final String STYLE_CLASS_MINOR_GRID_LINE_V = "chart-minor-vertical-lines";
    private static final PseudoClass SELECTED_PSEUDO_CLASS = PseudoClass.getPseudoClass((String)"withMinor");
    private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;
    private final double[] DEFAULT_GRID_DASH_PATTERM = new double[]{4.5, 2.5};
    protected final Chart baseChart;
    protected final BooleanProperty drawGridOnTop = new SimpleStyleableBooleanProperty(StyleableProperties.access$000(), (Object)this, "drawGridOnTop", true);
    private final Line horMajorGridStyleNode;
    private final Line verMajorGridStyleNode;
    private final Line horMinorGridStyleNode;
    private final Line verMinorGridStyleNode;
    private final Group gridStyleNodes = new Group();
    private boolean isPolarPlot = false;
    protected final ObservableList<Axis> axesList = FXCollections.observableArrayList();

    public GridRenderer(XYChart chart) {
        if (chart == null) {
            throw new InvalidParameterException("chart must not be null");
        }
        this.baseChart = chart;
        this.getStylesheets().add((Object)CHART_CSS);
        this.getStyleClass().setAll((Object[])new String[]{STYLE_CLASS_GRID_RENDERER});
        this.horMajorGridStyleNode = new Line();
        this.horMajorGridStyleNode.getStyleClass().add((Object)STYLE_CLASS_MAJOR_GRID_LINE);
        this.horMajorGridStyleNode.getStyleClass().add((Object)STYLE_CLASS_MAJOR_GRID_LINE_H);
        this.verMajorGridStyleNode = new Line();
        this.verMajorGridStyleNode.getStyleClass().add((Object)STYLE_CLASS_MAJOR_GRID_LINE);
        this.verMajorGridStyleNode.getStyleClass().add((Object)STYLE_CLASS_MAJOR_GRID_LINE_V);
        this.horMinorGridStyleNode = new Line();
        this.horMinorGridStyleNode.getStyleClass().add((Object)STYLE_CLASS_MINOR_GRID_LINE);
        this.horMinorGridStyleNode.getStyleClass().add((Object)STYLE_CLASS_MINOR_GRID_LINE_H);
        this.horMinorGridStyleNode.setVisible(false);
        this.verMinorGridStyleNode = new Line();
        this.verMinorGridStyleNode.getStyleClass().add((Object)STYLE_CLASS_MINOR_GRID_LINE);
        this.verMinorGridStyleNode.getStyleClass().add((Object)STYLE_CLASS_MINOR_GRID_LINE_V);
        this.verMinorGridStyleNode.setVisible(false);
        this.gridStyleNodes.getChildren().addAll((Object[])new Node[]{this.horMajorGridStyleNode, this.verMajorGridStyleNode, this.horMinorGridStyleNode, this.verMinorGridStyleNode});
        this.getChildren().add((Object)this.gridStyleNodes);
        Scene scene = new Scene((Parent)this);
        scene.getStylesheets().add((Object)CHART_CSS);
        this.gridStyleNodes.applyCss();
        this.impl_reapplyCSS();
        SetChangeListener listener = evt -> this.gridStyleNodes.applyCss();
        this.horMajorGridStyleNode.getPseudoClassStates().addListener(listener);
        this.verMajorGridStyleNode.getPseudoClassStates().addListener(listener);
        this.horMinorGridStyleNode.getPseudoClassStates().addListener(listener);
        this.verMinorGridStyleNode.getPseudoClassStates().addListener(listener);
        ChangeListener change = (ob, o, n) -> {
            this.horMajorGridStyleNode.pseudoClassStateChanged(SELECTED_PSEUDO_CLASS, this.horMinorGridStyleNode.isVisible());
            this.verMajorGridStyleNode.pseudoClassStateChanged(SELECTED_PSEUDO_CLASS, this.verMinorGridStyleNode.isVisible());
        };
        this.horizontalGridLinesVisibleProperty().addListener(change);
        this.verticalGridLinesVisibleProperty().addListener(change);
    }

    @Override
    public void render(GraphicsContext gc, Chart chart, int dataSetOffset, ObservableList<DataSet> datasets) {
        if (!(chart instanceof XYChart)) {
            throw new InvalidParameterException("must be derivative of XYChart for renderer - " + this.getClass().getSimpleName());
        }
        XYChart xyChart = (XYChart)chart;
        this.isPolarPlot = xyChart.isPolarPlot();
        if (this.isPolarPlot) {
            this.drawPolarGrid(gc, xyChart);
        } else {
            this.drawEuclideanGrid2(gc, xyChart);
        }
    }

    protected void applyGraphicsStyleFromLineStyle(GraphicsContext gc, Line style) {
        gc.setStroke(style.getStroke());
        gc.setLineWidth(style.getStrokeWidth());
        if (style.getStrokeDashArray() != null && !style.getStrokeDashArray().isEmpty()) {
            double[] dashes = style.getStrokeDashArray().stream().mapToDouble(d -> d).toArray();
            gc.setLineDashes(dashes);
        } else {
            gc.setLineDashes(this.DEFAULT_GRID_DASH_PATTERM);
        }
    }

    private double snap(double value) {
        return (double)((int)value) + 0.5;
    }

    protected void drawPolarGrid(GraphicsContext gc, XYChart xyChart) {
        Axis xAxis = xyChart.getXAxis();
        Axis yAxis = xyChart.getYAxis();
        double xAxisWidth = xyChart.getCanvas().getWidth();
        double yAxisHeight = xyChart.getCanvas().getHeight();
        double xRange = xAxis.getWidth();
        double yRange = yAxis.getHeight();
        double xCentre = xRange / 2.0;
        double yCentre = yRange / 2.0;
        double maxRadius = 0.5 * Math.min(xRange, yRange) * 0.9;
        if (xAxis instanceof Node) {
            ((Node)xAxis).setVisible(false);
        }
        gc.save();
        if (this.verMajorGridStyleNode.isVisible() || this.verMinorGridStyleNode.isVisible()) {
            this.applyGraphicsStyleFromLineStyle(gc, this.verMajorGridStyleNode);
            for (double phi = 0.0; phi <= 360.0; phi += xyChart.getPolarStepSize().get()) {
                double x = xCentre + maxRadius * Math.sin(phi * (Math.PI / 180));
                double y = yCentre - maxRadius * Math.cos(phi * (Math.PI / 180));
                double xl = xCentre + maxRadius * Math.sin(phi * (Math.PI / 180)) * 1.05;
                double yl = yCentre - maxRadius * Math.cos(phi * (Math.PI / 180)) * 1.05;
                if (!(phi >= 0.0) || !(phi <= 360.0)) continue;
                gc.strokeLine(xCentre, yCentre, x, y);
                gc.save();
                gc.setFont(yAxis.getTickLabelFont());
                gc.setStroke(yAxis.getTickLabelFill());
                gc.setLineDashes(null);
                gc.setTextBaseline(VPos.CENTER);
                if (phi < 350.0) {
                    if (phi < 20.0) {
                        gc.setTextAlign(TextAlignment.CENTER);
                    } else if (phi <= 160.0) {
                        gc.setTextAlign(TextAlignment.LEFT);
                    } else if (phi <= 200.0) {
                        gc.setTextAlign(TextAlignment.CENTER);
                    } else {
                        gc.setTextAlign(TextAlignment.RIGHT);
                    }
                    gc.strokeText(String.valueOf(phi), xl, yl);
                }
                gc.restore();
            }
            if (xAxis instanceof Axis && xAxis.isLogAxis() || this.verMinorGridStyleNode.isVisible()) {
                this.applyGraphicsStyleFromLineStyle(gc, this.verMinorGridStyleNode);
                xAxis.getMinorTickMarks().stream().mapToDouble(TickMark::getPosition).forEach(xPos -> {
                    if (xPos > 0.0 && xPos <= xAxisWidth) {
                        gc.strokeLine(xPos, 0.0, xPos, yAxisHeight);
                    }
                });
            }
        }
        if (this.horMajorGridStyleNode.isVisible() || this.horMinorGridStyleNode.isVisible()) {
            this.applyGraphicsStyleFromLineStyle(gc, this.horMajorGridStyleNode);
            ObservableList<TickMark> yTickMarks = yAxis.getTickMarks();
            gc.strokeOval(xCentre - maxRadius, yCentre - maxRadius, 2.0 * maxRadius, 2.0 * maxRadius);
            yTickMarks.forEach(tick -> {
                double yPos = yRange - yAxis.getDisplayPosition(tick.getValue());
                String label = yAxis.getTickMarkLabel(tick.getValue());
                double yNorm = yPos / yRange * maxRadius;
                if (yNorm >= 0.0 && yNorm < maxRadius) {
                    gc.strokeOval(xCentre - yNorm, yCentre - yNorm, 2.0 * yNorm, 2.0 * yNorm);
                    gc.save();
                    gc.setFont(yAxis.getTickLabelFont());
                    gc.setStroke(yAxis.getTickLabelFill());
                    gc.setLineDashes(null);
                    gc.setTextBaseline(VPos.CENTER);
                    gc.strokeText(label, xCentre + (double)((int)yAxis.getTickLabelGap()), yCentre - yNorm);
                    gc.restore();
                }
            });
            if (yAxis instanceof Axis && yAxis.isLogAxis() || this.horMinorGridStyleNode.isVisible()) {
                this.applyGraphicsStyleFromLineStyle(gc, this.horMinorGridStyleNode);
                yAxis.getMinorTickMarks().stream().mapToDouble(minorTick -> yRange - minorTick.getPosition()).forEach(yPos -> {
                    double yNorm = yPos / yRange * maxRadius;
                    if (yNorm >= 0.0 && yNorm < maxRadius) {
                        gc.strokeOval(xCentre - yNorm, yCentre - yNorm, 2.0 * yNorm, 2.0 * yNorm);
                    }
                });
            }
        }
        gc.restore();
    }

    protected void drawEuclideanGrid(GraphicsContext gc, XYChart xyChart) {
        Axis xAxis = xyChart.getXAxis();
        Axis yAxis = xyChart.getYAxis();
        double xAxisWidth = xyChart.getCanvas().getWidth();
        double yAxisHeight = xyChart.getCanvas().getHeight();
        if (xAxis instanceof Node) {
            ((Node)xAxis).setVisible(true);
        }
        gc.save();
        if (this.verMajorGridStyleNode.isVisible() || this.verMinorGridStyleNode.isVisible()) {
            this.applyGraphicsStyleFromLineStyle(gc, this.verMajorGridStyleNode);
            xAxis.getTickMarks().stream().mapToDouble(tick -> xAxis.getDisplayPosition(tick.getValue())).forEach(xPos -> {
                if (xPos > 0.0 && xPos <= xAxisWidth) {
                    gc.strokeLine(this.snap(xPos), this.snap(0.0), this.snap(xPos), this.snap(yAxisHeight));
                }
            });
        }
        if (xAxis instanceof Axis && xAxis.isLogAxis() || this.verMinorGridStyleNode.isVisible()) {
            this.applyGraphicsStyleFromLineStyle(gc, this.verMinorGridStyleNode);
            xAxis.getMinorTickMarks().stream().mapToDouble(TickMark::getPosition).forEach(xPos -> {
                if (xPos > 0.0 && xPos <= xAxisWidth) {
                    gc.strokeLine(this.snap(xPos), this.snap(0.0), this.snap(xPos), this.snap(yAxisHeight));
                }
            });
        }
        if (this.horMajorGridStyleNode.isVisible() || this.horMinorGridStyleNode.isVisible()) {
            this.applyGraphicsStyleFromLineStyle(gc, this.horMajorGridStyleNode);
            yAxis.getTickMarks().stream().mapToDouble(tick -> yAxis.getDisplayPosition(tick.getValue())).forEach(yPos -> {
                if (yPos >= 0.0 && yPos < yAxisHeight) {
                    gc.strokeLine(this.snap(0.0), this.snap(yPos), this.snap(xAxisWidth), this.snap(yPos));
                }
            });
        }
        if (yAxis instanceof Axis && yAxis.isLogAxis() || this.horMinorGridStyleNode.isVisible()) {
            this.applyGraphicsStyleFromLineStyle(gc, this.horMinorGridStyleNode);
            yAxis.getMinorTickMarks().stream().mapToDouble(TickMark::getPosition).forEach(yPos -> {
                if (yPos >= 0.0 && yPos < yAxisHeight) {
                    gc.strokeLine(this.snap(0.0), this.snap(yPos), this.snap(xAxisWidth), this.snap(yPos));
                }
            });
        }
        gc.restore();
    }

    protected void drawEuclideanGrid2(GraphicsContext gc, XYChart xyChart) {
        double y;
        double x;
        int i;
        ObservableList<TickMark> tickMarks;
        Axis xAxis = xyChart.getXAxis();
        Axis yAxis = xyChart.getYAxis();
        double xAxisWidth = xyChart.getCanvas().getWidth();
        double xAxisWidthSnapped = this.snap(xAxisWidth);
        double yAxisHeight = xyChart.getCanvas().getHeight();
        double yAxisHeightSnapped = this.snap(yAxisHeight);
        double zeroSnapped = this.snap(0.0);
        if (xAxis instanceof Node) {
            ((Node)xAxis).setVisible(true);
        }
        gc.save();
        if (this.verMajorGridStyleNode.isVisible() || this.verMinorGridStyleNode.isVisible()) {
            this.applyGraphicsStyleFromLineStyle(gc, this.verMajorGridStyleNode);
            tickMarks = xAxis.getTickMarks();
            for (i = 0; i < tickMarks.size(); ++i) {
                x = this.snap(xAxis.getDisplayPosition(((TickMark)((Object)tickMarks.get(i))).getValue()));
                if (!(x > 0.0) || !(x <= xAxisWidth)) continue;
                DashPatternStyle.strokeDashedLine(gc, x, zeroSnapped, x, yAxisHeightSnapped);
            }
        }
        if (xAxis instanceof Axis && xAxis.isLogAxis() || this.verMinorGridStyleNode.isVisible()) {
            this.applyGraphicsStyleFromLineStyle(gc, this.verMinorGridStyleNode);
            tickMarks = xAxis.getMinorTickMarks();
            for (i = 0; i < tickMarks.size(); ++i) {
                x = this.snap(xAxis.getDisplayPosition(((TickMark)((Object)tickMarks.get(i))).getValue()));
                if (!(x > 0.0) || !(x <= xAxisWidth)) continue;
                DashPatternStyle.strokeDashedLine(gc, x, zeroSnapped, x, yAxisHeightSnapped);
            }
        }
        if (this.horMajorGridStyleNode.isVisible() || this.horMinorGridStyleNode.isVisible()) {
            this.applyGraphicsStyleFromLineStyle(gc, this.horMajorGridStyleNode);
            tickMarks = yAxis.getTickMarks();
            for (i = 0; i < tickMarks.size(); ++i) {
                y = this.snap(yAxis.getDisplayPosition(((TickMark)((Object)tickMarks.get(i))).getValue()));
                if (!(y >= 0.0) || !(y < yAxisHeight)) continue;
                DashPatternStyle.strokeDashedLine(gc, zeroSnapped, y, xAxisWidthSnapped, y);
            }
        }
        if (yAxis instanceof Axis && yAxis.isLogAxis() || this.horMinorGridStyleNode.isVisible()) {
            this.applyGraphicsStyleFromLineStyle(gc, this.horMinorGridStyleNode);
            tickMarks = yAxis.getMinorTickMarks();
            for (i = 0; i < tickMarks.size(); ++i) {
                y = this.snap(yAxis.getDisplayPosition(((TickMark)((Object)tickMarks.get(i))).getValue()));
                if (!(y >= 0.0) || !(y < yAxisHeight)) continue;
                DashPatternStyle.strokeDashedLine(gc, zeroSnapped, y, xAxisWidthSnapped, y);
            }
        }
        gc.restore();
    }

    @Override
    public ObservableList<Axis> getAxes() {
        return this.axesList;
    }

    public final BooleanProperty verticalGridLinesVisibleProperty() {
        return this.verMajorGridStyleNode.visibleProperty();
    }

    public final BooleanProperty horizontalGridLinesVisibleProperty() {
        return this.horMajorGridStyleNode.visibleProperty();
    }

    public final BooleanProperty verticalMinorGridLinesVisibleProperty() {
        return this.verMinorGridStyleNode.visibleProperty();
    }

    public final BooleanProperty horizontalMinorGridLinesVisibleProperty() {
        return this.horMinorGridStyleNode.visibleProperty();
    }

    public final BooleanProperty drawOnTopProperty() {
        return this.drawGridOnTop;
    }

    public final boolean isDrawOnTop() {
        return this.drawGridOnTop.get();
    }

    public final void setDrawOnTop(boolean state) {
        this.drawGridOnTop.set(state);
    }

    @Override
    public ObservableList<DataSet> getDatasets() {
        return null;
    }

    @Override
    public ObservableList<DataSet> getDatasetsCopy() {
        return null;
    }

    @Override
    public BooleanProperty showInLegendProperty() {
        return null;
    }

    @Override
    public boolean showInLegend() {
        return false;
    }

    @Override
    public Renderer setShowInLegend(boolean state) {
        return this;
    }

    public Line getHorizontalMajorGrid() {
        return this.horMajorGridStyleNode;
    }

    public Line getVerticalMajorGrid() {
        return this.verMajorGridStyleNode;
    }

    public Line getHorizontalMinorGrid() {
        return this.horMinorGridStyleNode;
    }

    public Line getVerticalMinorGrid() {
        return this.verMinorGridStyleNode;
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return STYLEABLES;
    }

    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return GridRenderer.getClassCssMetaData();
    }

    @Override
    public Canvas drawLegendSymbol(DataSet dataSet, int dsIndex, int width, int height) {
        return null;
    }

    static {
        ArrayList<CssMetaData> styleables = new ArrayList<CssMetaData>(Region.getClassCssMetaData());
        styleables.add(StyleableProperties.GRID_ON_TOP);
        STYLEABLES = Collections.unmodifiableList(styleables);
    }

    private static class StyleableProperties {
        private static final CssMetaData<GridRenderer, Boolean> GRID_ON_TOP = new CssMetaData<GridRenderer, Boolean>("-fx-grid-on-top", BooleanConverter.getInstance(), Boolean.TRUE, false){

            public boolean isSettable(GridRenderer node) {
                return node.drawGridOnTop == null || !node.drawGridOnTop.isBound();
            }

            public StyleableProperty<Boolean> getStyleableProperty(GridRenderer node) {
                return (StyleableProperty)node.drawGridOnTop;
            }
        };

        private StyleableProperties() {
        }
    }
}

