/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.renderer.spi;

import de.gsi.chart.Chart;
import de.gsi.chart.XYChart;
import de.gsi.chart.axes.Axis;
import de.gsi.chart.axes.spi.CategoryAxis;
import de.gsi.chart.marker.Marker;
import de.gsi.chart.renderer.ErrorStyle;
import de.gsi.chart.renderer.Renderer;
import de.gsi.chart.renderer.RendererDataReducer;
import de.gsi.chart.renderer.spi.AbstractErrorDataSetRendererParameter;
import de.gsi.chart.renderer.spi.utils.BezierCurve;
import de.gsi.chart.renderer.spi.utils.Cache;
import de.gsi.chart.renderer.spi.utils.DefaultRenderColorScheme;
import de.gsi.chart.utils.StyleParser;
import de.gsi.dataset.DataSet;
import de.gsi.dataset.DataSet3D;
import de.gsi.dataset.DataSetError;
import de.gsi.dataset.utils.ProcessingProfiler;
import de.gsi.math.ArrayUtils;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javafx.collections.ObservableList;
import javafx.geometry.Orientation;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.FillRule;

public class ErrorDataSetRenderer
extends AbstractErrorDataSetRendererParameter<ErrorDataSetRenderer>
implements Renderer {
    private static final double DEG_TO_RAD = Math.PI / 180;
    private static final int MAX_THREADS = Math.max(4, Runtime.getRuntime().availableProcessors());
    private static final ExecutorService executorService = Executors.newFixedThreadPool(2 * MAX_THREADS);
    protected Cache cache = new Cache();
    private Marker marker;
    private boolean isPolarPlot = false;

    public ErrorDataSetRenderer() {
        this(3);
    }

    public ErrorDataSetRenderer(int dashSize) {
        this.setDashSize(dashSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void render(GraphicsContext gc, Chart chart, int dataSetOffset, ObservableList<DataSet> datasets) {
        long start = ProcessingProfiler.getTimeStamp();
        if (!(chart instanceof XYChart)) {
            throw new InvalidParameterException("must be derivative of XYChart for renderer - " + this.getClass().getSimpleName());
        }
        XYChart xyChart = (XYChart)chart;
        this.isPolarPlot = xyChart.isPolarPlot();
        ArrayList<DataSet> localDataSetList = new ArrayList<DataSet>((Collection<DataSet>)datasets);
        localDataSetList.addAll((Collection<DataSet>)super.getDatasets());
        if (localDataSetList.isEmpty()) {
            return;
        }
        if (this.getFirstAxis(Orientation.HORIZONTAL) == null) {
            throw new InvalidParameterException("x-Axis must not be null - axesList() = " + this.getAxes());
        }
        if (this.getFirstAxis(Orientation.VERTICAL) == null) {
            throw new InvalidParameterException("y-Axis must not be null - axesList() = " + this.getAxes());
        }
        if (!(this.getFirstAxis(Orientation.HORIZONTAL) instanceof Axis)) {
            throw new InvalidParameterException("x-Axis must be a derivative of Axis, axis is = " + this.getFirstAxis(Orientation.HORIZONTAL).getClass().getSimpleName());
        }
        if (!(this.getFirstAxis(Orientation.VERTICAL) instanceof Axis)) {
            throw new InvalidParameterException("y-Axis must be a derivative of Axis, axis is = " + this.getFirstAxis(Orientation.VERTICAL).getClass().getSimpleName());
        }
        Axis xAxis = this.getFirstAxis(Orientation.HORIZONTAL);
        double xAxisWidth = xAxis.getWidth();
        double xMin = xAxis.getValueForDisplay(0.0);
        double xMax = xAxis.getValueForDisplay(xAxisWidth);
        ProcessingProfiler.getTimeDiff((long)start, (String)"init");
        for (int dataSetIndex = localDataSetList.size() - 1; dataSetIndex >= 0; --dataSetIndex) {
            long stop = ProcessingProfiler.getTimeStamp();
            DataSet dataSet = (DataSet)localDataSetList.get(dataSetIndex);
            if (dataSet instanceof DataSet3D) {
                // empty if block
            }
            dataSet.lock();
            stop = ProcessingProfiler.getTimeDiff((long)stop, (String)"dataSet.lock()");
            if (dataSetIndex == 0) {
                CategoryAxis axis;
                if (this.getFirstAxis(Orientation.HORIZONTAL) instanceof CategoryAxis) {
                    axis = (CategoryAxis)this.getFirstAxis(Orientation.HORIZONTAL);
                    axis.updateCategories(dataSet);
                }
                if (this.getFirstAxis(Orientation.VERTICAL) instanceof CategoryAxis) {
                    axis = (CategoryAxis)this.getFirstAxis(Orientation.VERTICAL);
                    axis.updateCategories(dataSet);
                }
            }
            int indexMin = Math.max(0, dataSet.getXIndex(xMin));
            int indexMax = Math.min(dataSet.getXIndex(xMax) + 1, dataSet.getDataCount());
            if (xAxis.isInvertedAxis()) {
                int temp = indexMin;
                indexMin = indexMax - 1;
                indexMax = temp + 1;
            }
            if (indexMax - indexMin <= 0) {
                dataSet.unlock();
                continue;
            }
            stop = ProcessingProfiler.getTimeDiff((long)stop, (String)("get min/max" + String.format(" from:%d to:%d", indexMin, indexMax)));
            CachedDataPoints localCachedPoints = new CachedDataPoints(indexMin, indexMax, dataSet.getDataCount(), true);
            stop = ProcessingProfiler.getTimeDiff((long)stop, (String)"get CachedPoints");
            localCachedPoints.computeScreenCoordinates(chart, dataSet, dataSetOffset + dataSetIndex, indexMin, indexMax);
            stop = ProcessingProfiler.getTimeDiff((long)stop, (String)"computeScreenCoordinates()");
            dataSet.unlock();
            stop = ProcessingProfiler.getTimeDiff((long)stop, (String)"dataSet.unlock()");
            localCachedPoints.reduce();
            GraphicsContext graphicsContext = gc;
            synchronized (graphicsContext) {
                this.drawChartCompontents(gc, localCachedPoints);
            }
            stop = ProcessingProfiler.getTimeStamp();
            localCachedPoints.release();
            ProcessingProfiler.getTimeDiff((long)stop, (String)"localCachedPoints.release()");
        }
        ProcessingProfiler.getTimeDiff((long)start);
    }

    private void drawChartCompontents(GraphicsContext gc, CachedDataPoints localCachedPoints) {
        long start = ProcessingProfiler.getTimeStamp();
        switch (this.getErrorType()) {
            case ERRORBARS: {
                this.drawErrorBars(gc, localCachedPoints);
                break;
            }
            case ERRORSURFACE: {
                this.drawErrorSurface(gc, localCachedPoints);
                break;
            }
            case ERRORCOMBO: {
                if (localCachedPoints.getMinXDistance() >= this.getDashSize() * 2) {
                    this.drawErrorBars(gc, localCachedPoints);
                    break;
                }
                this.drawErrorSurface(gc, localCachedPoints);
                break;
            }
            default: {
                this.drawDefaultNoErrors(gc, localCachedPoints);
            }
        }
        ProcessingProfiler.getTimeDiff((long)start);
    }

    @Override
    public Canvas drawLegendSymbol(DataSet dataSet, int dsIndex, int width, int height) {
        Canvas canvas = new Canvas((double)width, (double)height);
        GraphicsContext gc = canvas.getGraphicsContext2D();
        String style = dataSet.getStyle();
        Integer layoutOffset = StyleParser.getIntegerPropertyValue(style, "dsLayoutOffset");
        Integer dsIndexLocal = StyleParser.getIntegerPropertyValue(style, "dsIndex");
        int dsLayoutIndexOffset = layoutOffset == null ? 0 : layoutOffset;
        int plotingIndex = dsLayoutIndexOffset + (dsIndexLocal == null ? dsIndex : dsIndexLocal);
        gc.save();
        DefaultRenderColorScheme.setLineScheme(gc, dataSet.getStyle(), plotingIndex);
        DefaultRenderColorScheme.setGraphicsContextAttributes(gc, dataSet.getStyle());
        DefaultRenderColorScheme.setFillScheme(gc, dataSet.getStyle(), plotingIndex);
        if (this.getErrorType() == ErrorStyle.ERRORBARS) {
            double x = (double)width / 2.0;
            double y = (double)height / 2.0;
            if (this.getDashSize() > 2) {
                gc.strokeLine(x - 1.0, 1.0, x + 1.0, 1.0);
                gc.strokeLine(x - 1.0, (double)height - 2.0, x + 1.0, (double)height - 2.0);
                gc.strokeLine(x, 1.0, x, (double)height - 2.0);
            }
            gc.strokeLine(1.0, y, (double)width, y);
        } else if (this.getErrorType() == ErrorStyle.ERRORSURFACE) {
            double y = (double)height / 2.0;
            gc.fillRect(1.0, 1.0, (double)width - 2.0, (double)height - 2.0);
            gc.strokeLine(1.0, y, (double)width - 2.0, y);
        } else if (this.getErrorType() == ErrorStyle.ERRORCOMBO) {
            double y = (double)height / 2.0;
            gc.fillRect(1.0, 1.0, (double)width - 2.0, (double)height - 2.0);
            gc.strokeLine(1.0, y, (double)width - 2.0, y);
        } else {
            double x = (double)width / 2.0;
            double y = (double)height / 2.0;
            if (this.getDashSize() > 2) {
                gc.strokeLine(x - 1.0, 1.0, x + 1.0, 1.0);
                gc.strokeLine(x - 1.0, (double)height - 2.0, x + 1.0, (double)height - 2.0);
                gc.strokeLine(x, 1.0, x, (double)height - 2.0);
            }
            gc.strokeLine(1.0, y, (double)width - 2.0, y);
        }
        gc.restore();
        return canvas;
    }

    protected void drawDefaultNoErrors(GraphicsContext gc, CachedDataPoints localCachedPoints) {
        this.drawBars(gc, localCachedPoints);
        this.drawPolyLine(gc, localCachedPoints);
        this.drawMarker(gc, localCachedPoints);
    }

    protected void drawPolyLine(GraphicsContext gc, CachedDataPoints localCachedPoints) {
        switch (this.getPolyLineStyle()) {
            case NONE: {
                return;
            }
            case AREA: {
                this.drawPolyLineArea(gc, localCachedPoints);
                break;
            }
            case ZERO_ORDER_HOLDER: 
            case STAIR_CASE: {
                this.drawPolyLineStairCase(gc, localCachedPoints);
                break;
            }
            case HISTOGRAM: {
                this.drawPolyLineHistogram(gc, localCachedPoints);
                break;
            }
            case HISTOGRAM_FILLED: {
                this.drawPolyLineHistogramFilled(gc, localCachedPoints);
                break;
            }
            case BEZIER_CURVE: {
                this.drawPolyLineHistogramBezier(gc, localCachedPoints);
                break;
            }
            default: {
                this.drawPolyLineLine(gc, localCachedPoints);
            }
        }
    }

    protected void drawPolyLineLine(GraphicsContext gc, CachedDataPoints localCachedPoints) {
        gc.save();
        DefaultRenderColorScheme.setLineScheme(gc, localCachedPoints.defaultStyle, localCachedPoints.dataSetIndex + localCachedPoints.dataSetStyleIndex);
        DefaultRenderColorScheme.setGraphicsContextAttributes(gc, localCachedPoints.defaultStyle);
        for (int i = 0; i < localCachedPoints.actualDataCount - 1; ++i) {
            double x1 = localCachedPoints.xValues[i];
            double x2 = localCachedPoints.xValues[i + 1];
            double y1 = localCachedPoints.yValues[i];
            double y2 = localCachedPoints.yValues[i + 1];
            gc.strokeLine(x1, y1, x2, y2);
        }
        gc.restore();
    }

    protected void drawPolyLineArea(GraphicsContext gc, CachedDataPoints localCachedPoints) {
        double zero = localCachedPoints.yZero;
        int n = localCachedPoints.actualDataCount;
        if (n == 0) {
            return;
        }
        double[] newX = this.cache.getCachedDoubleArray("xDrawPolyLineArea", n + 2);
        double[] newY = this.cache.getCachedDoubleArray("yDrawPolyLineArea", n + 2);
        System.arraycopy(localCachedPoints.xValues, 0, newX, 0, n);
        System.arraycopy(localCachedPoints.yValues, 0, newY, 0, n);
        newX[n] = localCachedPoints.xValues[n - 1];
        newY[n] = zero;
        newX[n + 1] = localCachedPoints.xValues[0];
        newY[n + 1] = zero;
        gc.save();
        DefaultRenderColorScheme.setLineScheme(gc, localCachedPoints.defaultStyle, localCachedPoints.dataSetIndex + localCachedPoints.dataSetStyleIndex);
        DefaultRenderColorScheme.setGraphicsContextAttributes(gc, localCachedPoints.defaultStyle);
        gc.setFill(gc.getStroke());
        gc.fillPolygon(newX, newY, n + 2);
        gc.restore();
        this.cache.release("xDrawPolyLineArea", newX);
        this.cache.release("yDrawPolyLineArea", newY);
    }

    protected void drawPolyLineStairCase(GraphicsContext gc, CachedDataPoints localCachedPoints) {
        int i;
        int n = localCachedPoints.actualDataCount;
        if (n == 0) {
            return;
        }
        double[] newX = this.cache.getCachedDoubleArray("xDrawPolyLineStairCase", 2 * n);
        double[] newY = this.cache.getCachedDoubleArray("yDrawPolyLineStairCase", 2 * n);
        for (i = 0; i < n - 1; ++i) {
            newX[2 * i] = localCachedPoints.xValues[i];
            newY[2 * i] = localCachedPoints.yValues[i];
            newX[2 * i + 1] = localCachedPoints.xValues[i + 1];
            newY[2 * i + 1] = localCachedPoints.yValues[i];
        }
        newX[2 * (n - 1)] = localCachedPoints.xValues[n - 1];
        newY[2 * (n - 1)] = localCachedPoints.yValues[n - 1];
        newX[2 * n - 1] = localCachedPoints.xMax;
        newY[2 * n - 1] = localCachedPoints.yValues[n - 1];
        gc.save();
        DefaultRenderColorScheme.setLineScheme(gc, localCachedPoints.defaultStyle, localCachedPoints.dataSetIndex + localCachedPoints.dataSetStyleIndex);
        DefaultRenderColorScheme.setGraphicsContextAttributes(gc, localCachedPoints.defaultStyle);
        for (i = 0; i < 2 * n - 1; ++i) {
            double x1 = newX[i];
            double x2 = newX[i + 1];
            double y1 = newY[i];
            double y2 = newY[i + 1];
            gc.strokeLine(x1, y1, x2, y2);
        }
        gc.restore();
        this.cache.release("xDrawPolyLineStairCase", newX);
        this.cache.release("yDrawPolyLineStairCase", newY);
    }

    protected void drawPolyLineHistogram(GraphicsContext gc, CachedDataPoints localCachedPoints) {
        int i;
        int n = localCachedPoints.actualDataCount;
        if (n == 0) {
            return;
        }
        double[] newX = this.cache.getCachedDoubleArray("xDrawPolyLineHistogram", 2 * (n + 1));
        double[] newY = this.cache.getCachedDoubleArray("yDrawPolyLineHistogram", 2 * (n + 1));
        double xRange = localCachedPoints.xMax - localCachedPoints.xMin;
        double diffRight = n > 0 ? 0.5 * (localCachedPoints.xValues[1] - localCachedPoints.xValues[0]) : 0.5 * xRange;
        newX[0] = localCachedPoints.xValues[0] - diffRight;
        newY[0] = localCachedPoints.yZero;
        for (i = 0; i < n; ++i) {
            double diffLeft = localCachedPoints.xValues[i] - newX[2 * i];
            double d = diffRight = i + 1 < n ? 0.5 * (localCachedPoints.xValues[i + 1] - localCachedPoints.xValues[i]) : diffLeft;
            if (i == 0) {
                diffLeft = diffRight;
            }
            newX[2 * i + 1] = localCachedPoints.xValues[i] - diffLeft;
            newY[2 * i + 1] = localCachedPoints.yValues[i];
            newX[2 * i + 2] = localCachedPoints.xValues[i] + diffRight;
            newY[2 * i + 2] = localCachedPoints.yValues[i];
        }
        newX[2 * (n + 1) - 1] = localCachedPoints.xValues[n - 1] + diffRight;
        newY[2 * (n + 1) - 1] = localCachedPoints.yZero;
        gc.save();
        DefaultRenderColorScheme.setLineScheme(gc, localCachedPoints.defaultStyle, localCachedPoints.dataSetIndex + localCachedPoints.dataSetStyleIndex);
        DefaultRenderColorScheme.setGraphicsContextAttributes(gc, localCachedPoints.defaultStyle);
        for (i = 0; i < 2 * (n + 1) - 1; ++i) {
            double x1 = newX[i];
            double x2 = newX[i + 1];
            double y1 = newY[i];
            double y2 = newY[i + 1];
            gc.strokeLine(x1, y1, x2, y2);
        }
        gc.restore();
        this.cache.release("xDrawPolyLineHistogram", newX);
        this.cache.release("yDrawPolyLineHistogram", newY);
    }

    protected void drawPolyLineHistogramFilled(GraphicsContext gc, CachedDataPoints localCachedPoints) {
        int n = localCachedPoints.actualDataCount;
        if (n == 0) {
            return;
        }
        double[] newX = this.cache.getCachedDoubleArray("xDrawPolyLineHistogram", 2 * (n + 1));
        double[] newY = this.cache.getCachedDoubleArray("yDrawPolyLineHistogram", 2 * (n + 1));
        double xRange = localCachedPoints.xMax - localCachedPoints.xMin;
        double diffRight = n > 0 ? 0.5 * (localCachedPoints.xValues[1] - localCachedPoints.xValues[0]) : 0.5 * xRange;
        newX[0] = localCachedPoints.xValues[0] - diffRight;
        newY[0] = localCachedPoints.yZero;
        for (int i = 0; i < n; ++i) {
            double diffLeft = localCachedPoints.xValues[i] - newX[2 * i];
            double d = diffRight = i + 1 < n ? 0.5 * (localCachedPoints.xValues[i + 1] - localCachedPoints.xValues[i]) : diffLeft;
            if (i == 0) {
                diffLeft = diffRight;
            }
            newX[2 * i + 1] = localCachedPoints.xValues[i] - diffLeft;
            newY[2 * i + 1] = localCachedPoints.yValues[i];
            newX[2 * i + 2] = localCachedPoints.xValues[i] + diffRight;
            newY[2 * i + 2] = localCachedPoints.yValues[i];
        }
        newX[2 * (n + 1) - 1] = localCachedPoints.xValues[n - 1] + diffRight;
        newY[2 * (n + 1) - 1] = localCachedPoints.yZero;
        gc.save();
        DefaultRenderColorScheme.setLineScheme(gc, localCachedPoints.defaultStyle, localCachedPoints.dataSetIndex + localCachedPoints.dataSetStyleIndex);
        DefaultRenderColorScheme.setGraphicsContextAttributes(gc, localCachedPoints.defaultStyle);
        gc.setFill(gc.getStroke());
        gc.fillPolygon(newX, newY, 2 * (n + 1));
        gc.restore();
        this.cache.release("xDrawPolyLineHistogram", newX);
        this.cache.release("yDrawPolyLineHistogram", newY);
    }

    protected void drawPolyLineHistogramBezier(GraphicsContext gc, CachedDataPoints localCachedPoints) {
        int n = localCachedPoints.actualDataCount;
        if (n < 2) {
            this.drawPolyLineLine(gc, localCachedPoints);
            return;
        }
        double[] xCp1 = this.cache.getCachedDoubleArray("xBezierFirstControlPoint", n);
        double[] yCp1 = this.cache.getCachedDoubleArray("yBezierFirstControlPoint", n);
        double[] xCp2 = this.cache.getCachedDoubleArray("xBezierSecondControlPoint", n);
        double[] yCp2 = this.cache.getCachedDoubleArray("yBezierSecondControlPoint", n);
        BezierCurve.calcCurveControlPoints(localCachedPoints.xValues, localCachedPoints.yValues, xCp1, yCp1, xCp2, yCp2, localCachedPoints.actualDataCount);
        gc.save();
        DefaultRenderColorScheme.setLineScheme(gc, localCachedPoints.defaultStyle, localCachedPoints.dataSetIndex + localCachedPoints.dataSetStyleIndex);
        DefaultRenderColorScheme.setGraphicsContextAttributes(gc, localCachedPoints.defaultStyle);
        gc.setFill(gc.getStroke());
        gc.beginPath();
        for (int i = 0; i < n - 1; ++i) {
            double x0 = localCachedPoints.xValues[i];
            double x1 = localCachedPoints.xValues[i + 1];
            double y0 = localCachedPoints.yValues[i];
            double y1 = localCachedPoints.yValues[i + 1];
            double xc0 = xCp1[i];
            double yc0 = yCp1[i];
            double xc1 = xCp2[i];
            double yc1 = yCp2[i];
            gc.moveTo(x0, y0);
            gc.bezierCurveTo(xc0, yc0, xc1, yc1, x1, y1);
        }
        gc.moveTo(localCachedPoints.xValues[n - 1], localCachedPoints.yValues[n - 1]);
        gc.closePath();
        gc.stroke();
        gc.restore();
        this.cache.release("xBezierFirstControlPoint", xCp1);
        this.cache.release("yBezierFirstControlPoint", yCp1);
        this.cache.release("xBezierSecondControlPoint", xCp2);
        this.cache.release("yBezierSecondControlPoint", yCp2);
    }

    protected void drawMarker(GraphicsContext gc, CachedDataPoints localCachedPoints) {
        if (!this.isDrawMarker()) {
            return;
        }
        gc.save();
        DefaultRenderColorScheme.setMarkerScheme(gc, localCachedPoints.defaultStyle, localCachedPoints.dataSetIndex + localCachedPoints.dataSetStyleIndex);
        Color fillColor = StyleParser.getColorPropertyValue(localCachedPoints.defaultStyle, "strokeColor");
        if (fillColor != null) {
            gc.setFill((Paint)fillColor);
        }
        for (int i = 0; i < localCachedPoints.actualDataCount; ++i) {
            double mSize = this.getMarkerSize();
            gc.fillRect(localCachedPoints.xValues[i] - mSize, localCachedPoints.yValues[i] - mSize, 2.0 * mSize, 2.0 * mSize);
        }
        gc.restore();
    }

    protected void drawBars(GraphicsContext gc, CachedDataPoints localCachedPoints) {
        if (!this.isDrawBars()) {
            return;
        }
        int xOffset = localCachedPoints.dataSetIndex >= 0 ? localCachedPoints.dataSetIndex : 0;
        int minRequiredWidth = Math.max(this.getDashSize(), localCachedPoints.minDistanceX);
        double barWPercentage = this.getBarWidthPercentage();
        double dynBarWidth = (double)minRequiredWidth * barWPercentage / 100.0;
        double constBarWidth = this.getBarWidth();
        double localBarWidth = this.isDynamicBarWidth() ? dynBarWidth : constBarWidth;
        double barWidthHalf = localBarWidth / 2.0 - (double)(this.isShiftBar() ? xOffset * this.getShiftBarOffset() : 0);
        gc.save();
        DefaultRenderColorScheme.setMarkerScheme(gc, localCachedPoints.defaultStyle, localCachedPoints.dataSetIndex + localCachedPoints.dataSetStyleIndex);
        DefaultRenderColorScheme.setGraphicsContextAttributes(gc, localCachedPoints.defaultStyle);
        if (localCachedPoints.polarPlot) {
            for (int i = 0; i < localCachedPoints.actualDataCount; ++i) {
                if (localCachedPoints.selected[i]) {
                    gc.strokeLine(localCachedPoints.xZero, localCachedPoints.yZero, localCachedPoints.xValues[i], localCachedPoints.yValues[i]);
                    continue;
                }
                gc.save();
                gc.setLineWidth(barWidthHalf);
                gc.strokeLine(localCachedPoints.xZero, localCachedPoints.yZero, localCachedPoints.xValues[i], localCachedPoints.yValues[i]);
                gc.restore();
            }
        } else {
            for (int i = 0; i < localCachedPoints.actualDataCount; ++i) {
                double yMin;
                double yDiff = localCachedPoints.yValues[i] - localCachedPoints.yZero;
                if (yDiff > 0.0) {
                    yMin = localCachedPoints.yZero;
                } else {
                    yMin = localCachedPoints.yValues[i];
                    yDiff = Math.abs(yDiff);
                }
                if (localCachedPoints.selected[i]) {
                    gc.strokeRect(localCachedPoints.xValues[i] - barWidthHalf, yMin, localBarWidth, yDiff);
                    continue;
                }
                gc.fillRect(localCachedPoints.xValues[i] - barWidthHalf, yMin, localBarWidth, yDiff);
            }
        }
        gc.restore();
    }

    protected void drawErrorBars(GraphicsContext gc, CachedDataPoints lCacheP) {
        long start = ProcessingProfiler.getTimeStamp();
        this.drawBars(gc, lCacheP);
        int dashHalf = this.getDashSize() / 2;
        gc.save();
        DefaultRenderColorScheme.setFillScheme(gc, lCacheP.defaultStyle, lCacheP.dataSetIndex);
        DefaultRenderColorScheme.setGraphicsContextAttributes(gc, lCacheP.defaultStyle);
        for (int i = 0; i < lCacheP.actualDataCount; ++i) {
            if (lCacheP.errorType == DataSetError.ErrorType.XY || lCacheP.errorType == DataSetError.ErrorType.XY_ASYMMETRIC) {
                gc.strokeLine(lCacheP.xValues[i], lCacheP.errorYNeg[i], lCacheP.xValues[i], lCacheP.errorYPos[i]);
                gc.strokeLine(lCacheP.errorXNeg[i], lCacheP.yValues[i], lCacheP.errorXPos[i], lCacheP.yValues[i]);
                gc.strokeLine(lCacheP.xValues[i] - (double)dashHalf, lCacheP.errorYNeg[i], lCacheP.xValues[i] + (double)dashHalf, lCacheP.errorYNeg[i]);
                gc.strokeLine(lCacheP.xValues[i] - (double)dashHalf, lCacheP.errorYPos[i], lCacheP.xValues[i] + (double)dashHalf, lCacheP.errorYPos[i]);
                gc.strokeLine(lCacheP.errorXNeg[i], lCacheP.yValues[i] - (double)dashHalf, lCacheP.errorXNeg[i], lCacheP.yValues[i] + (double)dashHalf);
                gc.strokeLine(lCacheP.errorXPos[i], lCacheP.yValues[i] - (double)dashHalf, lCacheP.errorXPos[i], lCacheP.yValues[i] + (double)dashHalf);
                continue;
            }
            if (lCacheP.errorType == DataSetError.ErrorType.Y || lCacheP.errorType == DataSetError.ErrorType.Y_ASYMMETRIC) {
                gc.strokeLine(lCacheP.xValues[i], lCacheP.errorYNeg[i], lCacheP.xValues[i], lCacheP.errorYPos[i]);
                gc.strokeLine(lCacheP.xValues[i] - (double)dashHalf, lCacheP.errorYNeg[i], lCacheP.xValues[i] + (double)dashHalf, lCacheP.errorYNeg[i]);
                gc.strokeLine(lCacheP.xValues[i] - (double)dashHalf, lCacheP.errorYPos[i], lCacheP.xValues[i] + (double)dashHalf, lCacheP.errorYPos[i]);
                continue;
            }
            if (lCacheP.errorType != DataSetError.ErrorType.X && lCacheP.errorType != DataSetError.ErrorType.X_ASYMMETRIC) continue;
            gc.strokeLine(lCacheP.errorXNeg[i], lCacheP.yValues[i], lCacheP.errorXPos[i], lCacheP.yValues[i]);
            gc.strokeLine(lCacheP.xValues[i] - (double)dashHalf, lCacheP.errorYNeg[i], lCacheP.xValues[i] + (double)dashHalf, lCacheP.errorYNeg[i]);
            gc.strokeLine(lCacheP.xValues[i] - (double)dashHalf, lCacheP.errorYPos[i], lCacheP.xValues[i] + (double)dashHalf, lCacheP.errorYPos[i]);
        }
        gc.restore();
        this.drawPolyLine(gc, lCacheP);
        this.drawMarker(gc, lCacheP);
        ProcessingProfiler.getTimeDiff((long)start);
    }

    protected void drawErrorSurface(GraphicsContext gc, CachedDataPoints localCachedPoints) {
        long start = ProcessingProfiler.getTimeStamp();
        DefaultRenderColorScheme.setFillScheme(gc, localCachedPoints.defaultStyle, localCachedPoints.dataSetIndex + localCachedPoints.dataSetStyleIndex);
        int nDataCount = localCachedPoints.actualDataCount;
        int nPolygoneEdges = 2 * nDataCount;
        double[] xValuesSurface = this.cache.getCachedDoubleArray("xValuesSurface", nPolygoneEdges);
        double[] yValuesSurface = this.cache.getCachedDoubleArray("yValuesSurface", nPolygoneEdges);
        int xend = nPolygoneEdges - 1;
        for (int i = 0; i < nDataCount; ++i) {
            xValuesSurface[i] = localCachedPoints.xValues[i];
            yValuesSurface[i] = localCachedPoints.errorYNeg[i];
            xValuesSurface[xend - i] = localCachedPoints.xValues[i];
            yValuesSurface[xend - i] = localCachedPoints.errorYPos[i];
        }
        if (nDataCount > 4) {
            double yTmp = yValuesSurface[nDataCount - 1];
            yValuesSurface[nDataCount - 1] = yValuesSurface[xend - nDataCount + 1];
            yValuesSurface[xend - nDataCount + 1] = yTmp;
        }
        gc.setFillRule(FillRule.EVEN_ODD);
        gc.fillPolygon(xValuesSurface, yValuesSurface, nPolygoneEdges);
        this.drawPolyLine(gc, localCachedPoints);
        this.drawBars(gc, localCachedPoints);
        this.drawMarker(gc, localCachedPoints);
        this.cache.release("xValuesSurface", xValuesSurface);
        this.cache.release("yValuesSurface", yValuesSurface);
        ProcessingProfiler.getTimeDiff((long)start);
    }

    @Override
    protected ErrorDataSetRenderer getThis() {
        return this;
    }

    public Marker getMarker() {
        return this.marker;
    }

    public void setMarker(Marker marker) {
        this.marker = marker;
    }

    protected class CachedDataPoints {
        protected double[] xValues;
        protected double[] yValues;
        protected double[] errorXNeg;
        protected double[] errorXPos;
        protected double[] errorYNeg;
        protected double[] errorYPos;
        protected boolean[] selected;
        protected String[] styles;
        protected boolean xAxisInverted;
        protected boolean yAxisInverted;
        protected String defaultStyle;
        protected int dataSetIndex;
        protected int dataSetStyleIndex;
        protected DataSetError.ErrorType errorType;
        protected int indexMin;
        protected int indexMax;
        protected int minDistanceX = Integer.MAX_VALUE;
        protected double xZero;
        protected double yZero;
        protected double yMin;
        protected double yMax;
        protected double xMin;
        protected double xMax;
        protected boolean polarPlot;
        protected double xRange;
        protected double yRange;
        protected double maxRadius;
        protected int maxDataCount;
        protected int actualDataCount;

        public CachedDataPoints(int indexMin, int indexMax, int dataLength, boolean full) {
            this.maxDataCount = dataLength;
            this.xValues = ErrorDataSetRenderer.this.cache.getCachedDoubleArray("xValues", this.maxDataCount);
            this.yValues = ErrorDataSetRenderer.this.cache.getCachedDoubleArray("yValues", this.maxDataCount);
            this.styles = ErrorDataSetRenderer.this.cache.getCachedStringArray("styles", dataLength);
            this.indexMin = indexMin;
            this.indexMax = indexMax;
            this.errorYNeg = ErrorDataSetRenderer.this.cache.getCachedDoubleArray("errorYNeg", this.maxDataCount);
            this.errorYPos = ErrorDataSetRenderer.this.cache.getCachedDoubleArray("errorYPos", this.maxDataCount);
            if (full) {
                this.errorXNeg = ErrorDataSetRenderer.this.cache.getCachedDoubleArray("errorXNeg", this.maxDataCount);
                this.errorXPos = ErrorDataSetRenderer.this.cache.getCachedDoubleArray("errorXPos", this.maxDataCount);
            }
            this.selected = ErrorDataSetRenderer.this.cache.getCachedBooleanArray("selected", dataLength);
            ArrayUtils.fillArray((Object[])this.styles, null);
        }

        private int getMinXDistance() {
            if (this.minDistanceX < Integer.MAX_VALUE) {
                return this.minDistanceX;
            }
            if (this.indexMin >= this.indexMax) {
                this.minDistanceX = 1;
                return this.minDistanceX;
            }
            this.minDistanceX = Integer.MAX_VALUE;
            for (int i = 1; i < this.actualDataCount; ++i) {
                double x0 = this.xValues[i - 1];
                double x1 = this.xValues[i];
                this.minDistanceX = Math.min(this.minDistanceX, (int)Math.abs(x1 - x0));
            }
            return this.minDistanceX;
        }

        private void computeScreenCoordinates(Chart chart, DataSet dataSet, int dsIndex, int min, int max) {
            if (!(ErrorDataSetRenderer.this.getFirstAxis(Orientation.HORIZONTAL) instanceof Axis)) {
                throw new InvalidParameterException("x Axis not a Axis derivative, xAxis = " + ErrorDataSetRenderer.this.getFirstAxis(Orientation.HORIZONTAL));
            }
            if (!(ErrorDataSetRenderer.this.getFirstAxis(Orientation.VERTICAL) instanceof Axis)) {
                throw new InvalidParameterException("y Axis not a Axis derivative, yAxis = " + ErrorDataSetRenderer.this.getFirstAxis(Orientation.VERTICAL));
            }
            Axis xAxis = ErrorDataSetRenderer.this.getFirstAxis(Orientation.HORIZONTAL);
            Axis yAxis = ErrorDataSetRenderer.this.getFirstAxis(Orientation.VERTICAL);
            this.xAxisInverted = xAxis.isInvertedAxis();
            this.yAxisInverted = yAxis.isInvertedAxis();
            this.indexMin = min;
            this.indexMax = max;
            this.xZero = xAxis.isLogAxis() ? xAxis.getDisplayPosition(xAxis.getLowerBound()) : xAxis.getDisplayPosition(0.0);
            this.yZero = yAxis.isLogAxis() ? yAxis.getDisplayPosition(yAxis.getLowerBound()) : yAxis.getDisplayPosition(0.0);
            this.polarPlot = ErrorDataSetRenderer.this.isPolarPlot;
            this.yMin = yAxis.getDisplayPosition(yAxis.getLowerBound());
            this.yMax = yAxis.getDisplayPosition(yAxis.getUpperBound());
            this.xMin = xAxis.getDisplayPosition(xAxis.getLowerBound());
            this.xMax = xAxis.getDisplayPosition(xAxis.getUpperBound());
            this.defaultStyle = dataSet.getStyle();
            this.xRange = Math.abs(this.xMax - this.xMin);
            this.yRange = Math.abs(this.yMax - this.yMin);
            this.maxRadius = 0.5 * Math.max(Math.min(this.xRange, this.yRange), 20.0) * 0.9;
            if (this.polarPlot) {
                this.xZero = 0.5 * this.xRange;
                this.yZero = 0.5 * this.yRange;
            }
            Integer layoutOffset = StyleParser.getIntegerPropertyValue(this.defaultStyle, "dsLayoutOffset");
            Integer dsIndexLocal = StyleParser.getIntegerPropertyValue(this.defaultStyle, "dsIndex");
            this.dataSetStyleIndex = layoutOffset == null ? 0 : layoutOffset;
            int n = this.dataSetIndex = dsIndexLocal == null ? dsIndex : dsIndexLocal;
            if (dataSet instanceof DataSetError) {
                DataSetError ds = (DataSetError)dataSet;
                this.errorType = ds.getErrorType();
            } else {
                this.errorType = DataSetError.ErrorType.Y;
            }
            if (ErrorDataSetRenderer.this.getErrorType() == ErrorStyle.NONE) {
                this.errorType = DataSetError.ErrorType.NO_ERROR;
            }
            if (ErrorDataSetRenderer.this.isParallelImplementation()) {
                int minthreshold = 1000;
                int divThread = (int)Math.ceil((double)Math.abs(max - min) / (double)MAX_THREADS);
                int stepSize = Math.max(divThread, 1000);
                ArrayList<Callable<Boolean>> workers = new ArrayList<Callable<Boolean>>();
                for (int i = min; i < max; i += stepSize) {
                    int start = i;
                    workers.add(() -> {
                        this.computeScreenCoordinates(xAxis, yAxis, dataSet, start, Math.min(max, start + stepSize));
                        return Boolean.TRUE;
                    });
                }
                try {
                    List jobs = executorService.invokeAll(workers);
                    for (Future future : jobs) {
                        Boolean r = (Boolean)future.get();
                        if (r.booleanValue()) continue;
                        throw new IllegalStateException("one parallel worker thread finished execution with error");
                    }
                }
                catch (InterruptedException | ExecutionException e) {
                    throw new IllegalStateException("one parallel worker thread finished execution with error", e);
                }
            } else {
                this.computeScreenCoordinates(xAxis, yAxis, dataSet, min, max);
            }
        }

        private void computeScreenCoordinates(Axis xAxis, Axis yAxis, DataSet dataSet, int min, int max) {
            switch (this.errorType) {
                case NO_ERROR: {
                    if (!this.polarPlot) {
                        for (int index = min; index < max; ++index) {
                            double x = dataSet.getX(index);
                            double y = dataSet.getY(index);
                            this.xValues[index] = xAxis.getDisplayPosition(x);
                            this.yValues[index] = yAxis.getDisplayPosition(y);
                            if (Double.isFinite(this.yValues[index])) continue;
                            this.yValues[index] = this.yMin;
                        }
                    } else {
                        for (int index = min; index < max; ++index) {
                            double x = dataSet.getX(index);
                            double y = dataSet.getY(index);
                            double phi = x * (Math.PI / 180);
                            double r = this.maxRadius * Math.abs(1.0 - yAxis.getDisplayPosition(y) / this.yRange);
                            this.xValues[index] = this.xZero + r * Math.cos(phi);
                            this.yValues[index] = this.yZero + r * Math.sin(phi);
                            if (Double.isFinite(this.yValues[index])) continue;
                            this.yValues[index] = this.yZero;
                        }
                    }
                    return;
                }
                case Y: 
                case Y_ASYMMETRIC: {
                    if (!this.polarPlot) {
                        if (dataSet instanceof DataSetError) {
                            DataSetError ds = (DataSetError)dataSet;
                            for (int index = min; index < max; ++index) {
                                double x = dataSet.getX(index);
                                double y = dataSet.getY(index);
                                this.xValues[index] = xAxis.getDisplayPosition(x);
                                this.yValues[index] = yAxis.getDisplayPosition(y);
                                if (Double.isFinite(this.yValues[index])) {
                                    this.errorYNeg[index] = yAxis.getDisplayPosition(y - ds.getYErrorNegative(index));
                                    this.errorYPos[index] = yAxis.getDisplayPosition(y + ds.getYErrorPositive(index));
                                    continue;
                                }
                                this.yValues[index] = this.yMin;
                                this.errorYNeg[index] = this.yMin;
                                this.errorYPos[index] = this.yMin;
                            }
                            return;
                        }
                        for (int index = min; index < max; ++index) {
                            double x = dataSet.getX(index);
                            double y = dataSet.getY(index);
                            this.xValues[index] = xAxis.getDisplayPosition(x);
                            this.yValues[index] = yAxis.getDisplayPosition(y);
                            if (!Double.isFinite(this.xValues[index])) {
                                this.xValues[index] = this.xMin;
                            }
                            if (Double.isFinite(this.yValues[index])) {
                                this.errorYNeg[index] = this.yValues[index];
                                this.errorYPos[index] = this.yValues[index];
                                continue;
                            }
                            this.yValues[index] = this.yMin;
                            this.errorYNeg[index] = this.yMin;
                            this.errorYPos[index] = this.yMin;
                        }
                    } else {
                        for (int index = min; index < max; ++index) {
                            double x = dataSet.getX(index);
                            double y = dataSet.getY(index);
                            double phi = x * (Math.PI / 180);
                            double r = this.maxRadius * Math.abs(1.0 - yAxis.getDisplayPosition(y) / this.yRange);
                            this.xValues[index] = this.xZero + r * Math.cos(phi);
                            this.yValues[index] = this.yZero + r * Math.sin(phi);
                            this.errorXNeg[index] = 0.0;
                            this.errorXPos[index] = 0.0;
                            this.errorYNeg[index] = 0.0;
                            this.errorYPos[index] = 0.0;
                            if (Double.isFinite(this.yValues[index])) continue;
                            this.yValues[index] = this.yZero;
                        }
                    }
                    return;
                }
            }
            if (!(dataSet instanceof DataSetError)) {
                throw new IllegalStateException("dataSet may not be non-DataSetError at this stage, dataSet = " + dataSet.getName() + " errorType = " + this.errorType);
            }
            DataSetError ds = (DataSetError)dataSet;
            if (!this.polarPlot) {
                for (int index = min; index < max; ++index) {
                    double x = dataSet.getX(index);
                    double y = dataSet.getY(index);
                    this.xValues[index] = xAxis.getDisplayPosition(x);
                    this.yValues[index] = yAxis.getDisplayPosition(y);
                    if (Double.isFinite(this.xValues[index])) {
                        this.errorXNeg[index] = xAxis.getDisplayPosition(x - ds.getXErrorNegative(index));
                        this.errorXPos[index] = xAxis.getDisplayPosition(x + ds.getXErrorPositive(index));
                    } else {
                        this.xValues[index] = this.xMin;
                        this.errorXNeg[index] = this.xMin;
                        this.errorXPos[index] = this.xMin;
                    }
                    if (Double.isFinite(this.yValues[index])) {
                        this.errorYNeg[index] = yAxis.getDisplayPosition(y - ds.getYErrorNegative(index));
                        this.errorYPos[index] = yAxis.getDisplayPosition(y + ds.getYErrorPositive(index));
                        continue;
                    }
                    this.yValues[index] = this.yMin;
                    this.errorYNeg[index] = this.yMin;
                    this.errorYPos[index] = this.yMin;
                }
            } else {
                for (int index = min; index < max; ++index) {
                    double x = dataSet.getX(index);
                    double y = dataSet.getY(index);
                    double phi = x * (Math.PI / 180);
                    double r = this.maxRadius * Math.abs(1.0 - yAxis.getDisplayPosition(y) / this.yRange);
                    this.xValues[index] = this.xZero + r * Math.cos(phi);
                    this.yValues[index] = this.yZero + r * Math.sin(phi);
                    this.errorXNeg[index] = 0.0;
                    this.errorXPos[index] = 0.0;
                    this.errorYNeg[index] = 0.0;
                    this.errorYPos[index] = 0.0;
                    if (Double.isFinite(this.yValues[index])) continue;
                    this.yValues[index] = this.yZero;
                }
            }
        }

        private int minDataPointDistanceX() {
            if (this.actualDataCount <= 1) {
                this.minDistanceX = 1;
                return this.minDistanceX;
            }
            this.minDistanceX = Integer.MAX_VALUE;
            for (int i = 1; i < this.actualDataCount; ++i) {
                double x0 = this.xValues[i - 1];
                double x1 = this.xValues[i];
                this.minDistanceX = Math.min(this.minDistanceX, (int)Math.abs(x1 - x0));
            }
            return this.minDistanceX;
        }

        protected void reduce() {
            long startTimeStamp = ProcessingProfiler.getTimeStamp();
            this.actualDataCount = 1;
            if (!ErrorDataSetRenderer.this.isReducePoints() || Math.abs(this.indexMax - this.indexMin) < ErrorDataSetRenderer.this.getMinRequiredReductionSize()) {
                this.actualDataCount = this.indexMax - this.indexMin;
                System.arraycopy(this.xValues, this.indexMin, this.xValues, 0, this.actualDataCount);
                System.arraycopy(this.yValues, this.indexMin, this.yValues, 0, this.actualDataCount);
                System.arraycopy(this.selected, this.indexMin, this.selected, 0, this.actualDataCount);
                switch (this.errorType) {
                    case NO_ERROR: {
                        break;
                    }
                    case Y: 
                    case Y_ASYMMETRIC: {
                        System.arraycopy(this.errorYNeg, this.indexMin, this.errorYNeg, 0, this.actualDataCount);
                        System.arraycopy(this.errorYPos, this.indexMin, this.errorYPos, 0, this.actualDataCount);
                        break;
                    }
                    default: {
                        System.arraycopy(this.errorXNeg, this.indexMin, this.errorXNeg, 0, this.actualDataCount);
                        System.arraycopy(this.errorXPos, this.indexMin, this.errorXPos, 0, this.actualDataCount);
                        System.arraycopy(this.errorYNeg, this.indexMin, this.errorYNeg, 0, this.actualDataCount);
                        System.arraycopy(this.errorYPos, this.indexMin, this.errorYPos, 0, this.actualDataCount);
                    }
                }
                ProcessingProfiler.getTimeDiff((long)startTimeStamp, (String)String.format("no data reduction (%d)", this.actualDataCount));
                return;
            }
            RendererDataReducer cruncher = (RendererDataReducer)ErrorDataSetRenderer.this.rendererDataReducerProperty().get();
            if (!ErrorDataSetRenderer.this.isReducePoints()) {
                // empty if block
            }
            switch (this.errorType) {
                case NO_ERROR: 
                case Y: {
                    this.actualDataCount = cruncher.reducePoints(this.xValues, this.yValues, null, null, this.errorYPos, this.errorYNeg, this.styles, this.selected, this.indexMin, this.indexMax);
                    this.minDataPointDistanceX();
                    break;
                }
                default: {
                    this.actualDataCount = cruncher.reducePoints(this.xValues, this.yValues, this.errorXPos, this.errorXNeg, this.errorYPos, this.errorYNeg, this.styles, this.selected, this.indexMin, this.indexMax);
                    this.minDataPointDistanceX();
                }
            }
        }

        protected void finalize() throws Throwable {
            this.release();
            super.finalize();
        }

        public void release() {
            ErrorDataSetRenderer.this.cache.release("xValues", this.xValues);
            ErrorDataSetRenderer.this.cache.release("yValues", this.yValues);
            ErrorDataSetRenderer.this.cache.release("errorYNeg", this.errorYNeg);
            ErrorDataSetRenderer.this.cache.release("errorYPos", this.errorYPos);
            ErrorDataSetRenderer.this.cache.release("errorXNeg", this.errorXNeg);
            ErrorDataSetRenderer.this.cache.release("errorXPos", this.errorXPos);
            ErrorDataSetRenderer.this.cache.release("selected", this.selected);
            ErrorDataSetRenderer.this.cache.release("styles", this.styles);
        }
    }
}

