/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.renderer.spi;

import de.gsi.chart.renderer.ErrorStyle;
import de.gsi.chart.renderer.LineStyle;
import de.gsi.chart.renderer.RendererDataReducer;
import de.gsi.chart.renderer.datareduction.DefaultDataReducer;
import de.gsi.chart.renderer.spi.AbstractDataSetManagement;
import de.gsi.dataset.utils.AssertUtils;
import java.security.InvalidParameterException;
import java.util.Collection;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;

public abstract class AbstractErrorDataSetRendererParameter<R extends AbstractErrorDataSetRendererParameter<R>>
extends AbstractDataSetManagement<R> {
    protected static final double DEFAULT_HISTORY_INTENSITY_FADING = 0.65;
    private final ObjectProperty<ErrorStyle> errorStyle = new SimpleObjectProperty((Object)this, "errorStyle", (Object)ErrorStyle.ERRORCOMBO);
    private final ObjectProperty<RendererDataReducer> rendererDataReducer = new SimpleObjectProperty((Object)this, "rendererDataReducer", (Object)new DefaultDataReducer());
    private BooleanProperty pointReduction = new SimpleBooleanProperty((Object)this, "pointReduction", true);
    private IntegerProperty dashSize = new SimpleIntegerProperty((Object)this, "dashSize", 3);
    private IntegerProperty minRequiredReductionSize = new SimpleIntegerProperty((Object)this, "minRequiredReductionSize", 5);
    private DoubleProperty markerSize = new SimpleDoubleProperty((Object)this, "markerSize", 1.5);
    private BooleanProperty drawMarker = new SimpleBooleanProperty((Object)this, "drawMarker", true);
    private final ObjectProperty<LineStyle> polyLineStyle = new SimpleObjectProperty((Object)this, "polyLineStyle", (Object)LineStyle.NORMAL);
    private BooleanProperty drawBars = new SimpleBooleanProperty((Object)this, "drawBars", false);
    private BooleanProperty shiftBar = new SimpleBooleanProperty((Object)this, "shiftBar", true);
    private IntegerProperty shiftBarOffset = new SimpleIntegerProperty((Object)this, "shiftBarOffset", 3);
    private BooleanProperty dynamicBarWidth = new SimpleBooleanProperty((Object)this, "dynamicBarWidth", true);
    private DoubleProperty barWidthPercentage = new SimpleDoubleProperty((Object)this, "barWidthPercentage", 70.0);
    private IntegerProperty barWidth = new SimpleIntegerProperty((Object)this, "barWidth", 5);
    private BooleanProperty parallelImplementation = new SimpleBooleanProperty((Object)this, "parallelImplementation", false);
    private DoubleProperty intensityFading = new SimpleDoubleProperty((Object)this, "intensityFading", 0.65);
    private boolean xsalgorithmChoice;
    protected BooleanProperty algorithmChoice;
    private int xsnumberOfPoints = 57;
    protected IntegerProperty numberOfPoints;

    @Override
    protected abstract R getThis();

    protected R bind(R other) {
        this.errorStyleProperty().bind(((AbstractErrorDataSetRendererParameter)other).errorStyleProperty());
        this.pointReductionProperty().bind((ObservableValue)((AbstractErrorDataSetRendererParameter)other).pointReductionProperty());
        this.dashSizeProperty().bind((ObservableValue)((AbstractErrorDataSetRendererParameter)other).dashSizeProperty());
        this.minRequiredReductionSizeProperty().bind((ObservableValue)((AbstractErrorDataSetRendererParameter)other).minRequiredReductionSizeProperty());
        this.markerSizeProperty().bind((ObservableValue)((AbstractErrorDataSetRendererParameter)other).markerSizeProperty());
        this.drawMarkerProperty().bind((ObservableValue)((AbstractErrorDataSetRendererParameter)other).drawMarkerProperty());
        this.polyLineStyleProperty().bind(((AbstractErrorDataSetRendererParameter)other).polyLineStyleProperty());
        this.drawBarsProperty().bind((ObservableValue)((AbstractErrorDataSetRendererParameter)other).drawBarsProperty());
        this.shiftBarProperty().bind((ObservableValue)((AbstractErrorDataSetRendererParameter)other).shiftBarProperty());
        this.shiftBarOffsetProperty().bind((ObservableValue)((AbstractErrorDataSetRendererParameter)other).shiftBarOffsetProperty());
        this.dynamicBarWidthProperty().bind((ObservableValue)((AbstractErrorDataSetRendererParameter)other).dynamicBarWidthProperty());
        this.barWidthPercentageProperty().bind((ObservableValue)((AbstractErrorDataSetRendererParameter)other).barWidthPercentageProperty());
        this.barWidthProperty().bind((ObservableValue)((AbstractErrorDataSetRendererParameter)other).barWidthProperty());
        this.getAxes().setAll(((AbstractDataSetManagement)other).getAxes());
        this.intensityFadingProperty().bind((ObservableValue)((AbstractErrorDataSetRendererParameter)other).intensityFadingProperty());
        ((AbstractDataSetManagement)other).getAxes().addListener(change -> {
            while (change.next()) {
                this.getAxes().addAll((Collection)change.getAddedSubList());
                this.getAxes().removeAll((Collection)change.getRemoved());
            }
        });
        return (R)this.getThis();
    }

    protected R unbind() {
        this.errorStyleProperty().unbind();
        this.pointReductionProperty().unbind();
        this.dashSizeProperty().unbind();
        this.minRequiredReductionSizeProperty().unbind();
        this.markerSizeProperty().unbind();
        this.drawMarkerProperty().unbind();
        this.polyLineStyleProperty().unbind();
        this.drawBarsProperty().unbind();
        this.shiftBarProperty().unbind();
        this.shiftBarOffsetProperty().unbind();
        this.dynamicBarWidthProperty().unbind();
        this.barWidthPercentageProperty().unbind();
        this.barWidthProperty().unbind();
        this.intensityFadingProperty().unbind();
        return (R)this.getThis();
    }

    public R setErrorType(ErrorStyle style) {
        this.errorStyle.set((Object)style);
        return (R)this.getThis();
    }

    public ErrorStyle getErrorType() {
        return (ErrorStyle)((Object)this.errorStyle.get());
    }

    public ObjectProperty<ErrorStyle> errorStyleProperty() {
        return this.errorStyle;
    }

    public ObjectProperty<RendererDataReducer> rendererDataReducerProperty() {
        return this.rendererDataReducer;
    }

    public RendererDataReducer getRendererDataReducer() {
        return (RendererDataReducer)this.rendererDataReducer.get();
    }

    public R getRendererDataReducer(RendererDataReducer algorithm) {
        if (algorithm == null) {
            this.rendererDataReducer.set((Object)new DefaultDataReducer());
        } else {
            this.rendererDataReducer.set((Object)algorithm);
        }
        return (R)this.getThis();
    }

    public boolean isReducePoints() {
        return this.pointReduction.get();
    }

    public R setPointReduction(boolean state) {
        this.pointReduction.set(state);
        return (R)this.getThis();
    }

    public BooleanProperty pointReductionProperty() {
        return this.pointReduction;
    }

    public int getDashSize() {
        return this.dashSize.get();
    }

    public R setDashSize(int dashSize) {
        AssertUtils.gtEqThanZero((String)"dash size", (int)dashSize);
        this.dashSize.setValue((Number)dashSize);
        return (R)this.getThis();
    }

    public IntegerProperty dashSizeProperty() {
        return this.dashSize;
    }

    public int getMinRequiredReductionSize() {
        return this.minRequiredReductionSize.get();
    }

    public R setMinRequiredReductionSize(int size) {
        this.minRequiredReductionSize.setValue((Number)size);
        return (R)this.getThis();
    }

    public IntegerProperty minRequiredReductionSizeProperty() {
        return this.minRequiredReductionSize;
    }

    public double getMarkerSize() {
        return this.markerSize.get();
    }

    public R setMarkerSize(double size) {
        AssertUtils.gtEqThanZero((String)"marker size ", (double)size);
        this.markerSize.setValue((Number)size);
        return (R)this.getThis();
    }

    public DoubleProperty markerSizeProperty() {
        return this.markerSize;
    }

    public double getIntensityFading() {
        return this.intensityFading.get();
    }

    public R setIntensityFading(double size) {
        this.intensityFading.setValue((Number)size);
        return (R)this.getThis();
    }

    public DoubleProperty intensityFadingProperty() {
        return this.intensityFading;
    }

    public boolean isDrawMarker() {
        return this.drawMarker.get();
    }

    public R setDrawMarker(boolean state) {
        this.drawMarker.set(state);
        return (R)this.getThis();
    }

    public BooleanProperty drawMarkerProperty() {
        return this.drawMarker;
    }

    public boolean isDrawBars() {
        return this.drawBars.get();
    }

    public R setDrawBars(boolean state) {
        this.drawBars.set(state);
        return (R)this.getThis();
    }

    public BooleanProperty drawBarsProperty() {
        return this.drawBars;
    }

    public boolean isShiftBar() {
        return this.shiftBar.get();
    }

    public R setShiftBar(boolean state) {
        this.shiftBar.set(state);
        return (R)this.getThis();
    }

    public BooleanProperty shiftBarProperty() {
        return this.shiftBar;
    }

    public int getShiftBarOffset() {
        return this.shiftBarOffset.get();
    }

    public R setshiftBarOffset(int shiftBarOffset) {
        AssertUtils.gtEqThanZero((String)"shiftBarOffset", (int)shiftBarOffset);
        this.shiftBarOffset.setValue((Number)shiftBarOffset);
        return (R)this.getThis();
    }

    public IntegerProperty shiftBarOffsetProperty() {
        return this.shiftBarOffset;
    }

    public boolean isDynamicBarWidth() {
        return this.dynamicBarWidth.get();
    }

    public R setDynamicBarWidth(boolean state) {
        this.dynamicBarWidth.set(state);
        return (R)this.getThis();
    }

    public BooleanProperty dynamicBarWidthProperty() {
        return this.dynamicBarWidth;
    }

    public double getBarWidthPercentage() {
        return this.barWidthPercentage.get();
    }

    public R setBarWidthPercentage(double size) {
        AssertUtils.gtEqThanZero((String)"barWidthPercentage", (double)size);
        this.barWidthPercentage.setValue((Number)size);
        return (R)this.getThis();
    }

    public DoubleProperty barWidthPercentageProperty() {
        return this.barWidthPercentage;
    }

    public int getBarWidth() {
        return this.barWidth.get();
    }

    public R setBarWidth(int barWidth) {
        AssertUtils.gtEqThanZero((String)"barWidth", (int)barWidth);
        this.barWidth.setValue((Number)barWidth);
        return (R)this.getThis();
    }

    public IntegerProperty barWidthProperty() {
        return this.barWidth;
    }

    public boolean isParallelImplementation() {
        return this.parallelImplementation.get();
    }

    public R setParallelImplementation(boolean state) {
        this.parallelImplementation.set(state);
        return (R)this.getThis();
    }

    public BooleanProperty parallelImplementationProperty() {
        return this.parallelImplementation;
    }

    public LineStyle getPolyLineStyle() {
        return (LineStyle)((Object)this.polyLineStyleProperty().get());
    }

    public R setPolyLineStyle(LineStyle style) {
        this.polyLineStyleProperty().set((Object)style);
        return (R)this.getThis();
    }

    public ObjectProperty<LineStyle> polyLineStyleProperty() {
        return this.polyLineStyle;
    }

    public boolean getAlgorithmChoice() {
        return this.algorithmChoice == null ? this.xsalgorithmChoice : this.algorithmChoice.get();
    }

    public R setAlgorithmChoice(boolean value) {
        if (this.algorithmChoice == null) {
            this.xsalgorithmChoice = value;
        } else {
            this.algorithmChoice.set(value);
        }
        return (R)this.getThis();
    }

    public BooleanProperty algorithmChoiceProperty() {
        if (this.algorithmChoice == null) {
            this.algorithmChoice = new SimpleBooleanProperty((Object)this, "algorithmChoice", this.xsalgorithmChoice);
        }
        return this.algorithmChoice;
    }

    public int getNumberOfPoints() {
        return this.numberOfPoints == null ? this.xsnumberOfPoints : this.numberOfPoints.get();
    }

    public R setNumberOfPoints(int numberOfPoint) {
        if (numberOfPoint < 0) {
            throw new InvalidParameterException("dash size " + numberOfPoint + " must be greater than zero");
        }
        if (this.numberOfPoints == null) {
            this.xsnumberOfPoints = numberOfPoint;
        } else {
            this.numberOfPoints.setValue((Number)numberOfPoint);
        }
        return (R)this.getThis();
    }

    public IntegerProperty numberOfPointsProperty() {
        if (this.numberOfPoints == null) {
            this.numberOfPoints = new SimpleIntegerProperty((Object)this, "numberOfPoint", this.xsnumberOfPoints);
        }
        return this.numberOfPoints;
    }
}

