/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.renderer.spi;

import de.gsi.chart.axes.Axis;
import de.gsi.chart.renderer.Renderer;
import de.gsi.dataset.DataSet;
import de.gsi.dataset.DataSetError;
import de.gsi.dataset.event.EventSource;
import de.gsi.dataset.event.UpdateEvent;
import de.gsi.dataset.event.UpdatedDataEvent;
import de.gsi.dataset.spi.DoubleDataSet;
import de.gsi.dataset.spi.DoubleErrorDataSet;
import de.gsi.dataset.utils.ProcessingProfiler;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.Orientation;

public abstract class AbstractDataSetManagement<R extends Renderer>
implements Renderer {
    private final ObservableList<DataSet> datasets = FXCollections.observableArrayList();
    protected BooleanProperty showInLegend = new SimpleBooleanProperty((Object)this, "showInLegend", true);
    private final ObservableList<Axis> axesList = FXCollections.observableArrayList();

    @Override
    public ObservableList<DataSet> getDatasets() {
        return this.datasets;
    }

    @Override
    public ObservableList<Axis> getAxes() {
        return this.axesList;
    }

    public Axis getFirstAxis(Orientation orientation) {
        block3: for (Axis axis : this.getAxes()) {
            if (axis.getSide() == null) continue;
            switch (orientation) {
                case VERTICAL: {
                    if (!axis.getSide().isVertical()) continue block3;
                    return axis;
                }
            }
            if (!axis.getSide().isHorizontal()) continue;
            return axis;
        }
        return null;
    }

    protected abstract R getThis();

    @Override
    public final BooleanProperty showInLegendProperty() {
        return this.showInLegend;
    }

    @Override
    public boolean showInLegend() {
        return this.showInLegend.get();
    }

    public R setShowInLegend(boolean state) {
        this.showInLegend.set(state);
        return this.getThis();
    }

    @Override
    public ObservableList<DataSet> getDatasetsCopy() {
        return this.getDatasetsCopy(this.getDatasets());
    }

    protected ObservableList<DataSet> getDatasetsCopy(ObservableList<DataSet> localDataSets) {
        long start = ProcessingProfiler.getTimeStamp();
        ObservableList dataSets = FXCollections.observableArrayList();
        for (DataSet dataSet : localDataSets) {
            if (dataSet instanceof DataSetError) {
                DataSetError dataSetError = (DataSetError)dataSet;
                dataSets.add((Object)AbstractDataSetManagement.getErrorDataSetCopy(dataSetError));
                continue;
            }
            dataSets.add((Object)AbstractDataSetManagement.getDataSetCopy(dataSet));
        }
        ProcessingProfiler.getTimeDiff((long)start);
        return dataSets;
    }

    protected static void copyMetaData(DataSet from, DataSet to) {
        to.setStyle(from.getStyle());
    }

    protected static final DoubleDataSet getDataSetCopy(DataSet dataSet) {
        int nLength = dataSet.getDataCount();
        DoubleDataSet ret = new DoubleDataSet(dataSet.getName(), nLength);
        ret.setAutoNotifaction(false);
        dataSet.lock();
        if (dataSet instanceof DoubleDataSet) {
            DoubleDataSet doubleDataSet = (DoubleDataSet)dataSet;
            double[] xValues = doubleDataSet.getXValues();
            double[] yValues = doubleDataSet.getYValues();
            ret.set(xValues, yValues);
            ret.getDataLabelMap().putAll(doubleDataSet.getDataLabelMap());
            ret.getDataStyleMap().putAll(doubleDataSet.getDataStyleMap());
        } else {
            for (int i = 0; i < nLength; ++i) {
                String style;
                ret.set(i, dataSet.getX(i), dataSet.getY(i));
                String label = dataSet.getDataLabel(i);
                if (label != null) {
                    ret.getDataLabelMap().put(i, label);
                }
                if ((style = ret.getDataLabel(i)) == null) continue;
                ret.getDataStyleMap().put(i, style);
            }
        }
        AbstractDataSetManagement.copyMetaData(dataSet, (DataSet)ret);
        dataSet.unlock();
        ret.fireInvalidated((UpdateEvent)new UpdatedDataEvent((EventSource)dataSet, "copy"));
        ret.setAutoNotifaction(true);
        return ret;
    }

    protected static final DoubleErrorDataSet getErrorDataSetCopy(DataSetError dataSet) {
        int nLength = dataSet.getDataCount();
        DoubleErrorDataSet ret = new DoubleErrorDataSet(dataSet.getName(), nLength);
        ret.setAutoNotifaction(false);
        dataSet.lock();
        if (dataSet instanceof DoubleErrorDataSet) {
            DoubleErrorDataSet doubleErrorDataSet = (DoubleErrorDataSet)dataSet;
            double[] xValues = doubleErrorDataSet.getXValues();
            double[] yValues = doubleErrorDataSet.getYValues();
            double[] yErrorsNeg = doubleErrorDataSet.getYErrorsNegative();
            double[] yErrorsPos = doubleErrorDataSet.getYErrorsPositive();
            ret.set(xValues, yValues, yErrorsNeg, yErrorsPos);
            ret.getDataLabelMap().putAll(doubleErrorDataSet.getDataLabelMap());
            ret.getDataStyleMap().putAll(doubleErrorDataSet.getDataStyleMap());
        } else {
            for (int i = 0; i < nLength; ++i) {
                String style;
                ret.set(i, dataSet.getX(i), dataSet.getY(i), dataSet.getYErrorNegative(i), dataSet.getYErrorPositive(i));
                String label = ret.getDataLabel(i);
                if (label != null) {
                    ret.getDataLabelMap().put(i, label);
                }
                if ((style = ret.getDataLabel(i)) == null) continue;
                ret.getDataStyleMap().put(i, style);
            }
        }
        AbstractDataSetManagement.copyMetaData((DataSet)dataSet, (DataSet)ret);
        dataSet.unlock();
        ret.setAutoNotifaction(true);
        ret.fireInvalidated((UpdateEvent)new UpdatedDataEvent((EventSource)dataSet, "copy"));
        return ret;
    }
}

