/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.plugins.measurements.utils;

import de.gsi.chart.plugins.measurements.utils.CheckedNumberTextField;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.Tooltip;
import javafx.scene.input.KeyCode;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;

public class CheckedValueField
extends VBox {
    private static final String DEFAULT_FONT_DATASET = "Verdana";
    private static final String DEFAULT_FONT = "Verdana Bold";
    private static final String DEFAULT_UNIT_FONT = "Verdana Bold";
    private static final int DEFAULT_FONT_SIZE = 55;
    private static final int DEFAULT_UNIT_FONT_SIZE = 30;
    private static final int DEFAULT_MIN_FONT_SIZE = 18;
    private static final int DEFAULT_MIN_UNIT_FONT_SIZE = 14;
    final Label valueTextField = new Label();
    final Label unitTextField = new Label();
    final Label dataSetNameField = new Label();
    protected double minRange = Double.NEGATIVE_INFINITY;
    protected double maxRange = Double.POSITIVE_INFINITY;
    protected CheckedNumberTextField dataRangeMin = new CheckedNumberTextField(this.minRange);
    protected CheckedNumberTextField dataRangeMax = new CheckedNumberTextField(this.maxRange);

    public CheckedValueField() {
        this.setMouseTransparent(true);
        this.dataSetNameField.setText("");
        this.dataSetNameField.setPrefWidth(-1.0);
        this.dataSetNameField.setMouseTransparent(true);
        this.getChildren().add((Object)new MyHBox((Node)this.dataSetNameField, Pos.TOP_LEFT));
        this.valueTextField.setText("");
        this.valueTextField.setFont(Font.font((String)"Verdana Bold", (double)55.0));
        this.valueTextField.setPrefWidth(-1.0);
        this.valueTextField.setMouseTransparent(true);
        this.getChildren().add((Object)new MyHBox((Node)this.valueTextField, Pos.CENTER));
        this.unitTextField.setText("");
        this.unitTextField.setFont(Font.font((String)"Verdana Bold", (double)30.0));
        this.unitTextField.setPrefWidth(-1.0);
        this.unitTextField.setMouseTransparent(true);
        this.getChildren().add((Object)new MyHBox((Node)this.unitTextField, Pos.TOP_RIGHT));
        this.dataRangeMin.setOnKeyPressed(ke -> {
            if (ke.getCode().equals((Object)KeyCode.ENTER)) {
                try {
                    double value;
                    this.minRange = value = Double.parseDouble(this.dataRangeMin.getText());
                }
                catch (NumberFormatException e) {
                    this.minRange = Double.NEGATIVE_INFINITY;
                }
            }
        });
        this.dataRangeMax.setOnKeyPressed(ke -> {
            if (ke.getCode().equals((Object)KeyCode.ENTER)) {
                try {
                    double value;
                    this.maxRange = value = Double.parseDouble(this.dataRangeMax.getText());
                }
                catch (NumberFormatException e) {
                    this.maxRange = Double.POSITIVE_INFINITY;
                }
            }
        });
        this.widthProperty().addListener((obs, o, n) -> {
            if (o == n) {
                return;
            }
            double fontSizeLarge = Math.max(18.0, Math.min(55.0, n.doubleValue() / 300.0 * 55.0));
            double fontSizeSmall = Math.max(14.0, Math.min(30.0, n.doubleValue() / 300.0 * 30.0));
            this.dataSetNameField.setFont(Font.font((String)DEFAULT_FONT_DATASET, (double)fontSizeSmall));
            this.valueTextField.setFont(Font.font((String)"Verdana Bold", (double)fontSizeLarge));
            this.unitTextField.setFont(Font.font((String)"Verdana Bold", (double)fontSizeSmall));
        });
        VBox.setVgrow((Node)this, (Priority)Priority.SOMETIMES);
    }

    public CheckedNumberTextField getMinRangeTextField() {
        return this.dataRangeMin;
    }

    public CheckedNumberTextField getMaxRangeTextField() {
        return this.dataRangeMax;
    }

    public CheckedValueField resetRanges() {
        this.minRange = Double.NEGATIVE_INFINITY;
        this.maxRange = Double.POSITIVE_INFINITY;
        this.dataRangeMin.setText(Double.toString(this.minRange));
        this.dataRangeMax.setText(Double.toString(this.maxRange));
        return this;
    }

    public CheckedValueField setMinRange(double value) {
        this.minRange = Double.isNaN(value) ? Double.NEGATIVE_INFINITY : value;
        this.dataRangeMin.setText(Double.toString(this.minRange));
        return this;
    }

    public CheckedValueField setMaxRange(double value) {
        this.maxRange = Double.isNaN(value) ? Double.POSITIVE_INFINITY : value;
        this.dataRangeMax.setText(Double.toString(this.maxRange));
        return this;
    }

    public void setDataSetName(String name) {
        this.dataSetNameField.setText(name);
    }

    public void setValue(double value, String valString) {
        if (this.valueTextField.getText().equals(valString)) {
            return;
        }
        this.valueTextField.setText(valString);
        this.setValueWarning(value < this.minRange || value > this.maxRange);
    }

    public void setValueToolTip(String toolTip) {
        this.valueTextField.setTooltip(new Tooltip(toolTip));
    }

    protected void setValueWarning(boolean state) {
        if (state) {
            this.valueTextField.setTextFill((Paint)Color.RED);
            this.unitTextField.setTextFill((Paint)Color.RED);
        } else {
            this.valueTextField.setTextFill((Paint)Color.BLACK);
            this.unitTextField.setTextFill((Paint)Color.BLACK);
        }
    }

    public void setUnit(String val) {
        if (this.unitTextField.getText() == null || this.unitTextField.getText().equals(val)) {
            return;
        }
        this.unitTextField.setText(val);
    }

    private class MyHBox
    extends HBox {
        public MyHBox(Node child, Pos position) {
            super(new Node[]{child});
            this.setAlignment(position);
            VBox.setVgrow((Node)this, (Priority)Priority.SOMETIMES);
        }
    }
}

