/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.plugins.measurements;

import de.gsi.chart.XYChart;
import de.gsi.chart.axes.Axis;
import de.gsi.chart.axes.AxisLabelFormatter;
import de.gsi.chart.axes.AxisMode;
import de.gsi.chart.axes.spi.DefaultNumericAxis;
import de.gsi.chart.axes.spi.MetricPrefix;
import de.gsi.chart.plugins.measurements.AbstractChartMeasurement;
import de.gsi.chart.plugins.measurements.ValueIndicator;
import de.gsi.chart.plugins.measurements.utils.SimpleDataSetEstimators;
import de.gsi.dataset.DataSet;
import de.gsi.dataset.event.UpdateEvent;
import javafx.scene.Node;
import javafx.scene.paint.Color;
import org.controlsfx.tools.Borders;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleMeasurements
extends ValueIndicator {
    private static final Logger LOGGER = LoggerFactory.getLogger(SimpleMeasurements.class);
    private static final double DEFAULT_MIN = Double.NEGATIVE_INFINITY;
    private static final double DEFAULT_MAX = Double.POSITIVE_INFINITY;
    private final MeasurementType measType;

    public SimpleMeasurements(XYChart chart, MeasurementType measType) {
        super(chart, AxisMode.X);
        Axis axis;
        this.measType = measType;
        this.title = (Object)((Object)measType) + " [#" + (AbstractChartMeasurement.markerCount - 1) + ", #" + AbstractChartMeasurement.markerCount + "]";
        this.valueField.setMinRange(Double.NEGATIVE_INFINITY).setMaxRange(Double.POSITIVE_INFINITY);
        Axis axis2 = axis = this.axisMode == AxisMode.X ? chart.getXAxis() : chart.getYAxis();
        if (!(axis instanceof Axis)) {
            LOGGER.warn("axis type " + axis.getClass().getSimpleName() + "not compatible with indicator (needs to derivce from Axis)");
            return;
        }
        Axis numAxis = axis;
        double lower = numAxis.getLowerBound();
        double upper = numAxis.getUpperBound();
        double middle = 0.5 * Math.abs(upper - lower);
        double min = Math.min(lower, upper);
        this.sliderIndicator1.setValue(min + 0.5 * middle);
        if (measType != MeasurementType.VALUE_HOR && measType != MeasurementType.VALUE_VER) {
            this.sliderIndicator2.setValue(min + 1.5 * middle);
            chart.getPlugins().add((Object)this.sliderIndicator2);
            this.sliderIndicator2.setText("Marker#" + AbstractChartMeasurement.markerCount);
            ++AbstractChartMeasurement.markerCount;
        } else {
            this.sliderIndicator2.setValue(Double.MAX_VALUE);
        }
        this.valueField.setMinRange(Double.NEGATIVE_INFINITY).setMaxRange(Double.POSITIVE_INFINITY);
    }

    @Override
    public void initialize() {
        Node node = Borders.wrap((Node)this.valueField).lineBorder().title(this.title).color(Color.BLACK).build().build();
        node.setMouseTransparent(true);
        this.displayPane.getChildren().add((Object)node);
        this.sliderIndicator1.valueProperty().addListener((ch, oldValue, newValue) -> {
            if (oldValue != newValue) {
                this.handle(null);
            }
        });
        this.sliderIndicator2.valueProperty().addListener((ch, oldValue, newValue) -> {
            if (oldValue != newValue) {
                this.handle(null);
            }
        });
        this.chart.addListener(e -> this.handle(null));
        super.showConfigDialogue();
        this.handle(null);
    }

    @Override
    protected void removeAction() {
        super.removeAction();
        this.chart.getPlugins().remove((Object)this.sliderIndicator2);
        this.chart.requestLayout();
    }

    @Override
    public void handle(UpdateEvent event) {
        String valueLabel;
        double val;
        if (this.sliderIndicator2 == null) {
            return;
        }
        DataSet selectedDataSet = this.getDataSet();
        double newValueMarker1 = this.sliderIndicator1.getValue();
        double newValueMarker2 = this.sliderIndicator2.getValue();
        int index0 = selectedDataSet.getXIndex(newValueMarker1);
        int index1 = selectedDataSet.getXIndex(newValueMarker2);
        int indexMin = Math.min(index0, index1);
        int indexMax = Math.max(index0, index1);
        switch (this.measType) {
            case VALUE_HOR: {
                val = SimpleDataSetEstimators.getValue(selectedDataSet, indexMin, true);
                break;
            }
            case VALUE_VER: {
                val = SimpleDataSetEstimators.getValue(selectedDataSet, indexMin, false);
                break;
            }
            case DISTANCE_HOR: {
                val = SimpleDataSetEstimators.getDistance(selectedDataSet, indexMin, indexMax, true);
                break;
            }
            case DISTANCE_VER: {
                val = SimpleDataSetEstimators.getDistance(selectedDataSet, indexMin, indexMax, false);
                break;
            }
            case MINIMUM: {
                val = SimpleDataSetEstimators.getMinimum(selectedDataSet, indexMin, indexMax);
                break;
            }
            case MAXIMUM: {
                val = SimpleDataSetEstimators.getMaximum(selectedDataSet, indexMin, indexMax);
                break;
            }
            case RANGE: {
                val = SimpleDataSetEstimators.getRange(selectedDataSet, indexMin, indexMax);
                break;
            }
            case MEAN: {
                val = SimpleDataSetEstimators.getMean(selectedDataSet, indexMin, indexMax);
                break;
            }
            case RMS: {
                val = SimpleDataSetEstimators.getRms(selectedDataSet, indexMin, indexMax);
                break;
            }
            case MEDIAN: {
                val = SimpleDataSetEstimators.getMedian(selectedDataSet, indexMin, indexMax);
                break;
            }
            case INTEGRAL: {
                val = SimpleDataSetEstimators.getIntegral(selectedDataSet, index0, index1);
                break;
            }
            case TRANSMISSION_ABS: {
                val = SimpleDataSetEstimators.getTransmission(selectedDataSet, index0, index1, true);
                break;
            }
            case TRANSMISSION_REL: {
                val = SimpleDataSetEstimators.getTransmission(selectedDataSet, index0, index1, false);
                break;
            }
            case EDGE_DETECT: {
                val = SimpleDataSetEstimators.getEdgeDetect(selectedDataSet, indexMin, indexMax);
                break;
            }
            case RISETIME_10_90: {
                val = SimpleDataSetEstimators.getSimpleRiseTime1090(selectedDataSet, indexMin, indexMax);
                break;
            }
            case RISETIME_20_80: {
                val = SimpleDataSetEstimators.getSimpleRiseTime2080(selectedDataSet, indexMin, indexMax);
                break;
            }
            case FWHM: {
                val = SimpleDataSetEstimators.getFullWidthHalfMaximum(selectedDataSet, indexMin, indexMax, false);
                break;
            }
            case FWHM_INTERPOLATED: {
                val = SimpleDataSetEstimators.getFullWidthHalfMaximum(selectedDataSet, indexMin, indexMax, true);
                break;
            }
            case LOCATION_MAXIMUM: {
                val = selectedDataSet.getX(SimpleDataSetEstimators.getLocationMaximum(selectedDataSet, indexMin, indexMax));
                break;
            }
            case LOCATION_MAXIMUM_GAUSS: {
                val = SimpleDataSetEstimators.getLocationMaximumGaussInterpolated(selectedDataSet, indexMin, indexMax);
                break;
            }
            case DUTY_CYCLE: {
                val = SimpleDataSetEstimators.getDutyCycle(selectedDataSet, indexMin, indexMax);
                break;
            }
            case PERIOD: {
                val = 1.0 / SimpleDataSetEstimators.getFrequencyEstimate(selectedDataSet, indexMin, indexMax);
                break;
            }
            case FREQUENCY: {
                val = SimpleDataSetEstimators.getFrequencyEstimate(selectedDataSet, indexMin, indexMax);
                break;
            }
            default: {
                val = Double.NaN;
            }
        }
        Axis axis = this.measType.isVerticalMeasurement() ? this.chart.getYAxis() : this.chart.getXAxis();
        Axis altAxis = this.measType.isVerticalMeasurement() ? this.chart.getXAxis() : this.chart.getYAxis();
        String axisUnit = axis.getUnit();
        String unit = axisUnit == null ? "a.u." : axis.getUnit();
        double unitScale = ((DefaultNumericAxis)axis).getUnitScaling();
        String axisPrefix = MetricPrefix.getShortPrefix(unitScale);
        double scaledValue = val / unitScale;
        if (axis instanceof DefaultNumericAxis && axisUnit != null) {
            this.valueField.setUnit(axisPrefix + unit);
            AxisLabelFormatter axisFormatter = ((DefaultNumericAxis)axis).getAxisLabelFormatter();
            valueLabel = axisFormatter.toString(scaledValue);
        } else {
            this.formatter = Math.abs(Math.log10(Math.abs(val))) < 3.0 ? this.formatterSmall : this.formatterLarge;
            valueLabel = this.formatter.format(val);
            this.valueField.setUnit(unit);
        }
        this.valueField.setValue(val, valueLabel);
        String altAxisLabel = altAxis.getLabel();
        switch (this.measType) {
            case TRANSMISSION_ABS: 
            case TRANSMISSION_REL: {
                this.valueField.setUnit("%");
                break;
            }
            default: {
                String string = altAxisLabel.replaceAll("\\[", "").replaceAll("\\]", "");
            }
        }
    }

    public static enum MeasurementType {
        VALUE_HOR(false, MeasurementCategory.INDICATOR, "hor. value"),
        VALUE_VER(true, MeasurementCategory.INDICATOR, "ver. value"),
        DISTANCE_HOR(false, MeasurementCategory.INDICATOR, "hor. distance"),
        DISTANCE_VER(true, MeasurementCategory.INDICATOR, "ver. distance"),
        MINIMUM(true, MeasurementCategory.VERTICAL, "Minimum"),
        MAXIMUM(true, MeasurementCategory.VERTICAL, "Maximum"),
        RANGE(true, MeasurementCategory.VERTICAL, "Range"),
        MEAN(true, MeasurementCategory.VERTICAL, "Mean"),
        RMS(true, MeasurementCategory.VERTICAL, "R.M.S."),
        MEDIAN(true, MeasurementCategory.VERTICAL, "Median"),
        INTEGRAL(true, MeasurementCategory.VERTICAL, "Integral"),
        TRANSMISSION_ABS(true, MeasurementCategory.ACC, "Abs. Transmission"),
        TRANSMISSION_REL(true, MeasurementCategory.ACC, "Rel. Transmission"),
        EDGE_DETECT(false, MeasurementCategory.HORIZONTAL, "Edge-Detect"),
        RISETIME_10_90(false, MeasurementCategory.HORIZONTAL, "10%-90% Rise-/Fall-Time\n (simple)"),
        RISETIME_20_80(false, MeasurementCategory.HORIZONTAL, "20%-80% Rise-/Fall-Time\n (simple)"),
        FWHM(false, MeasurementCategory.HORIZONTAL, "FWHM"),
        FWHM_INTERPOLATED(false, MeasurementCategory.HORIZONTAL, "FWHM (interp.)"),
        LOCATION_MAXIMUM(false, MeasurementCategory.HORIZONTAL, "Loc. Maximum"),
        LOCATION_MAXIMUM_GAUSS(false, MeasurementCategory.HORIZONTAL, "Loc. Maximum\n(Gauss-interp.)"),
        DUTY_CYCLE(false, MeasurementCategory.HORIZONTAL, "Duty Cycle\n(10% hysteresis)"),
        PERIOD(true, MeasurementCategory.HORIZONTAL, "Period"),
        FREQUENCY(false, MeasurementCategory.HORIZONTAL, "Frequency");

        private String name;
        private MeasurementCategory category;
        private boolean isVertical;

        private MeasurementType(boolean isVerticalMeasurement, MeasurementCategory measurementCategory, String description) {
            this.isVertical = isVerticalMeasurement;
            this.category = measurementCategory;
            this.name = description;
        }

        public MeasurementCategory getCategory() {
            return this.category;
        }

        public boolean isVerticalMeasurement() {
            return this.isVertical;
        }

        public String toString() {
            return this.name;
        }
    }

    public static enum MeasurementCategory {
        INDICATOR("Indicators"),
        VERTICAL("Vertical Measurements"),
        HORIZONTAL("Horizontal Measurements"),
        ACC("Accelerator Misc.");

        private String name;

        private MeasurementCategory(String description) {
            this.name = description;
        }

        public String toString() {
            return this.name;
        }
    }
}

