/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.plugins;

import de.gsi.chart.axes.Axis;
import de.gsi.chart.plugins.AbstractRangeValueIndicator;
import javafx.geometry.BoundingBox;
import javafx.geometry.Bounds;
import javafx.scene.Node;

public class YRangeIndicator
extends AbstractRangeValueIndicator {
    public YRangeIndicator(Axis axis, double lowerBound, double upperBound) {
        this(axis, lowerBound, upperBound, null);
    }

    public YRangeIndicator(Axis axis, double lowerBound, double upperBound, String text) {
        super(axis, lowerBound, upperBound, text);
    }

    @Override
    void updateStyleClass() {
        this.setStyleClasses((Node)this.label, "y-", "range-indicator-label");
        this.setStyleClasses((Node)this.rectangle, "y-", "range-indicator-rect");
    }

    @Override
    public void layoutChildren() {
        if (this.getChart() == null) {
            return;
        }
        Bounds plotAreaBounds = this.getChart().getCanvas().getBoundsInLocal();
        double minX = plotAreaBounds.getMinX();
        double maxX = plotAreaBounds.getMaxX();
        double minY = plotAreaBounds.getMinY();
        double maxY = plotAreaBounds.getMaxY();
        Axis yAxis = this.getNumericAxis();
        double startY = Math.max(minY, minY + yAxis.getDisplayPosition(this.getUpperBound()));
        double endY = Math.min(maxY, minY + yAxis.getDisplayPosition(this.getLowerBound()));
        this.layout((Bounds)new BoundingBox(minX, startY, maxX - minX, endY - startY));
    }
}

