/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.plugins;

import de.gsi.chart.axes.Axis;
import de.gsi.chart.plugins.AbstractRangeValueIndicator;
import javafx.geometry.BoundingBox;
import javafx.geometry.Bounds;
import javafx.scene.Node;

public class XRangeIndicator
extends AbstractRangeValueIndicator {
    public XRangeIndicator(Axis axis, double lowerBound, double upperBound) {
        this(axis, lowerBound, upperBound, null);
    }

    public XRangeIndicator(Axis axis, double lowerBound, double upperBound, String text) {
        super(axis, lowerBound, upperBound, text);
    }

    @Override
    void updateStyleClass() {
        this.setStyleClasses((Node)this.label, "x-", "range-indicator-label");
        this.setStyleClasses((Node)this.rectangle, "x-", "range-indicator-rect");
    }

    @Override
    public void layoutChildren() {
        if (this.getChart() == null) {
            return;
        }
        Bounds plotAreaBounds = this.getChart().getCanvas().getBoundsInLocal();
        double minX = plotAreaBounds.getMinX();
        double maxX = plotAreaBounds.getMaxX();
        double minY = plotAreaBounds.getMinY();
        double maxY = plotAreaBounds.getMaxY();
        Axis xAxis = this.getNumericAxis();
        double startX = Math.max(minX, minX + xAxis.getDisplayPosition(this.getLowerBound()));
        double endX = Math.min(maxX, minX + xAxis.getDisplayPosition(this.getUpperBound()));
        this.layout((Bounds)new BoundingBox(startX, minY, endX - startX, maxY - minY));
    }
}

