/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.plugins;

import de.gsi.chart.Chart;
import de.gsi.chart.plugins.ChartPlugin;
import de.gsi.chart.renderer.Renderer;
import de.gsi.dataset.DataSet;
import de.gsi.dataset.DataSetError;
import de.gsi.dataset.event.EventListener;
import impl.org.controlsfx.i18n.Localization;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.Separator;
import javafx.scene.control.TablePosition;
import javafx.scene.control.Tooltip;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.layout.HBox;
import javafx.stage.FileChooser;
import javafx.util.StringConverter;
import javafx.util.converter.DoubleStringConverter;
import org.controlsfx.control.spreadsheet.Grid;
import org.controlsfx.control.spreadsheet.GridBase;
import org.controlsfx.control.spreadsheet.SpreadsheetCell;
import org.controlsfx.control.spreadsheet.SpreadsheetCellType;
import org.controlsfx.control.spreadsheet.SpreadsheetView;
import org.controlsfx.control.spreadsheet.StringConverterWithFormat;
import org.controlsfx.glyphfont.FontAwesome;
import org.controlsfx.glyphfont.Glyph;

public class TableViewer
extends ChartPlugin {
    private static final int MAX_ROW_EXPORT_LIMIT = 10000;
    protected static final String FONT_AWESOME = "FontAwesome";
    protected static final int FONT_SIZE = 20;
    private final Glyph tableView = new Glyph("FontAwesome", (Object)"\uf0ce").size(20.0);
    private final Glyph graphView = new Glyph("FontAwesome", (Object)"\uf201").size(20.0);
    private final Glyph saveIcon = new Glyph("FontAwesome", (Object)"\uf0c7").size(20.0);
    private final Glyph clipBoardIcon = new Glyph("FontAwesome", (Object)FontAwesome.Glyph.CLIPBOARD).size(20.0);
    private final ListChangeListener<Renderer> rendererChangeListener = this::rendererChanged;
    private final ListChangeListener<DataSet> datasetChangeListener = this::datasetsChanged;
    private final EventListener dataSetDataUpdateListener = obs -> this.refreshTable();
    private final HBox interactorButtons = this.getInteractorBar();
    private final MySpreadsheetView table = new MySpreadsheetView();

    public TableViewer() {
        this.table.setStyle("-fx-background-color: -fx-focus-color, -fx-background; -fx-opacity = 0.5");
        this.table.setStyle("-fx-background-color: #AAAAAAD0");
        this.chartProperty().addListener((change, o, n) -> {
            if (o != null) {
                o.getToolBar().getChildren().remove((Object)this.interactorButtons);
                o.getPlotForeground().getChildren().remove((Object)this.table);
                o.getPlotArea().setBottom(null);
                this.table.prefWidthProperty().unbind();
                this.table.prefHeightProperty().unbind();
                o.getDatasets().removeListener(this.datasetChangeListener);
                o.getRenderers().removeListener(this.rendererChangeListener);
            }
            if (n != null) {
                if (this.isAddButtonsToToolBar()) {
                    n.getToolBar().getChildren().add((Object)this.interactorButtons);
                }
                n.getPlotForeground().getChildren().add((Object)this.table);
                this.table.toFront();
                this.table.setVisible(false);
                this.table.prefWidthProperty().bind((ObservableValue)n.getPlotForeground().widthProperty());
                this.table.prefHeightProperty().bind((ObservableValue)n.getPlotForeground().heightProperty());
                n.getDatasets().addListener(this.datasetChangeListener);
                n.getDatasets().forEach(dataSet -> dataSet.addListener(this.dataSetDataUpdateListener));
                n.getRenderers().addListener(this.rendererChangeListener);
                n.getRenderers().forEach(renderer -> renderer.getDatasets().addListener(this.datasetChangeListener));
            }
        });
        this.addButtonsToToolBarProperty().addListener((ch, o, n) -> {
            Chart chartLocal = this.getChart();
            if (chartLocal == null || o.equals(n)) {
                return;
            }
            if (n.booleanValue()) {
                chartLocal.getToolBar().getChildren().add((Object)this.interactorButtons);
            } else {
                chartLocal.getToolBar().getChildren().remove((Object)this.interactorButtons);
            }
        });
    }

    public HBox getInteractorBar() {
        Separator separator = new Separator();
        separator.setOrientation(Orientation.VERTICAL);
        HBox buttonBar = new HBox();
        buttonBar.setPadding(new Insets(1.0, 1.0, 1.0, 1.0));
        Button switchTableView = new Button(null, (Node)this.tableView);
        switchTableView.setPadding(new Insets(3.0, 3.0, 3.0, 3.0));
        switchTableView.setTooltip(new Tooltip("switches between graph and table view"));
        Button copyToClipBoard = new Button(null, (Node)this.clipBoardIcon);
        copyToClipBoard.setPadding(new Insets(3.0, 3.0, 3.0, 3.0));
        copyToClipBoard.setTooltip(new Tooltip("copy actively shown content top system clipboard"));
        copyToClipBoard.setOnAction(e -> this.table.copyAllToClipboard());
        Button saveTableView = new Button(null, (Node)this.saveIcon);
        saveTableView.setPadding(new Insets(3.0, 3.0, 3.0, 3.0));
        saveTableView.setTooltip(new Tooltip("store actively shown content as .csv file"));
        saveTableView.setOnAction(e -> this.exportGridToCSV());
        switchTableView.setOnAction(evt -> {
            switchTableView.setGraphic((Node)(this.table.isVisible() ? this.tableView : this.graphView));
            this.table.setVisible(!this.table.isVisible());
            this.table.setMouseTransparent(!this.table.isVisible());
            this.getChart().getPlotForeground().setMouseTransparent(!this.table.isVisible());
            this.table.setZoomFactor(1.0);
            this.refreshTable();
        });
        buttonBar.getChildren().addAll((Object[])new Node[]{separator, switchTableView, copyToClipBoard, saveTableView});
        return buttonBar;
    }

    protected void datasetsChanged(ListChangeListener.Change<? extends DataSet> change) {
        boolean dataSetChanges = false;
        ArrayList newDataSets = new ArrayList();
        ArrayList oldDataSets = new ArrayList();
        while (change.next()) {
            oldDataSets.addAll(change.getRemoved());
            for (DataSet set : change.getRemoved()) {
                set.removeListener(this.dataSetDataUpdateListener);
                dataSetChanges = true;
            }
            newDataSets.addAll(change.getAddedSubList());
            for (DataSet set : change.getAddedSubList()) {
                set.addListener(this.dataSetDataUpdateListener);
                dataSetChanges = true;
            }
        }
        if (dataSetChanges) {
            this.refreshTable();
        }
    }

    protected void rendererChanged(ListChangeListener.Change<? extends Renderer> change) {
        boolean dataSetChanges = false;
        while (change.next()) {
            change.getAddedSubList().forEach(renderer -> renderer.getDatasets().addListener(this.datasetChangeListener));
            if (!change.getAddedSubList().isEmpty()) {
                dataSetChanges = true;
            }
            change.getRemoved().forEach(renderer -> renderer.getDatasets().removeListener(this.datasetChangeListener));
            if (change.getRemoved().isEmpty()) continue;
            dataSetChanges = true;
        }
        if (dataSetChanges) {
            this.refreshTable();
        }
    }

    public SpreadsheetView getTable() {
        return this.table;
    }

    private void refreshTable() {
        if (this.getChart() == null || !this.table.isVisible()) {
            return;
        }
        this.repopulateTable();
    }

    private void repopulateTable() {
        ObservableList<DataSet> dataSets = this.getChart().getAllDatasets();
        int nRowCount = 0;
        int nColumnCount = 0;
        block4: for (DataSet ds : dataSets) {
            nRowCount = Math.min(Math.max(nRowCount, ds.getDataCount()), 10000);
            nColumnCount += 2;
            if (!(ds instanceof DataSetError)) continue;
            DataSetError eDs = (DataSetError)ds;
            switch (eDs.getErrorType()) {
                case NO_ERROR: {
                    continue block4;
                }
                case X: 
                case X_ASYMMETRIC: 
                case Y: 
                case Y_ASYMMETRIC: {
                    nColumnCount += 2;
                    continue block4;
                }
            }
            nColumnCount += 2;
        }
        this.table.setGrid((Grid)new MyGrid(nRowCount, nColumnCount, (List<DataSet>)dataSets));
    }

    public List<String> getGridStringRepresentation() {
        ArrayList<String> stringRows = new ArrayList<String>();
        ObservableList rows = this.table.getGrid().getRows();
        int countRow = 0;
        for (ObservableList row : rows) {
            StringBuilder sb = new StringBuilder();
            if (countRow < 2) {
                sb.append("# ");
            }
            for (SpreadsheetCell cell : row) {
                sb.append(cell.getText());
                sb.append(',');
            }
            sb.append('\n');
            stringRows.add(sb.toString());
            ++countRow;
        }
        return stringRows;
    }

    public void exportGridToCSV() {
        FileChooser chooser;
        File save;
        if (!this.table.isVisible()) {
            this.repopulateTable();
        }
        if ((save = (chooser = new FileChooser()).showSaveDialog(this.getChart().getScene().getWindow())) == null) {
            return;
        }
        List<String> stringRows = this.getGridStringRepresentation();
        try (FileWriter writer = new FileWriter(save.getPath() + ".csv");){
            for (String str : stringRows) {
                writer.write(str);
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private class MySpreadsheetView
    extends SpreadsheetView {
        MySpreadsheetView() {
        }

        public void copyAllToClipboard() {
            if (!TableViewer.this.table.isVisible()) {
                TableViewer.this.repopulateTable();
            }
            List<String> rows = TableViewer.this.getGridStringRepresentation();
            StringBuilder sb = new StringBuilder();
            rows.forEach(s -> sb.append((String)s));
            ClipboardContent content = new ClipboardContent();
            content.putString(sb.toString());
            Clipboard.getSystemClipboard().setContent((Map)content);
        }

        public void copyClipboard() {
            super.copyClipboard();
            ObservableList posList = this.getSelectionModel().getSelectedCells();
            int minRow = Integer.MAX_VALUE;
            int maxRow = -1;
            int minCol = Integer.MAX_VALUE;
            int maxCol = -1;
            for (TablePosition p : posList) {
                int row = p.getRow();
                int col = p.getColumn();
                minRow = Math.min(minRow, row);
                maxRow = Math.max(maxRow, row);
                minCol = Math.min(minCol, col);
                maxCol = Math.max(maxCol, col);
            }
            if (maxCol < 0 || maxRow < 0 || minCol == Integer.MAX_VALUE || minRow == Integer.MAX_VALUE) {
                this.copyAllToClipboard();
                return;
            }
            StringBuilder sb = new StringBuilder();
            int nRows = maxRow - minRow;
            int nCols = maxCol - minCol;
            for (int row = minRow; row <= maxRow; ++row) {
                for (int col = minCol; col <= maxCol; ++col) {
                    SpreadsheetCell cell = (SpreadsheetCell)((ObservableList)this.getGrid().getRows().get(this.getModelRow(row))).get(this.getModelColumn(col));
                    String cellString = cell.getItem().toString();
                    sb.append(cellString);
                    if (nCols <= 1) continue;
                    sb.append(',');
                }
                if (nRows <= 1) continue;
                sb.append('\n');
            }
            ClipboardContent content = new ClipboardContent();
            content.putString(sb.toString());
            Clipboard.getSystemClipboard().setContent((Map)content);
        }

        public ContextMenu getSpreadsheetViewContextMenu() {
            ContextMenu contextMenu = super.getSpreadsheetViewContextMenu();
            MenuItem copyAllItem = new MenuItem(Localization.localize((String)Localization.asKey((String)"spreadsheet.view.menu.copy")) + " all");
            copyAllItem.setGraphic((Node)new ImageView(new Image(SpreadsheetView.class.getResourceAsStream("copySpreadsheetView.png"))));
            copyAllItem.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.A, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}));
            copyAllItem.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent e) {
                    MySpreadsheetView.this.copyAllToClipboard();
                }
            });
            contextMenu.getItems().add(0, (Object)copyAllItem);
            return contextMenu;
        }
    }

    private class MyGrid
    extends GridBase {
        public MyGrid(int rowCount, int columnCount, List<DataSet> dataSets) {
            super(rowCount, columnCount);
            this.initRowData(dataSets);
        }

        private void initRowData(List<DataSet> dataSets) {
            ObservableList rows = FXCollections.observableArrayList();
            ObservableList dataSetNames = FXCollections.observableArrayList();
            for (int c = 0; c < this.getColumnCount(); ++c) {
                dataSetNames.add((Object)SpreadsheetCellType.STRING.createCell(0, c, 1, 1, ""));
            }
            rows.add((Object)dataSetNames);
            SpreadsheetCellType.DoubleType doubleCellConverter = new SpreadsheetCellType.DoubleType((StringConverter)new StringConverterWithFormat<Double>((StringConverter)new DoubleStringConverter()){

                public String toString(Double item) {
                    return this.toStringFormat(item, "");
                }

                public Double fromString(String str) {
                    if (str == null || str.isEmpty() || "NaN".equals(str)) {
                        return Double.NaN;
                    }
                    return (Double)this.myConverter.fromString(str);
                }

                public String toStringFormat(Double item, String format) {
                    try {
                        if (item == null || Double.isNaN(item)) {
                            return "";
                        }
                        return String.format("%f", item);
                    }
                    catch (Exception ex) {
                        return this.myConverter.toString((Object)item);
                    }
                }
            });
            ObservableList dataSetVariables = FXCollections.observableArrayList();
            rows.add((Object)dataSetVariables);
            int columnCountDataSetName = 0;
            for (int row = 0; row < this.getRowCount(); ++row) {
                int column = 0;
                ObservableList rowData = FXCollections.observableArrayList();
                rows.add((Object)rowData);
                for (DataSet ds : dataSets) {
                    int columnCount = 2;
                    Double valueX = row < ds.getDataCount() ? ds.getX(row) : Double.NaN;
                    Double valueY = row < ds.getDataCount() ? ds.getY(row) : Double.NaN;
                    rowData.add((Object)doubleCellConverter.createCell(row, column++, 1, 1, valueX));
                    rowData.add((Object)doubleCellConverter.createCell(row, column++, 1, 1, valueY));
                    if (row == 0) {
                        dataSetVariables.add((Object)SpreadsheetCellType.STRING.createCell(row, column - 2, 1, 1, "X"));
                        dataSetVariables.add((Object)SpreadsheetCellType.STRING.createCell(row, column - 1, 1, 1, "Y"));
                    }
                    if (ds instanceof DataSetError) {
                        DataSetError eDs = (DataSetError)ds;
                        Double errorXN = row < ds.getDataCount() ? eDs.getXErrorNegative(row) : Double.NaN;
                        Double errorXP = row < ds.getDataCount() ? eDs.getXErrorPositive(row) : Double.NaN;
                        Double errorYN = row < ds.getDataCount() ? eDs.getYErrorNegative(row) : Double.NaN;
                        Double errorYP = row < ds.getDataCount() ? eDs.getYErrorPositive(row) : Double.NaN;
                        switch (eDs.getErrorType()) {
                            case NO_ERROR: {
                                break;
                            }
                            case X: 
                            case X_ASYMMETRIC: {
                                rowData.add((Object)doubleCellConverter.createCell(row, column++, 1, 1, errorXN));
                                rowData.add((Object)doubleCellConverter.createCell(row, column++, 1, 1, errorXP));
                                if (row == 0) {
                                    dataSetVariables.add((Object)SpreadsheetCellType.STRING.createCell(row, column - 2, 1, 1, "+ex"));
                                    dataSetVariables.add((Object)SpreadsheetCellType.STRING.createCell(row, column - 1, 1, 1, "-ex"));
                                }
                                columnCount = 4;
                                break;
                            }
                            case Y: 
                            case Y_ASYMMETRIC: {
                                rowData.add((Object)doubleCellConverter.createCell(row, column++, 1, 1, errorYN));
                                rowData.add((Object)doubleCellConverter.createCell(row, column++, 1, 1, errorYP));
                                if (row == 0) {
                                    dataSetVariables.add((Object)SpreadsheetCellType.STRING.createCell(row, column - 2, 1, 1, "+ey"));
                                    dataSetVariables.add((Object)SpreadsheetCellType.STRING.createCell(row, column - 1, 1, 1, "-ey"));
                                }
                                columnCount = 4;
                                break;
                            }
                            default: {
                                rowData.add((Object)doubleCellConverter.createCell(row, column++, 1, 1, errorXN));
                                rowData.add((Object)doubleCellConverter.createCell(row, column++, 1, 1, errorXP));
                                rowData.add((Object)doubleCellConverter.createCell(row, column++, 1, 1, errorYN));
                                rowData.add((Object)doubleCellConverter.createCell(row, column++, 1, 1, errorYP));
                                if (row == 0) {
                                    dataSetVariables.add((Object)SpreadsheetCellType.STRING.createCell(row, column - 4, 1, 1, "+ex"));
                                    dataSetVariables.add((Object)SpreadsheetCellType.STRING.createCell(row, column - 3, 1, 1, "-ex"));
                                    dataSetVariables.add((Object)SpreadsheetCellType.STRING.createCell(row, column - 2, 1, 1, "+ey"));
                                    dataSetVariables.add((Object)SpreadsheetCellType.STRING.createCell(row, column - 1, 1, 1, "-ey"));
                                }
                                columnCount = 6;
                            }
                        }
                    }
                    if (row != 0) continue;
                    dataSetNames.set(columnCountDataSetName, (Object)SpreadsheetCellType.STRING.createCell(0, columnCountDataSetName, 1, columnCount, ds.getName()));
                    ++columnCountDataSetName;
                }
            }
            this.setRows((Collection)rows);
        }

        public ObservableList<String> getRowHeaders() {
            ObservableList rowHeaders = FXCollections.observableArrayList();
            for (int i = 0; i < this.getRowCount(); ++i) {
                rowHeaders.add((Object)String.valueOf(i));
            }
            return rowHeaders;
        }

        public ObservableList<String> getColumnHeaders() {
            ObservableList columnHeaders = FXCollections.observableArrayList();
            for (int i = 0; i < this.getRowCount(); ++i) {
                columnHeaders.add((Object)String.valueOf(i));
            }
            return columnHeaders;
        }
    }
}

