/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.plugins;

import de.gsi.chart.axes.Axis;
import de.gsi.chart.plugins.AbstractValueIndicator;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.geometry.Bounds;
import javafx.scene.Node;
import javafx.scene.shape.Rectangle;

public abstract class AbstractRangeValueIndicator
extends AbstractValueIndicator {
    static final String STYLE_CLASS_LABEL = "range-indicator-label";
    static final String STYLE_CLASS_RECT = "range-indicator-rect";
    protected final Rectangle rectangle = new Rectangle(0.0, 0.0, 0.0, 0.0);
    private final DoubleProperty lowerBound = new SimpleDoubleProperty(this, "lowerBound"){

        protected void invalidated() {
            AbstractRangeValueIndicator.this.layoutChildren();
        }
    };
    private final DoubleProperty upperBound = new SimpleDoubleProperty(this, "upperBound"){

        protected void invalidated() {
            AbstractRangeValueIndicator.this.layoutChildren();
        }
    };
    private final DoubleProperty labelHorizontalPosition = new SimpleDoubleProperty(this, "labelHorizontalPosition", 0.5){

        protected void invalidated() {
            if (this.get() < 0.0 || this.get() > 1.0) {
                throw new IllegalArgumentException("labelHorizontalPosition must be in rage [0,1]");
            }
            AbstractRangeValueIndicator.this.layoutChildren();
        }
    };
    private final DoubleProperty labelVerticalPosition = new SimpleDoubleProperty(this, "labelVerticalPosition", 0.5){

        protected void invalidated() {
            if (this.get() < 0.0 || this.get() > 1.0) {
                throw new IllegalArgumentException("labelVerticalPosition must be in rage [0,1]");
            }
            AbstractRangeValueIndicator.this.layoutChildren();
        }
    };

    protected AbstractRangeValueIndicator(Axis axis, double lowerBound, double upperBound, String text) {
        super(axis, text);
        this.setLowerBound(lowerBound);
        this.setUpperBound(upperBound);
        this.rectangle.setMouseTransparent(true);
        this.getChartChildren().addAll((Object[])new Node[]{this.rectangle, this.label});
    }

    public final DoubleProperty lowerBoundProperty() {
        return this.lowerBound;
    }

    public final double getLowerBound() {
        return this.lowerBoundProperty().get();
    }

    public final void setLowerBound(double value) {
        this.lowerBoundProperty().set(value);
    }

    public final DoubleProperty upperBoundProperty() {
        return this.upperBound;
    }

    public final double getUpperBound() {
        return this.upperBoundProperty().get();
    }

    public final void setUpperBound(double value) {
        this.upperBoundProperty().set(value);
    }

    public final DoubleProperty labelHorizontalPositionProperty() {
        return this.labelHorizontalPosition;
    }

    public final double getLabelHorizontalPosition() {
        return this.labelHorizontalPositionProperty().get();
    }

    public final void setLabelHorizontalPosition(double value) {
        this.labelHorizontalPositionProperty().set(value);
    }

    public final DoubleProperty labelVerticalPositionProperty() {
        return this.labelVerticalPosition;
    }

    public final double getLabelVerticalPosition() {
        return this.labelVerticalPositionProperty().get();
    }

    public final void setLabelVerticalPosition(double value) {
        this.labelVerticalPositionProperty().set(value);
    }

    protected void layout(Bounds bounds) {
        if (bounds.intersects(this.getChart().getCanvas().getBoundsInLocal())) {
            this.rectangle.setX(bounds.getMinX());
            this.rectangle.setY(bounds.getMinY());
            this.rectangle.setWidth(bounds.getWidth());
            this.rectangle.setHeight(bounds.getHeight());
            this.addChildNodeIfNotPresent((Node)this.rectangle);
            this.layoutLabel(bounds, this.getLabelHorizontalPosition(), this.getLabelVerticalPosition());
        } else {
            this.getChartChildren().clear();
        }
    }
}

