/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.axes.spi.format;

import de.gsi.chart.axes.Axis;
import de.gsi.chart.axes.TickUnitSupplier;
import de.gsi.chart.axes.spi.format.AbstractFormatter;
import de.gsi.chart.axes.spi.format.DefaultTickUnitSupplier;
import java.text.DecimalFormat;
import java.text.ParseException;

public class SimpleFormatter
extends AbstractFormatter {
    private static final TickUnitSupplier DEFAULT_TICK_UNIT_SUPPLIER = new DefaultTickUnitSupplier();
    private final DecimalFormat formatter = new DecimalFormat("0.######");
    private String prefix;
    private String suffix;

    public SimpleFormatter(Axis axis) {
        super(axis);
    }

    public SimpleFormatter() {
        this.setTickUnitSupplier(DEFAULT_TICK_UNIT_SUPPLIER);
    }

    public SimpleFormatter(Axis axis, String prefix, String suffix) {
        this(axis);
        this.prefix = prefix;
        this.suffix = suffix;
    }

    @Override
    protected void rangeUpdated() {
    }

    @Override
    public String toString(Number object) {
        return this.toString(object, this.formatter);
    }

    private String toString(Number object, DecimalFormat numFormatter) {
        String pref = this.prefix == null ? "" : this.prefix;
        String suff = this.suffix == null ? "" : this.suffix;
        return pref + numFormatter.format(object) + suff;
    }

    @Override
    public Number fromString(String string) {
        try {
            int prefixLength = this.prefix == null ? 0 : this.prefix.length();
            int suffixLength = this.suffix == null ? 0 : this.suffix.length();
            return this.formatter.parse(string.substring(prefixLength, string.length() - suffixLength));
        }
        catch (ParseException exc) {
            throw new IllegalArgumentException(exc);
        }
    }
}

