/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.axes.spi.format;

import de.gsi.chart.axes.TickUnitSupplier;
import java.util.Arrays;
import java.util.Collections;
import java.util.Objects;
import java.util.SortedSet;
import java.util.TreeSet;

public final class DefaultTickUnitSupplier
implements TickUnitSupplier {
    private static final int BASE = 10;
    private static final SortedSet<Number> DEFAULT_MULTIPLIERS = Collections.unmodifiableSortedSet(new TreeSet<Double>(Arrays.asList(1.0, 2.5, 5.0)));
    private final double[] multipliers;

    public DefaultTickUnitSupplier() {
        this(DEFAULT_MULTIPLIERS);
    }

    public DefaultTickUnitSupplier(SortedSet<? extends Number> multipliers) {
        Objects.requireNonNull(multipliers, "The multipliers must not be null");
        if (multipliers.isEmpty()) {
            throw new IllegalArgumentException("The set of multipliers must not be empty");
        }
        DefaultTickUnitSupplier.checkRange(multipliers);
        this.multipliers = multipliers.stream().mapToDouble(Number::doubleValue).toArray();
    }

    private static void checkRange(SortedSet<? extends Number> multipliers) {
        for (Number number : multipliers) {
            if (!(number.doubleValue() < 1.0) && !(number.doubleValue() >= 10.0)) continue;
            throw new IllegalArgumentException("The multiplier values must be in range [1, 10)");
        }
    }

    @Override
    public double computeTickUnit(double referenceTickUnit) {
        double localReferenceTickUnit = Math.abs(referenceTickUnit);
        int exp = (int)Math.floor(Math.log10(localReferenceTickUnit));
        double factor = localReferenceTickUnit / Math.pow(10.0, exp);
        double multiplier = 0.0;
        int lastIndex = this.multipliers.length - 1;
        if (factor > this.multipliers[lastIndex]) {
            ++exp;
            multiplier = this.multipliers[0];
        } else {
            for (int i = lastIndex; i >= 0 && factor <= this.multipliers[i]; --i) {
                multiplier = this.multipliers[i];
            }
        }
        return multiplier * Math.pow(10.0, exp);
    }
}

