/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.axes.spi.format;

import de.gsi.chart.axes.Axis;
import de.gsi.chart.axes.AxisLabelFormatter;
import de.gsi.chart.axes.TickUnitSupplier;
import de.gsi.chart.axes.spi.format.DefaultTickUnitSupplier;
import de.gsi.chart.axes.spi.format.FormatterLabelCache;
import java.util.List;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.util.StringConverter;

public abstract class AbstractFormatter
extends StringConverter<Number>
implements AxisLabelFormatter {
    private static final TickUnitSupplier DEFAULT_TICK_UNIT_SUPPLIER = new DefaultTickUnitSupplier();
    private final ObjectProperty<TickUnitSupplier> tickUnitSupplier = new SimpleObjectProperty((Object)this, "tickUnitSupplier", (Object)DEFAULT_TICK_UNIT_SUPPLIER);
    protected FormatterLabelCache labelCache = new FormatterLabelCache();
    protected List<Double> majorTickMarksCopy;
    protected double unitScaling;
    protected double rangeMin = 0.0;
    protected double rangeMax = 1.0;
    protected double localSchmidtTriggerThreshold = 0.01;
    protected DoubleProperty schmittTriggerThreshold = new SimpleDoubleProperty(this, "schmittTriggerThreshold", this.localSchmidtTriggerThreshold){

        public void set(double value) {
            super.set(Math.abs(value));
        }
    };

    public DoubleProperty schmittTriggerThresholdProperty() {
        return this.schmittTriggerThreshold;
    }

    @Override
    public ObjectProperty<TickUnitSupplier> tickUnitSupplierProperty() {
        return this.tickUnitSupplier;
    }

    @Override
    public TickUnitSupplier getTickUnitSupplier() {
        return (TickUnitSupplier)this.tickUnitSupplierProperty().get();
    }

    @Override
    public void setTickUnitSupplier(TickUnitSupplier supplier) {
        this.tickUnitSupplierProperty().set((Object)supplier);
    }

    protected double getRange() {
        return Math.abs(this.rangeMax - this.rangeMin);
    }

    protected double getLogRange() {
        double diff = this.getRange();
        return diff > 0.0 ? Math.log10(diff) : 1.0;
    }

    public AbstractFormatter(Axis axis) {
        this();
        if (axis == null) {
            return;
        }
    }

    @Override
    public void updateFormatter(List<Double> newMajorTickMarks, double unitScaling) {
        this.majorTickMarksCopy = newMajorTickMarks;
        this.unitScaling = unitScaling;
        this.rangeMin = Double.MAX_VALUE;
        this.rangeMax = -1.7976931348623157E308;
        for (Number number : this.majorTickMarksCopy) {
            double val = number.doubleValue();
            if (!Double.isFinite(val)) continue;
            this.rangeMin = Math.min(this.rangeMin, val);
            this.rangeMax = Math.max(this.rangeMax, val);
        }
        this.rangeMin /= unitScaling;
        this.rangeMax /= unitScaling;
        this.rangeUpdated();
    }

    protected abstract void rangeUpdated();

    public AbstractFormatter() {
    }
}

