/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.axes.spi;

import de.gsi.chart.axes.AxisLabelOverlapPolicy;
import de.gsi.chart.axes.spi.AxisRange;
import de.gsi.chart.axes.spi.DefaultNumericAxis;
import de.gsi.dataset.DataSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.util.StringConverter;

public final class CategoryAxis
extends DefaultNumericAxis {
    private boolean forceAxisCategories = false;
    private final List<String> allDataCategories = new ArrayList<String>();
    private boolean changeIsLocal = false;
    private final ObjectProperty<ObservableList<String>> categories = new ObjectPropertyBase<ObservableList<String>>(){

        public Object getBean() {
            return CategoryAxis.this;
        }

        public String getName() {
            return "categories";
        }
    };

    public void setCategories(ObservableList<String> categoryList) {
        if (categoryList == null) {
            this.forceAxisCategories = false;
            this.setCategories((ObservableList<String>)FXCollections.observableArrayList());
            return;
        }
        this.setTickLabelFormatter(new StringConverter<Number>(){

            public String toString(Number object) {
                int index = Math.round(object.floatValue());
                if (index < 0 || index >= CategoryAxis.this.getCategories().size()) {
                    return "unknown category";
                }
                return (String)CategoryAxis.this.getCategories().get(index);
            }

            public Number fromString(String string) {
                for (int i = 0; i < CategoryAxis.this.getCategories().size(); ++i) {
                    if (!((String)CategoryAxis.this.getCategories().get(i)).equalsIgnoreCase(string)) continue;
                    return i;
                }
                throw new IllegalArgumentException("Category not found.");
            }
        });
        this.categories.set(categoryList);
        if (!this.changeIsLocal) {
            this.allDataCategories.clear();
            this.allDataCategories.addAll((Collection<String>)this.getCategories());
        }
        this.requestAxisLayout();
    }

    public void setCategories(List<String> categories) {
        if (categories == null) {
            this.forceAxisCategories = false;
            this.setCategories((ObservableList<String>)FXCollections.observableArrayList());
            return;
        }
        this.forceAxisCategories = true;
        this.setCategories((ObservableList<String>)FXCollections.observableArrayList(categories));
    }

    public ObservableList<String> getCategories() {
        return (ObservableList)this.categories.get();
    }

    @Override
    protected AxisRange autoRange(double minValue, double maxValue, double length, double labelSize) {
        double min;
        double d = min = minValue > 0.0 && this.isForceZeroInRange() ? 0.0 : minValue;
        if (this.isLogAxis && minValue <= 0.0) {
            min = 1.0E-6;
            this.isUpdating = true;
            this.setLowerBound(1.0E-6);
            this.isUpdating = false;
        }
        double max = maxValue < 0.0 && this.isForceZeroInRange() ? 0.0 : maxValue;
        double padding = DefaultNumericAxis.getEffectiveRange(min, max) * this.getAutoRangePadding();
        double paddingScale = 1.0 + this.getAutoRangePadding();
        double paddedMin = this.isLogAxis ? minValue / paddingScale : min - padding;
        double paddedMax = this.isLogAxis ? maxValue * paddingScale : max + padding;
        return this.computeRange(paddedMin, paddedMax, length, labelSize);
    }

    public CategoryAxis() {
        this((String)null);
        this.setTickUnit(1.0);
        this.changeIsLocal = true;
        this.setCategories((ObservableList<String>)FXCollections.observableArrayList());
        this.changeIsLocal = false;
    }

    public CategoryAxis(String axisLabel) {
        super(axisLabel);
        this.setOverlapPolicy(AxisLabelOverlapPolicy.SHIFT_ALT);
        this.lowerBoundProperty().addListener((ch, old, val) -> {
            double range = Math.abs(val.doubleValue() - this.getUpperBound());
            double rangeInt = (int)range;
            double scale = 0.5 / rangeInt;
            this.autoRangePaddingProperty().set(scale);
        });
        this.upperBoundProperty().addListener((ch, old, val) -> {
            double range = Math.abs(this.getLowerBound() - val.doubleValue());
            double rangeInt = (int)range;
            double scale = 0.5 / rangeInt;
            this.autoRangePaddingProperty().set(scale);
        });
    }

    public CategoryAxis(ObservableList<String> categories) {
        this(null, categories);
    }

    public CategoryAxis(String axisLabel, ObservableList<String> categories) {
        super(axisLabel, 0.0, categories.size(), 1.0);
        this.changeIsLocal = true;
        this.setCategories(categories);
        this.changeIsLocal = false;
    }

    public boolean updateCategories(DataSet dataSet) {
        if (dataSet == null || this.forceAxisCategories) {
            return false;
        }
        boolean zeroDataLabels = true;
        ArrayList<String> newCategoryList = new ArrayList<String>();
        dataSet.lock();
        for (int i = 0; i < dataSet.getDataCount(); ++i) {
            String sanitizedLabel;
            String dataLabel = dataSet.getDataLabel(i);
            if (dataLabel == null) {
                sanitizedLabel = "unknown category";
            } else {
                sanitizedLabel = dataLabel;
                zeroDataLabels = false;
            }
            newCategoryList.add(sanitizedLabel);
        }
        dataSet.unlock();
        if (!zeroDataLabels) {
            this.setCategories(newCategoryList);
            this.forceAxisCategories = false;
        }
        return false;
    }

    @Override
    protected List<Double> calculateMinorTickValues() {
        return Collections.emptyList();
    }

    @Override
    protected double computeTickUnit(double rawTickUnit) {
        return 1.0;
    }
}

