/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.axes.spi;

import de.gsi.chart.axes.Axis;
import de.gsi.chart.axes.spi.CategoryAxis;
import javafx.beans.value.ObservableValue;
import javafx.scene.chart.ValueAxis;

public final class Axes {
    private Axes() {
    }

    public static boolean isNumericAxis(Axis axis) {
        return axis instanceof Axis;
    }

    public static boolean isCategoryAxis(Axis axis) {
        return axis instanceof CategoryAxis;
    }

    public static Axis toNumericAxis(Axis axis) {
        if (Axes.isNumericAxis(axis)) {
            return axis;
        }
        throw new IllegalArgumentException("Expected an instance of ValueAxis");
    }

    public static boolean hasBoundedRange(ValueAxis<?> axis) {
        return axis.lowerBoundProperty().isBound() || axis.upperBoundProperty().isBound();
    }

    public static boolean hasBoundedRange(Axis axis) {
        return axis.lowerBoundProperty().isBound() || axis.upperBoundProperty().isBound();
    }

    public static void bindBounds(ValueAxis<?> axis, ValueAxis<?> observable) {
        axis.lowerBoundProperty().bind((ObservableValue)observable.lowerBoundProperty());
        axis.upperBoundProperty().bind((ObservableValue)observable.upperBoundProperty());
    }

    public static void unbindBounds(ValueAxis<?> axis) {
        axis.lowerBoundProperty().unbind();
        axis.upperBoundProperty().unbind();
    }
}

