/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.axes.spi;

import com.sun.javafx.css.converters.BooleanConverter;
import com.sun.javafx.css.converters.EnumConverter;
import com.sun.javafx.css.converters.PaintConverter;
import com.sun.javafx.css.converters.SizeConverter;
import de.gsi.chart.Chart;
import de.gsi.chart.axes.Axis;
import de.gsi.chart.axes.AxisLabelOverlapPolicy;
import de.gsi.chart.axes.spi.AxisLabel;
import de.gsi.chart.axes.spi.AxisRange;
import de.gsi.chart.axes.spi.DefaultNumericAxis;
import de.gsi.chart.axes.spi.MetricPrefix;
import de.gsi.chart.axes.spi.TickMark;
import de.gsi.chart.ui.css.StylishBooleanProperty;
import de.gsi.chart.ui.css.StylishDoubleProperty;
import de.gsi.chart.ui.css.StylishIntegerProperty;
import de.gsi.chart.ui.css.StylishObjectProperty;
import de.gsi.chart.ui.css.StylishStringProperty;
import de.gsi.chart.ui.geometry.Side;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.ReadOnlyDoubleWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.css.CssMetaData;
import javafx.css.FontCssMetaData;
import javafx.css.PseudoClass;
import javafx.css.SimpleStyleableDoubleProperty;
import javafx.css.StyleConverter;
import javafx.css.Styleable;
import javafx.css.StyleableObjectProperty;
import javafx.css.StyleableProperty;
import javafx.scene.Node;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Path;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;
import javafx.util.StringConverter;

public abstract class AbstractAxisParameter
extends Pane
implements Axis {
    private static final String CHART_CSS = Chart.class.getResource("chart.css").toExternalForm();
    protected static final int DEFAULT_MINOR_TICK_COUNT = 10;
    protected final Path majorTickStyle = new Path();
    protected final Path minorTickStyle = new Path();
    protected final AxisLabel axisLabel = new AxisLabel();
    protected double oldAxisLength = -1.0;
    protected boolean rangeValid = false;
    protected boolean measureInvalid = false;
    protected boolean tickLabelsVisibleInvalid = false;
    protected final ObservableList<TickMark> majorTickMarks = FXCollections.observableArrayList();
    protected final ObservableList<TickMark> minorTickMarkValues = FXCollections.observableArrayList();
    protected AxisRange autoRange = new AxisRange();
    protected AxisRange userRange = new AxisRange();
    private final ObjectProperty<Side> side = new StyleableObjectProperty<Side>(Side.BOTTOM){

        protected void invalidated() {
            Side edge = (Side)((Object)this.get());
            AbstractAxisParameter.this.pseudoClassStateChanged(TOP_PSEUDOCLASS_STATE, edge == Side.TOP);
            AbstractAxisParameter.this.pseudoClassStateChanged(RIGHT_PSEUDOCLASS_STATE, edge == Side.RIGHT);
            AbstractAxisParameter.this.pseudoClassStateChanged(BOTTOM_PSEUDOCLASS_STATE, edge == Side.BOTTOM);
            AbstractAxisParameter.this.pseudoClassStateChanged(LEFT_PSEUDOCLASS_STATE, edge == Side.LEFT);
            AbstractAxisParameter.this.pseudoClassStateChanged(CENTRE_HOR_PSEUDOCLASS_STATE, edge == Side.CENTER_HOR);
            AbstractAxisParameter.this.pseudoClassStateChanged(CENTRE_VER_PSEUDOCLASS_STATE, edge == Side.CENTER_VER);
            AbstractAxisParameter.this.requestAxisLayout();
        }

        public CssMetaData<AbstractAxisParameter, Side> getCssMetaData() {
            return StyleableProperties.SIDE;
        }

        public Object getBean() {
            return AbstractAxisParameter.this;
        }

        public String getName() {
            return "side";
        }
    };
    private final ObjectProperty<AxisLabelOverlapPolicy> overlapPolicy = new StyleableObjectProperty<AxisLabelOverlapPolicy>(AxisLabelOverlapPolicy.SKIP_ALT){

        protected void invalidated() {
            AbstractAxisParameter.this.requestAxisLayout();
        }

        public CssMetaData<AbstractAxisParameter, AxisLabelOverlapPolicy> getCssMetaData() {
            return StyleableProperties.OVERLAP_POLICY;
        }

        public Object getBean() {
            return AbstractAxisParameter.this;
        }

        public String getName() {
            return "overlapPolcy";
        }
    };
    private final DoubleProperty centerAxisPosition = new StylishDoubleProperty(StyleableProperties.access$800(), this, "centerAxisPosition", 0.5, this::requestAxisLayout){

        public void set(double value) {
            super.set(Math.max(0.0, Math.min(value, 1.0)));
        }
    };
    private final ObjectProperty<TextAlignment> axisLabelTextAlignment = new StylishObjectProperty<TextAlignment>(StyleableProperties.access$900(), this, "axisLabelTextAlignment", TextAlignment.CENTER, this::requestAxisLayout);
    private final StringProperty label = new StylishStringProperty((CssMetaData<? extends Styleable, String>)StyleableProperties.access$1000(), this, "label", null, this::requestAxisLayout);
    private final BooleanProperty tickMarkVisible = new StylishBooleanProperty((CssMetaData<? extends Styleable, Boolean>)StyleableProperties.access$1100(), this, "tickMarkVisible", true, this::requestAxisLayout);
    private final BooleanProperty tickLabelsVisible = new StylishBooleanProperty((CssMetaData<? extends Styleable, Boolean>)StyleableProperties.access$1200(), this, "tickLabelsVisible", true, () -> {
        for (TickMark tick : this.majorTickMarks) {
            tick.setVisible(this.tickLabelsVisible.get());
        }
        this.tickLabelsVisibleInvalid = true;
        this.requestAxisLayout();
    });
    private final DoubleProperty axisPadding = new StylishDoubleProperty((CssMetaData<? extends Styleable, Number>)StyleableProperties.access$1300(), this, "axisPadding", 15.0, this::requestAxisLayout);
    private final DoubleProperty tickLength = new StylishDoubleProperty((CssMetaData<? extends Styleable, Number>)StyleableProperties.access$1400(), this, "tickLength", 8.0, this::requestAxisLayout);
    private final BooleanProperty autoRanging = new StylishBooleanProperty((CssMetaData<? extends Styleable, Boolean>)StyleableProperties.access$1500(), this, "autoRanging", true, this::requestAxisLayout);
    private final ObjectProperty<Font> tickLabelFont = new StylishObjectProperty<Font>(StyleableProperties.access$1600(), this, "tickLabelFont", Font.font((String)"System", (double)8.0), () -> {
        Font f = (Font)this.tickLabelFontProperty().get();
        for (TickMark tm : this.getTickMarks()) {
            tm.setFont(f);
        }
        this.measureInvalid = true;
        this.requestAxisLayout();
    });
    private final ObjectProperty<Paint> tickLabelFill = new StylishObjectProperty<Color>(StyleableProperties.access$1700(), this, "tickLabelFill", Color.BLACK, this::requestAxisLayout);
    private final DoubleProperty tickLabelGap = new StylishDoubleProperty((CssMetaData<? extends Styleable, Number>)StyleableProperties.access$1800(), this, "tickLabelGap", 3.0, this::requestAxisLayout);
    private final DoubleProperty axisLabelGap = new StylishDoubleProperty((CssMetaData<? extends Styleable, Number>)StyleableProperties.access$1900(), this, "axisLabelGap", 3.0, this::requestAxisLayout);
    private final IntegerProperty animationDuration = new StylishIntegerProperty((CssMetaData<? extends Styleable, Number>)StyleableProperties.access$2000(), this, "animationDuration", 250, this::requestAxisLayout);
    private final BooleanProperty animated = new SimpleBooleanProperty((Object)this, "animated", false);
    protected final DoubleProperty tickLabelRotation = new StylishDoubleProperty((CssMetaData<? extends Styleable, Number>)StyleableProperties.access$2100(), this, "tickLabelRotation", 0.0, this::requestAxisLayout);
    private final BooleanProperty minorTickVisible = new StylishBooleanProperty((CssMetaData<? extends Styleable, Boolean>)StyleableProperties.access$2200(), this, "minorTickVisible", true, this::requestAxisLayout);
    private final ReadOnlyDoubleWrapper scale = new ReadOnlyDoubleWrapper(this, "scale", 1.0){

        protected void invalidated() {
            AbstractAxisParameter.this.requestAxisLayout();
            AbstractAxisParameter.this.measureInvalid = true;
        }
    };
    protected final DoubleProperty upperBound = new SimpleDoubleProperty(this, "upperBound", 100.0){

        public void set(double newValue) {
            double oldValue = this.get();
            if (oldValue != newValue) {
                super.set(newValue);
                AbstractAxisParameter.this.requestAxisLayout();
            }
        }
    };
    protected final DoubleProperty lowerBound = new SimpleDoubleProperty(this, "lowerBound", 0.0){

        public void set(double newValue) {
            double oldValue = this.get();
            if (oldValue != newValue) {
                super.set(newValue);
                AbstractAxisParameter.this.requestAxisLayout();
            }
        }
    };
    private final ObjectProperty<StringConverter<Number>> tickLabelFormatter = new ObjectPropertyBase<StringConverter<Number>>(null){

        protected void invalidated() {
            AbstractAxisParameter.this.invalidateRange();
            AbstractAxisParameter.this.requestAxisLayout();
        }

        public Object getBean() {
            return AbstractAxisParameter.this;
        }

        public String getName() {
            return "tickLabelFormatter";
        }
    };
    private final DoubleProperty minorTickLength = new StylishDoubleProperty((CssMetaData<? extends Styleable, Number>)StyleableProperties.access$2300(), this, "minorTickLength", 5.0, this::requestAxisLayout);
    private final IntegerProperty minorTickCount = new StylishIntegerProperty((CssMetaData<? extends Styleable, Number>)StyleableProperties.access$2400(), this, "minorTickCount", 10, this::requestAxisLayout);
    protected final DoubleProperty scaleBinding = new SimpleDoubleProperty(this, "scaleBinding", this.getScale()){

        protected void invalidated() {
            AbstractAxisParameter.this.setScale(this.get());
        }
    };
    private final BooleanProperty autoGrowRanging = new StylishBooleanProperty((CssMetaData<? extends Styleable, Boolean>)StyleableProperties.access$2500(), this, "autoGrowRanging", false, this::requestAxisLayout);
    protected boolean isInvertedAxis = false;
    private final BooleanProperty invertAxis = new SimpleBooleanProperty(this, "invertAxis", false){

        protected void invalidated() {
            AbstractAxisParameter.this.isInvertedAxis = this.get();
            AbstractAxisParameter.this.invalidateRange();
            AbstractAxisParameter.this.requestAxisLayout();
        }
    };
    protected boolean isTimeAxis = false;
    private final BooleanProperty timeAxis = new SimpleBooleanProperty(this, "timeAxis", false){

        protected void invalidated() {
            AbstractAxisParameter.this.isTimeAxis = this.get();
            if (AbstractAxisParameter.this.isTimeAxis) {
                AbstractAxisParameter.this.setMinorTickCount(0);
            } else {
                AbstractAxisParameter.this.setMinorTickCount(10);
            }
            AbstractAxisParameter.this.invalidateRange();
            AbstractAxisParameter.this.requestAxisLayout();
        }
    };
    private final BooleanProperty autoRangeRounding = new StylishBooleanProperty((CssMetaData<? extends Styleable, Boolean>)StyleableProperties.access$2600(), this, "autoRangeRounding", false, this::requestAxisLayout);
    private final DoubleProperty autoRangePadding = new SimpleDoubleProperty(0.0);
    private final ObjectProperty<String> unitLabel = new ObjectPropertyBase<String>(){

        protected void invalidated() {
            AbstractAxisParameter.this.updateAxisLabelAndUnit();
            AbstractAxisParameter.this.requestAxisLayout();
        }

        public Object getBean() {
            return AbstractAxisParameter.this;
        }

        public String getName() {
            return "unitLabel";
        }
    };
    private final BooleanProperty autoUnitScaling = new SimpleBooleanProperty(this, "autoUnitScaling", false){

        protected void invalidated() {
            AbstractAxisParameter.this.updateAxisLabelAndUnit();
            AbstractAxisParameter.this.requestAxisLayout();
        }
    };
    private final DoubleProperty unitScaling = new SimpleDoubleProperty(this, "unitScaling", 1.0){

        protected void invalidated() {
            AbstractAxisParameter.this.updateAxisLabelAndUnit();
            AbstractAxisParameter.this.requestAxisLayout();
        }
    };
    protected final SimpleStyleableDoubleProperty tickUnit = new SimpleStyleableDoubleProperty(StyleableProperties.access$2700(), this, "tickUnit", 5.0){

        protected void invalidated() {
            if (AbstractAxisParameter.this.isAutoRanging() || AbstractAxisParameter.this.isAutoGrowRanging()) {
                return;
            }
            AbstractAxisParameter.this.invalidateRange();
            AbstractAxisParameter.this.requestAxisLayout();
        }
    };
    private static final PseudoClass TOP_PSEUDOCLASS_STATE = PseudoClass.getPseudoClass((String)"top");
    private static final PseudoClass BOTTOM_PSEUDOCLASS_STATE = PseudoClass.getPseudoClass((String)"bottom");
    private static final PseudoClass LEFT_PSEUDOCLASS_STATE = PseudoClass.getPseudoClass((String)"left");
    private static final PseudoClass RIGHT_PSEUDOCLASS_STATE = PseudoClass.getPseudoClass((String)"right");
    private static final PseudoClass CENTRE_HOR_PSEUDOCLASS_STATE = PseudoClass.getPseudoClass((String)"horCentre");
    private static final PseudoClass CENTRE_VER_PSEUDOCLASS_STATE = PseudoClass.getPseudoClass((String)"verCentre");

    public Path getMajorTickStyle() {
        return this.majorTickStyle;
    }

    public Path getMinorTickStyle() {
        return this.minorTickStyle;
    }

    public Text getAxisLabel() {
        return this.axisLabel;
    }

    @Override
    public ObservableList<TickMark> getTickMarks() {
        return this.majorTickMarks;
    }

    @Override
    public ObservableList<TickMark> getMinorTickMarks() {
        return this.minorTickMarkValues;
    }

    @Override
    public AxisRange getAutoRange() {
        return this.autoRange;
    }

    @Override
    public AxisRange getUserRange() {
        return this.userRange;
    }

    @Override
    public AxisRange getRange() {
        if (this.isAutoRanging() || this.isAutoGrowRanging()) {
            return this.getAutoRange();
        }
        return this.getUserRange();
    }

    @Override
    public Side getSide() {
        return (Side)((Object)this.sideProperty().get());
    }

    @Override
    public void setSide(Side value) {
        this.sideProperty().set((Object)value);
    }

    @Override
    public ObjectProperty<Side> sideProperty() {
        return this.side;
    }

    public AxisLabelOverlapPolicy getOverlapPolicy() {
        return (AxisLabelOverlapPolicy)((Object)this.overlapPolicyProperty().get());
    }

    public void setOverlapPolicy(AxisLabelOverlapPolicy value) {
        this.overlapPolicyProperty().set((Object)value);
    }

    public ObjectProperty<AxisLabelOverlapPolicy> overlapPolicyProperty() {
        return this.overlapPolicy;
    }

    public double getCenterAxisPosition() {
        return this.centerAxisPositionProperty().get();
    }

    public void setAxisCentrePosition(double value) {
        this.centerAxisPositionProperty().set(value);
    }

    public DoubleProperty centerAxisPositionProperty() {
        return this.centerAxisPosition;
    }

    public TextAlignment getaAxisLabelTextAlignment() {
        return (TextAlignment)this.axisLabelTextAlignmentProperty().get();
    }

    public void setAxisLabelAlignment(TextAlignment value) {
        this.axisLabelTextAlignmentProperty().set((Object)value);
    }

    public ObjectProperty<TextAlignment> axisLabelTextAlignmentProperty() {
        return this.axisLabelTextAlignment;
    }

    @Override
    public String getLabel() {
        return (String)this.labelProperty().get();
    }

    @Override
    public void setLabel(String value) {
        this.labelProperty().set((Object)value);
    }

    @Override
    public StringProperty labelProperty() {
        return this.label;
    }

    public boolean isTickMarkVisible() {
        return this.tickMarkVisible.get();
    }

    public void setTickMarkVisible(boolean value) {
        this.tickMarkVisible.set(value);
    }

    public BooleanProperty tickMarkVisibleProperty() {
        return this.tickMarkVisible;
    }

    public boolean isTickLabelsVisible() {
        return this.tickLabelsVisible.get();
    }

    public void setTickLabelsVisible(boolean value) {
        this.tickLabelsVisible.set(value);
    }

    public BooleanProperty tickLabelsVisibleProperty() {
        return this.tickLabelsVisible;
    }

    public double getAxisPadding() {
        return this.axisPaddingProperty().get();
    }

    public void setAxisPadding(double value) {
        this.axisPaddingProperty().set(value);
    }

    public DoubleProperty axisPaddingProperty() {
        return this.axisPadding;
    }

    public double getTickLength() {
        return this.tickLength.get();
    }

    public void setTickLength(double value) {
        this.tickLength.set(value);
    }

    public DoubleProperty tickLengthProperty() {
        return this.tickLength;
    }

    @Override
    public boolean isAutoRanging() {
        return this.autoRanging.get();
    }

    @Override
    public void setAutoRanging(boolean value) {
        this.autoRanging.set(value);
    }

    @Override
    public BooleanProperty autoRangingProperty() {
        return this.autoRanging;
    }

    @Override
    public Font getTickLabelFont() {
        return (Font)this.tickLabelFont.get();
    }

    public void setTickLabelFont(Font value) {
        this.tickLabelFont.set((Object)value);
    }

    public ObjectProperty<Font> tickLabelFontProperty() {
        return this.tickLabelFont;
    }

    @Override
    public Paint getTickLabelFill() {
        return (Paint)this.tickLabelFill.get();
    }

    public void setTickLabelFill(Paint value) {
        this.tickLabelFill.set((Object)value);
    }

    public ObjectProperty<Paint> tickLabelFillProperty() {
        return this.tickLabelFill;
    }

    @Override
    public double getTickLabelGap() {
        return this.axisLabelGap.get();
    }

    public void setTickLabelGap(double value) {
        this.tickLabelGap.set(value);
    }

    public DoubleProperty tickLabelGapProperty() {
        return this.tickLabelGap;
    }

    public double getAxisLabelGap() {
        return this.axisLabelGap.get();
    }

    public void setAxisLabelGap(double value) {
        this.axisLabelGap.set(value);
    }

    public DoubleProperty axisLabelGapProperty() {
        return this.axisLabelGap;
    }

    public int getAnimationDuration() {
        return this.animationDuration.get();
    }

    public void setAnimationDuration(int value) {
        this.animationDuration.set(value);
    }

    public IntegerProperty animationDurationProperty() {
        return this.animationDuration;
    }

    public boolean getAnimated() {
        return this.animated.get();
    }

    @Override
    public void setAnimated(boolean value) {
        this.animated.set(value);
    }

    public BooleanProperty animatedProperty() {
        return this.animated;
    }

    public double getTickLabelRotation() {
        return this.tickLabelRotation.getValue();
    }

    public void setTickLabelRotation(double value) {
        this.tickLabelRotation.setValue((Number)value);
    }

    public DoubleProperty tickLabelRotationProperty() {
        return this.tickLabelRotation;
    }

    public boolean isMinorTickVisible() {
        return this.minorTickVisible.get();
    }

    public void setMinorTickVisible(boolean value) {
        this.minorTickVisible.set(value);
    }

    public BooleanProperty minorTickVisibleProperty() {
        return this.minorTickVisible;
    }

    @Override
    public double getLength() {
        if (this.getSide() == null) {
            return Double.NaN;
        }
        return this.getSide().isHorizontal() ? this.getWidth() : this.getHeight();
    }

    public double getScale() {
        return this.scale.get();
    }

    protected void setScale(double scale) {
        this.scale.set(scale);
    }

    public ReadOnlyDoubleProperty scaleProperty() {
        return this.scale.getReadOnlyProperty();
    }

    ReadOnlyDoubleWrapper scalePropertyImpl() {
        return this.scale;
    }

    @Override
    public double getUpperBound() {
        return this.upperBound.get();
    }

    @Override
    public void setUpperBound(double value) {
        this.upperBound.set(value);
    }

    @Override
    public DoubleProperty upperBoundProperty() {
        return this.upperBound;
    }

    @Override
    public double getLowerBound() {
        return this.lowerBound.get();
    }

    @Override
    public void setLowerBound(double value) {
        this.lowerBound.set(value);
    }

    @Override
    public DoubleProperty lowerBoundProperty() {
        return this.lowerBound;
    }

    @Override
    public StringConverter<Number> getTickLabelFormatter() {
        return (StringConverter)this.tickLabelFormatter.getValue();
    }

    public void setTickLabelFormatter(StringConverter<Number> value) {
        this.tickLabelFormatter.setValue(value);
    }

    public ObjectProperty<StringConverter<Number>> tickLabelFormatterProperty() {
        return this.tickLabelFormatter;
    }

    public double getMinorTickLength() {
        return this.minorTickLength.get();
    }

    public void setMinorTickLength(double value) {
        this.minorTickLength.set(value);
    }

    public DoubleProperty minorTickLengthProperty() {
        return this.minorTickLength;
    }

    @Override
    public int getMinorTickCount() {
        return this.minorTickCount.get();
    }

    public void setMinorTickCount(int value) {
        this.minorTickCount.set(value);
    }

    public IntegerProperty minorTickCountProperty() {
        return this.minorTickCount;
    }

    @Override
    public boolean isAutoGrowRanging() {
        return this.autoGrowRanging.get();
    }

    @Override
    public void setAutoGrowRanging(boolean state) {
        if (state) {
            this.setAutoRanging(false);
            this.requestAxisLayout();
        }
        this.autoGrowRanging.set(state);
    }

    @Override
    public BooleanProperty autoGrowRangingProperty() {
        return this.autoGrowRanging;
    }

    public BooleanProperty autoRangeRoundingProperty() {
        return this.autoRangeRounding;
    }

    public boolean isAutoRangeRounding() {
        return this.autoRangeRoundingProperty().get();
    }

    public void setAutoRangeRounding(boolean round) {
        this.autoRangeRoundingProperty().set(round);
    }

    @Override
    public boolean isInvertedAxis() {
        return this.invertAxis.get();
    }

    @Override
    public void invertAxis(boolean value) {
        this.invertAxis.set(value);
    }

    @Override
    public BooleanProperty invertAxisProperty() {
        return this.invertAxis;
    }

    @Override
    public boolean isTimeAxis() {
        return this.timeAxis.get();
    }

    @Override
    public void setTimeAxis(boolean value) {
        this.timeAxis.set(value);
    }

    @Override
    public BooleanProperty timeAxisProperty() {
        return this.timeAxis;
    }

    public DoubleProperty autoRangePaddingProperty() {
        return this.autoRangePadding;
    }

    public double getAutoRangePadding() {
        return this.autoRangePaddingProperty().get();
    }

    public void setAutoRangePadding(double padding) {
        this.autoRangePaddingProperty().set(padding);
    }

    protected double decadeRange() {
        double range = Math.abs(this.getUpperBound() - this.getLowerBound());
        if (range <= 0.0) {
            return 1.0;
        }
        return Math.log10(range);
    }

    protected void updateScaleAndUnitPrefix() {
        double oldPower;
        double power3Lower;
        double range = Math.abs(this.getUpperBound() - this.getLowerBound());
        double logRange = Math.log10(range);
        double power3Upper = 3.0 * Math.ceil(logRange / 3.0);
        double a = power3Upper > (power3Lower = 3.0 * Math.floor(logRange / 3.0)) ? power3Lower : power3Upper;
        double power = Math.pow(10.0, a);
        if (power != (oldPower = this.getUnitScaling()) && power != 0.0) {
            this.setUnitScaling(power);
        }
        this.setTickUnit(range / (double)this.getMinorTickCount());
    }

    protected void updateAxisLabelAndUnit() {
        String axisPrimaryLabel = this.getLabel();
        String axisUnit = this.getUnit();
        boolean isAutoScaling = this.getAutoUnitScaling();
        if (isAutoScaling) {
            this.updateScaleAndUnitPrefix();
        }
        String axisPrefix = MetricPrefix.getShortPrefix(this.getUnitScaling());
        if (axisUnit == null && axisPrefix != null) {
            axisUnit = " a.u.";
        }
        if (axisUnit == null) {
            this.axisLabel.setText(axisPrimaryLabel);
        } else {
            this.axisLabel.setText(axisPrimaryLabel + " [" + axisPrefix + axisUnit + "]");
        }
        this.axisLabel.applyCss();
    }

    @Override
    public String getUnit() {
        return (String)this.unitLabel.get();
    }

    @Override
    public void setUnit(String value) {
        this.unitLabel.set((Object)value);
    }

    @Override
    public ObjectProperty<String> unitProperty() {
        return this.unitLabel;
    }

    @Override
    public boolean getAutoUnitScaling() {
        return this.autoUnitScaling.get();
    }

    @Override
    public void setAutoUnitScaling(boolean value) {
        this.autoUnitScaling.set(value);
    }

    @Override
    public BooleanProperty autoUnitScalingProperty() {
        return this.autoUnitScaling;
    }

    @Override
    public double getUnitScaling() {
        return this.unitScaling.get();
    }

    @Override
    public void setUnitScaling(double value) {
        if (!Double.isFinite(value) || value == 0.0) {
            throw new IllegalArgumentException("provided number is not finite and/or zero: " + value);
        }
        this.setTickUnit(value);
        this.unitScaling.set(value);
    }

    @Override
    public void setUnitScaling(MetricPrefix prefix) {
        this.unitScaling.set(prefix.getPower());
    }

    @Override
    public DoubleProperty unitScalingProperty() {
        return this.unitScaling;
    }

    @Override
    public DoubleProperty tickUnitProperty() {
        return this.tickUnit;
    }

    @Override
    public double getTickUnit() {
        return this.tickUnitProperty().get();
    }

    @Override
    public void setTickUnit(double unit) {
        this.tickUnitProperty().set(unit);
    }

    public AbstractAxisParameter() {
        this.getStylesheets().add((Object)CHART_CSS);
        this.getStyleClass().setAll((Object[])new String[]{"axis"});
        this.majorTickStyle.getStyleClass().add((Object)"axis-tick-mark");
        this.minorTickStyle.getStyleClass().add((Object)"axis-minor-tick-mark");
        this.getChildren().addAll((Object[])new Node[]{this.axisLabel, this.majorTickStyle, this.minorTickStyle});
        this.autoRangingProperty().addListener(ch -> {
            if (this.isAutoRanging()) {
                this.setAutoGrowRanging(false);
            }
        });
        this.autoGrowRangingProperty().addListener(ch -> {
            if (this.isAutoGrowRanging()) {
                this.setAutoRanging(false);
            }
        });
        this.labelProperty().addListener(e -> {
            this.updateAxisLabelAndUnit();
            this.requestAxisLayout();
        });
        ChangeListener autoRangeChangeListener = (ch, oldValue, newValue) -> {
            if (oldValue.equals(newValue)) {
                return;
            }
            if (this.getAutoUnitScaling()) {
                this.updateAxisLabelAndUnit();
            }
        };
        this.upperBoundProperty().addListener(autoRangeChangeListener);
        this.lowerBoundProperty().addListener(autoRangeChangeListener);
        this.axisLabel.textAlignmentProperty().bindBidirectional(this.axisLabelTextAlignmentProperty());
        ChangeListener userLimitChangeListener = (ch, o, n) -> {
            this.userRange.set(this.getLowerBound(), this.getUpperBound());
            if (!this.isAutoRanging() && !this.isAutoGrowRanging()) {
                this.requestAxisLayout();
            }
        };
        this.lowerBoundProperty().addListener(userLimitChangeListener);
        this.upperBoundProperty().addListener(userLimitChangeListener);
        this.majorTickStyle.applyCss();
        this.minorTickStyle.applyCss();
        this.axisLabel.applyCss();
    }

    protected void invalidateRange() {
        this.rangeValid = false;
    }

    @Override
    public abstract void requestAxisLayout();

    public abstract void fireInvalidated();

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.STYLEABLES;
    }

    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return AbstractAxisParameter.getClassCssMetaData();
    }

    private static class StyleableProperties {
        private static final CssMetaData<AbstractAxisParameter, Side> SIDE = new CssMetaData<AbstractAxisParameter, Side>("-fx-side", (StyleConverter)new EnumConverter(Side.class)){

            public boolean isSettable(AbstractAxisParameter n) {
                return n.side == null || !n.side.isBound();
            }

            public StyleableProperty<Side> getStyleableProperty(AbstractAxisParameter n) {
                return (StyleableProperty)n.sideProperty();
            }
        };
        private static final CssMetaData<AbstractAxisParameter, AxisLabelOverlapPolicy> OVERLAP_POLICY = new CssMetaData<AbstractAxisParameter, AxisLabelOverlapPolicy>("-fx-overlap-policy", (StyleConverter)new EnumConverter(AxisLabelOverlapPolicy.class)){

            public boolean isSettable(AbstractAxisParameter n) {
                return n.overlapPolicy == null || !n.overlapPolicy.isBound();
            }

            public StyleableProperty<AxisLabelOverlapPolicy> getStyleableProperty(AbstractAxisParameter n) {
                return (StyleableProperty)n.overlapPolicyProperty();
            }
        };
        private static final CssMetaData<AbstractAxisParameter, TextAlignment> AXIS_LABEL_ALIGNMENT = new CssMetaData<AbstractAxisParameter, TextAlignment>("-fx-axis-label-alignment", (StyleConverter)new EnumConverter(TextAlignment.class)){

            public boolean isSettable(AbstractAxisParameter n) {
                return n.axisLabelTextAlignment == null || !n.axisLabelTextAlignment.isBound();
            }

            public StyleableProperty<TextAlignment> getStyleableProperty(AbstractAxisParameter n) {
                return (StyleableProperty)n.axisLabelTextAlignmentProperty();
            }
        };
        private static final CssMetaData<AbstractAxisParameter, String> AXIS_LABEL = new CssMetaData<AbstractAxisParameter, String>("-fx-axis-label", com.sun.javafx.css.converters.StringConverter.getInstance()){

            public boolean isSettable(AbstractAxisParameter n) {
                return n.label == null || !n.label.isBound();
            }

            public StyleableProperty<String> getStyleableProperty(AbstractAxisParameter n) {
                return (StyleableProperty)n.labelProperty();
            }
        };
        private static final CssMetaData<AbstractAxisParameter, Number> CENTER_AXIS_POSITION = new CssMetaData<AbstractAxisParameter, Number>("-fx-centre-axis-position", SizeConverter.getInstance(), (Number)0.5){

            public boolean isSettable(AbstractAxisParameter n) {
                return n.centerAxisPosition == null || !n.centerAxisPosition.isBound();
            }

            public StyleableProperty<Number> getStyleableProperty(AbstractAxisParameter n) {
                return (StyleableProperty)n.centerAxisPositionProperty();
            }
        };
        private static final CssMetaData<AbstractAxisParameter, Number> AXIS_PADDING = new CssMetaData<AbstractAxisParameter, Number>("-fx-axis-padding", SizeConverter.getInstance(), (Number)15.0){

            public boolean isSettable(AbstractAxisParameter n) {
                return n.axisPadding == null || !n.axisPadding.isBound();
            }

            public StyleableProperty<Number> getStyleableProperty(AbstractAxisParameter n) {
                return (StyleableProperty)n.axisPaddingProperty();
            }
        };
        private static final CssMetaData<AbstractAxisParameter, Number> TICK_LENGTH = new CssMetaData<AbstractAxisParameter, Number>("-fx-tick-length", SizeConverter.getInstance(), (Number)8.0){

            public boolean isSettable(AbstractAxisParameter n) {
                return n.tickLength == null || !n.tickLength.isBound();
            }

            public StyleableProperty<Number> getStyleableProperty(AbstractAxisParameter n) {
                return (StyleableProperty)n.tickLengthProperty();
            }
        };
        private static final CssMetaData<AbstractAxisParameter, Font> TICK_LABEL_FONT = new FontCssMetaData<AbstractAxisParameter>("-fx-tick-label-font", Font.font((String)"system", (double)8.0)){

            public boolean isSettable(AbstractAxisParameter n) {
                return n.tickLabelFont == null || !n.tickLabelFont.isBound();
            }

            public StyleableProperty<Font> getStyleableProperty(AbstractAxisParameter n) {
                return (StyleableProperty)n.tickLabelFontProperty();
            }
        };
        private static final CssMetaData<AbstractAxisParameter, Paint> TICK_LABEL_FILL = new CssMetaData<AbstractAxisParameter, Paint>("-fx-tick-label-fill", PaintConverter.getInstance(), (Paint)Color.BLACK){

            public boolean isSettable(AbstractAxisParameter n) {
                return n.tickLabelFill == null | !n.tickLabelFill.isBound();
            }

            public StyleableProperty<Paint> getStyleableProperty(AbstractAxisParameter n) {
                return (StyleableProperty)n.tickLabelFillProperty();
            }
        };
        private static final CssMetaData<AbstractAxisParameter, Number> TICK_LABEL_TICK_GAP = new CssMetaData<AbstractAxisParameter, Number>("-fx-tick-label-gap", SizeConverter.getInstance(), (Number)3.0){

            public boolean isSettable(AbstractAxisParameter n) {
                return n.tickLabelGap == null || !n.tickLabelGap.isBound();
            }

            public StyleableProperty<Number> getStyleableProperty(AbstractAxisParameter n) {
                return (StyleableProperty)n.tickLabelGapProperty();
            }
        };
        private static final CssMetaData<AbstractAxisParameter, Number> AXIS_LABEL_TICK_GAP = new CssMetaData<AbstractAxisParameter, Number>("-fx-axis-label-gap", SizeConverter.getInstance(), (Number)3.0){

            public boolean isSettable(AbstractAxisParameter n) {
                return n.tickLabelGap == null || !n.tickLabelGap.isBound();
            }

            public StyleableProperty<Number> getStyleableProperty(AbstractAxisParameter n) {
                return (StyleableProperty)n.tickLabelGapProperty();
            }
        };
        private static final CssMetaData<AbstractAxisParameter, Number> ANIMATION_DURATION = new CssMetaData<AbstractAxisParameter, Number>("-fx-axis-animation-duration", SizeConverter.getInstance(), (Number)250){

            public boolean isSettable(AbstractAxisParameter n) {
                return n.animationDuration == null || !n.animationDuration.isBound();
            }

            public StyleableProperty<Number> getStyleableProperty(AbstractAxisParameter n) {
                return (StyleableProperty)n.animationDurationProperty();
            }
        };
        private static final CssMetaData<AbstractAxisParameter, Boolean> TICK_MARK_VISIBLE = new CssMetaData<AbstractAxisParameter, Boolean>("-fx-tick-mark-visible", BooleanConverter.getInstance(), Boolean.TRUE){

            public boolean isSettable(AbstractAxisParameter n) {
                return n.tickMarkVisible == null || !n.tickMarkVisible.isBound();
            }

            public StyleableProperty<Boolean> getStyleableProperty(AbstractAxisParameter n) {
                return (StyleableProperty)n.tickMarkVisibleProperty();
            }
        };
        private static final CssMetaData<AbstractAxisParameter, Boolean> TICK_LABELS_VISIBLE = new CssMetaData<AbstractAxisParameter, Boolean>("-fx-tick-labels-visible", BooleanConverter.getInstance(), Boolean.TRUE){

            public boolean isSettable(AbstractAxisParameter n) {
                return n.tickLabelsVisible == null || !n.tickLabelsVisible.isBound();
            }

            public StyleableProperty<Boolean> getStyleableProperty(AbstractAxisParameter n) {
                return (StyleableProperty)n.tickLabelsVisibleProperty();
            }
        };
        private static final CssMetaData<DefaultNumericAxis, Number> TICK_UNIT = new CssMetaData<DefaultNumericAxis, Number>("-fx-tick-unit", SizeConverter.getInstance(), (Number)5.0){

            public boolean isSettable(DefaultNumericAxis axis) {
                return axis.tickUnit == null || !axis.tickUnit.isBound();
            }

            public StyleableProperty<Number> getStyleableProperty(DefaultNumericAxis axis) {
                return (StyleableProperty)axis.tickUnitProperty();
            }
        };
        private static final CssMetaData<DefaultNumericAxis, Number> TICK_LABEL_ROTATION = new CssMetaData<DefaultNumericAxis, Number>("-fx-tick-rotation", SizeConverter.getInstance(), (Number)0.0){

            public boolean isSettable(DefaultNumericAxis axis) {
                return axis.tickLabelRotation == null || !axis.tickLabelRotation.isBound();
            }

            public StyleableProperty<Number> getStyleableProperty(DefaultNumericAxis axis) {
                return (StyleableProperty)axis.tickLabelRotationProperty();
            }
        };
        private static final CssMetaData<AbstractAxisParameter, Number> MINOR_TICK_LENGTH = new CssMetaData<AbstractAxisParameter, Number>("-fx-minor-tick-length", SizeConverter.getInstance(), (Number)5.0){

            public boolean isSettable(AbstractAxisParameter n) {
                return n.minorTickLength == null || !n.minorTickLength.isBound();
            }

            public StyleableProperty<Number> getStyleableProperty(AbstractAxisParameter n) {
                return (StyleableProperty)n.minorTickLengthProperty();
            }
        };
        private static final CssMetaData<AbstractAxisParameter, Number> MINOR_TICK_COUNT = new CssMetaData<AbstractAxisParameter, Number>("-fx-minor-tick-count", SizeConverter.getInstance(), (Number)5){

            public boolean isSettable(AbstractAxisParameter n) {
                return n.minorTickCount == null || !n.minorTickCount.isBound();
            }

            public StyleableProperty<Number> getStyleableProperty(AbstractAxisParameter n) {
                return (StyleableProperty)n.minorTickCountProperty();
            }
        };
        private static final CssMetaData<AbstractAxisParameter, Boolean> MINOR_TICK_VISIBLE = new CssMetaData<AbstractAxisParameter, Boolean>("-fx-minor-tick-visible", BooleanConverter.getInstance(), Boolean.TRUE){

            public boolean isSettable(AbstractAxisParameter n) {
                return n.minorTickVisible == null || !n.minorTickVisible.isBound();
            }

            public StyleableProperty<Boolean> getStyleableProperty(AbstractAxisParameter n) {
                return (StyleableProperty)n.minorTickVisibleProperty();
            }
        };
        private static final CssMetaData<AbstractAxisParameter, Boolean> AUTO_RANGING = new CssMetaData<AbstractAxisParameter, Boolean>("-fx-auto-ranging", BooleanConverter.getInstance(), Boolean.TRUE){

            public boolean isSettable(AbstractAxisParameter n) {
                return n.autoRanging == null || !n.autoRanging.isBound();
            }

            public StyleableProperty<Boolean> getStyleableProperty(AbstractAxisParameter n) {
                return (StyleableProperty)n.autoRangingProperty();
            }
        };
        private static final CssMetaData<AbstractAxisParameter, Boolean> AUTO_GROW_RANGING = new CssMetaData<AbstractAxisParameter, Boolean>("-fx-auto-grow-ranging", BooleanConverter.getInstance(), Boolean.FALSE){

            public boolean isSettable(AbstractAxisParameter n) {
                return n.autoGrowRanging == null || !n.autoGrowRanging.isBound();
            }

            public StyleableProperty<Boolean> getStyleableProperty(AbstractAxisParameter n) {
                return (StyleableProperty)n.autoGrowRangingProperty();
            }
        };
        private static final CssMetaData<AbstractAxisParameter, Boolean> AUTO_RANGE_ROUNDING = new CssMetaData<AbstractAxisParameter, Boolean>("-fx-auto-range-rounding", BooleanConverter.getInstance(), Boolean.FALSE){

            public boolean isSettable(AbstractAxisParameter n) {
                return n.autoRangeRounding == null || !n.autoRangeRounding.isBound();
            }

            public StyleableProperty<Boolean> getStyleableProperty(AbstractAxisParameter n) {
                return (StyleableProperty)n.autoRangeRoundingProperty();
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

        private StyleableProperties() {
        }

        static /* synthetic */ CssMetaData access$800() {
            return CENTER_AXIS_POSITION;
        }

        static /* synthetic */ CssMetaData access$900() {
            return AXIS_LABEL_ALIGNMENT;
        }

        static /* synthetic */ CssMetaData access$1000() {
            return AXIS_LABEL;
        }

        static /* synthetic */ CssMetaData access$1100() {
            return TICK_MARK_VISIBLE;
        }

        static /* synthetic */ CssMetaData access$1200() {
            return TICK_LABELS_VISIBLE;
        }

        static /* synthetic */ CssMetaData access$1300() {
            return AXIS_PADDING;
        }

        static /* synthetic */ CssMetaData access$1400() {
            return TICK_LENGTH;
        }

        static /* synthetic */ CssMetaData access$1500() {
            return AUTO_RANGING;
        }

        static /* synthetic */ CssMetaData access$1600() {
            return TICK_LABEL_FONT;
        }

        static /* synthetic */ CssMetaData access$1700() {
            return TICK_LABEL_FILL;
        }

        static /* synthetic */ CssMetaData access$1800() {
            return TICK_LABEL_TICK_GAP;
        }

        static /* synthetic */ CssMetaData access$1900() {
            return AXIS_LABEL_TICK_GAP;
        }

        static /* synthetic */ CssMetaData access$2000() {
            return ANIMATION_DURATION;
        }

        static /* synthetic */ CssMetaData access$2100() {
            return TICK_LABEL_ROTATION;
        }

        static /* synthetic */ CssMetaData access$2200() {
            return MINOR_TICK_VISIBLE;
        }

        static /* synthetic */ CssMetaData access$2300() {
            return MINOR_TICK_LENGTH;
        }

        static /* synthetic */ CssMetaData access$2400() {
            return MINOR_TICK_COUNT;
        }

        static /* synthetic */ CssMetaData access$2500() {
            return AUTO_GROW_RANGING;
        }

        static /* synthetic */ CssMetaData access$2600() {
            return AUTO_RANGE_ROUNDING;
        }

        static /* synthetic */ CssMetaData access$2700() {
            return TICK_UNIT;
        }

        static {
            ArrayList<Object> styleables = new ArrayList<Object>(Region.getClassCssMetaData());
            styleables.add(SIDE);
            styleables.add(CENTER_AXIS_POSITION);
            styleables.add(AXIS_PADDING);
            styleables.add(AXIS_LABEL_TICK_GAP);
            styleables.add(AXIS_LABEL_ALIGNMENT);
            styleables.add(AXIS_LABEL);
            styleables.add(ANIMATION_DURATION);
            styleables.add(TICK_LENGTH);
            styleables.add(TICK_LABEL_FONT);
            styleables.add(TICK_LABEL_FILL);
            styleables.add(TICK_LABEL_TICK_GAP);
            styleables.add(TICK_MARK_VISIBLE);
            styleables.add(TICK_LABELS_VISIBLE);
            styleables.add(TICK_LABEL_ROTATION);
            styleables.add(TICK_UNIT);
            styleables.add(MINOR_TICK_COUNT);
            styleables.add(MINOR_TICK_LENGTH);
            styleables.add(MINOR_TICK_VISIBLE);
            styleables.add(AUTO_RANGING);
            styleables.add(AUTO_GROW_RANGING);
            styleables.add(AUTO_RANGE_ROUNDING);
            STYLEABLES = Collections.unmodifiableList(styleables);
        }
    }
}

