/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.axes.spi;

import de.gsi.chart.axes.Axis;
import de.gsi.chart.axes.AxisLabelFormatter;
import de.gsi.chart.axes.AxisLabelOverlapPolicy;
import de.gsi.chart.axes.spi.AbstractAxisParameter;
import de.gsi.chart.axes.spi.AxisRange;
import de.gsi.chart.axes.spi.TickMark;
import de.gsi.chart.axes.spi.format.DefaultFormatter;
import de.gsi.chart.axes.spi.format.DefaultLogFormatter;
import de.gsi.chart.axes.spi.format.DefaultTimeFormatter;
import de.gsi.chart.ui.ResizableCanvas;
import de.gsi.chart.ui.geometry.Side;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.WeakHashMap;
import java.util.concurrent.locks.ReentrantLock;
import javafx.animation.FadeTransition;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.WritableValue;
import javafx.collections.ObservableList;
import javafx.geometry.Dimension2D;
import javafx.geometry.VPos;
import javafx.scene.CacheHint;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.scene.shape.Path;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;
import javafx.util.Duration;
import javafx.util.StringConverter;

public abstract class AbstractAxis
extends AbstractAxisParameter
implements Axis {
    protected static final int RANGE_ANIMATION_DURATION_MS = 700;
    protected WeakHashMap<Number, Dimension2D> tickMarkSizeCache = new WeakHashMap();
    protected final Timeline animator = new Timeline();
    private final Canvas canvas = new ResizableCanvas();
    protected boolean labelOverlap = false;
    protected double cachedOffset;
    protected final List<InvalidationListener> listeners = new LinkedList<InvalidationListener>();
    protected final ReentrantLock lock = new ReentrantLock();
    protected boolean autoNotification = true;
    protected double maxLabelHeight;
    protected double maxLabelWidth;
    protected final DoubleProperty currentLowerBound = new SimpleDoubleProperty((Object)this, "currentLowerBound");
    private final ObjectProperty<AxisLabelFormatter> axisFormatter = new SimpleObjectProperty<AxisLabelFormatter>((Object)this, "axisLabelFormatter", null){
        private final AxisLabelFormatter defaultFormatter;
        private final AxisLabelFormatter defaultLogFormatter;
        private final AxisLabelFormatter defaultTimeFormatter;
        private final AxisLabelFormatter defaultLogTimeFormatter;
        {
            this.defaultFormatter = new DefaultFormatter(AbstractAxis.this);
            this.defaultLogFormatter = new DefaultLogFormatter(AbstractAxis.this);
            this.defaultTimeFormatter = new DefaultTimeFormatter(AbstractAxis.this);
            this.defaultLogTimeFormatter = new DefaultTimeFormatter(AbstractAxis.this);
        }

        public AxisLabelFormatter get() {
            AxisLabelFormatter superImpl = (AxisLabelFormatter)super.get();
            if (superImpl != null) {
                return superImpl;
            }
            if (AbstractAxis.this.isTimeAxis()) {
                if (AbstractAxis.this.isLogAxis()) {
                    return this.defaultLogTimeFormatter;
                }
                return this.defaultTimeFormatter;
            }
            if (AbstractAxis.this.isLogAxis()) {
                return this.defaultLogFormatter;
            }
            return this.defaultFormatter;
        }

        protected void invalidated() {
            AbstractAxis.this.requestAxisLayout();
        }
    };
    protected WeakHashMap<String, TickMark> tickMarkStringCache = new WeakHashMap();
    protected WeakHashMap<Double, TickMark> tickMarkDoubleCache = new WeakHashMap();

    private static double snap(double coordinate) {
        return (double)Math.round(coordinate) + 0.5;
    }

    public AxisLabelFormatter getAxisLabelFormatter() {
        return (AxisLabelFormatter)this.axisFormatter.get();
    }

    public void setAxisLabelFormatter(AxisLabelFormatter value) {
        this.axisFormatter.set((Object)value);
    }

    public ObjectProperty<AxisLabelFormatter> axisLabelFormatterProperty() {
        return this.axisFormatter;
    }

    public AbstractAxis() {
        this.setMouseTransparent(false);
        this.setPickOnBounds(true);
        this.canvas.setMouseTransparent(false);
        this.canvas.toFront();
        if (!this.canvas.isCache()) {
            this.canvas.setCache(true);
            this.canvas.setCacheHint(CacheHint.QUALITY);
        }
        this.getChildren().add((Object)this.canvas);
        ChangeListener axisSizeChangeListener = (c, o, n) -> {
            if (o == n) {
                return;
            }
            double padding = this.getAxisPadding();
            if (this.getSide().isHorizontal()) {
                this.canvas.resize(this.getWidth() + 2.0 * padding, this.getHeight());
                this.canvas.setLayoutX(-padding);
            } else {
                this.canvas.resize(this.getWidth() + 2.0 * padding, this.getHeight() + 2.0 * padding);
                this.canvas.setLayoutY(-padding);
            }
        };
        this.axisPaddingProperty().addListener((ch, o, n) -> {
            if (o == n) {
                return;
            }
            double padding = this.getAxisPadding();
            if (this.getSide().isHorizontal()) {
                this.canvas.resize(this.getWidth() + 2.0 * padding, this.getHeight());
                this.canvas.setLayoutX(-padding);
            } else {
                this.canvas.resize(this.getWidth() + 2.0 * padding, this.getHeight() + 2.0 * padding);
                this.canvas.setLayoutY(-padding);
            }
        });
        this.widthProperty().addListener(axisSizeChangeListener);
        this.heightProperty().addListener(axisSizeChangeListener);
        VBox.setVgrow((Node)this, (Priority)Priority.ALWAYS);
        HBox.setHgrow((Node)this, (Priority)Priority.ALWAYS);
    }

    public AbstractAxis(double lowerBound, double upperBound) {
        this();
        this.setLowerBound(lowerBound);
        this.setUpperBound(upperBound);
        this.setAutoRanging(false);
    }

    protected abstract AxisRange computeRange(double var1, double var3, double var5, double var7);

    protected AxisRange autoRange(double minValue, double maxValue, double length, double labelSize) {
        return this.computeRange(minValue, maxValue, length, 2.0 * labelSize);
    }

    protected AxisRange autoRange(double length) {
        if (this.isAutoRanging() || this.isAutoGrowRanging()) {
            double labelSize = this.getTickLabelFont().getSize() * 2.0;
            AxisRange retVal = this.autoRange(this.autoRange.getMin(), this.autoRange.getMax(), length, labelSize);
            return retVal;
        }
        return this.getAxisRange();
    }

    protected double calculateNewScale(double length, double lowerBound, double upperBound) {
        double newScale = 1.0;
        Side side = this.getSide();
        double diff = upperBound - lowerBound;
        if (side.isVertical()) {
            this.cachedOffset = length;
            newScale = diff == 0.0 ? -length : -(length / diff);
        } else {
            this.cachedOffset = 0.0;
            newScale = upperBound - lowerBound == 0.0 ? length : length / diff;
        }
        return newScale != 0.0 ? newScale : -1.0;
    }

    protected abstract List<Double> calculateMinorTickValues();

    public TickMark getNewTickMark(Double tickValue, Double tickPosition, String tickMarkLabel) {
        TickMark tick;
        if (tickMarkLabel.isEmpty()) {
            tick = this.tickMarkDoubleCache.computeIfAbsent(tickValue, k -> new TickMark(tickValue, tickPosition, ""));
        } else {
            tick = this.tickMarkStringCache.computeIfAbsent(tickMarkLabel, k -> new TickMark(tickValue, tickPosition, (String)k));
            tick.setValue(tickValue);
        }
        tick.setPosition(tickPosition);
        tick.setFont(this.getTickLabelFont());
        tick.setFill(this.getTickLabelFill());
        tick.setRotate(this.getTickLabelRotation());
        tick.setVisible(this.isTickLabelsVisible());
        tick.applyCss();
        return tick;
    }

    protected List<TickMark> computeTickMarks(AxisRange range, boolean majorTickMark) {
        List<Double> newTickValues;
        LinkedList<TickMark> newTickMarkList = new LinkedList<TickMark>();
        Side side = this.getSide();
        if (side == null) {
            return newTickMarkList;
        }
        double width = this.getWidth();
        double height = this.getHeight();
        double axisLength = side.isVertical() ? height : width;
        List<Double> list = newTickValues = majorTickMark ? this.calculateMajorTickValues(axisLength, range) : this.calculateMinorTickValues();
        if (majorTickMark) {
            this.getAxisLabelFormatter().updateFormatter(newTickValues, this.getUnitScaling());
        }
        if (majorTickMark) {
            this.maxLabelHeight = 0.0;
            this.maxLabelWidth = 0.0;
        }
        newTickValues.forEach(newValue -> {
            double tickPosition = this.getDisplayPosition((double)newValue);
            TickMark tick = this.getNewTickMark((Double)newValue, tickPosition, majorTickMark ? this.getTickMarkLabel((double)newValue) : "");
            if (majorTickMark && this.shouldAnimate()) {
                tick.setOpacity(0.0);
            }
            this.maxLabelHeight = Math.max(this.maxLabelHeight, tick.getHeight());
            this.maxLabelWidth = Math.max(this.maxLabelWidth, tick.getWidth());
            newTickMarkList.add(tick);
            if (majorTickMark && this.shouldAnimate()) {
                FadeTransition ft = new FadeTransition(Duration.millis((double)750.0), (Node)tick);
                tick.opacityProperty().addListener((ch, o, n) -> {
                    this.clearAxisCanvas(this.canvas.getGraphicsContext2D(), width, height);
                    this.drawAxis(this.canvas.getGraphicsContext2D(), width, height);
                });
                ft.setFromValue(0.0);
                ft.setToValue(1.0);
                ft.play();
            }
        });
        return newTickMarkList;
    }

    public void recomputeTickMarks() {
        this.recomputeTickMarks(this.getRange());
    }

    protected void recomputeTickMarks(AxisRange range) {
        Side side = this.getSide();
        if (side == null) {
            return;
        }
        this.majorTickMarks.setAll(this.computeTickMarks(range, true));
        this.minorTickMarkValues.setAll(this.computeTickMarks(range, false));
        this.tickMarksUpdated();
    }

    @Override
    public void drawAxis(GraphicsContext gc, double axisWidth, double axisHeight) {
        if (gc == null || this.getSide() == null) {
            return;
        }
        this.drawAxisPre();
        this.majorTickStyle.applyCss();
        this.minorTickStyle.applyCss();
        this.axisLabel.applyCss();
        double axisLength = this.getSide().isHorizontal() ? axisWidth : axisHeight;
        this.drawAxisLine(gc, axisLength, axisWidth, axisHeight);
        if (!this.isTickMarkVisible()) {
            this.drawAxisLabel(gc, axisLength, axisWidth, axisHeight, this.getAxisLabel(), null, this.getTickLength());
            this.drawAxisPost();
            return;
        }
        ObservableList<TickMark> majorTicks = this.getTickMarks();
        ObservableList<TickMark> minorTicks = this.getMinorTickMarks();
        double neededLength = (this.getTickMarks().size() + minorTicks.size()) * 2;
        if (this.isMinorTickVisible() && axisLength > neededLength) {
            this.drawTickMarks(gc, axisLength, axisWidth, axisHeight, minorTicks, this.getMinorTickLength(), this.getMinorTickStyle());
            this.drawTickLabels(gc, axisWidth, axisHeight, minorTicks, this.getMinorTickLength());
        }
        this.drawTickMarks(gc, axisLength, axisWidth, axisHeight, majorTicks, this.getTickLength(), this.getMajorTickStyle());
        this.drawTickLabels(gc, axisWidth, axisHeight, majorTicks, this.getTickLength());
        this.drawAxisLabel(gc, axisLength, axisWidth, axisHeight, this.getAxisLabel(), majorTicks, this.getTickLength());
        this.drawAxisPost();
    }

    protected void drawAxisPre() {
    }

    protected void drawAxisPost() {
    }

    protected void updateCachedVariables() {
    }

    @Override
    public void forceRedraw() {
        this.layoutChildren();
    }

    protected void layoutChildren() {
        boolean lengthDiffers;
        double axisLength;
        Side side = this.getSide();
        if (side == null) {
            return;
        }
        double width = this.getWidth();
        double height = this.getHeight();
        double d = axisLength = side.isVertical() ? height : width;
        if (!this.isAutoRanging()) {
            this.setScale(this.calculateNewScale(axisLength, this.getLowerBound(), this.getUpperBound()));
            this.currentLowerBound.set(this.getLowerBound());
        }
        boolean recomputedTicks = false;
        boolean isFirstPass = this.oldAxisLength == -1.0;
        boolean rangeInvalid = !this.isRangeValid();
        boolean bl = lengthDiffers = this.oldAxisLength != axisLength;
        if (lengthDiffers || rangeInvalid || super.isNeedsLayout()) {
            AxisRange newAxisRange;
            if (this.isAutoRanging()) {
                newAxisRange = this.autoRange(axisLength);
                this.setRange(newAxisRange, this.getAnimated() && !isFirstPass && this.impl_isTreeVisible() && rangeInvalid);
            } else {
                newAxisRange = this.getAxisRange();
            }
            this.recomputeTickMarks(newAxisRange);
            this.oldAxisLength = axisLength;
            this.rangeValid = true;
            this.updateCachedVariables();
            recomputedTicks = true;
        }
        if (lengthDiffers || rangeInvalid || this.measureInvalid || this.tickLabelsVisibleInvalid) {
            boolean isShiftOverlapPolicy;
            this.measureInvalid = false;
            this.tickLabelsVisibleInvalid = false;
            int numLabelsToSkip = 0;
            double totalLabelsSize = 0.0;
            double maxLabelSize = 0.0;
            for (TickMark m : this.majorTickMarks) {
                m.setPosition(this.getDisplayPosition(m.getValue()));
                if (!m.isVisible()) continue;
                double tickSize = side.isHorizontal() ? m.getWidth() : m.getHeight();
                totalLabelsSize += tickSize;
                maxLabelSize = Math.round(Math.max(maxLabelSize, tickSize));
            }
            this.labelOverlap = false;
            if (maxLabelSize > 0.0 && axisLength < totalLabelsSize) {
                numLabelsToSkip = (int)((double)this.majorTickMarks.size() * maxLabelSize / axisLength) + 1;
                this.labelOverlap = true;
            }
            boolean bl2 = isShiftOverlapPolicy = this.getOverlapPolicy() == AxisLabelOverlapPolicy.SHIFT_ALT || this.getOverlapPolicy() == AxisLabelOverlapPolicy.FORCED_SHIFT_ALT;
            if (numLabelsToSkip > 0 && !isShiftOverlapPolicy) {
                int tickIndex = 0;
                for (TickMark m : this.majorTickMarks) {
                    if (!m.isVisible()) continue;
                    m.setVisible(tickIndex++ % numLabelsToSkip == 0);
                }
            }
            if (this.majorTickMarks.size() > 2) {
                TickMark m2;
                TickMark m1 = (TickMark)((Object)this.majorTickMarks.get(0));
                if (this.isTickLabelsOverlap(side, m1, m2 = (TickMark)((Object)this.majorTickMarks.get(1)), this.getTickLabelGap())) {
                    this.labelOverlap = true;
                }
                if (this.isTickLabelsOverlap(side, m1 = (TickMark)((Object)this.majorTickMarks.get(this.majorTickMarks.size() - 2)), m2 = (TickMark)((Object)this.majorTickMarks.get(this.majorTickMarks.size() - 1)), this.getTickLabelGap())) {
                    this.labelOverlap = true;
                }
            }
        }
        if (recomputedTicks) {
            GraphicsContext gc = this.canvas.getGraphicsContext2D();
            this.clearAxisCanvas(gc, this.canvas.getWidth(), this.canvas.getHeight());
            double axisWidth = this.getWidth();
            double axisHeight = this.getHeight();
            this.drawAxis(gc, axisWidth, axisHeight);
            this.fireInvalidated();
        }
    }

    @Override
    public void invalidateRange(List<Number> data) {
        double dataMinValue;
        double dataMaxValue;
        if (data.isEmpty()) {
            dataMaxValue = this.getUpperBound();
            dataMinValue = this.getLowerBound();
            this.autoRange.set(this.getLowerBound(), this.getUpperBound());
        } else {
            dataMinValue = Double.MAX_VALUE;
            dataMaxValue = -1.7976931348623157E308;
            this.autoRange.empty();
        }
        for (Number dataValue : data) {
            dataMinValue = Math.min(dataMinValue, dataValue.doubleValue());
            dataMaxValue = Math.max(dataMaxValue, dataValue.doubleValue());
            this.autoRange.add(dataValue.doubleValue());
        }
        boolean change = false;
        if (this.getLowerBound() != dataMinValue) {
            this.setLowerBound(dataMinValue);
            change = true;
        }
        if (this.getUpperBound() != dataMaxValue) {
            this.setUpperBound(dataMaxValue);
            change = true;
        }
        if (change) {
            data.clear();
            this.autoRange.setAxisLength(this.getLength() == 0.0 ? 1.0 : this.getLength(), this.getSide());
        }
        this.invalidateRange();
        this.requestAxisLayout();
    }

    @Override
    public boolean isValueOnAxis(double value) {
        return Double.isFinite(value) && value >= this.getLowerBound() && value <= this.getUpperBound();
    }

    public Canvas getCanvas() {
        return this.canvas;
    }

    public boolean isLabelOverlapping() {
        return this.labelOverlap;
    }

    public GraphicsContext getGraphicsContext() {
        return this.canvas.getGraphicsContext2D();
    }

    protected boolean isRangeValid() {
        return this.rangeValid;
    }

    @Override
    protected void invalidateRange() {
        this.rangeValid = false;
    }

    protected boolean shouldAnimate() {
        return this.getAnimated() && this.impl_isTreeVisible() && this.getScene() != null;
    }

    @Override
    public void requestAxisLayout() {
        super.requestLayout();
    }

    protected abstract List<Double> calculateMajorTickValues(double var1, AxisRange var3);

    protected double computePrefHeight(double width) {
        Side side = this.getSide();
        if (side == null || side == Side.CENTER_HOR || side.isVertical()) {
            return 150.0;
        }
        if (this.getTickMarks().isEmpty()) {
            AxisRange range = this.autoRange(width);
            this.computeTickMarks(range, true);
            this.computeTickMarks(range, false);
        }
        double maxLabelHeightLocal = this.isTickLabelsVisible() ? this.maxLabelHeight : 0.0;
        double tickMarkLength = this.isTickMarkVisible() && this.getTickLength() > 0.0 ? this.getTickLength() : 0.0;
        double labelHeight = this.axisLabel.getText() == null || this.axisLabel.getText().isEmpty() ? 0.0 : this.axisLabel.prefHeight(-1.0) + 2.0 * this.getAxisLabelGap();
        double shiftedLabels = this.getOverlapPolicy() == AxisLabelOverlapPolicy.SHIFT_ALT && this.isLabelOverlapping() || this.getOverlapPolicy() == AxisLabelOverlapPolicy.FORCED_SHIFT_ALT ? labelHeight : 0.0;
        return tickMarkLength + maxLabelHeightLocal + labelHeight + shiftedLabels;
    }

    protected double computePrefWidth(double height) {
        Side side = this.getSide();
        if (side == null || side == Side.CENTER_VER || side.isHorizontal()) {
            return 150.0;
        }
        if (this.getTickMarks().isEmpty()) {
            AxisRange range = this.autoRange(height);
            this.computeTickMarks(range, true);
            this.computeTickMarks(range, false);
        }
        double maxLabelWidthLocal = this.isTickLabelsVisible() ? this.maxLabelWidth : 0.0;
        double tickMarkLength = this.isTickMarkVisible() && this.getTickLength() > 0.0 ? this.getTickLength() : 0.0;
        double labelHeight = this.axisLabel.getText() == null || this.axisLabel.getText().isEmpty() ? 0.0 : this.axisLabel.prefHeight(-1.0) + 2.0 * this.getAxisLabelGap();
        double shiftedLabels = this.getOverlapPolicy() == AxisLabelOverlapPolicy.SHIFT_ALT && this.isLabelOverlapping() || this.getOverlapPolicy() == AxisLabelOverlapPolicy.FORCED_SHIFT_ALT ? labelHeight : 0.0;
        return maxLabelWidthLocal + tickMarkLength + labelHeight + shiftedLabels;
    }

    protected void tickMarksUpdated() {
    }

    protected AxisRange getAxisRange() {
        return new AxisRange(this.getLowerBound(), this.getUpperBound(), this.getLength(), this.getScale(), this.getTickUnit());
    }

    protected void setRange(AxisRange rangeObj, boolean animate) {
        if (!(rangeObj instanceof AxisRange)) {
            return;
        }
        AxisRange range = rangeObj;
        double oldLowerBound = this.getLowerBound();
        if (this.getLowerBound() != range.getLowerBound()) {
            this.setLowerBound(range.getLowerBound());
        }
        if (this.getUpperBound() != range.getUpperBound()) {
            this.setUpperBound(range.getUpperBound());
        }
        if (animate) {
            this.animator.stop();
            this.animator.getKeyFrames().setAll((Object[])new KeyFrame[]{new KeyFrame(Duration.ZERO, new KeyValue[]{new KeyValue((WritableValue)this.currentLowerBound, (Object)oldLowerBound), new KeyValue((WritableValue)this.scaleBinding, (Object)this.getScale())}), new KeyFrame(Duration.millis((double)700.0), new KeyValue[]{new KeyValue((WritableValue)this.currentLowerBound, (Object)range.getLowerBound()), new KeyValue((WritableValue)this.scaleBinding, (Object)range.getScale())})});
            this.animator.play();
        } else {
            this.currentLowerBound.set(range.getLowerBound());
            this.setScale(range.getScale());
        }
    }

    protected void clearAxisCanvas(GraphicsContext gc, double width, double height) {
        gc.clearRect(0.0, 0.0, width, height);
    }

    protected void drawAxisLine(GraphicsContext gc, double axisLength, double axisWidth, double axisHeight) {
        double paddingX = this.getSide().isHorizontal() ? this.getAxisPadding() : 0.0;
        double paddingY = this.getSide().isVertical() ? this.getAxisPadding() : 0.0;
        double axisCentre = this.getCenterAxisPosition();
        Path tickStyle = this.getMajorTickStyle();
        gc.save();
        gc.setStroke(tickStyle.getStroke());
        gc.setFill(tickStyle.getFill());
        gc.setLineWidth(tickStyle.getStrokeWidth());
        gc.translate(paddingX, paddingY);
        switch (this.getSide()) {
            case LEFT: {
                gc.strokeLine(AbstractAxis.snap(axisWidth), AbstractAxis.snap(0.0), AbstractAxis.snap(axisWidth), AbstractAxis.snap(axisLength));
                break;
            }
            case RIGHT: {
                gc.strokeLine(AbstractAxis.snap(0.0), AbstractAxis.snap(0.0), AbstractAxis.snap(0.0), AbstractAxis.snap(axisLength));
                break;
            }
            case TOP: {
                gc.strokeLine(AbstractAxis.snap(0.0), AbstractAxis.snap(axisHeight), AbstractAxis.snap(axisLength), AbstractAxis.snap(axisHeight));
                break;
            }
            case BOTTOM: {
                gc.strokeLine(AbstractAxis.snap(0.0), AbstractAxis.snap(0.0), AbstractAxis.snap(axisLength), AbstractAxis.snap(0.0));
                break;
            }
            case CENTER_HOR: {
                gc.strokeLine(AbstractAxis.snap(0.0), axisCentre * axisHeight, AbstractAxis.snap(axisLength), AbstractAxis.snap(axisCentre * axisHeight));
                break;
            }
            case CENTER_VER: {
                gc.strokeLine(AbstractAxis.snap(axisCentre * axisWidth), AbstractAxis.snap(0.0), AbstractAxis.snap(axisCentre * axisWidth), AbstractAxis.snap(axisLength));
                break;
            }
        }
        gc.restore();
    }

    protected void drawTickMarks(GraphicsContext gc, double axisLength, double axisWidth, double axisHeight, ObservableList<TickMark> tickMarks, double tickLength, Path tickStyle) {
        if (tickLength <= 0.0) {
            return;
        }
        double paddingX = this.getSide().isHorizontal() ? this.getAxisPadding() : 0.0;
        double paddingY = this.getSide().isVertical() ? this.getAxisPadding() : 0.0;
        double axisCentre = this.getCenterAxisPosition();
        gc.save();
        gc.setStroke(tickStyle.getStroke());
        gc.setFill(tickStyle.getFill());
        gc.setLineWidth(tickStyle.getStrokeWidth());
        gc.translate(paddingX, paddingY);
        switch (this.getSide()) {
            case LEFT: {
                for (TickMark tickMark : tickMarks) {
                    double position = tickMark.getPosition();
                    if (position < 0.0 || position > axisLength) continue;
                    double x0 = AbstractAxis.snap(axisWidth - tickLength);
                    double x1 = AbstractAxis.snap(axisWidth);
                    double y = AbstractAxis.snap(position);
                    gc.strokeLine(x0, y, x1, y);
                }
                break;
            }
            case RIGHT: {
                for (TickMark tickMark : tickMarks) {
                    double position = tickMark.getPosition();
                    if (position < 0.0 || position > axisLength) continue;
                    double x0 = AbstractAxis.snap(0.0);
                    double x1 = AbstractAxis.snap(tickLength);
                    double y = AbstractAxis.snap(position);
                    gc.strokeLine(x0, y, x1, y);
                }
                break;
            }
            case TOP: {
                for (TickMark tickMark : tickMarks) {
                    double position = tickMark.getPosition();
                    if (position < 0.0 || position > axisLength) continue;
                    double x = AbstractAxis.snap(position);
                    double y0 = AbstractAxis.snap(axisHeight);
                    double y1 = AbstractAxis.snap(axisHeight - tickLength);
                    gc.strokeLine(x, y0, x, y1);
                }
                break;
            }
            case BOTTOM: {
                for (TickMark tickMark : tickMarks) {
                    double position = tickMark.getPosition();
                    if (position < 0.0 || position > axisLength) continue;
                    double x = AbstractAxis.snap(position);
                    double y0 = AbstractAxis.snap(0.0);
                    double y1 = AbstractAxis.snap(tickLength);
                    gc.strokeLine(x, y0, x, y1);
                }
                break;
            }
            case CENTER_HOR: {
                for (TickMark tickMark : tickMarks) {
                    double position = tickMark.getPosition();
                    if (position < 0.0 || position > axisLength) continue;
                    double x = AbstractAxis.snap(position);
                    double y0 = AbstractAxis.snap(axisCentre * axisHeight - tickLength);
                    double y1 = AbstractAxis.snap(axisCentre * axisHeight + tickLength);
                    gc.strokeLine(x, y0, x, y1);
                }
                break;
            }
            case CENTER_VER: {
                for (TickMark tickMark : tickMarks) {
                    double position = tickMark.getPosition();
                    if (position < 0.0 || position > axisLength) continue;
                    double x0 = AbstractAxis.snap(axisCentre * axisWidth - tickLength);
                    double x1 = AbstractAxis.snap(axisCentre * axisWidth + tickLength);
                    double y = AbstractAxis.snap(position);
                    gc.strokeLine(x0, y, x1, y);
                }
                break;
            }
        }
        gc.restore();
    }

    protected void drawTickMarkLabel(GraphicsContext gc, double x, double y, double rotation, TickMark tickMark) {
        gc.save();
        gc.setFont(tickMark.getFont());
        gc.setFill(tickMark.getFill());
        gc.translate(x, y);
        if (rotation != 0.0) {
            gc.rotate(tickMark.getRotate());
        }
        gc.setGlobalAlpha(tickMark.getOpacity());
        gc.fillText(tickMark.getText(), 0.0, 0.0);
        gc.restore();
    }

    protected void drawTickLabels(GraphicsContext gc, double axisWidth, double axisHeight, ObservableList<TickMark> tickMarks, double tickLength) {
        if (tickLength <= 0.0) {
            return;
        }
        double paddingX = this.getSide().isHorizontal() ? this.getAxisPadding() : 0.0;
        double paddingY = this.getSide().isVertical() ? this.getAxisPadding() : 0.0;
        double axisCentre = this.getCenterAxisPosition();
        AxisLabelOverlapPolicy overlapPolicy = this.getOverlapPolicy();
        double tickLabelGap = this.getTickLabelGap();
        double tickLabelRotation = this.getTickLabelRotation();
        int counter = 0;
        gc.save();
        gc.translate(paddingX, paddingY);
        if (!tickMarks.isEmpty()) {
            TickMark firstTick = (TickMark)((Object)tickMarks.get(0));
            gc.setFont(firstTick.getFont());
            gc.setFill(firstTick.getFill());
            gc.setGlobalAlpha(firstTick.getOpacity());
        }
        switch (this.getSide()) {
            case LEFT: {
                gc.setTextAlign(TextAlignment.RIGHT);
                gc.setTextBaseline(VPos.CENTER);
                for (TickMark tickMark : tickMarks) {
                    double position = tickMark.getPosition();
                    if (!tickMark.isVisible()) continue;
                    double x = axisWidth - tickLength - tickLabelGap;
                    double y = position;
                    this.drawTickMarkLabel(gc, x, y, tickLabelRotation, tickMark);
                }
                break;
            }
            case RIGHT: {
                gc.setTextAlign(TextAlignment.LEFT);
                gc.setTextBaseline(VPos.CENTER);
                for (TickMark tickMark : tickMarks) {
                    double position = tickMark.getPosition();
                    if (!tickMark.isVisible()) continue;
                    double x = tickLength + tickLabelGap;
                    double y = position;
                    this.drawTickMarkLabel(gc, x, y, tickLabelRotation, tickMark);
                }
                break;
            }
            case TOP: {
                if (tickLabelRotation % 360.0 == 0.0) {
                    gc.setTextAlign(TextAlignment.CENTER);
                    gc.setTextBaseline(VPos.BOTTOM);
                } else {
                    gc.setTextAlign(TextAlignment.LEFT);
                    gc.setTextBaseline(VPos.BOTTOM);
                }
                block28: for (TickMark tickMark : tickMarks) {
                    double position = tickMark.getPosition();
                    if (!tickMark.isVisible()) continue;
                    double x = position;
                    double y = axisHeight - tickLength - tickLabelGap;
                    switch (overlapPolicy) {
                        case DO_NOTHING: {
                            this.drawTickMarkLabel(gc, x, y, tickLabelRotation, tickMark);
                            continue block28;
                        }
                        case NARROW_FONT: {
                            this.drawTickMarkLabel(gc, x, y, tickLabelRotation, tickMark);
                            continue block28;
                        }
                        case SHIFT_ALT: {
                            if (this.isLabelOverlapping()) {
                                y -= (double)(counter % 2) * tickLabelGap + (double)(counter % 2) * tickMark.getFont().getSize();
                            }
                            this.drawTickMarkLabel(gc, x, y, tickLabelRotation, tickMark);
                            continue block28;
                        }
                        case FORCED_SHIFT_ALT: {
                            this.drawTickMarkLabel(gc, x, y -= (double)(counter % 2) * tickLabelGap + (double)(counter % 2) * tickMark.getFont().getSize(), tickLabelRotation, tickMark);
                            continue block28;
                        }
                    }
                    if (counter % 2 != 0 && this.isLabelOverlapping()) continue;
                    this.drawTickMarkLabel(gc, x, y, tickLabelRotation, tickMark);
                }
                break;
            }
            case BOTTOM: {
                if (tickLabelRotation % 360.0 == 0.0) {
                    gc.setTextAlign(TextAlignment.CENTER);
                    gc.setTextBaseline(VPos.TOP);
                } else {
                    gc.setTextAlign(TextAlignment.LEFT);
                    gc.setTextBaseline(VPos.TOP);
                }
                counter = 0;
                for (TickMark tickMark : tickMarks) {
                    double position = tickMark.getPosition();
                    if (!tickMark.isVisible()) continue;
                    double x = position;
                    double y = tickLength + tickLabelGap;
                    switch (overlapPolicy) {
                        case DO_NOTHING: {
                            this.drawTickMarkLabel(gc, x, y, tickLabelRotation, tickMark);
                            break;
                        }
                        case NARROW_FONT: {
                            this.drawTickMarkLabel(gc, x, y, tickLabelRotation, tickMark);
                            break;
                        }
                        case SHIFT_ALT: {
                            if (this.isLabelOverlapping()) {
                                y += (double)(counter % 2) * tickLabelGap + (double)(counter % 2) * tickMark.getFont().getSize();
                            }
                            this.drawTickMarkLabel(gc, x, y, tickLabelRotation, tickMark);
                            break;
                        }
                        case FORCED_SHIFT_ALT: {
                            this.drawTickMarkLabel(gc, x, y += (double)(counter % 2) * tickLabelGap + (double)(counter % 2) * tickMark.getFont().getSize(), tickLabelRotation, tickMark);
                            break;
                        }
                        default: {
                            if (counter % 2 != 0 && this.isLabelOverlapping()) break;
                            this.drawTickMarkLabel(gc, x, y, tickLabelRotation, tickMark);
                        }
                    }
                    ++counter;
                }
                break;
            }
            case CENTER_VER: {
                gc.setTextAlign(TextAlignment.LEFT);
                gc.setTextBaseline(VPos.CENTER);
                for (TickMark tickMark : tickMarks) {
                    double position = tickMark.getPosition();
                    if (!tickMark.isVisible()) continue;
                    double x = axisCentre * axisWidth + tickLength + tickLabelGap;
                    double y = position;
                    this.drawTickMarkLabel(gc, x, y, tickLabelRotation, tickMark);
                }
                break;
            }
            case CENTER_HOR: {
                if (tickLabelRotation % 360.0 == 0.0) {
                    gc.setTextAlign(TextAlignment.CENTER);
                    gc.setTextBaseline(VPos.TOP);
                } else {
                    gc.setTextAlign(TextAlignment.LEFT);
                    gc.setTextBaseline(VPos.TOP);
                }
                block31: for (TickMark tickMark : tickMarks) {
                    double position = tickMark.getPosition();
                    if (!tickMark.isVisible()) continue;
                    double x = position;
                    double y = axisCentre * axisHeight + tickLength + tickLabelGap;
                    switch (overlapPolicy) {
                        case DO_NOTHING: {
                            this.drawTickMarkLabel(gc, x, y, tickLabelRotation, tickMark);
                            continue block31;
                        }
                        case NARROW_FONT: {
                            this.drawTickMarkLabel(gc, x, y, tickLabelRotation, tickMark);
                            continue block31;
                        }
                        case SHIFT_ALT: {
                            if (this.isLabelOverlapping()) {
                                y += (double)(counter % 2) * tickLabelGap + (double)(counter % 2) * tickMark.getFont().getSize();
                            }
                            this.drawTickMarkLabel(gc, x, y, tickLabelRotation, tickMark);
                            continue block31;
                        }
                        case FORCED_SHIFT_ALT: {
                            this.drawTickMarkLabel(gc, x, y += (double)(counter % 2) * tickLabelGap + (double)(counter % 2) * tickMark.getFont().getSize(), tickLabelRotation, tickMark);
                            continue block31;
                        }
                    }
                    if (counter % 2 != 0 && this.isLabelOverlapping()) continue;
                    this.drawTickMarkLabel(gc, x, y, tickLabelRotation, tickMark);
                }
                break;
            }
        }
        gc.restore();
    }

    protected void drawAxisLabel(GraphicsContext gc, double x, double y, Text label) {
        gc.save();
        gc.setTextAlign(label.getTextAlignment());
        gc.setFont(label.getFont());
        gc.setFill(label.getFill());
        gc.setStroke(label.getStroke());
        gc.setLineWidth(label.getStrokeWidth());
        gc.translate(x, y);
        gc.rotate(label.getRotate());
        gc.fillText(label.getText(), 0.0, 0.0);
        gc.restore();
    }

    protected double measureTickMarkLength(double major) {
        TickMark tick = this.getNewTickMark(major, 0.0, this.getTickMarkLabel(major));
        return this.getSide().isHorizontal() ? tick.getWidth() : tick.getHeight();
    }

    public abstract double computePreferredTickUnit(double var1);

    protected double getMaxTickLabelWidth(List<TickMark> tickMarks) {
        return tickMarks == null || tickMarks.isEmpty() ? 0.0 : tickMarks.stream().mapToDouble(TickMark::getWidth).max().getAsDouble();
    }

    protected double getMaxTickLabelHeight(List<TickMark> tickMarks) {
        return tickMarks == null || tickMarks.isEmpty() ? 0.0 : tickMarks.stream().mapToDouble(TickMark::getHeight).max().getAsDouble();
    }

    protected void drawAxisLabel(GraphicsContext gc, double axisLength, double axisWidth, double axisHeight, Text axisLabel, ObservableList<TickMark> tickMarks, double tickLength) {
        double labelGap;
        double labelPosition;
        double paddingX = this.getSide().isHorizontal() ? this.getAxisPadding() : 0.0;
        double paddingY = this.getSide().isVertical() ? this.getAxisPadding() : 0.0;
        boolean isHorizontal = this.getSide().isHorizontal();
        double tickLabelGap = this.getTickLabelGap();
        double axisLabelGap = this.getAxisLabelGap();
        double axisCentre = this.getCenterAxisPosition();
        switch (axisLabel.getTextAlignment()) {
            case LEFT: {
                labelPosition = 0.0;
                labelGap = tickLabelGap;
                break;
            }
            case RIGHT: {
                labelPosition = 1.0;
                labelGap = -tickLabelGap;
                break;
            }
            default: {
                labelPosition = 0.5;
                labelGap = 0.0;
            }
        }
        double tickLabelSize = isHorizontal ? this.maxLabelHeight : this.maxLabelWidth;
        double shiftedLabels = this.getOverlapPolicy() == AxisLabelOverlapPolicy.SHIFT_ALT && this.isLabelOverlapping() || this.getOverlapPolicy() == AxisLabelOverlapPolicy.FORCED_SHIFT_ALT ? tickLabelSize + tickLabelGap : 0.0;
        gc.save();
        gc.translate(paddingX, paddingY);
        switch (this.getSide()) {
            case LEFT: {
                gc.setTextBaseline(VPos.BASELINE);
                double x = axisWidth - tickLength - 2.0 * tickLabelGap - tickLabelSize - axisLabelGap - shiftedLabels;
                double y = (1.0 - labelPosition) * axisHeight - labelGap;
                axisLabel.setRotate(-90.0);
                this.drawAxisLabel(gc, x, y, axisLabel);
                break;
            }
            case RIGHT: {
                gc.setTextBaseline(VPos.TOP);
                axisLabel.setRotate(-90.0);
                double x = tickLength + tickLabelGap + tickLabelSize + axisLabelGap + shiftedLabels;
                double y = (1.0 - labelPosition) * axisHeight - labelGap;
                this.drawAxisLabel(gc, x, y, axisLabel);
                break;
            }
            case TOP: {
                gc.setTextBaseline(VPos.BOTTOM);
                double x = labelPosition * axisWidth + labelGap;
                double y = axisHeight - tickLength - tickLabelGap - tickLabelSize - axisLabelGap - shiftedLabels;
                this.drawAxisLabel(gc, x, y, axisLabel);
                break;
            }
            case BOTTOM: {
                gc.setTextBaseline(VPos.TOP);
                double x = labelPosition * axisWidth + labelGap;
                double y = tickLength + tickLabelGap + tickLabelSize + axisLabelGap + shiftedLabels;
                this.drawAxisLabel(gc, x, y, axisLabel);
                break;
            }
            case CENTER_VER: {
                gc.setTextBaseline(VPos.TOP);
                axisLabel.setRotate(-90.0);
                double x = axisCentre * axisWidth - tickLength - tickLabelGap - tickLabelSize - axisLabelGap - shiftedLabels;
                double y = (1.0 - labelPosition) * axisHeight - labelGap;
                this.drawAxisLabel(gc, x, y, axisLabel);
                break;
            }
            case CENTER_HOR: {
                gc.setTextBaseline(VPos.TOP);
                double x = labelPosition * axisWidth + labelGap;
                double y = axisCentre * axisHeight + tickLength + tickLabelGap + tickLabelSize + axisLabelGap + shiftedLabels;
                this.drawAxisLabel(gc, x, y, axisLabel);
                break;
            }
        }
        gc.restore();
    }

    private boolean isTickLabelsOverlap(Side side, TickMark m1, TickMark m2, double gap) {
        if (!m1.isVisible() || !m2.isVisible()) {
            return false;
        }
        double m1Size = side.isHorizontal() ? m1.getWidth() : m1.getHeight();
        double m2Size = side.isHorizontal() ? m2.getWidth() : m2.getHeight();
        double m1Start = m1.getPosition() - m1Size / 2.0;
        double m1End = m1.getPosition() + m1Size / 2.0;
        double m2Start = m2.getPosition() - m2Size / 2.0;
        double m2End = m2.getPosition() + m2Size / 2.0;
        return side.isVertical() ? m1Start - m2End <= gap : m2Start - m1End <= gap;
    }

    @Override
    public String getTickMarkLabel(double value) {
        double scaledValue = value / this.getUnitScaling();
        StringConverter<Number> formatter = this.getTickLabelFormatter();
        if (formatter != null) {
            return formatter.toString((Object)scaledValue);
        }
        return this.getAxisLabelFormatter().toString(scaledValue);
    }

    public void addListener(InvalidationListener listener) {
        Objects.requireNonNull(listener, "InvalidationListener must not be null");
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeListener(InvalidationListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void setAutoNotifaction(boolean flag) {
        this.autoNotification = flag;
    }

    @Override
    public boolean isAutoNotification() {
        return this.autoNotification;
    }

    @Override
    public void fireInvalidated() {
        if (!this.autoNotification || this.listeners.isEmpty()) {
            return;
        }
        if (Platform.isFxApplicationThread()) {
            this.executeFireInvalidated();
        } else {
            Platform.runLater(this::executeFireInvalidated);
        }
    }

    protected void executeFireInvalidated() {
        for (InvalidationListener listener : new ArrayList<InvalidationListener>(this.listeners)) {
            listener.invalidated((Observable)this);
        }
    }

    @Override
    public double getDisplayPosition(double value) {
        return this.cachedOffset + (value - this.currentLowerBound.get()) * this.getScale();
    }

    @Override
    public double getZeroPosition() {
        if (0.0 < this.getLowerBound() || 0.0 > this.getUpperBound()) {
            return Double.NaN;
        }
        return this.getDisplayPosition(0.0);
    }

    @Override
    public void setLowerBound(double value) {
        if (this.isLogAxis() && (value <= 0.0 || !Double.isFinite(value))) {
            if (this.getUpperBound() > 0.0) {
                super.setLowerBound(this.getUpperBound() / 1000000.0);
            }
            return;
        }
        super.setLowerBound(value);
    }

    @Override
    public void setUpperBound(double value) {
        if (this.isLogAxis() && (value <= 0.0 || !Double.isFinite(value))) {
            if (this.getLowerBound() >= 0.0) {
                super.setUpperBound(this.getLowerBound() * 1000000.0);
            }
            return;
        }
        super.setUpperBound(value);
    }
}

