/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart;

import de.gsi.chart.Chart;
import de.gsi.chart.axes.Axis;
import de.gsi.chart.axes.spi.CategoryAxis;
import de.gsi.chart.axes.spi.DefaultNumericAxis;
import de.gsi.chart.renderer.PolarTickStep;
import de.gsi.chart.renderer.Renderer;
import de.gsi.chart.renderer.spi.ErrorDataSetRenderer;
import de.gsi.chart.renderer.spi.GridRenderer;
import de.gsi.chart.renderer.spi.LabelledMarkerRenderer;
import de.gsi.chart.ui.geometry.Side;
import de.gsi.dataset.DataSet;
import de.gsi.dataset.DataSet3D;
import de.gsi.dataset.utils.AssertUtils;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.canvas.GraphicsContext;
import javafx.util.Duration;

public class XYChart
extends Chart {
    protected static final int BURST_LIMIT_MS = 15;
    protected BooleanProperty polarPlot = new SimpleBooleanProperty((Object)this, "polarPlot", false);
    private final ObjectProperty<PolarTickStep> polarStepSize = new SimpleObjectProperty((Object)PolarTickStep.THIRTY);
    private final GridRenderer gridRenderer = new GridRenderer(this);
    private long lastCanvasUpdate = 0L;
    private boolean callCanvasUpdateLater = false;
    final ChangeListener<Side> axisSideChangeListener = this::axisSideChanged;

    public XYChart() {
        this(new DefaultNumericAxis(), new DefaultNumericAxis());
    }

    public XYChart(Axis xAxis, Axis yAxis) {
        Objects.requireNonNull(xAxis, "X axis is required");
        Objects.requireNonNull(yAxis, "Y axis is required");
        if (xAxis.getSide() == null || !xAxis.getSide().isHorizontal()) {
            xAxis.setSide(Side.BOTTOM);
        }
        if (yAxis.getSide() == null || !yAxis.getSide().isVertical()) {
            yAxis.setSide(Side.LEFT);
        }
        this.getAxes().addAll((Object[])new Axis[]{xAxis, yAxis});
        this.getRenderers().add((Object)new ErrorDataSetRenderer());
        this.setAnimated(false);
        xAxis.setAnimated(false);
        yAxis.setAnimated(false);
    }

    public final boolean isPolarPlot() {
        return this.polarPlotProperty().get();
    }

    public final XYChart setPolarPlot(boolean state) {
        this.polarPlotProperty().set(state);
        return this;
    }

    public ObjectProperty<PolarTickStep> polarStepSizeProperty() {
        return this.polarStepSize;
    }

    public void setPolarStepSize(PolarTickStep step) {
        this.polarStepSizeProperty().set((Object)step);
    }

    public PolarTickStep getPolarStepSize() {
        return (PolarTickStep)((Object)this.polarStepSizeProperty().get());
    }

    public final BooleanProperty polarPlotProperty() {
        return this.polarPlot;
    }

    public Axis getXAxis() {
        return this.getFirstAxis(Orientation.HORIZONTAL);
    }

    public Axis getYAxis() {
        return this.getFirstAxis(Orientation.VERTICAL);
    }

    @Override
    public ObservableList<DataSet> getAllDatasets() {
        if (this.getRenderers() == null) {
            return this.allDataSets;
        }
        this.allDataSets.clear();
        this.allDataSets.addAll(this.getDatasets());
        this.getRenderers().stream().filter(renderer -> !(renderer instanceof LabelledMarkerRenderer)).forEach(renderer -> this.allDataSets.addAll(renderer.getDatasets()));
        return this.allDataSets;
    }

    public ObservableList<DataSet> getAllShownDatasets() {
        ObservableList ret = FXCollections.observableArrayList();
        ret.addAll(this.getDatasets());
        this.getRenderers().stream().filter(Renderer::showInLegend).forEach(renderer -> ret.addAll(renderer.getDatasets()));
        return ret;
    }

    public final BooleanProperty verticalGridLinesVisibleProperty() {
        return this.gridRenderer.verticalGridLinesVisibleProperty();
    }

    public final boolean isVerticalGridLinesVisible() {
        return this.verticalGridLinesVisibleProperty().get();
    }

    public final void setVerticalGridLinesVisible(boolean value) {
        this.verticalGridLinesVisibleProperty().set(value);
    }

    public final BooleanProperty horizontalGridLinesVisibleProperty() {
        return this.gridRenderer.horizontalGridLinesVisibleProperty();
    }

    public GridRenderer getGridRenderer() {
        return this.gridRenderer;
    }

    public final boolean isHorizontalGridLinesVisible() {
        return this.horizontalGridLinesVisibleProperty().get();
    }

    public final void setHorizontalGridLinesVisible(boolean value) {
        this.horizontalGridLinesVisibleProperty().set(value);
    }

    private boolean isDataEmpty() {
        return this.getAllDatasets() == null || this.getAllDatasets().isEmpty();
    }

    @Override
    public void updateAxisRange() {
        if (this.isDataEmpty()) {
            return;
        }
        this.getAxes().forEach(chartAxis -> {
            List<DataSet> dataSets = this.getDataSetForAxis((Axis)chartAxis);
            this.updateNumericAxis((Axis)chartAxis, dataSets);
        });
    }

    protected List<DataSet> getDataSetForAxis(Axis axis) {
        ArrayList<DataSet> retVal = new ArrayList<DataSet>();
        if (axis == null) {
            return retVal;
        }
        retVal.addAll((Collection<DataSet>)this.getDatasets());
        this.getRenderers().forEach(renderer -> renderer.getAxes().stream().filter(axis::equals).forEach(rendererAxis -> retVal.addAll((Collection<DataSet>)renderer.getDatasets())));
        return retVal;
    }

    protected void updateNumericAxis(Axis axis, List<DataSet> dataSets) {
        if (dataSets != null && dataSets.isEmpty()) {
            return;
        }
        boolean oldFlag = axis.isAutoNotification();
        axis.setAutoNotifaction(false);
        boolean isHorizontal = axis.getSide().isHorizontal();
        Side side = axis.getSide();
        axis.getAutoRange().empty();
        dataSets.forEach(dataset -> {
            if (dataset instanceof DataSet3D && (side == Side.RIGHT || side == Side.TOP)) {
                DataSet3D mDataSet = (DataSet3D)dataset;
                axis.getAutoRange().add(mDataSet.getZRange().getMin());
                axis.getAutoRange().add(mDataSet.getZRange().getMax());
            } else {
                axis.getAutoRange().add(isHorizontal ? dataset.getXMin() : dataset.getYMin());
                axis.getAutoRange().add(isHorizontal ? dataset.getXMax() : dataset.getYMax());
            }
        });
        axis.getAutoRange().setAxisLength(axis.getLength() == 0.0 ? 1.0 : axis.getLength(), side);
        if (!axis.isAutoRanging() && !axis.isAutoGrowRanging()) {
            axis.setAutoNotifaction(oldFlag);
            return;
        }
        ArrayList<Number> dataMinMax = new ArrayList<Number>();
        dataSets.forEach(dataset -> {
            if (dataset instanceof DataSet3D && (side == Side.RIGHT || side == Side.TOP)) {
                DataSet3D mDataSet = (DataSet3D)dataset;
                dataMinMax.add(mDataSet.getZRange().getMin());
                dataMinMax.add(mDataSet.getZRange().getMax());
            } else {
                dataMinMax.add(isHorizontal ? dataset.getXMin() : dataset.getYMin());
                dataMinMax.add(isHorizontal ? dataset.getXMax() : dataset.getYMax());
            }
        });
        if (axis.isAutoGrowRanging()) {
            dataMinMax.add(axis.getLowerBound());
            dataMinMax.add(axis.getUpperBound());
        }
        if (axis.isAutoGrowRanging()) {
            double min = Double.MAX_VALUE;
            double max = -1.7976931348623157E308;
            for (Number val : dataMinMax) {
                min = Math.min(min, val.doubleValue());
                max = Math.max(max, val.doubleValue());
            }
            axis.setLowerBound(min);
            axis.setUpperBound(max);
        } else {
            axis.invalidateRange(dataMinMax);
        }
        axis.setAutoNotifaction(oldFlag);
    }

    @Override
    protected void redrawCanvas() {
        this.setAutoNotifaction(false);
        long now = System.nanoTime();
        double diffMillisSinceLastUpdate = TimeUnit.NANOSECONDS.toMillis(now - this.lastCanvasUpdate);
        if (diffMillisSinceLastUpdate < 15.0) {
            if (!this.callCanvasUpdateLater) {
                this.callCanvasUpdateLater = true;
                KeyFrame kf1 = new KeyFrame(Duration.millis((double)20.0), e -> this.requestLayout(), new KeyValue[0]);
                Timeline timeline = new Timeline(new KeyFrame[]{kf1});
                Platform.runLater(() -> ((Timeline)timeline).play());
            }
            return;
        }
        this.lastCanvasUpdate = now;
        this.callCanvasUpdateLater = false;
        GraphicsContext gc = this.canvas.getGraphicsContext2D();
        gc.clearRect(0.0, 0.0, this.canvas.getWidth(), this.canvas.getHeight());
        if (!this.gridRenderer.isDrawOnTop()) {
            this.gridRenderer.render(gc, this, 0, null);
        }
        int dataSetOffset = 0;
        for (Renderer renderer : this.getRenderers()) {
            renderer.render(gc, this, dataSetOffset, this.getDatasets());
            dataSetOffset += this.getDatasets().size() + renderer.getDatasets().size();
        }
        if (this.gridRenderer.isDrawOnTop()) {
            this.gridRenderer.render(gc, this, 0, null);
        }
        this.setAutoNotifaction(true);
    }

    protected void axisSideChanged(ObservableValue<? extends Side> change, Side oldValue, Side newValue) {
        for (Axis axis : this.axesList) {
            if (axis.getSide() == null) {
                this.removeFromAllAxesPanes(axis);
            }
            if (this.getAxesPane(axis.getSide()).getChildren().contains((Object)axis)) continue;
            this.removeFromAllAxesPanes(axis);
            this.getAxesPane(axis.getSide()).getChildren().add((Object)((Node)axis));
        }
        this.requestLayout();
    }

    @Override
    protected void axesChanged(ListChangeListener.Change<? extends Axis> change) {
        while (change.next()) {
            change.getRemoved().forEach(set -> {
                AssertUtils.notNull((String)"to be removed axis is null", (Object)set);
                set.sideProperty().removeListener(this.axisSideChangeListener);
            });
            for (Axis set2 : change.getAddedSubList()) {
                AssertUtils.notNull((String)"to be added axis is null", (Object)set2);
                if (!(set2 instanceof Axis) && !(set2 instanceof CategoryAxis)) {
                    throw new InvalidParameterException("do not know what to do with axis " + set2.getLabel() + " type " + set2.getClass().toGenericString());
                }
                Side side = set2.getSide();
                if (side == null) {
                    throw new InvalidParameterException("axis '" + set2.getLabel() + "' has 'null' as side being set");
                }
                if (!this.getAxesPane(set2.getSide()).getChildren().contains((Object)set2)) {
                    this.getAxesPane(set2.getSide()).getChildren().add((Object)((Node)set2));
                }
                set2.sideProperty().addListener(this.axisSideChangeListener);
            }
        }
        this.requestLayout();
    }
}

