/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart;

import com.sun.javafx.charts.ChartLayoutAnimator;
import com.sun.javafx.css.converters.BooleanConverter;
import com.sun.javafx.css.converters.EnumConverter;
import de.gsi.chart.axes.Axis;
import de.gsi.chart.axes.spi.DefaultNumericAxis;
import de.gsi.chart.legend.Legend;
import de.gsi.chart.legend.spi.DefaultLegend;
import de.gsi.chart.plugins.ChartPlugin;
import de.gsi.chart.renderer.Renderer;
import de.gsi.chart.renderer.spi.LabelledMarkerRenderer;
import de.gsi.chart.ui.HiddenSidesPane;
import de.gsi.chart.ui.ResizableCanvas;
import de.gsi.chart.ui.SidesPane;
import de.gsi.chart.ui.css.StylishBooleanProperty;
import de.gsi.chart.ui.css.StylishObjectProperty;
import de.gsi.chart.ui.geometry.Corner;
import de.gsi.chart.ui.geometry.Side;
import de.gsi.dataset.DataSet;
import de.gsi.dataset.event.EventListener;
import de.gsi.dataset.utils.AssertUtils;
import de.gsi.dataset.utils.ProcessingProfiler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javafx.animation.Animation;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.property.StringPropertyBase;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.css.CssMetaData;
import javafx.css.StyleConverter;
import javafx.css.Styleable;
import javafx.css.StyleableObjectProperty;
import javafx.css.StyleableProperty;
import javafx.geometry.Bounds;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.geometry.Point2D;
import javafx.geometry.Pos;
import javafx.scene.CacheHint;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.canvas.Canvas;
import javafx.scene.control.Label;
import javafx.scene.layout.Border;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.BorderStroke;
import javafx.scene.layout.BorderStrokeStyle;
import javafx.scene.layout.BorderWidths;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.RowConstraints;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.util.Duration;

public abstract class Chart
extends SidesPane
implements Observable {
    private static final String CHART_CSS = Chart.class.getResource("chart.css").toExternalForm();
    private static final int DEFAULT_TRIGGER_DISTANCE = 50;
    protected static final boolean DEBUG = false;
    protected BooleanBinding showingBinding;
    protected final BooleanProperty showingProperty = new SimpleBooleanProperty((Object)this, "showing", false);
    protected final ResizableCanvas canvas = new ResizableCanvas();
    protected final GridPane axesAndCanvasPane = new GridPane();
    protected final Map<Side, Pane> axesPane = new ConcurrentHashMap<Side, Pane>(4);
    protected final Map<Side, Pane> titleLegendPane;
    protected final Map<Corner, StackPane> axesCorner;
    protected final Map<Corner, StackPane> titleLegendCorner;
    protected final ListChangeListener<DataSet> datasetChangeListener;
    protected final ObservableList<DataSet> allDataSets;
    private final ObservableList<DataSet> datasets;
    private final ObservableList<Renderer> renderers;
    protected final HiddenSidesPane hiddenPane;
    protected final Pane plotBackground;
    protected final Pane plotForeGround;
    protected final Pane canvasForeground;
    protected final ObservableList<Axis> axesList;
    protected final ListChangeListener<Axis> axesChangeListenerLocal;
    protected final ListChangeListener<Axis> axesChangeListener;
    private final InvalidationListener axisChangeListener;
    protected boolean isAxesUpdate;
    protected final ChartLayoutAnimator animator;
    protected final Label titleLabel;
    protected final StringProperty title;
    private final ObjectProperty<Side> titleSide;
    private final ObjectProperty<Side> measurementBarSide;
    private final ObjectProperty<Legend> legend;
    private final BooleanProperty legendVisible;
    private final ObjectProperty<Side> legendSide;
    private final BooleanProperty animated;
    protected final FlowPane toolBar;
    protected Map<Side, Pane> parameterDisplayPane;
    private final ObjectProperty<Side> toolBarSide;
    private final Map<ChartPlugin, Group> pluginGroups;
    private final ObservableList<ChartPlugin> plugins;
    protected final Group pluginsArea;
    protected final ListChangeListener<ChartPlugin> pluginsChanged;
    protected boolean layoutOngoing;
    protected final EventListener dataSetDataListener;
    protected final List<InvalidationListener> listeners;
    protected BooleanProperty autoNotification;

    public boolean isShowing() {
        return this.showingProperty.get();
    }

    public ReadOnlyBooleanProperty showingProperty() {
        return this.showingProperty;
    }

    public Canvas getCanvas() {
        return this.canvas;
    }

    public GridPane getAxesAndCanvasPane() {
        return this.axesAndCanvasPane;
    }

    public Pane getAxesPane(Side side) {
        return this.axesPane.get((Object)side);
    }

    public boolean removeFromAllAxesPanes(Axis node) {
        boolean state = false;
        if (!(node instanceof Node)) {
            return state;
        }
        for (Side side : Side.values()) {
            if (!this.getAxesPane(side).getChildren().remove((Object)node)) continue;
            state = true;
        }
        return state;
    }

    public Pane getTitleLegendPane(Side side) {
        return this.titleLegendPane.get((Object)side);
    }

    public StackPane getAxesCornerPane(Corner corner) {
        return this.axesCorner.get((Object)corner);
    }

    public StackPane getTitleLegendCornerPane(Corner corner) {
        return this.titleLegendCorner.get((Object)corner);
    }

    public ObservableList<DataSet> getAllDatasets() {
        if (this.getRenderers() == null) {
            return this.allDataSets;
        }
        this.allDataSets.clear();
        this.allDataSets.addAll(this.getDatasets());
        this.getRenderers().stream().filter(renderer -> !(renderer instanceof LabelledMarkerRenderer)).forEach(renderer -> this.allDataSets.addAll(renderer.getDatasets()));
        return this.allDataSets;
    }

    public ObservableList<DataSet> getDatasets() {
        return this.datasets;
    }

    public ObservableList<Renderer> getRenderers() {
        return this.renderers;
    }

    public Pane getPlotBackground() {
        return this.plotBackground;
    }

    public Pane getPlotForeground() {
        return this.plotForeGround;
    }

    public Pane getCanvasForeground() {
        return this.canvasForeground;
    }

    public HiddenSidesPane getPlotArea() {
        return this.hiddenPane;
    }

    public ObservableList<Axis> getAxes() {
        return this.axesList;
    }

    protected abstract void axesChanged(ListChangeListener.Change<? extends Axis> var1);

    protected void axesInvalidated(Object axisObj) {
        if (!(axisObj instanceof Axis) || this.layoutOngoing || this.isAxesUpdate) {
            return;
        }
        this.isAxesUpdate = true;
        this.requestLayout();
        this.isAxesUpdate = false;
    }

    protected void axesChangedLocal(ListChangeListener.Change<? extends Axis> change) {
        while (change.next()) {
            change.getRemoved().forEach(set -> {
                AssertUtils.notNull((String)"to be removed axis is null", (Object)set);
                set.removeListener(this.axisChangeListener);
            });
            for (Axis set2 : change.getAddedSubList()) {
                AssertUtils.notNull((String)"to be added axis is null", (Object)set2);
                if (!(set2 instanceof Axis)) continue;
                set2.addListener(this.axisChangeListener);
            }
        }
        this.requestLayout();
    }

    public Axis getFirstAxis(Orientation orientation) {
        block3: for (Axis axis : this.getAxes()) {
            if (axis.getSide() == null) continue;
            switch (orientation) {
                case VERTICAL: {
                    if (!axis.getSide().isVertical()) continue block3;
                    return axis;
                }
            }
            if (!axis.getSide().isHorizontal()) continue;
            return axis;
        }
        return null;
    }

    public final String getTitle() {
        return (String)this.title.get();
    }

    public final void setTitle(String value) {
        this.title.set((Object)value);
    }

    public final StringProperty titleProperty() {
        return this.title;
    }

    public final Side getTitleSide() {
        return (Side)((Object)this.titleSide.get());
    }

    public final void setTitleSide(Side value) {
        this.titleSide.set((Object)value);
    }

    public final ObjectProperty<Side> titleSideProperty() {
        return this.titleSide;
    }

    public final Side getMeasurementBarSide() {
        return (Side)((Object)this.measurementBarSide.get());
    }

    public final void setMeasurementBarSide(Side value) {
        this.measurementBarSide.set((Object)value);
    }

    public final ObjectProperty<Side> measurementBarSideProperty() {
        return this.measurementBarSide;
    }

    public final Legend getLegend() {
        return (Legend)this.legend.getValue();
    }

    public final void setLegend(Legend value) {
        this.legend.setValue((Object)value);
    }

    public final ObjectProperty<Legend> legendProperty() {
        return this.legend;
    }

    public final boolean isLegendVisible() {
        return this.legendVisible.getValue();
    }

    public final void setLegendVisible(boolean value) {
        this.legendVisible.set(value);
    }

    public final BooleanProperty legendVisibleProperty() {
        return this.legendVisible;
    }

    public final Side getLegendSide() {
        return (Side)((Object)this.legendSide.get());
    }

    public final void setLegendSide(Side value) {
        this.legendSide.set((Object)value);
    }

    public final ObjectProperty<Side> legendSideProperty() {
        return this.legendSide;
    }

    public final boolean getAnimated() {
        return this.animated.get();
    }

    public final void setAnimated(boolean value) {
        this.animated.set(value);
    }

    public final BooleanProperty animatedProperty() {
        return this.animated;
    }

    public FlowPane getToolBar() {
        return this.toolBar;
    }

    public Pane getMeasurementBar(Side side) {
        return this.parameterDisplayPane.get((Object)side);
    }

    public final Side getToolBarSide() {
        return (Side)((Object)this.toolBarSide.get());
    }

    public final void setToolBarSide(Side value) {
        this.toolBarSide.set((Object)value);
    }

    public final ObjectProperty<Side> toolBarSideProperty() {
        return this.toolBarSide;
    }

    public final ObservableList<ChartPlugin> getPlugins() {
        return this.plugins;
    }

    protected static Group createChildGroup() {
        Group group = new Group();
        group.setManaged(false);
        group.setAutoSizeChildren(false);
        group.relocate(0.0, 0.0);
        return group;
    }

    protected void pluginRemoved(ChartPlugin plugin) {
        plugin.setChart(null);
        Group group = this.pluginGroups.remove(plugin);
        Bindings.unbindContent((Object)group, plugin.getChartChildren());
        group.getChildren().clear();
        this.pluginsArea.getChildren().remove((Object)group);
    }

    protected void pluginAdded(ChartPlugin plugin) {
        plugin.setChart(this);
        Group group = Chart.createChildGroup();
        Bindings.bindContent((List)group.getChildren(), plugin.getChartChildren());
        this.pluginGroups.put(plugin, group);
    }

    protected void updatePluginsArea() {
        this.pluginsArea.getChildren().setAll((Collection)this.plugins.stream().map(this.pluginGroups::get).collect(Collectors.toList()));
        this.requestLayout();
    }

    protected void registerShowingListener() {
        this.sceneProperty().addListener((ch, oldScene, newScene) -> {
            if (oldScene == newScene) {
                return;
            }
            if (oldScene != null) {
                // empty if block
            }
            if (newScene == null) {
                this.showingProperty.set(false);
                return;
            }
            newScene.windowProperty().addListener((ch1, oldWindow, newWindow) -> {
                if (newWindow == null) {
                    this.showingProperty.set(false);
                    return;
                }
                newWindow.showingProperty().addListener((ch2, o, n) -> this.showingProperty.set(n.booleanValue()));
            });
        });
        this.showingProperty.addListener((ch, o, n) -> {
            if (o == n) {
                return;
            }
            if (n.booleanValue()) {
                KeyFrame kf1 = new KeyFrame(Duration.millis((double)20.0), e -> this.requestLayout(), new KeyValue[0]);
                Timeline timeline = new Timeline(new KeyFrame[]{kf1});
                Platform.runLater(() -> ((Timeline)timeline).play());
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public Chart() {
        void var4_16;
        for (Side side : Side.values()) {
            this.axesPane.put(side, (Pane)(side.isVertical() ? new ChartHBox() : new ChartVBox()));
            if (side != Side.CENTER_HOR && side != Side.CENTER_VER) continue;
            this.axesPane.get((Object)side).setMouseTransparent(true);
        }
        this.titleLegendPane = new ConcurrentHashMap<Side, Pane>(4);
        for (Side side : Side.values()) {
            this.titleLegendPane.put(side, (Pane)(side.isVertical() ? new ChartHBox() : new ChartVBox()));
        }
        this.axesCorner = new ConcurrentHashMap<Corner, StackPane>(4);
        for (Enum enum_ : Corner.values()) {
            this.axesCorner.put((Corner)enum_, new StackPane());
        }
        this.titleLegendCorner = new ConcurrentHashMap<Corner, StackPane>(4);
        for (Enum enum_ : Corner.values()) {
            this.titleLegendCorner.put((Corner)enum_, new StackPane());
        }
        this.datasetChangeListener = this::datasetsChanged;
        this.allDataSets = FXCollections.observableArrayList();
        this.datasets = FXCollections.observableArrayList();
        this.getDatasets().addListener(this.datasetChangeListener);
        this.renderers = FXCollections.observableArrayList();
        this.getRenderers().addListener(this::rendererChanged);
        this.hiddenPane = new HiddenSidesPane();
        this.plotBackground = new Pane();
        this.plotForeGround = new Pane();
        this.canvasForeground = new Pane();
        this.axesList = FXCollections.observableArrayList();
        this.axesChangeListenerLocal = this::axesChangedLocal;
        this.axesChangeListener = this::axesChanged;
        this.getAxes().addListener(this.axesChangeListener);
        this.getAxes().addListener(this.axesChangeListenerLocal);
        this.axisChangeListener = this::axesInvalidated;
        this.isAxesUpdate = false;
        this.animator = new ChartLayoutAnimator((Parent)this);
        this.titleLabel = new Label();
        this.title = new StringPropertyBase(){

            protected void invalidated() {
                Chart.this.titleLabel.setText(this.get());
            }

            public Object getBean() {
                return Chart.this;
            }

            public String getName() {
                return "title";
            }
        };
        this.titleSide = new StylishObjectProperty<Side>(StyleableProperties.TITLE_SIDE, (Object)this, "titleSide", Side.TOP, this::requestLayout){

            public void set(Side side) {
                AssertUtils.notNull((String)"Side must not be null", (Object)((Object)side));
                for (Side s : Side.values()) {
                    Chart.this.getMeasurementBar(s).getChildren().remove((Object)Chart.this.titleLabel);
                }
                Chart.this.getMeasurementBar(side).getChildren().add((Object)Chart.this.titleLabel);
                super.set((Object)side);
            }
        };
        this.measurementBarSide = new StyleableObjectProperty<Side>(Side.RIGHT){

            public void set(Side side) {
                AssertUtils.notNull((String)"Side must not be null", (Object)((Object)side));
                super.set((Object)side);
            }

            protected void invalidated() {
                Chart.this.requestLayout();
            }

            public CssMetaData<Chart, Side> getCssMetaData() {
                return StyleableProperties.MEASUREMENT_SIDE_BAR;
            }

            public Object getBean() {
                return Chart.this;
            }

            public String getName() {
                return "measurementBarSide";
            }
        };
        this.legend = new SimpleObjectProperty<Legend>((Object)this, "legend"){
            private Legend oldLegend;

            protected void invalidated() {
                Legend newLegend = (Legend)this.get();
                if (this.oldLegend != null) {
                    Chart.this.getChildren().remove((Object)this.oldLegend);
                }
                if (newLegend != null) {
                    Chart.this.getChildren().add((Object)newLegend.getNode());
                    newLegend.getNode().setVisible(Chart.this.isLegendVisible());
                }
                this.oldLegend = newLegend;
            }
        };
        this.legendVisible = new StylishBooleanProperty((CssMetaData<? extends Styleable, Boolean>)StyleableProperties.LEGEND_VISIBLE, (Object)this, "legendVisible", true, () -> {
            this.updateLegend((List<DataSet>)this.getDatasets(), (List<Renderer>)this.getRenderers());
            this.requestLayout();
        });
        this.legendSide = new StylishObjectProperty<Side>(StyleableProperties.LEGEND_SIDE, (Object)this, "legendSide", Side.BOTTOM, this::requestLayout){

            public void set(Side side) {
                AssertUtils.notNull((String)"Side must not be null", (Object)((Object)side));
                Legend legend = Chart.this.getLegend();
                for (Side s : Side.values()) {
                    Chart.this.getMeasurementBar(s).getChildren().remove((Object)legend);
                }
                Chart.this.getMeasurementBar(side).getChildren().add((Object)legend.getNode());
                if (legend instanceof Legend) {
                    legend.setVertical(side.isVertical());
                }
                super.set((Object)side);
            }
        };
        this.animated = new SimpleBooleanProperty((Object)this, "animated", true);
        this.toolBar = new FlowPane();
        this.parameterDisplayPane = new ConcurrentHashMap<Side, Pane>(4);
        for (Enum enum_ : Side.values()) {
            if (enum_ == Side.RIGHT) {
                FlowPane flowPane = new FlowPane(Orientation.VERTICAL);
                flowPane.setAlignment(Pos.TOP_LEFT);
                flowPane.setPrefSize(-1.0, -1.0);
                this.parameterDisplayPane.put((Side)enum_, (Pane)flowPane);
                continue;
            }
            this.parameterDisplayPane.put((Side)enum_, (Pane)(((Side)enum_).isVertical() ? new ChartHBox() : new ChartVBox()));
        }
        this.toolBarSide = new StyleableObjectProperty<Side>(Side.TOP){

            public void set(Side side) {
                AssertUtils.notNull((String)"Side must not be null", (Object)((Object)side));
                Chart.this.setTop(null);
                Chart.this.setBottom(null);
                Chart.this.setLeft(null);
                Chart.this.setRight(null);
                switch (side) {
                    case LEFT: {
                        Chart.this.getToolBar().setOrientation(Orientation.VERTICAL);
                        Chart.this.setLeft((Node)Chart.this.getToolBar());
                        break;
                    }
                    case RIGHT: {
                        Chart.this.getToolBar().setOrientation(Orientation.VERTICAL);
                        Chart.this.setRight((Node)Chart.this.getToolBar());
                        break;
                    }
                    case BOTTOM: {
                        Chart.this.getToolBar().setOrientation(Orientation.HORIZONTAL);
                        Chart.this.setBottom((Node)Chart.this.getToolBar());
                        break;
                    }
                    default: {
                        Chart.this.getToolBar().setOrientation(Orientation.HORIZONTAL);
                        Chart.this.setTop((Node)Chart.this.getToolBar());
                    }
                }
                super.set((Object)side);
            }

            protected void invalidated() {
                Chart.this.requestLayout();
            }

            public CssMetaData<Chart, Side> getCssMetaData() {
                return StyleableProperties.TOOLBAR_SIDE;
            }

            public Object getBean() {
                return Chart.this;
            }

            public String getName() {
                return "titleSide";
            }
        };
        this.pluginGroups = new ConcurrentHashMap<ChartPlugin, Group>();
        this.plugins = FXCollections.observableList(new LinkedList());
        this.pluginsArea = Chart.createChildGroup();
        this.pluginsChanged = change -> {
            while (change.next()) {
                change.getRemoved().forEach(this::pluginRemoved);
                change.getAddedSubList().forEach(this::pluginAdded);
            }
            this.updatePluginsArea();
        };
        this.layoutOngoing = false;
        this.dataSetDataListener = obs -> this.dataSetInvalidated();
        this.listeners = new ArrayList<InvalidationListener>();
        this.autoNotification = new SimpleBooleanProperty((Object)this, "autoNotification", true);
        this.getStylesheets().add((Object)CHART_CSS);
        this.setTriggerDistance(50.0);
        this.setMinSize(0.0, 0.0);
        this.setPrefSize(-1.0, -1.0);
        this.setMaxSize(-1.0, -1.0);
        this.setPadding(Insets.EMPTY);
        BorderPane localBorderPane = new BorderPane();
        this.axesAndCanvasPane.setPadding(Insets.EMPTY);
        localBorderPane.setCenter((Node)new StackPane(new Node[]{this.plotBackground, this.axesAndCanvasPane, this.plotForeGround}));
        this.plotBackground.toBack();
        this.plotForeGround.toFront();
        this.plotForeGround.setMouseTransparent(true);
        Side[] sideArray = Side.values();
        int n2 = sideArray.length;
        boolean bl = false;
        while (var4_16 < n2) {
            Side side = sideArray[var4_16];
            BorderPane.setAlignment((Node)this.getMeasurementBar(side), (Pos)Pos.CENTER);
            ++var4_16;
        }
        localBorderPane.setTop((Node)this.getMeasurementBar(Side.TOP));
        localBorderPane.setBottom((Node)this.getMeasurementBar(Side.BOTTOM));
        localBorderPane.setLeft((Node)this.getMeasurementBar(Side.LEFT));
        localBorderPane.setRight((Node)this.getMeasurementBar(Side.RIGHT));
        super.setContent((Node)localBorderPane);
        this.hiddenPane.triggerDistanceProperty().bindBidirectional((Property)this.triggerDistanceProperty());
        this.hiddenPane.setAnimationDelay(Duration.millis((double)500.0));
        this.hiddenPane.setPickOnBounds(false);
        StackPane stackPane = new StackPane(new Node[]{this.getCanvas(), this.getCanvasForeground(), this.pluginsArea});
        this.hiddenPane.setContent((Node)stackPane);
        this.getCanvasForeground().setManaged(false);
        ChangeListener canvasSizeChangeListener = (ch, o, n) -> {
            if (n == o) {
                return;
            }
            double width = this.getCanvas().getWidth();
            double height = this.getCanvas().getHeight();
            if (this.getCanvasForeground().getWidth() != width || this.getCanvasForeground().getHeight() != height) {
                this.getCanvasForeground().resize(width, height);
            }
            this.requestLayout();
        };
        this.canvas.widthProperty().addListener(canvasSizeChangeListener);
        this.canvas.heightProperty().addListener(canvasSizeChangeListener);
        this.getCanvasForeground().setMouseTransparent(true);
        this.getCanvas().toFront();
        this.getCanvasForeground().toFront();
        this.pluginsArea.toFront();
        this.hiddenPane.getStyleClass().setAll((Object[])new String[]{"plot-content"});
        this.plotBackground.getStyleClass().setAll((Object[])new String[]{"chart-plot-background"});
        if (!this.canvas.isCache()) {
            this.canvas.setCache(true);
            this.canvas.setCacheHint(CacheHint.QUALITY);
        }
        this.axesAndCanvasPane.add((Node)this.hiddenPane, 2, 2);
        this.canvas.setStyle("-fx-background-color: rgba(200, 250, 200, 0.5);");
        boolean bl2 = true;
        boolean COL_SPAN1 = true;
        int ROW_SPAN3 = 3;
        int COL_SPAN3 = 3;
        this.axesAndCanvasPane.add((Node)this.getTitleLegendPane(Side.LEFT), 0, 1, 1, 3);
        this.axesAndCanvasPane.add((Node)this.getTitleLegendPane(Side.RIGHT), 4, 1, 1, 3);
        this.axesAndCanvasPane.add((Node)this.getTitleLegendPane(Side.TOP), 1, 0, 3, 1);
        this.axesAndCanvasPane.add((Node)this.getTitleLegendPane(Side.BOTTOM), 1, 4, 3, 1);
        this.axesAndCanvasPane.add((Node)this.getAxesPane(Side.LEFT), 1, 2);
        this.axesAndCanvasPane.add((Node)this.getAxesPane(Side.RIGHT), 3, 2);
        this.axesAndCanvasPane.add((Node)this.getAxesPane(Side.TOP), 2, 1);
        this.axesAndCanvasPane.add((Node)this.getAxesPane(Side.BOTTOM), 2, 3);
        Pane pane = this.getAxesPane(Side.CENTER_VER);
        GridPane.setFillHeight((Node)pane, (Boolean)true);
        GridPane.setFillWidth((Node)pane, (Boolean)true);
        this.axesAndCanvasPane.add((Node)this.getAxesPane(Side.CENTER_VER), 2, 2);
        this.axesAndCanvasPane.add((Node)this.getAxesPane(Side.CENTER_HOR), 2, 2);
        this.axesAndCanvasPane.add((Node)this.getAxesCornerPane(Corner.TOP_LEFT), 1, 1);
        this.axesAndCanvasPane.add((Node)this.getAxesCornerPane(Corner.TOP_RIGHT), 3, 1);
        this.axesAndCanvasPane.add((Node)this.getAxesCornerPane(Corner.BOTTOM_LEFT), 1, 3);
        this.axesAndCanvasPane.add((Node)this.getAxesCornerPane(Corner.BOTTOM_RIGHT), 3, 3);
        this.axesAndCanvasPane.add((Node)this.getTitleLegendCornerPane(Corner.TOP_LEFT), 0, 0);
        this.axesAndCanvasPane.add((Node)this.getTitleLegendCornerPane(Corner.TOP_RIGHT), 4, 0);
        this.axesAndCanvasPane.add((Node)this.getTitleLegendCornerPane(Corner.BOTTOM_LEFT), 0, 4);
        this.axesAndCanvasPane.add((Node)this.getTitleLegendCornerPane(Corner.BOTTOM_RIGHT), 4, 4);
        for (int i = 0; i < 4; ++i) {
            RowConstraints rowConstraint = new RowConstraints();
            if (i == 2) {
                rowConstraint.setVgrow(Priority.ALWAYS);
                rowConstraint.setFillHeight(true);
            }
            this.axesAndCanvasPane.getRowConstraints().add(i, (Object)rowConstraint);
            ColumnConstraints colConstraint = new ColumnConstraints();
            if (i == 2) {
                colConstraint.setHgrow(Priority.ALWAYS);
                colConstraint.setFillWidth(true);
            }
            this.axesAndCanvasPane.getColumnConstraints().add(i, (Object)colConstraint);
        }
        this.getPlugins().addListener(this.pluginsChanged);
        this.titleLabel.setAlignment(Pos.CENTER);
        HBox.setHgrow((Node)this.titleLabel, (Priority)Priority.ALWAYS);
        VBox.setVgrow((Node)this.titleLabel, (Priority)Priority.ALWAYS);
        this.titleLabel.focusTraversableProperty().bind((ObservableValue)Platform.accessibilityActiveProperty());
        this.toolBar.setPrefHeight(-1.0);
        this.toolBar.setMinHeight(0.0);
        this.toolBar.setPrefWidth(-1.0);
        this.toolBar.setMinWidth(0.0);
        this.toolBar.setPadding(new Insets(1.0, 1.0, 1.0, 1.0));
        VBox.setVgrow((Node)this.toolBar, (Priority)Priority.ALWAYS);
        this.setTop((Node)this.getToolBar());
        this.getToolBar().setOnMouseClicked(mevt -> {
            boolean isPinned = this.isPinned(this.getToolBarSide()) == false;
            this.setPinned(this.getToolBarSide(), isPinned);
            if (isPinned) {
                this.getToolBar().setBorder(new Border(new BorderStroke[]{new BorderStroke((Paint)Color.DARKBLUE, BorderStrokeStyle.SOLID, CornerRadii.EMPTY, BorderWidths.DEFAULT)}));
            } else {
                this.getToolBar().setBorder(null);
            }
            this.requestLayout();
        });
        this.getTitleLegendPane(Side.TOP).getChildren().add((Object)this.titleLabel);
        this.setLegend(new DefaultLegend());
        this.legendVisibleProperty().addListener((ch, old, visible) -> {
            if (this.getLegend() == null) {
                return;
            }
            this.getLegend().getNode().setVisible(visible.booleanValue());
            if (visible.booleanValue()) {
                if (!this.getTitleLegendPane(this.getLegendSide()).getChildren().contains((Object)this.getLegend().getNode())) {
                    this.getTitleLegendPane(this.getLegendSide()).getChildren().add((Object)this.getLegend().getNode());
                }
            } else {
                this.getTitleLegendPane(this.getLegendSide()).getChildren().remove((Object)this.getLegend().getNode());
            }
        });
        this.getTitleLegendPane(this.getLegendSide()).getChildren().add((Object)this.getLegend().getNode());
        this.titleLabel.getStyleClass().add((Object)"chart-title");
        this.getStyleClass().add((Object)"chart");
        this.axesAndCanvasPane.getStyleClass().add((Object)"chart-content");
        this.registerShowingListener();
    }

    public abstract void updateAxisRange();

    protected abstract void redrawCanvas();

    public void layoutChildren() {
        if (this.layoutOngoing) {
            return;
        }
        long start = ProcessingProfiler.getTimeStamp();
        this.layoutOngoing = true;
        this.updateAxisRange();
        for (Axis axis : this.getAxes()) {
            boolean oldFlag = axis.isAutoNotification();
            axis.setAutoNotifaction(false);
            axis.forceRedraw();
            axis.setAutoNotifaction(oldFlag);
        }
        ProcessingProfiler.getTimeDiff((long)start, (String)"updateAxisRange()");
        super.layoutChildren();
        this.redrawCanvas();
        ProcessingProfiler.getTimeDiff((long)start, (String)"updateCanvas()");
        this.layoutPluginsChildren();
        ProcessingProfiler.getTimeDiff((long)start, (String)"layoutPluginsChildren()");
        ProcessingProfiler.getTimeDiff((long)start, (String)"end");
        this.layoutOngoing = false;
        this.fireInvalidated();
    }

    protected void layoutPluginsChildren() {
        this.plugins.forEach(ChartPlugin::layoutChildren);
    }

    protected void dataSetInvalidated() {
        this.requestLayout();
    }

    protected void datasetsChanged(ListChangeListener.Change<? extends DataSet> change) {
        boolean dataSetChanges = false;
        ArrayList newDataSets = new ArrayList();
        ArrayList oldDataSets = new ArrayList();
        while (change.next()) {
            oldDataSets.addAll(change.getRemoved());
            for (DataSet set : change.getRemoved()) {
                set.removeListener(this.dataSetDataListener);
                dataSetChanges = true;
            }
            newDataSets.addAll(change.getAddedSubList());
            for (DataSet set : change.getAddedSubList()) {
                set.addListener(this.dataSetDataListener);
                dataSetChanges = true;
            }
        }
        if (dataSetChanges) {
            this.updateLegend((List<DataSet>)this.getDatasets(), (List<Renderer>)this.getRenderers());
            this.requestLayout();
        }
    }

    protected void updateLegend(List<DataSet> dataSets, List<Renderer> renderers) {
        Legend legend = this.getLegend();
        if (legend == null) {
            return;
        }
        legend.updateLegend(dataSets, renderers);
    }

    void animate(KeyFrame ... keyFrames) {
        this.animator.animate(keyFrames);
    }

    protected void animate(Animation animation) {
        this.animator.animate(animation);
    }

    protected final boolean shouldAnimate() {
        return this.getAnimated() && this.impl_isTreeVisible() && this.getScene() != null;
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.STYLEABLES;
    }

    protected List<CssMetaData<? extends Styleable, ?>> getControlCssMetaData() {
        return Chart.getClassCssMetaData();
    }

    public void addListener(InvalidationListener listener) {
        Objects.requireNonNull(listener, "InvalidationListener must not be null");
        this.listeners.add(listener);
    }

    public void removeListener(InvalidationListener listener) {
        this.listeners.remove(listener);
    }

    public Chart fireInvalidated() {
        if (!this.isAutoNotification() || this.listeners.isEmpty()) {
            return this;
        }
        if (Platform.isFxApplicationThread()) {
            this.executeFireInvalidated();
        } else {
            Platform.runLater(this::executeFireInvalidated);
        }
        return this;
    }

    protected void executeFireInvalidated() {
        new ArrayList<InvalidationListener>(this.listeners).forEach(listener -> listener.invalidated((Observable)this));
    }

    public void setAutoNotifaction(boolean flag) {
        this.autoNotification.set(flag);
    }

    public boolean isAutoNotification() {
        return this.autoNotification.get();
    }

    public BooleanProperty autoNotificationProperty() {
        return this.autoNotification;
    }

    public final Point2D toPlotArea(double xCoord, double yCoord) {
        Bounds plotAreaBounds = this.getCanvas().getBoundsInParent();
        return new Point2D(xCoord - plotAreaBounds.getMinX(), yCoord - plotAreaBounds.getMinY());
    }

    protected void rendererChanged(ListChangeListener.Change<? extends Renderer> change) {
        while (change.next()) {
            for (Renderer renderer2 : change.getAddedSubList()) {
                renderer2.getDatasets().addListener(this.datasetChangeListener);
                boolean rendererHasXAxis = false;
                boolean rendererHasYAxis = false;
                for (Axis axis : renderer2.getAxes()) {
                    if (axis.getSide() == null || !axis.getSide().isHorizontal()) continue;
                    this.getAxes().add((Object)axis);
                    rendererHasXAxis = true;
                }
                for (Axis axis : renderer2.getAxes()) {
                    if (axis.getSide() == null || !axis.getSide().isVertical()) continue;
                    if (!this.axesList.contains((Object)axis)) {
                        this.getAxes().add((Object)axis);
                    }
                    rendererHasYAxis = true;
                }
                if (rendererHasXAxis && rendererHasYAxis) continue;
                Axis existingChartXAxis = this.getFirstAxis(Orientation.HORIZONTAL);
                if (existingChartXAxis != null) {
                    renderer2.getAxes().add((Object)existingChartXAxis);
                } else if (!rendererHasXAxis) {
                    DefaultNumericAxis newAxis = new DefaultNumericAxis();
                    newAxis.setLabel("default x-axis");
                    newAxis.setSide(Side.BOTTOM);
                    renderer2.getAxes().add((Object)newAxis);
                    this.getAxes().add((Object)newAxis);
                }
                Axis existingChartXYAxis = this.getFirstAxis(Orientation.VERTICAL);
                if (existingChartXYAxis != null) {
                    renderer2.getAxes().add((Object)existingChartXYAxis);
                    continue;
                }
                if (rendererHasYAxis) continue;
                DefaultNumericAxis newAxis = new DefaultNumericAxis();
                newAxis.setLabel("default y-axis");
                newAxis.setSide(Side.LEFT);
                renderer2.getAxes().add((Object)newAxis);
                this.getAxes().add((Object)newAxis);
            }
            change.getRemoved().forEach(renderer -> renderer.getDatasets().removeListener(this.datasetChangeListener));
        }
        this.requestLayout();
        this.updateLegend((List<DataSet>)this.getDatasets(), (List<Renderer>)this.getRenderers());
    }

    public void requestLayout() {
        super.requestLayout();
    }

    private static class StyleableProperties {
        private static final CssMetaData<Chart, Side> TITLE_SIDE = new CssMetaData<Chart, Side>("-fx-title-side", (StyleConverter)new EnumConverter(Side.class), Side.TOP){

            public boolean isSettable(Chart node) {
                return node.titleSide == null || !node.titleSide.isBound();
            }

            public StyleableProperty<Side> getStyleableProperty(Chart node) {
                return (StyleableProperty)node.titleSideProperty();
            }
        };
        private static final CssMetaData<Chart, Side> MEASUREMENT_SIDE_BAR = new CssMetaData<Chart, Side>("-fx-measurement-bar-side", (StyleConverter)new EnumConverter(Side.class), Side.RIGHT){

            public boolean isSettable(Chart node) {
                return node.measurementBarSide == null || !node.measurementBarSide.isBound();
            }

            public StyleableProperty<Side> getStyleableProperty(Chart node) {
                return (StyleableProperty)node.measurementBarSideProperty();
            }
        };
        private static final CssMetaData<Chart, Side> TOOLBAR_SIDE = new CssMetaData<Chart, Side>("-fx-toolbar-side", (StyleConverter)new EnumConverter(Side.class), Side.TOP){

            public boolean isSettable(Chart node) {
                return node.toolBarSide == null || !node.toolBarSide.isBound();
            }

            public StyleableProperty<Side> getStyleableProperty(Chart node) {
                return (StyleableProperty)node.toolBarSideProperty();
            }
        };
        private static final CssMetaData<Chart, Side> LEGEND_SIDE = new CssMetaData<Chart, Side>("-fx-legend-side", (StyleConverter)new EnumConverter(Side.class), Side.BOTTOM){

            public boolean isSettable(Chart node) {
                return node.legendSide == null || !node.legendSide.isBound();
            }

            public StyleableProperty<Side> getStyleableProperty(Chart node) {
                return (StyleableProperty)node.legendSideProperty();
            }
        };
        private static final CssMetaData<Chart, Boolean> LEGEND_VISIBLE = new CssMetaData<Chart, Boolean>("-fx-legend-visible", BooleanConverter.getInstance(), Boolean.TRUE){

            public boolean isSettable(Chart node) {
                return node.legendVisible == null || !node.legendVisible.isBound();
            }

            public StyleableProperty<Boolean> getStyleableProperty(Chart node) {
                return (StyleableProperty)node.legendVisibleProperty();
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

        private StyleableProperties() {
        }

        static {
            ArrayList<Object> styleables = new ArrayList<Object>(Region.getClassCssMetaData());
            styleables.add(TITLE_SIDE);
            styleables.add(MEASUREMENT_SIDE_BAR);
            styleables.add(TOOLBAR_SIDE);
            styleables.add(LEGEND_SIDE);
            styleables.add(LEGEND_VISIBLE);
            STYLEABLES = Collections.unmodifiableList(styleables);
        }
    }

    protected class ChartVBox
    extends VBox {
        public ChartVBox() {
            this.setAlignment(Pos.CENTER);
            this.setPrefSize(-1.0, -1.0);
        }

        public ChartVBox(boolean fill) {
            this();
            this.setFillWidth(fill);
        }
    }

    protected class ChartHBox
    extends HBox {
        public ChartHBox() {
            this.setAlignment(Pos.CENTER);
            this.setPrefSize(-1.0, -1.0);
        }

        public ChartHBox(boolean fill) {
            this();
            this.setFillHeight(fill);
        }
    }
}

