/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.viewer;

import de.gsi.chart.plugins.MouseEventsHelper;
import de.gsi.chart.ui.BorderedTitledPane;
import de.gsi.chart.utils.DragResizerUtil;
import de.gsi.chart.utils.FXUtils;
import de.gsi.chart.utils.MouseUtils;
import de.gsi.chart.viewer.DataView;
import de.gsi.chart.viewer.SquareButton;
import de.gsi.chart.viewer.event.WindowClosedEvent;
import de.gsi.chart.viewer.event.WindowClosingEvent;
import de.gsi.chart.viewer.event.WindowDetachedEvent;
import de.gsi.chart.viewer.event.WindowDetachingEvent;
import de.gsi.chart.viewer.event.WindowMaximisedEvent;
import de.gsi.chart.viewer.event.WindowMaximisingEvent;
import de.gsi.chart.viewer.event.WindowMinimisedEvent;
import de.gsi.chart.viewer.event.WindowMinimisingEvent;
import de.gsi.chart.viewer.event.WindowRestoredEvent;
import de.gsi.chart.viewer.event.WindowRestoringEvent;
import de.gsi.dataset.event.EventListener;
import de.gsi.dataset.event.EventSource;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import javafx.beans.DefaultProperty;
import javafx.beans.NamedArg;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.geometry.BoundingBox;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.geometry.Rectangle2D;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;
import javafx.stage.Screen;
import javafx.stage.Stage;
import javafx.stage.Window;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DefaultProperty(value="content")
public class DataViewWindow
extends BorderPane
implements EventSource {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataViewWindow.class);
    private static final int MIN_DRAG_BORDER_WIDTH = 20;
    private static final String WINDOW_CSS = "DataViewer.css";
    private static final String CSS_WINDOW = "window";
    private static final String CSS_WINDOW_DETACH_ICON = "window-detach-icon";
    private static final String CSS_WINDOW_CLOSE_ICON = "window-close-icon";
    private static final String CSS_WINDOW_MINIMIZE_ICON = "window-minimize-icon2";
    private static final String CSS_WINDOW_RESTORE_ICON = "window-restore-icon";
    private static final String CSS_WINDOW_MAXIMIZE_ICON = "window-maximize-icon";
    private static final String CSS_WINDOW_TITLE_BAR = "window-titlebar";
    private static final String CSS_TITLE_LABEL = "window-titlelabel";
    protected transient boolean parallelListeners = false;
    private final transient AtomicBoolean autoNotification = new AtomicBoolean(true);
    private final transient AtomicBoolean updatingStage = new AtomicBoolean(false);
    private final transient List<EventListener> updateListeners = Collections.synchronizedList(new LinkedList());
    private final StringProperty name = new SimpleStringProperty((Object)this, "name", "");
    private final HBox leftButtons = new HBox();
    private final Label titleLabel = new Label();
    private final HBox rightButtons = new HBox();
    private final HBox windowDecorationBar = new HBox();
    private final BooleanProperty detachableWindow = new SimpleBooleanProperty((Object)this, "detachableWindow", true);
    private final BooleanProperty minimisedWindow = new SimpleBooleanProperty((Object)this, "minimisedWindow", false);
    private final BooleanProperty maximisedWindow = new SimpleBooleanProperty((Object)this, "maximisedWindow", false);
    private final BooleanProperty restoredWindow = new SimpleBooleanProperty((Object)this, "restoredWindow", true);
    private final BooleanProperty closedWindow = new SimpleBooleanProperty((Object)this, "closedWindow", false);
    private final ObjectProperty<WindowState> windowState = new SimpleObjectProperty<WindowState>((Object)this, "windowState", WindowState.WINDOW_RESTORED){

        public void set(WindowState state) {
            if (DataViewWindow.this.windowState.get() == state) {
                return;
            }
            switch (state) {
                case WINDOW_MINIMISED: {
                    DataViewWindow.this.setMinimised(true);
                    DataViewWindow.this.setMaximised(false);
                    DataViewWindow.this.setRestored(false);
                    break;
                }
                case WINDOW_MAXIMISED: {
                    DataViewWindow.this.setMinimised(false);
                    DataViewWindow.this.setMaximised(true);
                    DataViewWindow.this.setRestored(false);
                    break;
                }
                case WINDOW_RESTORED: {
                    DataViewWindow.this.setMinimised(false);
                    DataViewWindow.this.setMaximised(false);
                    DataViewWindow.this.setRestored(true);
                    break;
                }
                case WINDOW_CLOSED: {
                    DataViewWindow.this.setClosed(true);
                    break;
                }
            }
            super.set((Object)state);
            switch (state) {
                case WINDOW_MINIMISED: {
                    DataViewWindow.this.invokeListener(new WindowMinimisedEvent(DataViewWindow.this), DataViewWindow.this.parallelListeners);
                    break;
                }
                case WINDOW_MAXIMISED: {
                    DataViewWindow.this.invokeListener(new WindowMaximisedEvent(DataViewWindow.this), DataViewWindow.this.parallelListeners);
                    break;
                }
                case WINDOW_RESTORED: {
                    DataViewWindow.this.invokeListener(new WindowRestoredEvent(DataViewWindow.this), DataViewWindow.this.parallelListeners);
                    break;
                }
                case WINDOW_CLOSED: {
                    DataViewWindow.this.invokeListener(new WindowClosedEvent(DataViewWindow.this), DataViewWindow.this.parallelListeners);
                    break;
                }
            }
        }
    };
    private final BooleanProperty detachedWindow = new SimpleBooleanProperty((Object)this, "detachedWindow", false);
    private final ObjectProperty<WindowDecoration> windowDecoration = new SimpleObjectProperty((Object)this, "windowDecoration");
    private final ObjectProperty<Node> content = new SimpleObjectProperty((Object)this, "content");
    private final Button detachButton = new SquareButton("window-detach-icon");
    private final Button minimizeButton = new SquareButton("window-minimize-icon2");
    private final Button maximizeRestoreButton = new SquareButton("window-maximize-icon");
    private final Button closeButton = new SquareButton("window-close-icon");
    private final ExternalStage dialog = new ExternalStage();
    private transient double xOffset;
    private transient double yOffset;
    private final ObjectProperty<DataView> parentView = new SimpleObjectProperty((Object)this, "parentView");
    private final Predicate<MouseEvent> mouseFilter = MouseEventsHelper::isOnlyPrimaryButtonDown;
    private final ObjectProperty<Cursor> dragCursor = new SimpleObjectProperty((Object)this, "dragCursor", (Object)Cursor.CLOSED_HAND);
    private Cursor originalCursor;
    private final ObjectProperty<Node> graphic = new SimpleObjectProperty((Object)this, "graphic");
    protected final Runnable maximizeButtonAction = () -> {
        if (this.updatingStage.get() || this.getParentView() == null || this.isDetached()) {
            return;
        }
        this.updatingStage.set(true);
        if (this.isMaximised()) {
            this.invokeListener(new WindowRestoringEvent(this), this.parallelListeners);
        } else if (this.isMinimised()) {
            this.invokeListener(new WindowRestoringEvent(this), this.parallelListeners);
        } else {
            this.invokeListener(new WindowMaximisingEvent(this), this.parallelListeners);
        }
        if (this.dialog.isShowing()) {
            this.dialog.maximizeRestore(this);
            this.updatingStage.set(false);
            return;
        }
        if (this.getParentView().getMinimisedChildren().contains((Object)this)) {
            this.invokeListener(new WindowRestoringEvent(this), this.parallelListeners);
            this.getParentView().getMinimisedChildren().remove((Object)this);
            this.setMinimised(false);
            this.getParentView().getVisibleChildren().add((Object)this);
            this.setWindowState(WindowState.WINDOW_RESTORED);
            this.updatingStage.set(false);
            return;
        }
        if (this.equals((Object)this.getParentView().getMaximizedChild())) {
            this.maximizeRestoreButton.getStyleClass().setAll((Object[])new String[]{CSS_WINDOW_MAXIMIZE_ICON});
            this.getParentView().setMaximizedChild(null);
            this.getParentView().getVisibleChildren().add((Object)this);
            this.setWindowState(WindowState.WINDOW_RESTORED);
            this.updatingStage.set(false);
            return;
        }
        this.maximizeRestoreButton.getStyleClass().setAll((Object[])new String[]{CSS_WINDOW_RESTORE_ICON});
        this.getParentView().getVisibleChildren().remove((Object)this);
        this.getParentView().setMaximizedChild(this);
        this.setWindowState(WindowState.WINDOW_MAXIMISED);
        this.updatingStage.set(false);
    };
    protected final Runnable minimizeButtonAction = () -> {
        if (this.isDetached() || this.isMinimised()) {
            return;
        }
        this.updatingStage.set(true);
        this.invokeListener(new WindowMinimisingEvent(this), this.parallelListeners);
        if (this.dialog.isShowing()) {
            this.dialog.hide();
            this.maximizeRestoreButton.getStyleClass().setAll((Object[])new String[]{CSS_WINDOW_MAXIMIZE_ICON});
            this.setWindowState(WindowState.WINDOW_MINIMISED);
            return;
        }
        if (this.equals((Object)this.getParentView().getMaximizedChild())) {
            this.maximizeRestoreButton.getStyleClass().setAll((Object[])new String[]{CSS_WINDOW_MAXIMIZE_ICON});
            this.getParentView().setMaximizedChild(null);
            this.getParentView().getVisibleChildren().add((Object)this);
        }
        this.maximizeRestoreButton.getStyleClass().setAll((Object[])new String[]{CSS_WINDOW_MAXIMIZE_ICON});
        this.getParentView().getVisibleChildren().remove((Object)this);
        this.setWindowState(WindowState.WINDOW_MINIMISED);
        this.getParentView().getMinimisedChildren().add((Object)this);
        this.updatingStage.set(false);
    };
    protected Runnable closeButtonAction = () -> {
        if (this.updatingStage.get() || this.isClosed()) {
            return;
        }
        this.updatingStage.set(true);
        this.invokeListener(new WindowClosingEvent(this), this.parallelListeners);
        this.getParentView().getMinimisedChildren().remove((Object)this);
        this.getParentView().getVisibleChildren().remove((Object)this);
        this.getParentView().getVisibleChildren().remove((Object)this);
        this.getParentView().getUndockedChildren().remove((Object)this);
        if (this.equals((Object)this.getParentView().getMaximizedChild())) {
            this.getParentView().setMaximizedChild(null);
        }
        this.setWindowState(WindowState.WINDOW_CLOSED);
        this.updatingStage.set(false);
    };

    public DataViewWindow(@NamedArg(value="name") String name, @NamedArg(value="content") Node content) {
        this(name, content, WindowDecoration.BAR);
    }

    public DataViewWindow(String name, Node content, WindowDecoration windowDecoration) {
        if (content == null) {
            throw new IllegalArgumentException("content must not be null");
        }
        this.setName(name);
        GridPane.setHgrow((Node)this, (Priority)Priority.ALWAYS);
        GridPane.setVgrow((Node)this, (Priority)Priority.ALWAYS);
        this.getStyleClass().setAll((Object[])new String[]{CSS_WINDOW});
        String css = DataViewWindow.class.getResource(WINDOW_CSS).toExternalForm();
        this.getStylesheets().clear();
        this.getStylesheets().add((Object)css);
        this.contentProperty().addListener((ch, o, newNode) -> this.setLocalCenter((Node)newNode));
        DragResizerUtil.makeResizable((Node)this);
        this.leftButtons.setPrefWidth(-1.0);
        HBox.setHgrow((Node)this.leftButtons, (Priority)Priority.SOMETIMES);
        Pane spacer1 = new Pane();
        HBox.setHgrow((Node)spacer1, (Priority)Priority.ALWAYS);
        this.titleLabel.getStyleClass().setAll((Object[])new String[]{CSS_TITLE_LABEL});
        this.titleLabel.textProperty().bindBidirectional((Property)this.nameProperty());
        HBox.setHgrow((Node)this.titleLabel, (Priority)Priority.ALWAYS);
        Pane spacer2 = new Pane();
        HBox.setHgrow((Node)spacer2, (Priority)Priority.ALWAYS);
        this.rightButtons.setPrefWidth(-1.0);
        HBox.setHgrow((Node)this.rightButtons, (Priority)Priority.SOMETIMES);
        this.windowDecorationBar.getStyleClass().setAll((Object[])new String[]{CSS_WINDOW_TITLE_BAR});
        this.windowDecorationBar.getChildren().addAll((Object[])new Node[]{this.leftButtons, spacer1, this.titleLabel, spacer2, this.rightButtons});
        this.getLeftIcons().add((Object)this.detachButton);
        this.getRightIcons().addAll((Object[])new Node[]{this.minimizeButton, this.maximizeRestoreButton});
        this.minimisedProperty().addListener((ch, o, n) -> {
            if (!this.isDetached()) {
                this.setLocalCenter(Boolean.TRUE.equals(n) ? null : this.getContent());
            }
        });
        this.windowDecorationProperty().addListener((ch, o, n) -> {
            switch (n) {
                case NONE: {
                    this.setTop(null);
                    break;
                }
                case BAR_WO_CLOSE: {
                    this.setTop((Node)this.getWindowDecorationBar());
                    this.removeCloseWindowButton();
                    break;
                }
                case FRAME: {
                    this.setTop(null);
                    break;
                }
                default: {
                    this.setTop((Node)this.getWindowDecorationBar());
                    this.addCloseWindowButton();
                }
            }
            this.setLocalCenter(this.getContent());
        });
        this.setWindowDecoration(windowDecoration);
        this.minimisedWindow.addListener((ch, o, n) -> this.minimizeButtonAction.run());
        this.maximisedWindow.addListener((ch, o, n) -> this.maximizeButtonAction.run());
        this.restoredWindow.addListener((ch, o, n) -> this.maximizeButtonAction.run());
        this.detachedWindow.addListener((ch, o, n) -> {
            if (Boolean.TRUE.equals(n)) {
                if (!this.isDetachableWindow()) {
                    return;
                }
                this.dialog.show(this, null);
            } else {
                this.dialog.hide();
            }
        });
        this.closedWindow.addListener((ch, o, n) -> {
            if (Boolean.TRUE.equals(n)) {
                this.closeButtonAction.run();
            }
        });
        this.detachButton.setOnAction(evt -> this.setDetached(true));
        this.detachButton.setId("detachButton");
        this.minimizeButton.setOnAction(evt -> this.minimizeButtonAction.run());
        this.minimizeButton.setId("minimizeButton");
        this.maximizeRestoreButton.setOnAction(evt -> this.maximizeButtonAction.run());
        this.maximizeRestoreButton.setId("maximizeRestoreButton");
        this.closeButton.setOnAction(evt -> this.closeButtonAction.run());
        this.closeButton.setId("closeButton");
        this.windowDecorationBar.setOnMouseReleased(this::dragFinish);
        this.windowDecorationBar.setOnMousePressed(this::dragStart);
        this.windowDecorationBar.setOnMouseDragged(this::dragOngoing);
        this.dialog.setOnHiding(we -> this.dialog.hide(this));
        this.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        this.setContent(content);
    }

    public final void addCloseWindowButton() {
        Button button = this.getCloseButton();
        if (!this.getRightIcons().contains((Object)button)) {
            this.getRightIcons().add((Object)button);
        }
    }

    public AtomicBoolean autoNotification() {
        return this.autoNotification;
    }

    public BooleanProperty closedProperty() {
        return this.closedWindow;
    }

    public ObjectProperty<Node> contentProperty() {
        return this.content;
    }

    public BooleanProperty detachableWindowProperty() {
        return this.detachableWindow;
    }

    public BooleanProperty detachedProperty() {
        return this.detachedWindow;
    }

    public final ObjectProperty<Cursor> dragCursorProperty() {
        return this.dragCursor;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DataViewWindow)) {
            return false;
        }
        DataViewWindow other = (DataViewWindow)((Object)obj);
        return Objects.equals(this.graphic, other.graphic) && Objects.equals(this.name, other.name);
    }

    public Button getCloseButton() {
        return this.closeButton;
    }

    public Node getContent() {
        return (Node)this.contentProperty().get();
    }

    public Button getDetachButton() {
        return this.detachButton;
    }

    public ExternalStage getDialog() {
        return this.dialog;
    }

    public final Cursor getDragCursor() {
        return (Cursor)this.dragCursorProperty().get();
    }

    public final Node getGraphic() {
        return (Node)this.graphicProperty().get();
    }

    public ObservableList<Node> getLeftIcons() {
        return this.leftButtons.getChildren();
    }

    public Button getMaximizeRestoreButton() {
        return this.maximizeRestoreButton;
    }

    public Button getMinimizeButton() {
        return this.minimizeButton;
    }

    public final String getName() {
        return (String)this.nameProperty().get();
    }

    public DataView getParentView() {
        return (DataView)((Object)this.parentViewProperty().get());
    }

    public ObservableList<Node> getRightIcons() {
        return this.rightButtons.getChildren();
    }

    public Label getTitleLabel() {
        return this.titleLabel;
    }

    public WindowDecoration getWindowDecoration() {
        return (WindowDecoration)((Object)this.windowDecorationProperty().get());
    }

    public WindowState getWindowState() {
        return (WindowState)((Object)this.windowStateProperty().get());
    }

    public final ObjectProperty<Node> graphicProperty() {
        return this.graphic;
    }

    public int hashCode() {
        return Objects.hash(this.graphic, this.name);
    }

    public boolean isClosed() {
        return this.closedProperty().get();
    }

    public boolean isDetachableWindow() {
        return this.detachableWindowProperty().get();
    }

    public boolean isDetached() {
        return this.detachedProperty().get();
    }

    public boolean isMaximised() {
        return this.maximisedProperty().get();
    }

    public boolean isMinimised() {
        return this.minimisedProperty().get();
    }

    public boolean isRestored() {
        return this.restoredProperty().get();
    }

    public BooleanProperty maximisedProperty() {
        return this.maximisedWindow;
    }

    public BooleanProperty minimisedProperty() {
        return this.minimisedWindow;
    }

    public final StringProperty nameProperty() {
        return this.name;
    }

    public ObjectProperty<DataView> parentViewProperty() {
        return this.parentView;
    }

    public final void removeCloseWindowButton() {
        Button button = this.getCloseButton();
        this.getLeftIcons().remove((Object)button);
        this.getRightIcons().remove((Object)button);
    }

    public BooleanProperty restoredProperty() {
        return this.restoredWindow;
    }

    public void setClosed(boolean state) {
        this.closedProperty().set(state);
    }

    public final void setContent(Node content) {
        this.contentProperty().set((Object)content);
    }

    public void setDetachableWindow(boolean state) {
        this.detachableWindowProperty().set(state);
    }

    public void setDetached(boolean state) {
        this.detachedProperty().set(state);
    }

    public final void setDragCursor(Cursor cursor) {
        this.dragCursorProperty().set((Object)cursor);
    }

    public final void setGraphic(Node graphic) {
        this.graphicProperty().set((Object)graphic);
    }

    public void setMaximised(boolean state) {
        this.maximisedProperty().set(state);
    }

    public void setMinimised(boolean state) {
        this.minimisedProperty().set(state);
    }

    public final void setName(String name) {
        this.nameProperty().set((Object)name);
    }

    public void setParentView(DataView view) {
        this.parentViewProperty().set((Object)view);
    }

    public void setRestored(boolean state) {
        this.restoredProperty().set(state);
    }

    public void setWindowDecoration(WindowDecoration state) {
        this.windowDecorationProperty().set((Object)state);
    }

    public String toString() {
        return DataViewWindow.class.getSimpleName() + "(\"" + this.getName() + "\")";
    }

    public List<EventListener> updateEventListener() {
        return this.updateListeners;
    }

    public ObjectProperty<WindowDecoration> windowDecorationProperty() {
        return this.windowDecoration;
    }

    public ObjectProperty<WindowState> windowStateProperty() {
        return this.windowState;
    }

    protected HBox getWindowDecorationBar() {
        return this.windowDecorationBar;
    }

    protected void installCursor() {
        this.originalCursor = this.getCursor();
        if (this.getDragCursor() != null) {
            this.setCursor(this.getDragCursor());
        }
    }

    protected void setLocalCenter(Node content) {
        switch (this.getWindowDecoration()) {
            case FRAME: {
                if (content == null) {
                    this.setCenter(null);
                    break;
                }
                BorderedTitledPane node = new BorderedTitledPane(this.getName(), content);
                node.setOnMousePressed(this::dragStart);
                node.setOnMouseDragged(this::dragOngoing);
                node.setOnMouseReleased(this::dragFinish);
                this.setCenter((Node)node);
                break;
            }
            default: {
                this.setCenter(content);
            }
        }
    }

    protected void setWindowState(WindowState state) {
        this.windowStateProperty().set((Object)state);
    }

    private void dragFinish(MouseEvent mevt) {
        if (this.isMinimised() || this.getParentView() == null || this.getParentView().getMinimisedChildren().contains((Object)this)) {
            return;
        }
        if (!this.mouseFilter.test(mevt)) {
            return;
        }
        this.uninstallCursor();
        if (!this.isDetachableWindow()) {
            return;
        }
        if (this.getScene() == null) {
            return;
        }
        Point2D mouseLoc = new Point2D(mevt.getScreenX(), mevt.getScreenY());
        Window window = this.getScene().getWindow();
        BoundingBox sceneBounds = new BoundingBox(window.getX(), window.getY(), window.getWidth(), window.getHeight());
        Bounds screenBounds = this.localToScreen(WindowDecoration.FRAME.equals((Object)this.getWindowDecoration()) ? this.getBoundsInLocal() : this.getWindowDecorationBar().getBoundsInLocal());
        if (MouseUtils.mouseOutsideBoundaryBoxDistance(screenBounds, mouseLoc) > 20.0 && MouseUtils.mouseOutsideBoundaryBoxDistance((Bounds)sceneBounds, mouseLoc) > 20.0) {
            if (!this.dialog.isShowing()) {
                this.dialog.show(this, mevt);
                return;
            }
            this.dialog.setX(mevt.getScreenX() - this.xOffset);
            this.dialog.setY(mevt.getScreenY() - this.yOffset);
            return;
        }
        if (!this.dialog.isShowing()) {
            return;
        }
        this.dialog.setX(mevt.getScreenX() - this.xOffset);
        this.dialog.setY(mevt.getScreenY() - this.yOffset);
    }

    private void dragOngoing(MouseEvent mevt) {
        if (!this.mouseFilter.test(mevt)) {
            return;
        }
        this.dialog.setX(mevt.getScreenX() - this.xOffset);
        this.dialog.setY(mevt.getScreenY() - this.yOffset);
    }

    private void dragStart(MouseEvent mevt) {
        if (!this.mouseFilter.test(mevt)) {
            return;
        }
        this.installCursor();
        this.xOffset = mevt.getSceneX();
        this.yOffset = mevt.getSceneY();
    }

    private void uninstallCursor() {
        this.setCursor(this.originalCursor);
    }

    protected static class ExternalStage
    extends Stage {
        private transient double posX = 640.0;
        private transient double posY = 480.0;
        private transient double width = 640.0;
        private transient double height = 480.0;
        private transient boolean maximized;
        private final transient Scene scene = new Scene((Parent)new StackPane(), 640.0, 480.0);

        public ExternalStage() {
            this.setScene(this.scene);
        }

        public void hide(DataViewWindow dataViewWindow) {
            dataViewWindow.invokeListener(new WindowRestoringEvent(dataViewWindow), dataViewWindow.parallelListeners);
            this.titleProperty().unbind();
            this.scene.setRoot((Parent)new StackPane());
            dataViewWindow.setLocalCenter(dataViewWindow.getContent());
            dataViewWindow.getParentView().getUndockedChildren().remove((Object)dataViewWindow);
            dataViewWindow.getParentView().getVisibleChildren().add((Object)dataViewWindow);
            dataViewWindow.invokeListener(new WindowRestoredEvent(dataViewWindow), dataViewWindow.parallelListeners);
        }

        public boolean isMaximised() {
            return this.maximized;
        }

        public void maximizeRestore(DataViewWindow dataViewWindow) {
            if (this.maximized) {
                this.setWidth(this.width);
                this.setHeight(this.height);
                this.setX(this.posX);
                this.setY(this.posY);
                this.maximized = false;
                dataViewWindow.setWindowState(WindowState.WINDOW_RESTORED);
                return;
            }
            Rectangle2D primaryScreenBounds = Screen.getPrimary().getVisualBounds();
            this.width = this.getWidth();
            this.height = this.getHeight();
            this.posX = this.getX();
            this.posY = this.getY();
            this.setX(primaryScreenBounds.getMinX());
            this.setY(primaryScreenBounds.getMinY());
            this.setWidth(primaryScreenBounds.getWidth());
            this.setHeight(primaryScreenBounds.getHeight());
            this.maximized = true;
            dataViewWindow.setWindowState(WindowState.WINDOW_MAXIMISED);
        }

        public void show(DataViewWindow dataViewWindow, MouseEvent mouseEvent) {
            if (this.isShowing()) {
                return;
            }
            if (mouseEvent == null) {
                this.setX(dataViewWindow.getScene().getWindow().getX() + 50.0);
                this.setY(dataViewWindow.getScene().getWindow().getY() + 50.0);
            } else {
                this.setX(mouseEvent.getScreenX());
                this.setY(mouseEvent.getScreenY());
            }
            dataViewWindow.invokeListener(new WindowDetachingEvent(dataViewWindow), dataViewWindow.parallelListeners);
            this.posX = this.getX();
            this.posY = this.getY();
            this.titleProperty().set((Object)dataViewWindow.getName());
            this.titleProperty().bind((ObservableValue)dataViewWindow.nameProperty());
            this.show();
            if (dataViewWindow.equals((Object)dataViewWindow.getParentView().getMaximizedChild())) {
                dataViewWindow.getParentView().setMaximizedChild(null);
            }
            dataViewWindow.getParentView().getMinimisedChildren().remove((Object)dataViewWindow);
            dataViewWindow.getParentView().getVisibleChildren().remove((Object)dataViewWindow);
            dataViewWindow.getParentView().getUndockedChildren().add((Object)dataViewWindow);
            dataViewWindow.setLocalCenter(null);
            Node dataWindowContent = dataViewWindow.getContent();
            if (dataWindowContent.getParent() instanceof Pane) {
                FXUtils.assertJavaFxThread();
                ((Pane)dataWindowContent.getParent()).getChildren().remove((Object)dataWindowContent);
            }
            if (dataWindowContent instanceof Pane) {
                this.scene.setRoot((Parent)((Pane)dataWindowContent));
            } else {
                this.scene.setRoot((Parent)new StackPane(new Node[]{dataWindowContent}));
            }
            dataViewWindow.setWindowState(WindowState.WINDOW_RESTORED);
            dataViewWindow.setDetached(true);
            dataViewWindow.invokeListener(new WindowDetachedEvent(dataViewWindow), dataViewWindow.parallelListeners);
        }

        private String getName() {
            return this.titleProperty().getValue();
        }
    }

    public static enum WindowState {
        WINDOW_RESTORED,
        WINDOW_MINIMISED,
        WINDOW_MAXIMISED,
        WINDOW_CLOSED;

    }

    public static enum WindowDecoration {
        NONE,
        BAR,
        BAR_WO_CLOSE,
        FRAME;

    }
}

