/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.utils;

import de.gsi.chart.utils.NumberFormatter;
import java.text.DecimalFormat;
import javafx.util.StringConverter;

public class ScientificNotationStringConverter
extends StringConverter<Number>
implements NumberFormatter {
    private int precision = 2;
    private final DecimalFormat format = new DecimalFormat();

    public ScientificNotationStringConverter() {
        this.buildFormat(this.precision);
    }

    public ScientificNotationStringConverter(int precision) {
        this.precision = precision;
        this.buildFormat(precision);
    }

    private void buildFormat(int precision) {
        StringBuilder sb = new StringBuilder(32);
        sb.append("0.");
        for (int i = 0; i < precision; ++i) {
            sb.append('0');
        }
        sb.append("E0");
        this.format.applyPattern(sb.toString());
    }

    public Number fromString(String string) {
        return Double.parseDouble(string);
    }

    @Override
    public int getPrecision() {
        return this.precision;
    }

    @Override
    public boolean isExponentialForm() {
        return true;
    }

    @Override
    public NumberFormatter setExponentialForm(boolean state) {
        return this;
    }

    @Override
    public NumberFormatter setPrecision(int precision) {
        this.precision = precision;
        this.buildFormat(precision);
        return this;
    }

    @Override
    public String toString(double val) {
        return this.toString((Number)val);
    }

    public String toString(Number object) {
        return this.format.format(object);
    }
}

