/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.utils;

import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import java.util.function.Supplier;
import javafx.application.Platform;
import javafx.scene.Scene;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FXUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(FXUtils.class);

    public static void assertJavaFxThread() {
        if (!Platform.isFxApplicationThread()) {
            throw new IllegalStateException("access JavaFX from non-JavaFX thread - please fix");
        }
    }

    public static void keepJavaFxAlive() {
        Platform.setImplicitExit((boolean)false);
    }

    public static void runAndWait(Runnable function) throws Exception {
        FXUtils.runAndWait("runAndWait(Runnable)", t -> {
            function.run();
            return "FXUtils::runAndWait - null Runnable return";
        });
    }

    public static <R> R runAndWait(Supplier<R> function) throws Exception {
        return (R)FXUtils.runAndWait("runAndWait(Supplier<R>)", t -> function.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T, R> R runAndWait(T argument, Function<T, R> function) throws Exception {
        if (Platform.isFxApplicationThread()) {
            return function.apply(argument);
        }
        AtomicBoolean runCondition = new AtomicBoolean(true);
        ReentrantLock lock = new ReentrantLock();
        Condition condition = lock.newCondition();
        ExceptionWrapper throwableWrapper = new ExceptionWrapper();
        RunnableWithReturn<Object> run = new RunnableWithReturn<Object>(() -> {
            Object returnValue = null;
            lock.lock();
            try {
                returnValue = function.apply(argument);
            }
            catch (Exception e) {
                throwableWrapper.t = e;
            }
            finally {
                try {
                    runCondition.set(false);
                    condition.signal();
                }
                finally {
                    runCondition.set(false);
                    lock.unlock();
                }
            }
            return returnValue;
        });
        lock.lock();
        try {
            Platform.runLater(run);
            while (runCondition.get()) {
                condition.await();
            }
            if (throwableWrapper.t != null) {
                throw throwableWrapper.t;
            }
        }
        finally {
            lock.unlock();
        }
        return (R)run.getReturnValue();
    }

    public static void runFX(Runnable run) {
        FXUtils.keepJavaFxAlive();
        if (Platform.isFxApplicationThread()) {
            run.run();
        } else {
            Platform.runLater((Runnable)run);
        }
    }

    public static boolean waitForFxTicks(Scene scene, int nTicks) {
        return FXUtils.waitForFxTicks(scene, nTicks, -1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean waitForFxTicks(Scene scene, int nTicks, long timeoutMillis) {
        if (Platform.isFxApplicationThread()) {
            for (int i = 0; i < nTicks; ++i) {
                Platform.requestNextPulse();
            }
            return true;
        }
        Timer timer = new Timer("FXUtils-thread", true);
        final AtomicBoolean run = new AtomicBoolean(true);
        AtomicInteger tickCount = new AtomicInteger(0);
        final ReentrantLock lock = new ReentrantLock();
        final Condition condition = lock.newCondition();
        Runnable tickListener = () -> {
            if (tickCount.incrementAndGet() >= nTicks) {
                lock.lock();
                try {
                    run.getAndSet(false);
                    condition.signal();
                }
                finally {
                    run.getAndSet(false);
                    lock.unlock();
                }
            }
            Platform.requestNextPulse();
        };
        lock.lock();
        try {
            FXUtils.runAndWait(() -> scene.addPostLayoutPulseListener(tickListener));
        }
        catch (Exception e) {
            LOGGER.atError().setCause((Throwable)e).log("addPostLayoutPulseListener interrupted");
        }
        try {
            Platform.requestNextPulse();
            if (timeoutMillis > 0L) {
                timer.schedule(new TimerTask(){

                    @Override
                    public void run() {
                        LOGGER.atWarn().log("FXUtils::waitForTicks(..) interrupted by timeout");
                        lock.lock();
                        try {
                            run.getAndSet(false);
                            condition.signal();
                        }
                        finally {
                            run.getAndSet(false);
                            lock.unlock();
                        }
                    }
                }, timeoutMillis);
            }
            while (run.get()) {
                condition.await();
            }
        }
        catch (InterruptedException e) {
            LOGGER.atError().setCause((Throwable)e).log("await interrupted");
        }
        finally {
            lock.unlock();
            timer.cancel();
        }
        try {
            FXUtils.runAndWait(() -> scene.removePostLayoutPulseListener(tickListener));
        }
        catch (Exception e) {
            LOGGER.atError().setCause((Throwable)e).log("removePostLayoutPulseListener interrupted");
        }
        return tickCount.get() >= nTicks;
    }

    private static class RunnableWithReturn<R>
    implements Runnable {
        private final Supplier<R> internalRunnable;
        private final Object lock = new Object();
        private R returnValue;

        public RunnableWithReturn(Supplier<R> run) {
            this.internalRunnable = run;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public R getReturnValue() {
            Object object = this.lock;
            synchronized (object) {
                return this.returnValue;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = this.lock;
            synchronized (object) {
                this.returnValue = this.internalRunnable.get();
            }
        }
    }

    private static class ExceptionWrapper {
        private Exception t;

        private ExceptionWrapper() {
        }
    }
}

