/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.utils;

import de.gsi.chart.axes.Axis;
import java.util.ArrayList;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;

public class AxisSynchronizer {
    private boolean updating;
    private final ArrayList<Axis> axes = new ArrayList();
    private final ChangeListener<Number> upperBoundChangeListener = this::upperBoundChanged;
    private final ChangeListener<Number> lowerBoundChangeListener = this::lowerBoundChanged;

    public void add(Axis axis) {
        this.axes.add(axis);
        axis.maxProperty().addListener(this.upperBoundChangeListener);
        axis.minProperty().addListener(this.lowerBoundChangeListener);
    }

    private Axis findAxis(ObservableValue<? extends Number> property) {
        for (Axis chart : this.axes) {
            if (property == chart.maxProperty()) {
                return chart;
            }
            if (property != chart.minProperty()) continue;
            return chart;
        }
        return null;
    }

    private void lowerBoundChanged(ObservableValue<? extends Number> property, Number oldValue, Number newValue) {
        if (!this.updating) {
            double value = newValue.doubleValue();
            if (Double.isNaN(value)) {
                return;
            }
            if (value == oldValue.doubleValue()) {
                return;
            }
            this.updating = true;
            Axis sender = this.findAxis(property);
            if (sender == null) {
                this.updating = false;
                return;
            }
            double tickUnit = sender.getTickUnit();
            for (Axis axis : this.axes) {
                if (axis != sender) {
                    axis.setMin(value);
                    axis.setAutoRanging(false);
                }
                axis.setTickUnit(tickUnit);
            }
            this.updating = false;
        }
    }

    public void remove(Axis axis) {
        this.axes.remove(axis);
        axis.maxProperty().removeListener(this.upperBoundChangeListener);
        axis.minProperty().removeListener(this.lowerBoundChangeListener);
        axis.setAutoRanging(true);
    }

    private void upperBoundChanged(ObservableValue<? extends Number> property, Number oldValue, Number newValue) {
        if (!this.updating) {
            double value = newValue.doubleValue();
            if (Double.isNaN(value)) {
                return;
            }
            if (value == oldValue.doubleValue()) {
                return;
            }
            this.updating = true;
            Axis sender = this.findAxis(property);
            if (sender == null) {
                this.updating = false;
                return;
            }
            double tickUnit = sender.getTickUnit();
            for (Axis axis : this.axes) {
                if (axis != sender) {
                    axis.setAutoRanging(false);
                    axis.setMax(value);
                }
                axis.setTickUnit(tickUnit);
            }
            this.updating = false;
        }
    }
}

