/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.ui;

import de.gsi.chart.ui.SidesPane;
import de.gsi.chart.ui.geometry.Side;
import java.security.InvalidParameterException;
import javafx.animation.Animation;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.InvalidationListener;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.control.Control;
import javafx.scene.control.SkinBase;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.Region;
import javafx.scene.shape.Rectangle;
import javafx.util.Duration;

public class SidesPaneSkin
extends SkinBase<SidesPane> {
    private final BorderPane borderPane = new BorderPane();
    private final EventHandler<MouseEvent> exitedHandler;
    private boolean mousePressed;
    private final DoubleProperty[] visibility = new SimpleDoubleProperty[Side.values().length];
    private final Timeline[] showTimeline = new Timeline[Side.values().length];
    private final Timeline[] hideTimeline = new Timeline[Side.values().length];

    public SidesPaneSkin(SidesPane pane) {
        super((Control)pane);
        this.exitedHandler = event -> {
            if (this.isMouseEnabled() && !this.mousePressed) {
                for (Side s : Side.values()) {
                    if (((SidesPane)this.getSkinnable()).isPinned(s).booleanValue()) continue;
                    this.hide(s);
                }
            }
        };
        this.getChildren().add((Object)this.borderPane);
        this.updateBorderPane();
        InvalidationListener rebuildListener = observable -> this.updateBorderPane();
        pane.contentProperty().addListener(rebuildListener);
        pane.topProperty().addListener(rebuildListener);
        pane.rightProperty().addListener(rebuildListener);
        pane.bottomProperty().addListener(rebuildListener);
        pane.leftProperty().addListener(rebuildListener);
        pane.addEventFilter(MouseEvent.MOUSE_MOVED, event -> {
            if (this.isMouseEnabled()) {
                Side side = this.getSide((MouseEvent)event);
                if (side != null) {
                    this.show(side);
                } else if (this.isMouseMovedOutsideSides((MouseEvent)event)) {
                    for (Side s : Side.values()) {
                        if (((SidesPane)this.getSkinnable()).isPinned(s).booleanValue()) continue;
                        this.hide(s);
                    }
                }
            }
        });
        pane.addEventFilter(MouseEvent.MOUSE_EXITED, this.exitedHandler);
        pane.addEventFilter(MouseEvent.MOUSE_PRESSED, event -> {
            this.mousePressed = true;
        });
        pane.addEventFilter(MouseEvent.MOUSE_RELEASED, event -> {
            Side side;
            this.mousePressed = false;
            if (this.isMouseEnabled() && (side = this.getSide((MouseEvent)event)) != null) {
                this.show(side);
            }
        });
        for (Side side : Side.values()) {
            this.visibility[side.ordinal()] = new SimpleDoubleProperty(0.0);
            this.visibility[side.ordinal()].addListener(observable -> ((SidesPane)this.getSkinnable()).requestLayout());
        }
        for (Side side : Side.values()) {
            if (!((SidesPane)this.getSkinnable()).isPinned(side).booleanValue()) continue;
            this.show(side);
        }
        pane.pinnedSideProperty().addListener(change -> {
            for (Side side : Side.values()) {
                if (((SidesPane)this.getSkinnable()).isPinned(side).booleanValue()) {
                    this.show(side);
                    continue;
                }
                this.hide(side);
            }
        });
        Rectangle clip = new Rectangle();
        clip.setX(0.0);
        clip.setY(0.0);
        clip.widthProperty().bind((ObservableValue)((SidesPane)this.getSkinnable()).widthProperty());
        clip.heightProperty().bind((ObservableValue)((SidesPane)this.getSkinnable()).heightProperty());
        ((SidesPane)this.getSkinnable()).setClip((Node)clip);
    }

    private Side getSide(MouseEvent evt) {
        if (this.borderPane.getBoundsInLocal().contains(evt.getX(), evt.getY())) {
            double trigger = ((SidesPane)this.getSkinnable()).getTriggerDistance();
            if (evt.getX() <= trigger && ((SidesPane)this.getSkinnable()).getLeft() != null) {
                return Side.LEFT;
            }
            if (evt.getX() > ((SidesPane)this.getSkinnable()).getWidth() - trigger && ((SidesPane)this.getSkinnable()).getRight() != null) {
                return Side.RIGHT;
            }
            if (evt.getY() <= trigger && ((SidesPane)this.getSkinnable()).getTop() != null) {
                return Side.TOP;
            }
            if (evt.getY() > ((SidesPane)this.getSkinnable()).getHeight() - trigger && ((SidesPane)this.getSkinnable()).getBottom() != null) {
                return Side.BOTTOM;
            }
        }
        return null;
    }

    private void hide(Side side) {
        boolean sideVisible;
        if (this.showTimeline[side.ordinal()] != null) {
            this.showTimeline[side.ordinal()].stop();
        }
        if (this.hideTimeline[side.ordinal()] != null && this.hideTimeline[side.ordinal()].getStatus() == Animation.Status.RUNNING) {
            return;
        }
        boolean bl = sideVisible = this.visibility[side.ordinal()].get() > 0.0;
        if (!sideVisible) {
            return;
        }
        KeyValue[] keyValues = new KeyValue[Side.values().length];
        keyValues[side.ordinal()] = new KeyValue((WritableValue)this.visibility[side.ordinal()], (Object)0);
        Duration delay = ((SidesPane)this.getSkinnable()).getAnimationDelay() != null ? ((SidesPane)this.getSkinnable()).getAnimationDelay() : Duration.millis((double)300.0);
        Duration duration = ((SidesPane)this.getSkinnable()).getAnimationDuration() != null ? ((SidesPane)this.getSkinnable()).getAnimationDuration() : Duration.millis((double)200.0);
        KeyFrame keyFrame = new KeyFrame(duration, keyValues);
        this.hideTimeline[side.ordinal()] = new Timeline(new KeyFrame[]{keyFrame});
        this.hideTimeline[side.ordinal()].setDelay(delay);
        this.hideTimeline[side.ordinal()].play();
    }

    private boolean isMouseEnabled() {
        return ((SidesPane)this.getSkinnable()).getTriggerDistance() > 0.0;
    }

    private boolean isMouseMovedOutsideSides(MouseEvent event) {
        return !(((SidesPane)this.getSkinnable()).getLeft() != null && ((SidesPane)this.getSkinnable()).getLeft().getBoundsInParent().contains(event.getX(), event.getY()) || ((SidesPane)this.getSkinnable()).getTop() != null && ((SidesPane)this.getSkinnable()).getTop().getBoundsInParent().contains(event.getX(), event.getY()) || ((SidesPane)this.getSkinnable()).getRight() != null && ((SidesPane)this.getSkinnable()).getRight().getBoundsInParent().contains(event.getX(), event.getY()) || ((SidesPane)this.getSkinnable()).getBottom() != null && ((SidesPane)this.getSkinnable()).getBottom().getBoundsInParent().contains(event.getX(), event.getY()));
    }

    protected void layoutChildren(double contentX, double contentY, double contentWidth, double contentHeight) {
        Node top;
        Node right;
        Node left;
        super.layoutChildren(contentX, contentY, contentWidth, contentHeight);
        Node bottom = ((SidesPane)this.getSkinnable()).getBottom();
        if (bottom != null) {
            double prefHeight = ((SidesPane)this.getSkinnable()).prefHeightBottomProperty().get();
            if (bottom.prefHeight(-1.0) > 0.0) {
                ((SidesPane)this.getSkinnable()).prefHeightBottomProperty().set(Math.max(bottom.prefHeight(-1.0), prefHeight));
            }
            double offset = prefHeight * this.visibility[Side.BOTTOM.ordinal()].get();
            bottom.setVisible(this.visibility[Side.BOTTOM.ordinal()].get() > 0.0);
            SidesPaneSkin.setPrefHeight(bottom, offset);
        }
        if ((left = ((SidesPane)this.getSkinnable()).getLeft()) != null) {
            double prefWidth = ((SidesPane)this.getSkinnable()).prefWidthLeftProperty().get();
            if (left.prefWidth(-1.0) > 0.0) {
                ((SidesPane)this.getSkinnable()).prefWidthLeftProperty().set(Math.max(left.prefWidth(-1.0), prefWidth));
            }
            double offset = prefWidth * this.visibility[Side.LEFT.ordinal()].get();
            left.setVisible(this.visibility[Side.LEFT.ordinal()].get() > 0.0);
            SidesPaneSkin.setPrefWidth(left, offset);
        }
        if ((right = ((SidesPane)this.getSkinnable()).getRight()) != null) {
            double prefWidth = ((SidesPane)this.getSkinnable()).prefWidthRightProperty().get();
            if (right.prefWidth(-1.0) > 0.0) {
                ((SidesPane)this.getSkinnable()).prefWidthRightProperty().set(Math.max(right.prefWidth(-1.0), prefWidth));
            }
            double offset = prefWidth * this.visibility[Side.RIGHT.ordinal()].get();
            right.setVisible(this.visibility[Side.RIGHT.ordinal()].get() > 0.0);
            SidesPaneSkin.setPrefWidth(right, offset);
        }
        if ((top = ((SidesPane)this.getSkinnable()).getTop()) != null) {
            double prefHeight = ((SidesPane)this.getSkinnable()).prefHeightTopProperty().get();
            if (top.prefHeight(-1.0) > 0.0) {
                ((SidesPane)this.getSkinnable()).prefHeightTopProperty().set(Math.max(top.prefHeight(-1.0), prefHeight));
            }
            double offset = prefHeight * this.visibility[Side.TOP.ordinal()].get();
            top.setVisible(this.visibility[Side.TOP.ordinal()].get() > 0.0);
            top.setClip((Node)new Rectangle(contentWidth, offset));
            SidesPaneSkin.setPrefHeight(top, offset);
        }
    }

    private void show(Side side) {
        if (this.hideTimeline[side.ordinal()] != null) {
            this.hideTimeline[side.ordinal()].stop();
        }
        if (this.showTimeline[side.ordinal()] != null && this.showTimeline[side.ordinal()].getStatus() == Animation.Status.RUNNING) {
            return;
        }
        KeyValue[] keyValues = new KeyValue[Side.values().length];
        keyValues[side.ordinal()] = new KeyValue((WritableValue)this.visibility[side.ordinal()], (Object)1);
        Duration delay = ((SidesPane)this.getSkinnable()).getAnimationDelay() != null ? ((SidesPane)this.getSkinnable()).getAnimationDelay() : Duration.millis((double)300.0);
        Duration duration = ((SidesPane)this.getSkinnable()).getAnimationDuration() != null ? ((SidesPane)this.getSkinnable()).getAnimationDuration() : Duration.millis((double)200.0);
        KeyFrame keyFrame = new KeyFrame(duration, keyValues);
        this.showTimeline[side.ordinal()] = new Timeline(new KeyFrame[]{keyFrame});
        this.showTimeline[side.ordinal()].setDelay(delay);
        this.showTimeline[side.ordinal()].play();
    }

    private void updateBorderPane() {
        this.borderPane.getChildren().clear();
        if (((SidesPane)this.getSkinnable()).getContent() != null) {
            this.borderPane.setCenter(((SidesPane)this.getSkinnable()).getContent());
        }
        if (((SidesPane)this.getSkinnable()).getTop() != null) {
            this.borderPane.setTop(((SidesPane)this.getSkinnable()).getTop());
            ((SidesPane)this.getSkinnable()).getTop().setManaged(true);
            ((SidesPane)this.getSkinnable()).getTop().removeEventFilter(MouseEvent.MOUSE_EXITED, this.exitedHandler);
            ((SidesPane)this.getSkinnable()).getTop().addEventFilter(MouseEvent.MOUSE_EXITED, this.exitedHandler);
        }
        if (((SidesPane)this.getSkinnable()).getRight() != null) {
            this.borderPane.setRight(((SidesPane)this.getSkinnable()).getRight());
            ((SidesPane)this.getSkinnable()).getRight().setManaged(true);
            ((SidesPane)this.getSkinnable()).getRight().removeEventFilter(MouseEvent.MOUSE_EXITED, this.exitedHandler);
            ((SidesPane)this.getSkinnable()).getRight().addEventFilter(MouseEvent.MOUSE_EXITED, this.exitedHandler);
        }
        if (((SidesPane)this.getSkinnable()).getBottom() != null) {
            this.borderPane.setBottom(((SidesPane)this.getSkinnable()).getBottom());
            ((SidesPane)this.getSkinnable()).getBottom().setManaged(true);
            ((SidesPane)this.getSkinnable()).getBottom().removeEventFilter(MouseEvent.MOUSE_EXITED, this.exitedHandler);
            ((SidesPane)this.getSkinnable()).getBottom().addEventFilter(MouseEvent.MOUSE_EXITED, this.exitedHandler);
        }
        if (((SidesPane)this.getSkinnable()).getLeft() != null) {
            this.borderPane.setLeft(((SidesPane)this.getSkinnable()).getLeft());
            ((SidesPane)this.getSkinnable()).getLeft().setManaged(true);
            ((SidesPane)this.getSkinnable()).getLeft().removeEventFilter(MouseEvent.MOUSE_EXITED, this.exitedHandler);
            ((SidesPane)this.getSkinnable()).getLeft().addEventFilter(MouseEvent.MOUSE_EXITED, this.exitedHandler);
        }
    }

    private static void setPrefHeight(Node node, double prefHeight) {
        if (node instanceof Region) {
            ((Region)node).setPrefHeight(prefHeight);
            return;
        }
        if (node instanceof Canvas) {
            ((Canvas)node).setHeight(prefHeight);
            return;
        }
        throw new InvalidParameterException("no prefHeight for class type:" + node.getClass().getCanonicalName());
    }

    private static void setPrefWidth(Node node, double prefWidth) {
        if (node instanceof Region) {
            ((Region)node).setPrefWidth(prefWidth);
            return;
        }
        if (node instanceof Canvas) {
            ((Canvas)node).setWidth(prefWidth);
            return;
        }
        throw new InvalidParameterException("no prefWidth for class type:" + node.getClass().getCanonicalName());
    }
}

