/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.ui;

import de.gsi.chart.ui.SidesPane;
import de.gsi.chart.ui.geometry.Side;
import javafx.application.Application;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.stage.Stage;

public class SidesPaneSample
extends Application {
    protected static final int SHUTDOWN_PERIOD = 5000;
    protected static final int UPDATE_PERIOD = 100;

    public void start(Stage stage) {
        stage.setTitle("TitledPane");
        Label label = new Label("top content\ntop content");
        Pane topContent = new Pane(new Node[]{label});
        topContent.setStyle("-fx-background-color: rgba(0,255,0,0.2)");
        Pane leftContent = new Pane(new Node[]{new Label("left content")});
        leftContent.setStyle("-fx-background-color: rgba(255,0,0,0.2)");
        Button button1 = new Button("press me to shrink");
        button1.setOnAction(evt -> topContent.setPrefHeight(50.0));
        Button button2 = new Button("press me to enlarge");
        button2.setOnAction(evt -> topContent.setPrefHeight(100.0));
        Pane mainContent = new Pane(new Node[]{new HBox(new Node[]{new Label("main content"), button1, button2})});
        SidesPane pane = new SidesPane();
        pane.setTriggerDistance(50.0);
        Scene scene = new Scene((Parent)pane, 800.0, 600.0);
        pane.setTop((Node)topContent);
        pane.setLeft((Node)leftContent);
        pane.setContent((Node)mainContent);
        topContent.setOnMouseClicked(mevt -> {
            boolean isPinned = pane.isPinned(Side.TOP) == false;
            pane.setPinned(Side.TOP, isPinned);
            label.textProperty().set((Object)String.format("top content(%b)%ntop content(%b)", isPinned, isPinned));
        });
        stage.setScene(scene);
        stage.show();
    }

    public static void main(String[] args) {
        Application.launch((String[])args);
    }
}

