/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.renderer.spi.utils;

import de.gsi.dataset.utils.AssertUtils;
import java.util.WeakHashMap;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.image.Image;
import javafx.scene.image.WritableImage;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.paint.ImagePattern;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Line;

public final class FillPatternStyleHelper {
    private static final int HATCH_WINDOW_SIZE = 8;
    private static int hatchSpacing = 10;
    private static int hatchAngle = 45;
    protected static WeakHashMap<Color, ImagePattern> defaultHatchCache = new WeakHashMap();
    protected static WeakHashMap<Paint, WeakHashMap<Double, Image>> defaultHatchCacheWithStrokeWidth = new WeakHashMap();

    private static Image createDefaultHatch(Paint color, double strokeWidth) {
        Image val;
        WeakHashMap<Double, Image> checkCache = defaultHatchCacheWithStrokeWidth.get(color);
        if (checkCache != null && (val = checkCache.get(strokeWidth)) != null) {
            return val;
        }
        Pane pane = new Pane();
        pane.setPrefSize(10.0, 10.0);
        Line fw = new Line(-5.0, -5.0, 25.0, 25.0);
        Line bw = new Line(-5.0, 25.0, 25.0, -5.0);
        fw.setSmooth(false);
        bw.setSmooth(false);
        fw.setStroke(color);
        bw.setStroke(color);
        fw.setStrokeWidth(strokeWidth);
        bw.setStrokeWidth(strokeWidth);
        pane.getChildren().addAll((Object[])new Node[]{fw, bw});
        pane.setStyle("-fx-background-color: rgba(0, 0, 0, 0.0)");
        Scene scene = new Scene((Parent)pane);
        scene.setFill((Paint)Color.TRANSPARENT);
        WritableImage retVal = pane.snapshot(null, null);
        if (checkCache == null) {
            WeakHashMap<Double, WritableImage> temp = new WeakHashMap<Double, WritableImage>();
            temp.put(strokeWidth, retVal);
            defaultHatchCacheWithStrokeWidth.put(color, temp);
        } else {
            checkCache.put(strokeWidth, (Image)retVal);
        }
        return retVal;
    }

    private static Image createHatch(FillPattern fillPattern, Paint color, double strokeWidth) {
        Pane pane = new Pane();
        pane.setPrefSize(8.0, 8.0);
        pane.setStyle("-fx-background-color: rgba(0, 0, 0, 0.0)");
        int hatchAngle = 45;
        int windowSize = 40;
        FillPatternStyleHelper.drawHatching(pane, fillPattern, -40, -40, 40, 40, color, strokeWidth, 45, hatchSpacing);
        Scene scene = new Scene((Parent)pane);
        scene.setFill((Paint)Color.TRANSPARENT);
        return pane.snapshot(null, null);
    }

    private static void drawHatching(Pane pane, FillPattern fillPattern, int minx, int miny, int maxx, int maxy, Paint color, double strokeWidth, int setHatchAngle, int hatchSpacing) {
        int hatchAngle = setHatchAngle;
        switch (fillPattern) {
            case HATCH0: {
                hatchAngle = 0;
                break;
            }
            case HATCH30: {
                hatchAngle = 30;
                break;
            }
            case HATCH45: 
            case HATCHCROSS1: {
                hatchAngle = 45;
                break;
            }
            case HATCH60: {
                hatchAngle = 60;
                break;
            }
            case HATCH90: 
            case HATCHCROSS2: {
                hatchAngle = 90;
                break;
            }
        }
        if (fillPattern != FillPattern.HATCHCROSS1 && fillPattern != FillPattern.HATCHCROSS2) {
            int step = hatchSpacing;
            int diff = (maxy - miny) / 2;
            int center = miny + diff;
            if (hatchAngle % 180 != 0 && (hatchAngle + 90) % 180 != 0) {
                double sin = Math.sin(Math.PI * (double)hatchAngle / 180.0);
                double cos = Math.cos(Math.PI * (double)hatchAngle / 180.0);
                step = (int)((double)hatchSpacing / cos);
                int dx = (int)((double)diff / cos);
                int dy = (int)((double)diff / sin);
                for (int i = minx - dx; i < maxx + dx; i += step) {
                    int x1 = i - dx;
                    int x2 = i + dx;
                    int y1 = center + dy;
                    int y2 = center - dy;
                    Line line = new Line((double)x1, (double)y1, (double)x2, (double)y2);
                    line.setStroke(color);
                    line.setStrokeWidth(strokeWidth);
                    pane.getChildren().add((Object)line);
                }
            } else if (hatchAngle % 180 != 0) {
                int y1 = center + diff;
                int y2 = center - diff;
                for (int i = minx; i < maxx; i += step) {
                    Line line = new Line((double)i, (double)y1, (double)i, (double)y2);
                    line.setStroke(color);
                    line.setStrokeWidth(strokeWidth);
                    pane.getChildren().add((Object)line);
                }
            } else {
                int x1 = minx;
                int x2 = maxx;
                for (int i = miny; i < maxy; i += step) {
                    Line line = new Line((double)x1, (double)i, (double)x2, (double)i);
                    line.setStroke(color);
                    line.setStrokeWidth(strokeWidth);
                    pane.getChildren().add((Object)line);
                }
            }
        } else if (fillPattern == FillPattern.HATCHCROSS1) {
            hatchAngle = 45;
            int diff = (maxy - miny) / 2;
            int center = miny + diff;
            double sin = Math.sin(Math.PI * (double)hatchAngle / 180.0);
            double cos = Math.cos(Math.PI * (double)hatchAngle / 180.0);
            int step = (int)((double)hatchSpacing / cos);
            int dx = (int)((double)diff / cos);
            int dy = (int)((double)diff / sin);
            for (int i = minx - dx; i < maxx + dx; i += step) {
                Line line = new Line((double)(i - dx), (double)(center + dy), (double)(i + dx), (double)(center - dy));
                line.setStroke(color);
                line.setStrokeWidth(strokeWidth);
                pane.getChildren().add((Object)line);
                line = new Line((double)(i + dx), (double)(center + dy), (double)(i - dx), (double)(center - dy));
                line.setStroke(color);
                line.setStrokeWidth(strokeWidth);
                pane.getChildren().add((Object)line);
            }
        } else {
            hatchAngle = 0;
            int step = hatchSpacing;
            int diff = (maxy - miny) / 2;
            int center = miny + diff;
            int y1 = center + diff;
            int y2 = center - diff;
            for (int i = minx; i < maxx; i += step) {
                Line line = new Line((double)i, (double)y1, (double)i, (double)y2);
                line.setStroke(color);
                line.setStrokeWidth(strokeWidth);
            }
            int x1 = minx;
            int x2 = maxx;
            for (int i = miny; i < maxy; i += step) {
                Line line = new Line((double)x1, (double)i, (double)x2, (double)i);
                line.setStroke(color);
                line.setStrokeWidth(strokeWidth);
            }
        }
    }

    public static ImagePattern getDefaultHatch(Color color) {
        ImagePattern retVal = defaultHatchCache.get(color);
        if (retVal == null) {
            retVal = FillPatternStyleHelper.getDefaultHatch((Paint)color, 0.0);
            defaultHatchCache.put(color, retVal);
        }
        return retVal;
    }

    public static ImagePattern getDefaultHatch(Paint color, double xOffset) {
        return new ImagePattern(FillPatternStyleHelper.createDefaultHatch(color, 1.0), xOffset, xOffset, 8.0, 8.0, false);
    }

    public static int getDefaultHatchAngle() {
        return hatchAngle;
    }

    public static int getDefaultHatchSpacing() {
        return hatchSpacing;
    }

    public static ImagePattern getHatch(FillPattern fillPattern, Paint color) {
        return FillPatternStyleHelper.getHatch(fillPattern, color, 1.0);
    }

    public static ImagePattern getHatch(FillPattern fillPattern, Paint color, double width) {
        Image hatch = FillPatternStyleHelper.createHatch(fillPattern, color, width);
        return new ImagePattern(hatch, 0.0, 0.0, 8.0, 8.0, false);
    }

    public static void setDefaultHatchAngle(int angle) {
        AssertUtils.gtEqThanZero((String)"setDefaultHatchSpacing", (int)angle);
        hatchAngle = angle;
    }

    public static void setDefaultHatchSpacing(int spacing) {
        AssertUtils.gtEqThanZero((String)"setDefaultHatchSpacing", (int)spacing);
        hatchSpacing = spacing;
    }

    public static enum FillPattern {
        SOLID,
        HATCH,
        HATCH0,
        HATCH30,
        HATCH45,
        HATCH60,
        HATCH90,
        HATCHCROSS1,
        HATCHCROSS2;

    }
}

