/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.renderer.spi;

import de.gsi.chart.Chart;
import de.gsi.chart.axes.Axis;
import de.gsi.chart.axes.spi.CategoryAxis;
import de.gsi.chart.renderer.LineStyle;
import de.gsi.chart.renderer.Renderer;
import de.gsi.chart.renderer.spi.AbstractErrorDataSetRendererParameter;
import de.gsi.chart.renderer.spi.utils.BezierCurve;
import de.gsi.chart.renderer.spi.utils.DefaultRenderColorScheme;
import de.gsi.chart.utils.StyleParser;
import de.gsi.dataset.DataSet;
import de.gsi.dataset.Histogram;
import de.gsi.dataset.spi.LimitedIndexedTreeDataSet;
import de.gsi.dataset.utils.DoubleArrayCache;
import de.gsi.dataset.utils.ProcessingProfiler;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javafx.animation.AnimationTimer;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.ObservableList;
import javafx.geometry.Orientation;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;

public class HistogramRenderer
extends AbstractErrorDataSetRendererParameter<HistogramRenderer>
implements Renderer {
    private final BooleanProperty animate = new SimpleBooleanProperty((Object)this, "animate", false);
    private final BooleanProperty autoSorting = new SimpleBooleanProperty((Object)this, "autoSorting", true);
    private final ObjectProperty<Chart> chartProperty = new SimpleObjectProperty((Object)this, "chartProperty", null);
    private final BooleanProperty roundedCorner = new SimpleBooleanProperty((Object)this, "roundedCorner", true);
    private final IntegerProperty roundedCornerRadius = new SimpleIntegerProperty((Object)this, "roundedCornerRadius", 10);
    private final Map<String, Double> scaling = new ConcurrentHashMap<String, Double>();
    private final AnimationTimer timer = new MyTimer();
    private final List<DataSet> localDataSetList = new ArrayList<DataSet>();

    public HistogramRenderer() {
        this.setPolyLineStyle(LineStyle.HISTOGRAM_FILLED);
    }

    public BooleanProperty animateProperty() {
        return this.animate;
    }

    public BooleanProperty autoSortingProperty() {
        return this.autoSorting;
    }

    public ObjectProperty<Chart> chartProperty() {
        return this.chartProperty;
    }

    @Override
    public Canvas drawLegendSymbol(DataSet dataSet, int dsIndex, int width, int height) {
        Canvas canvas = new Canvas((double)width, (double)height);
        GraphicsContext gc = canvas.getGraphicsContext2D();
        String style = dataSet.getStyle();
        Integer layoutOffset = StyleParser.getIntegerPropertyValue(style, "dsLayoutOffset");
        Integer dsIndexLocal = StyleParser.getIntegerPropertyValue(style, "dsIndex");
        int dsLayoutIndexOffset = layoutOffset == null ? 0 : layoutOffset;
        int plotingIndex = dsLayoutIndexOffset + (dsIndexLocal == null ? dsIndex : dsIndexLocal);
        gc.save();
        DefaultRenderColorScheme.setLineScheme(gc, dataSet.getStyle(), plotingIndex);
        DefaultRenderColorScheme.setGraphicsContextAttributes(gc, dataSet.getStyle());
        DefaultRenderColorScheme.setFillScheme(gc, dataSet.getStyle(), plotingIndex);
        double y = (double)height / 2.0;
        gc.fillRect(1.0, 1.0, (double)width - 2.0, (double)height - 2.0);
        gc.strokeLine(1.0, y, (double)width - 2.0, y);
        gc.restore();
        return canvas;
    }

    public Chart getChart() {
        return (Chart)((Object)this.chartProperty().get());
    }

    public int getRoundedCornerRadius() {
        return this.roundedCornerRadiusProperty().get();
    }

    public boolean isAnimate() {
        return this.animateProperty().get();
    }

    public boolean isAutoSorting() {
        return this.autoSortingProperty().get();
    }

    public boolean isRoundedCorner() {
        return this.roundedCornerProperty().get();
    }

    @Override
    public List<DataSet> render(GraphicsContext gc, Chart chart, int dataSetOffset, ObservableList<DataSet> datasets) {
        long start = ProcessingProfiler.getTimeStamp();
        this.setChartChart(chart);
        Axis xAxis = this.getFirstAxis(Orientation.HORIZONTAL);
        Axis yAxis = this.getFirstAxis(Orientation.VERTICAL);
        this.localDataSetList.clear();
        this.localDataSetList.addAll((Collection<DataSet>)datasets);
        this.localDataSetList.addAll((Collection<DataSet>)super.getDatasets());
        int i = 0;
        while (i < this.localDataSetList.size()) {
            DataSet dataSet = this.localDataSetList.get(i);
            int index = i++;
            dataSet.lock().readLockGuardOptimistic(() -> {
                CategoryAxis axis;
                if (!(dataSet instanceof Histogram) && this.isAutoSorting() && !HistogramRenderer.isDataSetSorted(dataSet, 0) && !HistogramRenderer.isDataSetSorted(dataSet, 1)) {
                    LimitedIndexedTreeDataSet newDataSet = new LimitedIndexedTreeDataSet(dataSet.getName(), Integer.MAX_VALUE);
                    newDataSet.set(dataSet);
                    this.localDataSetList.set(index, (DataSet)newDataSet);
                }
                if (index != 0) {
                    return;
                }
                if (xAxis instanceof CategoryAxis) {
                    axis = (CategoryAxis)xAxis;
                    axis.updateCategories(dataSet);
                }
                if (yAxis instanceof CategoryAxis) {
                    axis = (CategoryAxis)yAxis;
                    axis.updateCategories(dataSet);
                }
            });
        }
        this.drawHistograms(gc, this.localDataSetList, xAxis, yAxis, dataSetOffset);
        this.drawBars(gc, this.localDataSetList, xAxis, yAxis, dataSetOffset, true);
        if (this.isAnimate()) {
            this.timer.start();
        }
        ProcessingProfiler.getTimeDiff((long)start);
        return this.localDataSetList;
    }

    public void requestLayout() {
        Chart chart = this.getChart();
        if (chart == null) {
            return;
        }
        chart.requestLayout();
    }

    public BooleanProperty roundedCornerProperty() {
        return this.roundedCorner;
    }

    public IntegerProperty roundedCornerRadiusProperty() {
        return this.roundedCornerRadius;
    }

    public void setAnimate(boolean animate) {
        this.animateProperty().set(animate);
    }

    public void setAutoSorting(boolean autoSorting) {
        this.autoSortingProperty().set(autoSorting);
    }

    public void setChartChart(Chart chartProperty) {
        this.chartProperty().set((Object)chartProperty);
    }

    public void setRoundedCorner(boolean roundedCorner) {
        this.roundedCornerProperty().set(roundedCorner);
    }

    public void setRoundedCornerRadius(int roundedCornerRadius) {
        this.roundedCornerRadius.set(roundedCornerRadius);
    }

    protected void drawBars(GraphicsContext gc, List<DataSet> dataSets, Axis xAxis, Axis yAxis, int dataSetOffset, boolean filled) {
        if (!this.isDrawBars()) {
            return;
        }
        int lindex = dataSetOffset - 1;
        for (DataSet ds : dataSets) {
            ++lindex;
            if (ds.getDataCount() == 0) continue;
            double scaleValue = this.isAnimate() ? this.scaling.getOrDefault(ds.getName(), 1.0) : 1.0;
            boolean isVerticalDataSet = HistogramRenderer.isVerticalDataSet(ds);
            double barWPercentage = this.getBarWidthPercentage();
            double constBarWidth = this.getBarWidth();
            int dimIndexAbscissa = isVerticalDataSet ? 1 : 0;
            int dimIndexOrdinate = isVerticalDataSet ? 0 : 1;
            Axis abscissa = isVerticalDataSet ? yAxis : xAxis;
            Axis ordinate = isVerticalDataSet ? xAxis : yAxis;
            int indexMin = Math.max(0, ds.getIndex(dimIndexAbscissa, new double[]{Math.min(abscissa.getMin(), abscissa.getMax())}));
            int indexMax = Math.min(ds.getDataCount(), ds.getIndex(dimIndexAbscissa, new double[]{Math.max(abscissa.getMin(), abscissa.getMax()) + 1.0}));
            int nRange = Math.abs(indexMax - indexMin);
            double axisMin = HistogramRenderer.getAxisMin(xAxis, yAxis, !isVerticalDataSet);
            boolean isHistogram = ds instanceof Histogram;
            gc.save();
            DefaultRenderColorScheme.setMarkerScheme(gc, ds.getStyle(), lindex);
            DefaultRenderColorScheme.setLineScheme(gc, ds.getStyle(), lindex);
            DefaultRenderColorScheme.setGraphicsContextAttributes(gc, ds.getStyle());
            gc.setFill(gc.getStroke());
            for (int i = 0; i < nRange; ++i) {
                double localBarWidth;
                int index = indexMin + i;
                double scale = this.isAnimate() ? Math.max(0.0, Math.min(1.0, scaleValue - (double)index)) : 1.0;
                double binValue = ordinate.getDisplayPosition(scale * ds.get(dimIndexOrdinate, index));
                double binCentre = abscissa.getDisplayPosition(ds.get(dimIndexAbscissa, index));
                double binStart = abscissa.getDisplayPosition(HistogramRenderer.getBinStart(ds, dimIndexAbscissa, index));
                double binStop = abscissa.getDisplayPosition(HistogramRenderer.getBinStop(ds, dimIndexAbscissa, index));
                double minRequiredWidth = Math.max((double)this.getDashSize(), Math.abs(binStop - binStart) / (this.isShiftBar() ? (double)dataSets.size() : 1.0));
                double binWidth = minRequiredWidth * barWPercentage / 100.0;
                double d = localBarWidth = this.isDynamicBarWidth() ? 0.5 * binWidth : constBarWidth;
                double barOffset = dataSets.size() == 1 ? 0.0 : (this.isDynamicBarWidth() ? minRequiredWidth : (double)this.getShiftBarOffset()) * ((double)lindex - 0.25 * (double)dataSets.size());
                double offset = this.isShiftBar() ? barOffset : 0.0;
                double x0 = isHistogram ? binStart : binCentre - localBarWidth - offset;
                double x1 = isHistogram ? binStop : binCentre + localBarWidth - offset;
                String dataPointStyle = ds.getStyle(index);
                if (dataPointStyle != null) {
                    gc.save();
                    DefaultRenderColorScheme.setMarkerScheme(gc, dataPointStyle, lindex);
                    DefaultRenderColorScheme.setLineScheme(gc, dataPointStyle, lindex);
                    DefaultRenderColorScheme.setGraphicsContextAttributes(gc, dataPointStyle);
                }
                double topRadius = this.isRoundedCorner() ? Math.max(0.0, Math.min((double)this.getRoundedCornerRadius(), 0.5 * binWidth)) : 0.0;
                this.drawBar(gc, x0, axisMin, x1, binValue, topRadius, isVerticalDataSet, filled);
                if (dataPointStyle == null) continue;
                gc.restore();
            }
            gc.restore();
        }
        gc.save();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void drawHistograms(GraphicsContext gc, List<DataSet> dataSets, Axis xAxis, Axis yAxis, int dataSetOffset) {
        ArrayDeque lockQueue = new ArrayDeque(dataSets.size());
        try {
            dataSets.forEach(ds -> {
                lockQueue.push(ds);
                ds.lock().readLock();
            });
            switch (this.getPolyLineStyle()) {
                case NONE: {
                    return;
                }
                case AREA: {
                    HistogramRenderer.drawPolyLineLine(gc, dataSets, xAxis, yAxis, dataSetOffset, true);
                    return;
                }
                case ZERO_ORDER_HOLDER: 
                case STAIR_CASE: {
                    HistogramRenderer.drawPolyLineStairCase(gc, dataSets, xAxis, yAxis, dataSetOffset, false);
                    return;
                }
                case HISTOGRAM: {
                    HistogramRenderer.drawPolyLineHistogram(gc, dataSets, xAxis, yAxis, dataSetOffset, false);
                    return;
                }
                case HISTOGRAM_FILLED: {
                    HistogramRenderer.drawPolyLineHistogram(gc, dataSets, xAxis, yAxis, dataSetOffset, true);
                    return;
                }
                case BEZIER_CURVE: {
                    HistogramRenderer.drawPolyLineHistogramBezier(gc, dataSets, xAxis, yAxis, dataSetOffset, true);
                    return;
                }
                default: {
                    HistogramRenderer.drawPolyLineLine(gc, dataSets, xAxis, yAxis, dataSetOffset, false);
                    return;
                }
            }
        }
        finally {
            while (!lockQueue.isEmpty()) {
                ((DataSet)lockQueue.pop()).lock().readUnLock();
            }
        }
    }

    protected static void drawPolyLineHistogram(GraphicsContext gc, List<DataSet> dataSets, Axis xAxis, Axis yAxis, int dataSetOffset, boolean filled) {
        int lindex = dataSetOffset - 1;
        for (DataSet ds : dataSets) {
            ++lindex;
            if (ds.getDataCount() == 0) continue;
            boolean isVerticalDataSet = HistogramRenderer.isVerticalDataSet(ds);
            int dimIndexAbscissa = isVerticalDataSet ? 1 : 0;
            int dimIndexOrdinate = isVerticalDataSet ? 0 : 1;
            Axis abscissa = isVerticalDataSet ? yAxis : xAxis;
            Axis ordinate = isVerticalDataSet ? xAxis : yAxis;
            int indexMin = Math.max(0, ds.getIndex(dimIndexAbscissa, new double[]{Math.min(abscissa.getMin(), abscissa.getMax())}));
            int indexMax = Math.min(ds.getDataCount(), ds.getIndex(dimIndexAbscissa, new double[]{Math.max(abscissa.getMin(), abscissa.getMax()) + 1.0}));
            int nRange = Math.abs(indexMax - indexMin);
            double[] newX = DoubleArrayCache.getInstance().getArrayExact(2 * (nRange + 1));
            double[] newY = DoubleArrayCache.getInstance().getArrayExact(2 * (nRange + 1));
            double axisMin = HistogramRenderer.getAxisMin(xAxis, yAxis, !isVerticalDataSet);
            for (int i = 0; i < nRange; ++i) {
                int index = indexMin + i;
                double binValue = ordinate.getDisplayPosition(ds.get(dimIndexOrdinate, index));
                double binStart = abscissa.getDisplayPosition(HistogramRenderer.getBinStart(ds, dimIndexAbscissa, index));
                double binStop = abscissa.getDisplayPosition(HistogramRenderer.getBinStop(ds, dimIndexAbscissa, index));
                newX[2 * i + 1] = binStart;
                newY[2 * i + 1] = binValue;
                newX[2 * i + 2] = binStop;
                newY[2 * i + 2] = binValue;
            }
            newX[0] = newX[1];
            newY[0] = axisMin;
            newX[2 * (nRange + 1) - 1] = newX[2 * (nRange + 1) - 2];
            newY[2 * (nRange + 1) - 1] = axisMin;
            gc.save();
            DefaultRenderColorScheme.setLineScheme(gc, ds.getStyle(), lindex);
            DefaultRenderColorScheme.setGraphicsContextAttributes(gc, ds.getStyle());
            HistogramRenderer.drawPolygon(gc, newX, newY, filled, isVerticalDataSet);
            gc.restore();
            DoubleArrayCache.getInstance().add((Object)newX);
            DoubleArrayCache.getInstance().add((Object)newY);
        }
    }

    protected static void drawPolyLineHistogramBezier(GraphicsContext gc, List<DataSet> dataSets, Axis xAxis, Axis yAxis, int dataSetOffset, boolean filled) {
        int lindex = dataSetOffset - 1;
        for (DataSet ds : dataSets) {
            int i;
            ++lindex;
            boolean isVerticalDataSet = HistogramRenderer.isVerticalDataSet(ds);
            int dimIndexAbscissa = isVerticalDataSet ? 1 : 0;
            Axis abscissa = isVerticalDataSet ? yAxis : xAxis;
            int indexMin = Math.max(0, ds.getIndex(dimIndexAbscissa, new double[]{Math.min(abscissa.getMin(), abscissa.getMax())}));
            int indexMax = Math.min(ds.getDataCount(), ds.getIndex(dimIndexAbscissa, new double[]{Math.max(abscissa.getMin(), abscissa.getMax()) + 1.0}));
            int min = Math.min(indexMin, indexMax);
            int nRange = Math.abs(indexMax - indexMin);
            if (nRange <= 2) {
                HistogramRenderer.drawPolyLineLine(gc, List.of(ds), xAxis, yAxis, lindex, filled);
                continue;
            }
            double[] xCp1 = DoubleArrayCache.getInstance().getArrayExact(nRange);
            double[] yCp1 = DoubleArrayCache.getInstance().getArrayExact(nRange);
            double[] xCp2 = DoubleArrayCache.getInstance().getArrayExact(nRange);
            double[] yCp2 = DoubleArrayCache.getInstance().getArrayExact(nRange);
            double[] xValues = DoubleArrayCache.getInstance().getArrayExact(nRange);
            double[] yValues = DoubleArrayCache.getInstance().getArrayExact(nRange);
            for (i = 0; i < nRange; ++i) {
                xValues[i] = xAxis.getDisplayPosition(ds.get(0, min + i));
                yValues[i] = yAxis.getDisplayPosition(ds.get(1, min + i));
            }
            BezierCurve.calcCurveControlPoints(xValues, yValues, xCp1, yCp1, xCp2, yCp2, nRange);
            gc.save();
            DefaultRenderColorScheme.setLineScheme(gc, ds.getStyle(), lindex);
            DefaultRenderColorScheme.setGraphicsContextAttributes(gc, ds.getStyle());
            gc.setFill(gc.getStroke());
            gc.beginPath();
            for (i = 0; i < nRange - 1; ++i) {
                double x0 = xValues[i];
                double x1 = xValues[i + 1];
                double y0 = yValues[i];
                double y1 = yValues[i + 1];
                double xc0 = xCp1[i];
                double yc0 = yCp1[i];
                double xc1 = xCp2[i];
                double yc1 = yCp2[i];
                gc.moveTo(x0, y0);
                gc.bezierCurveTo(xc0, yc0, xc1, yc1, x1, y1);
            }
            gc.moveTo(xValues[nRange - 1], yValues[nRange - 1]);
            gc.closePath();
            gc.stroke();
            gc.restore();
            DoubleArrayCache.getInstance().add((Object)xValues);
            DoubleArrayCache.getInstance().add((Object)yValues);
            DoubleArrayCache.getInstance().add((Object)xCp1);
            DoubleArrayCache.getInstance().add((Object)yCp1);
            DoubleArrayCache.getInstance().add((Object)xCp2);
            DoubleArrayCache.getInstance().add((Object)yCp2);
        }
    }

    protected static void drawPolyLineLine(GraphicsContext gc, List<DataSet> dataSets, Axis xAxis, Axis yAxis, int dataSetOffset, boolean filled) {
        int lindex = dataSetOffset - 1;
        for (DataSet ds : dataSets) {
            ++lindex;
            boolean isVerticalDataSet = HistogramRenderer.isVerticalDataSet(ds);
            int dimIndexAbscissa = isVerticalDataSet ? 1 : 0;
            Axis abscissa = isVerticalDataSet ? yAxis : xAxis;
            int indexMin = Math.max(0, ds.getIndex(dimIndexAbscissa, new double[]{Math.min(abscissa.getMin(), abscissa.getMax())}));
            int indexMax = Math.min(ds.getDataCount(), ds.getIndex(dimIndexAbscissa, new double[]{Math.max(abscissa.getMin(), abscissa.getMax()) + 1.0}));
            int nRange = Math.abs(indexMax - indexMin);
            if (nRange == 0) continue;
            gc.save();
            DefaultRenderColorScheme.setLineScheme(gc, ds.getStyle(), lindex);
            DefaultRenderColorScheme.setGraphicsContextAttributes(gc, ds.getStyle());
            gc.beginPath();
            double a = xAxis.getDisplayPosition(ds.get(0, indexMin));
            double b = yAxis.getDisplayPosition(ds.get(1, indexMin));
            gc.moveTo(a, b);
            boolean lastIsFinite = true;
            double xLastValid = 0.0;
            double yLastValid = 0.0;
            for (int i = indexMin + 1; i < indexMax; ++i) {
                a = xAxis.getDisplayPosition(ds.get(0, i));
                b = yAxis.getDisplayPosition(ds.get(1, i));
                if (Double.isFinite(a) && Double.isFinite(b)) {
                    if (!lastIsFinite) {
                        gc.moveTo(a, b);
                        lastIsFinite = true;
                        continue;
                    }
                    gc.lineTo(a, b);
                    xLastValid = a;
                    yLastValid = b;
                    lastIsFinite = true;
                    continue;
                }
                lastIsFinite = false;
            }
            gc.moveTo(xLastValid, yLastValid);
            gc.closePath();
            if (filled) {
                gc.fill();
            } else {
                gc.stroke();
            }
            gc.restore();
        }
    }

    protected static void drawPolyLineStairCase(GraphicsContext gc, List<DataSet> dataSets, Axis xAxis, Axis yAxis, int dataSetOffset, boolean filled) {
        int lindex = dataSetOffset - 1;
        for (DataSet ds : dataSets) {
            ++lindex;
            boolean isVerticalDataSet = HistogramRenderer.isVerticalDataSet(ds);
            int dimIndexAbscissa = isVerticalDataSet ? 1 : 0;
            int dimIndexOrdinate = isVerticalDataSet ? 0 : 1;
            Axis abscissa = isVerticalDataSet ? yAxis : xAxis;
            Axis ordinate = isVerticalDataSet ? xAxis : yAxis;
            int indexMin = Math.max(0, ds.getIndex(dimIndexAbscissa, new double[]{Math.min(abscissa.getMin(), abscissa.getMax())}));
            int indexMax = Math.min(ds.getDataCount(), ds.getIndex(dimIndexAbscissa, new double[]{Math.max(abscissa.getMin(), abscissa.getMax()) + 1.0}));
            int min = Math.min(indexMin, indexMax);
            int nRange = Math.abs(indexMax - indexMin);
            double axisMin = HistogramRenderer.getAxisMin(xAxis, yAxis, !isVerticalDataSet);
            if (nRange <= 0) {
                HistogramRenderer.drawPolyLineLine(gc, List.of(ds), xAxis, yAxis, lindex, filled);
                continue;
            }
            double[] newX = DoubleArrayCache.getInstance().getArrayExact(2 * nRange);
            double[] newY = DoubleArrayCache.getInstance().getArrayExact(2 * nRange);
            for (int i = 0; i < nRange - 1; ++i) {
                int index = i + min;
                newX[2 * i] = abscissa.getDisplayPosition(ds.get(dimIndexAbscissa, index));
                newY[2 * i] = ordinate.getDisplayPosition(ds.get(dimIndexOrdinate, index));
                newX[2 * i + 1] = abscissa.getDisplayPosition(ds.get(dimIndexAbscissa, index + 1));
                newY[2 * i + 1] = newY[2 * i];
            }
            newX[2 * (nRange - 1)] = abscissa.getDisplayPosition(ds.get(dimIndexAbscissa, min + nRange - 1));
            newY[2 * (nRange - 1)] = ordinate.getDisplayPosition(ds.get(dimIndexOrdinate, min + nRange - 1));
            newX[2 * nRange - 1] = abscissa.getDisplayPosition(axisMin);
            newY[2 * nRange - 1] = newY[2 * (nRange - 1)];
            gc.save();
            DefaultRenderColorScheme.setLineScheme(gc, ds.getStyle(), lindex);
            DefaultRenderColorScheme.setGraphicsContextAttributes(gc, ds.getStyle());
            HistogramRenderer.drawPolygon(gc, newX, newY, filled, isVerticalDataSet);
            gc.restore();
            DoubleArrayCache.getInstance().add((Object)newX);
            DoubleArrayCache.getInstance().add((Object)newY);
        }
    }

    protected static void drawPolygon(GraphicsContext gc, double[] a, double[] b, boolean filled, boolean isVerticalDataSet) {
        if (filled) {
            gc.setFill(gc.getStroke());
            if (isVerticalDataSet) {
                gc.fillPolygon(b, a, a.length);
            } else {
                gc.fillPolygon(a, b, a.length);
            }
            return;
        }
        if (isVerticalDataSet) {
            gc.strokePolyline(b, a, a.length);
        } else {
            gc.strokePolyline(a, b, a.length);
        }
    }

    protected static double estimateHalfBinWidth(DataSet ds, int dimIndex, int index) {
        boolean isInValidRight;
        int nMax = ds.getDataCount();
        if (nMax == 0) {
            return 0.5;
        }
        if (nMax == 1) {
            return 0.5 * Math.abs(ds.get(dimIndex, 1) - ds.get(dimIndex, 0));
        }
        double binCentre = ds.get(dimIndex, index);
        double diffLeft = index - 1 >= 0 ? Math.abs(binCentre - ds.get(dimIndex, index - 1)) : -1.0;
        double diffRight = index + 1 < nMax ? Math.abs(ds.get(dimIndex, index + 1)) - binCentre : -1.0;
        boolean isInValidLeft = diffLeft < 0.0;
        boolean bl = isInValidRight = diffRight < 0.0;
        if (isInValidLeft && isInValidRight) {
            return 0.5;
        }
        if (isInValidLeft || isInValidRight) {
            return 0.5 * Math.max(diffLeft, diffRight);
        }
        return 0.5 * Math.min(diffLeft, diffRight);
    }

    protected static double getBinStart(DataSet ds, int dimIndex, int index) {
        if (ds instanceof Histogram) {
            return ((Histogram)ds).getBinLimits(dimIndex, Histogram.Boundary.LOWER, index + 1);
        }
        return ds.get(dimIndex, index) - HistogramRenderer.estimateHalfBinWidth(ds, dimIndex, index);
    }

    protected static double getBinStop(DataSet ds, int dimIndex, int index) {
        if (ds instanceof Histogram) {
            return ((Histogram)ds).getBinLimits(dimIndex, Histogram.Boundary.UPPER, index + 1);
        }
        return ds.get(dimIndex, index) + HistogramRenderer.estimateHalfBinWidth(ds, dimIndex, index);
    }

    @Override
    protected HistogramRenderer getThis() {
        return this;
    }

    protected static boolean isDataSetSorted(DataSet dataSet, int dimIndex) {
        if (dataSet.getDataCount() < 2) {
            return true;
        }
        double xLast = dataSet.get(dimIndex, 0);
        for (int i = 1; i < dataSet.getDataCount(); ++i) {
            double x = dataSet.get(dimIndex, i);
            if (x < xLast) {
                return false;
            }
            xLast = x;
        }
        return true;
    }

    protected static boolean isVerticalDataSet(DataSet ds) {
        if (ds instanceof Histogram) {
            Histogram histogram = (Histogram)ds;
            return histogram.getBinCount(0) == 0 && histogram.getBinCount(1) > 0;
        }
        boolean sortedInX = HistogramRenderer.isDataSetSorted(ds, 0);
        boolean sortedInY = HistogramRenderer.isDataSetSorted(ds, 1);
        if (sortedInX && sortedInY) {
            return false;
        }
        return sortedInY;
    }

    private void drawBar(GraphicsContext gc, double x0, double y0, double x1, double y1, double radius, boolean verticalDataSet, boolean filled) {
        double b1;
        double a0 = verticalDataSet ? y0 : x0;
        double a1 = verticalDataSet ? y1 : x1;
        double b0 = verticalDataSet ? x0 : y0;
        double d = b1 = verticalDataSet ? x1 : y1;
        if (filled) {
            gc.fillRoundRect(Math.min(a0, a1), Math.min(b0, b1), Math.abs(a1 - a0), Math.abs(b1 - b0), radius, radius);
        } else {
            gc.strokeRoundRect(Math.min(a0, a1), Math.min(b0, b1), Math.abs(a1 - a0), Math.abs(b1 - b0), radius, radius);
        }
    }

    private static double getAxisMin(Axis xAxis, Axis yAxis, boolean isHorizontalDataSet) {
        double xMin = Math.min(xAxis.getMin(), xAxis.getMax());
        double yMin = Math.min(yAxis.getMin(), yAxis.getMax());
        if (isHorizontalDataSet) {
            if (yAxis.isLogAxis()) {
                return yAxis.isInvertedAxis() ? 0.0 : yAxis.getLength();
            }
            return yAxis.isInvertedAxis() ? Math.max(yAxis.getDisplayPosition(0.0), yAxis.getDisplayPosition(yMin)) : Math.min(yAxis.getDisplayPosition(0.0), yAxis.getDisplayPosition(yMin));
        }
        if (xAxis.isLogAxis()) {
            return xAxis.isInvertedAxis() ? xAxis.getLength() : 0.0;
        }
        return yAxis.isInvertedAxis() ? Math.min(xAxis.getDisplayPosition(0.0), xAxis.getDisplayPosition(xMin)) : Math.max(xAxis.getDisplayPosition(0.0), xAxis.getDisplayPosition(xMin));
    }

    private class MyTimer
    extends AnimationTimer {
        private MyTimer() {
        }

        public void handle(long now) {
            if (!HistogramRenderer.this.isAnimate()) {
                this.stop();
                return;
            }
            for (DataSet dataSet : HistogramRenderer.this.localDataSetList) {
                Double val = HistogramRenderer.this.scaling.put(dataSet.getName(), Math.min(HistogramRenderer.this.scaling.computeIfAbsent(dataSet.getName(), ds -> 0.0) + 0.05, (double)dataSet.getDataCount() + 1.0));
                if (val == null || !(val < (double)dataSet.getDataCount() + 1.0)) continue;
                HistogramRenderer.this.requestLayout();
            }
        }
    }
}

