/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.renderer.spi;

import de.gsi.chart.Chart;
import de.gsi.chart.XYChart;
import de.gsi.chart.axes.Axis;
import de.gsi.chart.axes.spi.TickMark;
import de.gsi.chart.renderer.Renderer;
import de.gsi.chart.renderer.spi.utils.DashPatternStyle;
import de.gsi.dataset.DataSet;
import de.gsi.dataset.utils.NoDuplicatesList;
import java.security.InvalidParameterException;
import java.util.Collections;
import java.util.List;
import javafx.beans.property.BooleanProperty;
import javafx.beans.value.ChangeListener;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.SetChangeListener;
import javafx.css.CssMetaData;
import javafx.css.PseudoClass;
import javafx.css.Styleable;
import javafx.geometry.VPos;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.layout.Pane;
import javafx.scene.shape.Line;
import javafx.scene.text.TextAlignment;

public class GridRenderer
extends Pane
implements Renderer {
    private static final double DEG_TO_RAD = Math.PI / 180;
    private static final String CHART_CSS = Chart.class.getResource("chart.css").toExternalForm();
    private static final String STYLE_CLASS_GRID_RENDERER = "grid-renderer";
    private static final String STYLE_CLASS_MAJOR_GRID_LINE = "chart-major-grid-lines";
    private static final String STYLE_CLASS_MAJOR_GRID_LINE_H = "chart-major-horizontal-lines";
    private static final String STYLE_CLASS_MAJOR_GRID_LINE_V = "chart-major-vertical-lines";
    private static final String STYLE_CLASS_MINOR_GRID_LINE = "chart-minor-grid-lines";
    private static final String STYLE_CLASS_MINOR_GRID_LINE_H = "chart-minor-horizontal-lines";
    private static final String STYLE_CLASS_MINOR_GRID_LINE_V = "chart-minor-vertical-lines";
    private static final String STYLE_CLASS_GRID_ON_TOP = "chart-grid-line-on-top";
    private static final PseudoClass SELECTED_PSEUDO_CLASS = PseudoClass.getPseudoClass((String)"withMinor");
    private static final double[] DEFAULT_GRID_DASH_PATTERM = new double[]{4.5, 2.5};
    private final Line horMajorGridStyleNode;
    private final Line verMajorGridStyleNode;
    private final Line horMinorGridStyleNode;
    private final Line verMinorGridStyleNode;
    private final Line drawGridOnTopNode;
    private final Group gridStyleNodes = new Group();
    protected final ObservableList<Axis> axesList = FXCollections.observableList((List)new NoDuplicatesList());

    public GridRenderer() {
        this.getStylesheets().add((Object)CHART_CSS);
        this.getStyleClass().setAll((Object[])new String[]{STYLE_CLASS_GRID_RENDERER});
        this.horMajorGridStyleNode = new Line();
        this.horMajorGridStyleNode.getStyleClass().add((Object)STYLE_CLASS_MAJOR_GRID_LINE);
        this.horMajorGridStyleNode.getStyleClass().add((Object)STYLE_CLASS_MAJOR_GRID_LINE_H);
        this.verMajorGridStyleNode = new Line();
        this.verMajorGridStyleNode.getStyleClass().add((Object)STYLE_CLASS_MAJOR_GRID_LINE);
        this.verMajorGridStyleNode.getStyleClass().add((Object)STYLE_CLASS_MAJOR_GRID_LINE_V);
        this.horMinorGridStyleNode = new Line();
        this.horMinorGridStyleNode.getStyleClass().add((Object)STYLE_CLASS_MINOR_GRID_LINE);
        this.horMinorGridStyleNode.getStyleClass().add((Object)STYLE_CLASS_MINOR_GRID_LINE_H);
        this.horMinorGridStyleNode.setVisible(false);
        this.verMinorGridStyleNode = new Line();
        this.verMinorGridStyleNode.getStyleClass().add((Object)STYLE_CLASS_MINOR_GRID_LINE);
        this.verMinorGridStyleNode.getStyleClass().add((Object)STYLE_CLASS_MINOR_GRID_LINE_V);
        this.verMinorGridStyleNode.setVisible(false);
        this.drawGridOnTopNode = new Line();
        this.drawGridOnTopNode.getStyleClass().add((Object)STYLE_CLASS_GRID_ON_TOP);
        this.drawGridOnTopNode.getStyleClass().add((Object)STYLE_CLASS_GRID_ON_TOP);
        this.drawGridOnTopNode.setVisible(true);
        this.gridStyleNodes.getChildren().addAll((Object[])new Node[]{this.horMajorGridStyleNode, this.verMajorGridStyleNode, this.horMinorGridStyleNode, this.verMinorGridStyleNode, this.drawGridOnTopNode});
        this.getChildren().add((Object)this.gridStyleNodes);
        Scene scene = new Scene((Parent)this);
        scene.getStylesheets().add((Object)CHART_CSS);
        this.gridStyleNodes.applyCss();
        SetChangeListener listener = evt -> this.gridStyleNodes.applyCss();
        this.horMajorGridStyleNode.getPseudoClassStates().addListener(listener);
        this.verMajorGridStyleNode.getPseudoClassStates().addListener(listener);
        this.horMinorGridStyleNode.getPseudoClassStates().addListener(listener);
        this.verMinorGridStyleNode.getPseudoClassStates().addListener(listener);
        this.drawGridOnTopNode.getPseudoClassStates().addListener(listener);
        ChangeListener change = (ob, o, n) -> {
            this.horMajorGridStyleNode.pseudoClassStateChanged(SELECTED_PSEUDO_CLASS, this.horMinorGridStyleNode.isVisible());
            this.verMajorGridStyleNode.pseudoClassStateChanged(SELECTED_PSEUDO_CLASS, this.verMinorGridStyleNode.isVisible());
            this.drawGridOnTopNode.pseudoClassStateChanged(SELECTED_PSEUDO_CLASS, this.drawGridOnTopNode.isVisible());
        };
        this.horizontalGridLinesVisibleProperty().addListener(change);
        this.verticalGridLinesVisibleProperty().addListener(change);
        this.drawOnTopProperty().addListener(change);
    }

    protected void drawEuclideanGrid(GraphicsContext gc, XYChart xyChart) {
        Axis xAxis = xyChart.getXAxis();
        Axis yAxis = xyChart.getYAxis();
        double xAxisWidth = xyChart.getCanvas().getWidth();
        double xAxisWidthSnapped = GridRenderer.snap(xAxisWidth);
        double yAxisHeight = xyChart.getCanvas().getHeight();
        double yAxisHeightSnapped = GridRenderer.snap(yAxisHeight);
        if (xAxis instanceof Node) {
            ((Node)xAxis).setVisible(true);
        }
        gc.save();
        this.drawVerticalMajorGridLines(gc, xAxis, xAxisWidth, yAxisHeightSnapped);
        this.drawVerticalMinorGridLines(gc, xAxis, xAxisWidth, yAxisHeightSnapped);
        this.drawHorizontalMajorGridLines(gc, yAxis, xAxisWidthSnapped, yAxisHeight);
        this.drawHorizontalMinorGridLines(gc, yAxis, xAxisWidthSnapped, yAxisHeight);
        gc.restore();
    }

    protected void drawHorizontalMajorGridLines(GraphicsContext gc, Axis yAxis, double xAxisWidthSnapped, double yAxisHeight) {
        if (!this.horMajorGridStyleNode.isVisible() && !this.horMinorGridStyleNode.isVisible()) {
            return;
        }
        double zeroSnapped = GridRenderer.snap(0.0);
        GridRenderer.applyGraphicsStyleFromLineStyle(gc, this.horMajorGridStyleNode);
        ObservableList<TickMark> tickMarks = yAxis.getTickMarks();
        for (TickMark tickMark : tickMarks) {
            double y = GridRenderer.snap(yAxis.getDisplayPosition(tickMark.getValue()));
            if (!(y >= 0.0) || !(y < yAxisHeight)) continue;
            DashPatternStyle.strokeDashedLine(gc, zeroSnapped, y, xAxisWidthSnapped, y);
        }
    }

    protected void drawHorizontalMinorGridLines(GraphicsContext gc, Axis yAxis, double xAxisWidthSnapped, double yAxisHeight) {
        if (!yAxis.isLogAxis() && !this.horMinorGridStyleNode.isVisible()) {
            return;
        }
        double zeroSnapped = GridRenderer.snap(0.0);
        GridRenderer.applyGraphicsStyleFromLineStyle(gc, this.horMinorGridStyleNode);
        ObservableList<TickMark> tickMarks = yAxis.getMinorTickMarks();
        for (TickMark tickMark : tickMarks) {
            double y = GridRenderer.snap(yAxis.getDisplayPosition(tickMark.getValue()));
            if (!(y >= 0.0) || !(y < yAxisHeight)) continue;
            DashPatternStyle.strokeDashedLine(gc, zeroSnapped, y, xAxisWidthSnapped, y);
        }
    }

    @Override
    public Canvas drawLegendSymbol(DataSet dataSet, int dsIndex, int width, int height) {
        return null;
    }

    public final BooleanProperty drawOnTopProperty() {
        return this.drawGridOnTopNode.visibleProperty();
    }

    protected void drawPolarCircle(GraphicsContext gc, Axis yAxis, double yRange, double xCentre, double yCentre, double maxRadius) {
        if (!this.horMajorGridStyleNode.isVisible() && !this.horMinorGridStyleNode.isVisible()) {
            return;
        }
        GridRenderer.applyGraphicsStyleFromLineStyle(gc, this.horMajorGridStyleNode);
        ObservableList<TickMark> yTickMarks = yAxis.getTickMarks();
        gc.strokeOval(xCentre - maxRadius, yCentre - maxRadius, 2.0 * maxRadius, 2.0 * maxRadius);
        yTickMarks.forEach(tick -> {
            double yPos = yRange - yAxis.getDisplayPosition(tick.getValue());
            String label = yAxis.getTickMarkLabel(tick.getValue());
            double yNorm = yPos / yRange * maxRadius;
            if (yNorm >= 0.0 && yNorm < maxRadius) {
                gc.strokeOval(xCentre - yNorm, yCentre - yNorm, 2.0 * yNorm, 2.0 * yNorm);
                gc.save();
                gc.setFont(yAxis.getTickLabelFont());
                gc.setStroke(yAxis.getTickLabelFill());
                gc.setLineDashes((double[])null);
                gc.setTextBaseline(VPos.CENTER);
                gc.strokeText(label, xCentre + (double)((int)yAxis.getTickLabelGap()), yCentre - yNorm);
                gc.restore();
            }
        });
        if (!yAxis.isLogAxis() && !this.horMinorGridStyleNode.isVisible()) {
            return;
        }
        GridRenderer.applyGraphicsStyleFromLineStyle(gc, this.horMinorGridStyleNode);
        yAxis.getMinorTickMarks().stream().mapToDouble(minorTick -> yRange - minorTick.getPosition()).forEach(yPos -> {
            double yNorm = yPos / yRange * maxRadius;
            if (yNorm >= 0.0 && yNorm < maxRadius) {
                gc.strokeOval(xCentre - yNorm, yCentre - yNorm, 2.0 * yNorm, 2.0 * yNorm);
            }
        });
    }

    protected void drawPolarGrid(GraphicsContext gc, XYChart xyChart) {
        Axis xAxis = xyChart.getXAxis();
        Axis yAxis = xyChart.getYAxis();
        double xAxisWidth = xyChart.getCanvas().getWidth();
        double yAxisHeight = xyChart.getCanvas().getHeight();
        double xRange = xAxis.getWidth();
        double yRange = yAxis.getHeight();
        double xCentre = xRange / 2.0;
        double yCentre = yRange / 2.0;
        double maxRadius = 0.5 * Math.min(xRange, yRange) * 0.9;
        if (xAxis instanceof Node) {
            ((Node)xAxis).setVisible(false);
        }
        gc.save();
        if (this.verMajorGridStyleNode.isVisible() || this.verMinorGridStyleNode.isVisible()) {
            GridRenderer.applyGraphicsStyleFromLineStyle(gc, this.verMajorGridStyleNode);
            for (double phi = 0.0; phi <= 360.0; phi += xyChart.getPolarStepSize().get()) {
                double x = xCentre + maxRadius * Math.sin(phi * (Math.PI / 180));
                double y = yCentre - maxRadius * Math.cos(phi * (Math.PI / 180));
                double xl = xCentre + maxRadius * Math.sin(phi * (Math.PI / 180)) * 1.05;
                double yl = yCentre - maxRadius * Math.cos(phi * (Math.PI / 180)) * 1.05;
                gc.strokeLine(xCentre, yCentre, x, y);
                gc.save();
                gc.setFont(yAxis.getTickLabelFont());
                gc.setStroke(yAxis.getTickLabelFill());
                gc.setLineDashes((double[])null);
                gc.setTextBaseline(VPos.CENTER);
                if (phi < 350.0) {
                    if (phi < 20.0) {
                        gc.setTextAlign(TextAlignment.CENTER);
                    } else if (phi <= 160.0) {
                        gc.setTextAlign(TextAlignment.LEFT);
                    } else if (phi <= 200.0) {
                        gc.setTextAlign(TextAlignment.CENTER);
                    } else {
                        gc.setTextAlign(TextAlignment.RIGHT);
                    }
                    gc.strokeText(String.valueOf(phi), xl, yl);
                }
                gc.restore();
            }
            if (xAxis.isLogAxis() || this.verMinorGridStyleNode.isVisible()) {
                GridRenderer.applyGraphicsStyleFromLineStyle(gc, this.verMinorGridStyleNode);
                xAxis.getMinorTickMarks().stream().mapToDouble(TickMark::getPosition).forEach(xPos -> {
                    if (xPos > 0.0 && xPos <= xAxisWidth) {
                        gc.strokeLine(xPos, 0.0, xPos, yAxisHeight);
                    }
                });
            }
        }
        this.drawPolarCircle(gc, yAxis, yRange, xCentre, yCentre, maxRadius);
        gc.restore();
    }

    protected void drawVerticalMajorGridLines(GraphicsContext gc, Axis xAxis, double xAxisWidth, double yAxisHeightSnapped) {
        if (!this.verMajorGridStyleNode.isVisible() && !this.verMinorGridStyleNode.isVisible()) {
            return;
        }
        double zeroSnapped = GridRenderer.snap(0.0);
        GridRenderer.applyGraphicsStyleFromLineStyle(gc, this.verMajorGridStyleNode);
        ObservableList<TickMark> tickMarks = xAxis.getTickMarks();
        for (TickMark tickMark : tickMarks) {
            double x = GridRenderer.snap(xAxis.getDisplayPosition(tickMark.getValue()));
            if (!(x > 0.0) || !(x <= xAxisWidth)) continue;
            DashPatternStyle.strokeDashedLine(gc, x, zeroSnapped, x, yAxisHeightSnapped);
        }
    }

    protected void drawVerticalMinorGridLines(GraphicsContext gc, Axis xAxis, double xAxisWidth, double yAxisHeightSnapped) {
        if (!xAxis.isLogAxis() && !this.verMinorGridStyleNode.isVisible()) {
            return;
        }
        double zeroSnapped = GridRenderer.snap(0.0);
        GridRenderer.applyGraphicsStyleFromLineStyle(gc, this.verMinorGridStyleNode);
        ObservableList<TickMark> tickMarks = xAxis.getMinorTickMarks();
        for (TickMark tickMark : tickMarks) {
            double x = GridRenderer.snap(xAxis.getDisplayPosition(tickMark.getValue()));
            if (!(x > 0.0) || !(x <= xAxisWidth)) continue;
            DashPatternStyle.strokeDashedLine(gc, x, zeroSnapped, x, yAxisHeightSnapped);
        }
    }

    @Override
    public ObservableList<Axis> getAxes() {
        return this.axesList;
    }

    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return GridRenderer.getClassCssMetaData();
    }

    @Override
    public ObservableList<DataSet> getDatasets() {
        return null;
    }

    @Override
    public ObservableList<DataSet> getDatasetsCopy() {
        return null;
    }

    public Line getHorizontalMajorGrid() {
        return this.horMajorGridStyleNode;
    }

    public Line getHorizontalMinorGrid() {
        return this.horMinorGridStyleNode;
    }

    public Line getVerticalMajorGrid() {
        return this.verMajorGridStyleNode;
    }

    public Line getVerticalMinorGrid() {
        return this.verMinorGridStyleNode;
    }

    public final BooleanProperty horizontalGridLinesVisibleProperty() {
        return this.horMajorGridStyleNode.visibleProperty();
    }

    public final BooleanProperty horizontalMinorGridLinesVisibleProperty() {
        return this.horMinorGridStyleNode.visibleProperty();
    }

    public final boolean isDrawOnTop() {
        return this.drawGridOnTopNode.isVisible();
    }

    @Override
    public List<DataSet> render(GraphicsContext gc, Chart chart, int dataSetOffset, ObservableList<DataSet> datasets) {
        if (!(chart instanceof XYChart)) {
            throw new InvalidParameterException("must be derivative of XYChart for renderer - " + this.getClass().getSimpleName());
        }
        XYChart xyChart = (XYChart)chart;
        if (xyChart.isPolarPlot()) {
            this.drawPolarGrid(gc, xyChart);
        } else {
            this.drawEuclideanGrid(gc, xyChart);
        }
        return Collections.emptyList();
    }

    public final void setDrawOnTop(boolean state) {
        this.drawGridOnTopNode.setVisible(state);
    }

    @Override
    public Renderer setShowInLegend(boolean state) {
        return this;
    }

    @Override
    public boolean showInLegend() {
        return false;
    }

    @Override
    public BooleanProperty showInLegendProperty() {
        return null;
    }

    public final BooleanProperty verticalGridLinesVisibleProperty() {
        return this.verMajorGridStyleNode.visibleProperty();
    }

    public final BooleanProperty verticalMinorGridLinesVisibleProperty() {
        return this.verMinorGridStyleNode.visibleProperty();
    }

    protected static void applyGraphicsStyleFromLineStyle(GraphicsContext gc, Line style) {
        gc.setStroke(style.getStroke());
        gc.setLineWidth(style.getStrokeWidth());
        if (style.getStrokeDashArray() == null || style.getStrokeDashArray().isEmpty()) {
            gc.setLineDashes(DEFAULT_GRID_DASH_PATTERM);
        } else {
            double[] dashes = style.getStrokeDashArray().stream().mapToDouble(d -> d).toArray();
            gc.setLineDashes(dashes);
        }
    }

    private static double snap(double value) {
        return (double)((int)value) + 0.5;
    }
}

