/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.renderer.spi;

import de.gsi.chart.Chart;
import de.gsi.chart.XYChart;
import de.gsi.chart.axes.Axis;
import de.gsi.chart.axes.spi.CategoryAxis;
import de.gsi.chart.marker.DefaultMarker;
import de.gsi.chart.marker.Marker;
import de.gsi.chart.renderer.ErrorStyle;
import de.gsi.chart.renderer.Renderer;
import de.gsi.chart.renderer.RendererDataReducer;
import de.gsi.chart.renderer.spi.AbstractErrorDataSetRendererParameter;
import de.gsi.chart.renderer.spi.CachedDataPoints;
import de.gsi.chart.renderer.spi.utils.BezierCurve;
import de.gsi.chart.renderer.spi.utils.DefaultRenderColorScheme;
import de.gsi.chart.utils.StyleParser;
import de.gsi.dataset.DataSet;
import de.gsi.dataset.DataSetError;
import de.gsi.dataset.spi.utils.Triple;
import de.gsi.dataset.utils.DoubleArrayCache;
import de.gsi.dataset.utils.ProcessingProfiler;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import javafx.collections.ObservableList;
import javafx.geometry.Orientation;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.FillRule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ErrorDataSetRenderer
extends AbstractErrorDataSetRendererParameter<ErrorDataSetRenderer>
implements Renderer {
    private static final Logger LOGGER = LoggerFactory.getLogger(ErrorDataSetRenderer.class);
    private Marker marker = DefaultMarker.RECTANGLE;
    private long stopStamp;

    public ErrorDataSetRenderer() {
        this(3);
    }

    public ErrorDataSetRenderer(int dashSize) {
        this.setDashSize(dashSize);
    }

    @Override
    public Canvas drawLegendSymbol(DataSet dataSet, int dsIndex, int width, int height) {
        Canvas canvas = new Canvas((double)width, (double)height);
        GraphicsContext gc = canvas.getGraphicsContext2D();
        String style = dataSet.getStyle();
        Integer layoutOffset = StyleParser.getIntegerPropertyValue(style, "dsLayoutOffset");
        Integer dsIndexLocal = StyleParser.getIntegerPropertyValue(style, "dsIndex");
        int dsLayoutIndexOffset = layoutOffset == null ? 0 : layoutOffset;
        int plotingIndex = dsLayoutIndexOffset + (dsIndexLocal == null ? dsIndex : dsIndexLocal);
        gc.save();
        DefaultRenderColorScheme.setLineScheme(gc, dataSet.getStyle(), plotingIndex);
        DefaultRenderColorScheme.setGraphicsContextAttributes(gc, dataSet.getStyle());
        DefaultRenderColorScheme.setFillScheme(gc, dataSet.getStyle(), plotingIndex);
        if (this.getErrorType() == ErrorStyle.ERRORBARS) {
            double x = (double)width / 2.0;
            double y = (double)height / 2.0;
            if (this.getDashSize() > 2) {
                gc.strokeLine(x - 1.0, 1.0, x + 1.0, 1.0);
                gc.strokeLine(x - 1.0, (double)height - 2.0, x + 1.0, (double)height - 2.0);
                gc.strokeLine(x, 1.0, x, (double)height - 2.0);
            }
            gc.strokeLine(1.0, y, (double)width, y);
        } else if (this.getErrorType() == ErrorStyle.ERRORSURFACE || this.getErrorType() == ErrorStyle.ERRORCOMBO) {
            double y = (double)height / 2.0;
            gc.fillRect(1.0, 1.0, (double)width - 2.0, (double)height - 2.0);
            gc.strokeLine(1.0, y, (double)width - 2.0, y);
        } else {
            double x = (double)width / 2.0;
            double y = (double)height / 2.0;
            if (this.getDashSize() > 2) {
                gc.strokeLine(x - 1.0, 1.0, x + 1.0, 1.0);
                gc.strokeLine(x - 1.0, (double)height - 2.0, x + 1.0, (double)height - 2.0);
                gc.strokeLine(x, 1.0, x, (double)height - 2.0);
            }
            gc.strokeLine(1.0, y, (double)width - 2.0, y);
        }
        gc.restore();
        return canvas;
    }

    public Marker getMarker() {
        return this.marker;
    }

    @Override
    public List<DataSet> render(GraphicsContext gc, Chart chart, int dataSetOffset, ObservableList<DataSet> datasets) {
        if (!(chart instanceof XYChart)) {
            throw new InvalidParameterException("must be derivative of XYChart for renderer - " + this.getClass().getSimpleName());
        }
        ArrayList<DataSet> localDataSetList = this.isDrawChartDataSets() ? new ArrayList<DataSet>((Collection<DataSet>)datasets) : new ArrayList();
        localDataSetList.addAll((Collection<DataSet>)super.getDatasets());
        if (localDataSetList.isEmpty()) {
            return Collections.emptyList();
        }
        Axis xAxisTemp = this.getFirstAxis(Orientation.HORIZONTAL);
        if (xAxisTemp == null) {
            xAxisTemp = chart.getFirstAxis(Orientation.HORIZONTAL);
        }
        Axis xAxis = xAxisTemp;
        Axis yAxisTemp = this.getFirstAxis(Orientation.VERTICAL);
        if (yAxisTemp == null) {
            yAxisTemp = chart.getFirstAxis(Orientation.VERTICAL);
        }
        Axis yAxis = yAxisTemp;
        long start = ProcessingProfiler.getTimeStamp();
        double xAxisWidth = xAxis.getWidth();
        boolean xAxisInverted = xAxis.isInvertedAxis();
        double xMin = xAxis.getValueForDisplay(xAxisInverted ? xAxisWidth : 0.0);
        double xMax = xAxis.getValueForDisplay(xAxisInverted ? 0.0 : xAxisWidth);
        if (ProcessingProfiler.getDebugState()) {
            ProcessingProfiler.getTimeDiff((long)start, (String)"init");
        }
        ArrayList<DataSet> drawnDataSet = new ArrayList<DataSet>(localDataSetList.size());
        for (int dataSetIndex = localDataSetList.size() - 1; dataSetIndex >= 0; --dataSetIndex) {
            int ldataSetIndex = dataSetIndex;
            this.stopStamp = ProcessingProfiler.getTimeStamp();
            DataSet dataSet = (DataSet)localDataSetList.get(dataSetIndex);
            if (dataSetIndex == 0) {
                CategoryAxis axis;
                if (this.getFirstAxis(Orientation.HORIZONTAL) instanceof CategoryAxis) {
                    axis = (CategoryAxis)this.getFirstAxis(Orientation.HORIZONTAL);
                    dataSet.lock().readLockGuard(() -> axis.updateCategories(dataSet));
                }
                if (this.getFirstAxis(Orientation.VERTICAL) instanceof CategoryAxis) {
                    axis = (CategoryAxis)this.getFirstAxis(Orientation.VERTICAL);
                    dataSet.lock().readLockGuard(() -> axis.updateCategories(dataSet));
                }
            }
            Optional cachedPoints = (Optional)dataSet.lock().readLockGuard(() -> {
                int indexMax;
                int indexMin;
                if (this.isAssumeSortedData()) {
                    indexMin = Math.max(0, dataSet.getIndex(0, new double[]{xMin}) - 1);
                    indexMax = Math.min(dataSet.getIndex(0, new double[]{xMax}) + 2, dataSet.getDataCount());
                } else {
                    indexMin = 0;
                    indexMax = dataSet.getDataCount();
                }
                if (indexMax - indexMin <= 0) {
                    return Optional.empty();
                }
                if (ProcessingProfiler.getDebugState()) {
                    this.stopStamp = ProcessingProfiler.getTimeDiff((long)this.stopStamp, (String)("get min/max" + String.format(" from:%d to:%d", indexMin, indexMax)));
                }
                CachedDataPoints localCachedPoints = new CachedDataPoints(indexMin, indexMax, dataSet.getDataCount(), true);
                if (ProcessingProfiler.getDebugState()) {
                    this.stopStamp = ProcessingProfiler.getTimeDiff((long)this.stopStamp, (String)"get CachedPoints");
                }
                boolean isPolarPlot = ((XYChart)chart).isPolarPlot();
                if (this.isParallelImplementation()) {
                    localCachedPoints.computeScreenCoordinatesInParallel(xAxis, yAxis, dataSet, dataSetOffset + ldataSetIndex, indexMin, indexMax, this.getErrorType(), isPolarPlot, this.isallowNaNs());
                } else {
                    localCachedPoints.computeScreenCoordinates(xAxis, yAxis, dataSet, dataSetOffset + ldataSetIndex, indexMin, indexMax, this.getErrorType(), isPolarPlot, this.isallowNaNs());
                }
                if (ProcessingProfiler.getDebugState()) {
                    this.stopStamp = ProcessingProfiler.getTimeDiff((long)this.stopStamp, (String)"computeScreenCoordinates()");
                }
                return Optional.of(localCachedPoints);
            });
            drawnDataSet.add(dataSet);
            cachedPoints.ifPresent(value -> {
                value.reduce((RendererDataReducer)this.rendererDataReducerProperty().get(), this.isReducePoints(), this.getMinRequiredReductionSize());
                this.drawChartCompontents(gc, (CachedDataPoints)value);
                value.release();
            });
            this.stopStamp = ProcessingProfiler.getTimeStamp();
            if (!ProcessingProfiler.getDebugState()) continue;
            ProcessingProfiler.getTimeDiff((long)this.stopStamp, (String)"localCachedPoints.release()");
        }
        ProcessingProfiler.getTimeDiff((long)start);
        return drawnDataSet;
    }

    public void setMarker(Marker marker) {
        this.marker = marker;
    }

    protected void drawBars(GraphicsContext gc, CachedDataPoints localCachedPoints) {
        if (!this.isDrawBars()) {
            return;
        }
        int xOffset = Math.max(localCachedPoints.dataSetIndex, 0);
        int minRequiredWidth = Math.max(this.getDashSize(), localCachedPoints.minDistanceX);
        double barWPercentage = this.getBarWidthPercentage();
        double dynBarWidth = (double)minRequiredWidth * barWPercentage / 100.0;
        double constBarWidth = this.getBarWidth();
        double localBarWidth = this.isDynamicBarWidth() ? dynBarWidth : constBarWidth;
        double barWidthHalf = localBarWidth / 2.0 - (double)(this.isShiftBar() ? xOffset * this.getShiftBarOffset() : 0);
        gc.save();
        DefaultRenderColorScheme.setMarkerScheme(gc, localCachedPoints.defaultStyle, localCachedPoints.dataSetIndex + localCachedPoints.dataSetStyleIndex);
        DefaultRenderColorScheme.setGraphicsContextAttributes(gc, localCachedPoints.defaultStyle);
        if (localCachedPoints.polarPlot) {
            for (int i = 0; i < localCachedPoints.actualDataCount; ++i) {
                if (localCachedPoints.styles[i] == null) {
                    gc.strokeLine(localCachedPoints.xZero, localCachedPoints.yZero, localCachedPoints.xValues[i], localCachedPoints.yValues[i]);
                    continue;
                }
                gc.save();
                gc.setFill((Paint)StyleParser.getColorPropertyValue(localCachedPoints.styles[i], "fillColor"));
                gc.setLineWidth(barWidthHalf);
                gc.strokeLine(localCachedPoints.xZero, localCachedPoints.yZero, localCachedPoints.xValues[i], localCachedPoints.yValues[i]);
                gc.restore();
            }
        } else {
            for (int i = 0; i < localCachedPoints.actualDataCount; ++i) {
                double yMin;
                double yDiff = localCachedPoints.yValues[i] - localCachedPoints.yZero;
                if (yDiff > 0.0) {
                    yMin = localCachedPoints.yZero;
                } else {
                    yMin = localCachedPoints.yValues[i];
                    yDiff = Math.abs(yDiff);
                }
                if (localCachedPoints.styles[i] == null) {
                    gc.fillRect(localCachedPoints.xValues[i] - barWidthHalf, yMin, localBarWidth, yDiff);
                    continue;
                }
                gc.save();
                gc.setFill((Paint)StyleParser.getColorPropertyValue(localCachedPoints.styles[i], "fillColor"));
                gc.fillRect(localCachedPoints.xValues[i] - barWidthHalf, yMin, localBarWidth, yDiff);
                gc.restore();
            }
        }
        gc.restore();
    }

    protected void drawBubbles(GraphicsContext gc, CachedDataPoints localCachedPoints) {
        if (!this.isDrawBubbles()) {
            return;
        }
        gc.save();
        DefaultRenderColorScheme.setMarkerScheme(gc, localCachedPoints.defaultStyle, localCachedPoints.dataSetIndex + localCachedPoints.dataSetStyleIndex);
        Color fillColor = StyleParser.getColorPropertyValue(localCachedPoints.defaultStyle, "strokeColor");
        if (fillColor != null) {
            gc.setFill((Paint)fillColor);
        }
        double minSize = this.getMarkerSize();
        if (localCachedPoints.errorType[0] != DataSetError.ErrorType.NO_ERROR || localCachedPoints.errorType[1] == DataSetError.ErrorType.NO_ERROR) {
            for (int i = 0; i < localCachedPoints.actualDataCount; ++i) {
                double radius = Math.max(minSize, localCachedPoints.errorXPos[i] - localCachedPoints.errorXNeg[i]);
                double x = localCachedPoints.xValues[i] - radius;
                double y = localCachedPoints.yValues[i] - radius;
                gc.fillOval(x, y, 2.0 * radius, 2.0 * radius);
            }
        } else if (localCachedPoints.errorType[0] == DataSetError.ErrorType.NO_ERROR || localCachedPoints.errorType[1] != DataSetError.ErrorType.NO_ERROR) {
            for (int i = 0; i < localCachedPoints.actualDataCount; ++i) {
                double radius = Math.max(minSize, localCachedPoints.errorYNeg[i] - localCachedPoints.errorYPos[i]);
                double x = localCachedPoints.xValues[i] - radius;
                double y = localCachedPoints.yValues[i] - radius;
                gc.fillOval(x, y, 2.0 * radius, 2.0 * radius);
            }
        } else if (localCachedPoints.errorType[0] != DataSetError.ErrorType.NO_ERROR || localCachedPoints.errorType[1] != DataSetError.ErrorType.NO_ERROR) {
            for (int i = 0; i < localCachedPoints.actualDataCount; ++i) {
                double width = Math.max(minSize, localCachedPoints.errorXPos[i] - localCachedPoints.errorXNeg[i]);
                double height = Math.max(minSize, localCachedPoints.errorYNeg[i] - localCachedPoints.errorYPos[i]);
                double x = localCachedPoints.xValues[i] - width;
                double y = localCachedPoints.yValues[i] - height;
                gc.fillOval(x, y, 2.0 * width, 2.0 * height);
            }
        } else {
            for (int i = 0; i < localCachedPoints.actualDataCount; ++i) {
                double x = localCachedPoints.xValues[i] - minSize;
                double y = localCachedPoints.yValues[i] - minSize;
                gc.fillOval(x, y, 2.0 * minSize, 2.0 * minSize);
            }
        }
        gc.restore();
    }

    protected void drawDefaultNoErrors(GraphicsContext gc, CachedDataPoints localCachedPoints) {
        this.drawBars(gc, localCachedPoints);
        this.drawPolyLine(gc, localCachedPoints);
        this.drawMarker(gc, localCachedPoints);
        this.drawBubbles(gc, localCachedPoints);
    }

    protected void drawErrorBars(GraphicsContext gc, CachedDataPoints lCacheP) {
        long start = ProcessingProfiler.getTimeStamp();
        this.drawBars(gc, lCacheP);
        int dashHalf = this.getDashSize() / 2;
        gc.save();
        DefaultRenderColorScheme.setFillScheme(gc, lCacheP.defaultStyle, lCacheP.dataSetIndex);
        DefaultRenderColorScheme.setGraphicsContextAttributes(gc, lCacheP.defaultStyle);
        for (int i = 0; i < lCacheP.actualDataCount; ++i) {
            if (lCacheP.errorType[0] != DataSetError.ErrorType.NO_ERROR && lCacheP.errorType[1] != DataSetError.ErrorType.NO_ERROR) {
                gc.strokeLine(lCacheP.xValues[i], lCacheP.errorYNeg[i], lCacheP.xValues[i], lCacheP.errorYPos[i]);
                gc.strokeLine(lCacheP.errorXNeg[i], lCacheP.yValues[i], lCacheP.errorXPos[i], lCacheP.yValues[i]);
                gc.strokeLine(lCacheP.xValues[i] - (double)dashHalf, lCacheP.errorYNeg[i], lCacheP.xValues[i] + (double)dashHalf, lCacheP.errorYNeg[i]);
                gc.strokeLine(lCacheP.xValues[i] - (double)dashHalf, lCacheP.errorYPos[i], lCacheP.xValues[i] + (double)dashHalf, lCacheP.errorYPos[i]);
                gc.strokeLine(lCacheP.errorXNeg[i], lCacheP.yValues[i] - (double)dashHalf, lCacheP.errorXNeg[i], lCacheP.yValues[i] + (double)dashHalf);
                gc.strokeLine(lCacheP.errorXPos[i], lCacheP.yValues[i] - (double)dashHalf, lCacheP.errorXPos[i], lCacheP.yValues[i] + (double)dashHalf);
                continue;
            }
            if (lCacheP.errorType[0] == DataSetError.ErrorType.NO_ERROR && lCacheP.errorType[1] != DataSetError.ErrorType.NO_ERROR) {
                gc.strokeLine(lCacheP.xValues[i], lCacheP.errorYNeg[i], lCacheP.xValues[i], lCacheP.errorYPos[i]);
                gc.strokeLine(lCacheP.xValues[i] - (double)dashHalf, lCacheP.errorYNeg[i], lCacheP.xValues[i] + (double)dashHalf, lCacheP.errorYNeg[i]);
                gc.strokeLine(lCacheP.xValues[i] - (double)dashHalf, lCacheP.errorYPos[i], lCacheP.xValues[i] + (double)dashHalf, lCacheP.errorYPos[i]);
                continue;
            }
            if (lCacheP.errorType[0] == DataSetError.ErrorType.NO_ERROR || lCacheP.errorType[1] != DataSetError.ErrorType.NO_ERROR) continue;
            gc.strokeLine(lCacheP.errorXNeg[i], lCacheP.yValues[i], lCacheP.errorXPos[i], lCacheP.yValues[i]);
            gc.strokeLine(lCacheP.xValues[i] - (double)dashHalf, lCacheP.errorYNeg[i], lCacheP.xValues[i] + (double)dashHalf, lCacheP.errorYNeg[i]);
            gc.strokeLine(lCacheP.xValues[i] - (double)dashHalf, lCacheP.errorYPos[i], lCacheP.xValues[i] + (double)dashHalf, lCacheP.errorYPos[i]);
        }
        gc.restore();
        this.drawPolyLine(gc, lCacheP);
        this.drawMarker(gc, lCacheP);
        this.drawBubbles(gc, lCacheP);
        ProcessingProfiler.getTimeDiff((long)start);
    }

    protected void drawErrorSurface(GraphicsContext gc, CachedDataPoints localCachedPoints) {
        long start = ProcessingProfiler.getTimeStamp();
        DefaultRenderColorScheme.setFillScheme(gc, localCachedPoints.defaultStyle, localCachedPoints.dataSetIndex + localCachedPoints.dataSetStyleIndex);
        int nDataCount = localCachedPoints.actualDataCount;
        int nPolygoneEdges = 2 * nDataCount;
        double[] xValuesSurface = DoubleArrayCache.getInstance().getArrayExact(nPolygoneEdges);
        double[] yValuesSurface = DoubleArrayCache.getInstance().getArrayExact(nPolygoneEdges);
        int xend = nPolygoneEdges - 1;
        for (int i = 0; i < nDataCount; ++i) {
            xValuesSurface[i] = localCachedPoints.xValues[i];
            yValuesSurface[i] = localCachedPoints.errorYNeg[i];
            xValuesSurface[xend - i] = localCachedPoints.xValues[i];
            yValuesSurface[xend - i] = localCachedPoints.errorYPos[i];
        }
        gc.setFillRule(FillRule.EVEN_ODD);
        gc.fillPolygon(xValuesSurface, yValuesSurface, nPolygoneEdges);
        this.drawPolyLine(gc, localCachedPoints);
        this.drawBars(gc, localCachedPoints);
        this.drawMarker(gc, localCachedPoints);
        this.drawBubbles(gc, localCachedPoints);
        DoubleArrayCache.getInstance().add((Object)xValuesSurface);
        DoubleArrayCache.getInstance().add((Object)yValuesSurface);
        ProcessingProfiler.getTimeDiff((long)start);
    }

    protected void drawErrorSurfaceNaNCompatible(GraphicsContext gc, CachedDataPoints localCachedPoints) {
        long start = ProcessingProfiler.getTimeStamp();
        DefaultRenderColorScheme.setFillScheme(gc, localCachedPoints.defaultStyle, localCachedPoints.dataSetIndex + localCachedPoints.dataSetStyleIndex);
        gc.setFillRule(FillRule.EVEN_ODD);
        int nDataCount = localCachedPoints.actualDataCount;
        int nPolygoneEdges = 2 * nDataCount;
        double[] xValuesSurface = DoubleArrayCache.getInstance().getArrayExact(nPolygoneEdges);
        double[] yValuesSurface = DoubleArrayCache.getInstance().getArrayExact(nPolygoneEdges);
        int xend = nPolygoneEdges - 1;
        int count = 0;
        for (int i = 0; i < nDataCount; ++i) {
            double x = localCachedPoints.xValues[i];
            double yen = localCachedPoints.errorYNeg[i];
            double yep = localCachedPoints.errorYPos[i];
            if (Double.isFinite(yen) && Double.isFinite(yep)) {
                xValuesSurface[count] = x;
                yValuesSurface[count] = yep;
                xValuesSurface[xend - count] = x;
                yValuesSurface[xend - count] = yen;
                ++count;
                continue;
            }
            if (count == 0) continue;
            ErrorDataSetRenderer.compactVector(xValuesSurface, count);
            ErrorDataSetRenderer.compactVector(yValuesSurface, count);
            gc.fillPolygon(xValuesSurface, yValuesSurface, 2 * count);
            count = 0;
        }
        if (count > 0) {
            ErrorDataSetRenderer.compactVector(xValuesSurface, count);
            ErrorDataSetRenderer.compactVector(yValuesSurface, count);
            if (count > 4) {
                double yTmp = yValuesSurface[count - 1];
                yValuesSurface[count - 1] = yValuesSurface[count];
                yValuesSurface[count] = yTmp;
            }
            gc.fillPolygon(xValuesSurface, yValuesSurface, 2 * count);
        }
        this.drawPolyLine(gc, localCachedPoints);
        this.drawBars(gc, localCachedPoints);
        this.drawMarker(gc, localCachedPoints);
        this.drawBubbles(gc, localCachedPoints);
        DoubleArrayCache.getInstance().add((Object)xValuesSurface);
        DoubleArrayCache.getInstance().add((Object)yValuesSurface);
        ProcessingProfiler.getTimeDiff((long)start);
    }

    protected void drawMarker(GraphicsContext gc, CachedDataPoints localCachedPoints) {
        if (!this.isDrawMarker()) {
            return;
        }
        gc.save();
        DefaultRenderColorScheme.setMarkerScheme(gc, localCachedPoints.defaultStyle, localCachedPoints.dataSetIndex + localCachedPoints.dataSetStyleIndex);
        Triple<Marker, Color, Double> markerTypeColorAndSize = this.getDefaultMarker(localCachedPoints.defaultStyle);
        Marker defaultMarker = (Marker)markerTypeColorAndSize.getFirst();
        Color defaultMarkerColor = (Color)markerTypeColorAndSize.getSecond();
        double defaultMarkerSize = (Double)markerTypeColorAndSize.getThird();
        if (defaultMarkerColor != null) {
            gc.setFill((Paint)defaultMarkerColor);
        }
        for (int i = 0; i < localCachedPoints.actualDataCount; ++i) {
            double x = localCachedPoints.xValues[i];
            double y = localCachedPoints.yValues[i];
            if (localCachedPoints.styles[i] == null) {
                defaultMarker.draw(gc, x, y, defaultMarkerSize);
                continue;
            }
            Triple<Marker, Color, Double> markerForPoint = this.getDefaultMarker(localCachedPoints.defaultStyle + localCachedPoints.styles[i]);
            gc.save();
            if (markerForPoint.getSecond() != null) {
                gc.setFill((Paint)markerForPoint.getSecond());
            }
            Marker pointMarker = markerForPoint.getFirst() == null ? defaultMarker : (Marker)markerForPoint.getFirst();
            pointMarker.draw(gc, x, y, (Double)markerForPoint.getThird());
            gc.restore();
        }
        gc.restore();
    }

    protected void drawPolyLine(GraphicsContext gc, CachedDataPoints localCachedPoints) {
        switch (this.getPolyLineStyle()) {
            case NONE: {
                return;
            }
            case AREA: {
                ErrorDataSetRenderer.drawPolyLineArea(gc, localCachedPoints);
                break;
            }
            case ZERO_ORDER_HOLDER: 
            case STAIR_CASE: {
                ErrorDataSetRenderer.drawPolyLineStairCase(gc, localCachedPoints);
                break;
            }
            case HISTOGRAM: {
                ErrorDataSetRenderer.drawPolyLineHistogram(gc, localCachedPoints);
                break;
            }
            case HISTOGRAM_FILLED: {
                ErrorDataSetRenderer.drawPolyLineHistogramFilled(gc, localCachedPoints);
                break;
            }
            case BEZIER_CURVE: {
                ErrorDataSetRenderer.drawPolyLineHistogramBezier(gc, localCachedPoints);
                break;
            }
            default: {
                ErrorDataSetRenderer.drawPolyLineLine(gc, localCachedPoints);
            }
        }
    }

    protected Triple<Marker, Color, Double> getDefaultMarker(String dataSetStyle) {
        String markerColor;
        String markerSize;
        Marker defaultMarker = this.getMarker();
        Color defaultMarkerColor = StyleParser.getColorPropertyValue(dataSetStyle, "strokeColor");
        double defaultMarkerSize = this.getMarkerSize();
        if (dataSetStyle == null) {
            return new Triple((Object)defaultMarker, (Object)defaultMarkerColor, (Object)defaultMarkerSize);
        }
        Map<String, String> map = StyleParser.splitIntoMap(dataSetStyle);
        String markerType = map.get("markerType".toLowerCase(Locale.UK));
        if (markerType != null) {
            try {
                defaultMarker = DefaultMarker.get(markerType);
            }
            catch (IllegalArgumentException ex) {
                LOGGER.error("could not parse marker type description for 'markerType'='" + markerType + "'", (Throwable)ex);
            }
        }
        if ((markerSize = map.get("markerSize".toLowerCase(Locale.UK))) != null) {
            try {
                defaultMarkerSize = Double.parseDouble(markerSize);
            }
            catch (NumberFormatException ex) {
                LOGGER.error("could not parse marker size description for 'markerSize'='" + markerSize + "'", (Throwable)ex);
            }
        }
        if ((markerColor = map.get("markerColor".toLowerCase(Locale.UK))) != null) {
            try {
                defaultMarkerColor = Color.web((String)markerColor);
            }
            catch (IllegalArgumentException ex) {
                LOGGER.error("could not parse marker color description for 'markerColor'='" + markerColor + "'", (Throwable)ex);
            }
        }
        return new Triple((Object)defaultMarker, (Object)defaultMarkerColor, (Object)defaultMarkerSize);
    }

    @Override
    protected ErrorDataSetRenderer getThis() {
        return this;
    }

    private void drawChartCompontents(GraphicsContext gc, CachedDataPoints localCachedPoints) {
        long start = ProcessingProfiler.getTimeStamp();
        switch (this.getErrorType()) {
            case ERRORBARS: {
                this.drawErrorBars(gc, localCachedPoints);
                break;
            }
            case ERRORSURFACE: {
                if (this.isallowNaNs()) {
                    this.drawErrorSurfaceNaNCompatible(gc, localCachedPoints);
                    break;
                }
                this.drawErrorSurface(gc, localCachedPoints);
                break;
            }
            case ERRORCOMBO: {
                if (localCachedPoints.getMinXDistance() >= this.getDashSize() * 2) {
                    this.drawErrorBars(gc, localCachedPoints);
                    break;
                }
                if (this.isallowNaNs()) {
                    this.drawErrorSurfaceNaNCompatible(gc, localCachedPoints);
                    break;
                }
                this.drawErrorSurface(gc, localCachedPoints);
                break;
            }
            default: {
                this.drawDefaultNoErrors(gc, localCachedPoints);
            }
        }
        ProcessingProfiler.getTimeDiff((long)start);
    }

    protected static void drawPolyLineArea(GraphicsContext gc, CachedDataPoints localCachedPoints) {
        int n = localCachedPoints.actualDataCount;
        if (n == 0) {
            return;
        }
        double[] newX = DoubleArrayCache.getInstance().getArrayExact(n + 2);
        double[] newY = DoubleArrayCache.getInstance().getArrayExact(n + 2);
        double zero = localCachedPoints.yZero;
        System.arraycopy(localCachedPoints.xValues, 0, newX, 0, n);
        System.arraycopy(localCachedPoints.yValues, 0, newY, 0, n);
        newX[n] = localCachedPoints.xValues[n - 1];
        newY[n] = zero;
        newX[n + 1] = localCachedPoints.xValues[0];
        newY[n + 1] = zero;
        gc.save();
        DefaultRenderColorScheme.setLineScheme(gc, localCachedPoints.defaultStyle, localCachedPoints.dataSetIndex + localCachedPoints.dataSetStyleIndex);
        DefaultRenderColorScheme.setGraphicsContextAttributes(gc, localCachedPoints.defaultStyle);
        gc.setFill(gc.getStroke());
        gc.fillPolygon(newX, newY, n + 2);
        gc.restore();
        DoubleArrayCache.getInstance().add((Object)newX);
        DoubleArrayCache.getInstance().add((Object)newY);
    }

    protected static void drawPolyLineHistogram(GraphicsContext gc, CachedDataPoints localCachedPoints) {
        int i;
        int n = localCachedPoints.actualDataCount;
        if (n == 0) {
            return;
        }
        double[] newX = DoubleArrayCache.getInstance().getArrayExact(2 * (n + 1));
        double[] newY = DoubleArrayCache.getInstance().getArrayExact(2 * (n + 1));
        double xRange = localCachedPoints.xMax - localCachedPoints.xMin;
        double diffRight = n > 0 ? 0.5 * (localCachedPoints.xValues[1] - localCachedPoints.xValues[0]) : 0.5 * xRange;
        newX[0] = localCachedPoints.xValues[0] - diffRight;
        newY[0] = localCachedPoints.yZero;
        for (i = 0; i < n; ++i) {
            double diffLeft = localCachedPoints.xValues[i] - newX[2 * i];
            double d = diffRight = i + 1 < n ? 0.5 * (localCachedPoints.xValues[i + 1] - localCachedPoints.xValues[i]) : diffLeft;
            if (i == 0) {
                diffLeft = diffRight;
            }
            newX[2 * i + 1] = localCachedPoints.xValues[i] - diffLeft;
            newY[2 * i + 1] = localCachedPoints.yValues[i];
            newX[2 * i + 2] = localCachedPoints.xValues[i] + diffRight;
            newY[2 * i + 2] = localCachedPoints.yValues[i];
        }
        newX[2 * (n + 1) - 1] = localCachedPoints.xValues[n - 1] + diffRight;
        newY[2 * (n + 1) - 1] = localCachedPoints.yZero;
        gc.save();
        DefaultRenderColorScheme.setLineScheme(gc, localCachedPoints.defaultStyle, localCachedPoints.dataSetIndex + localCachedPoints.dataSetStyleIndex);
        DefaultRenderColorScheme.setGraphicsContextAttributes(gc, localCachedPoints.defaultStyle);
        for (i = 0; i < 2 * (n + 1) - 1; ++i) {
            double x1 = newX[i];
            double x2 = newX[i + 1];
            double y1 = newY[i];
            double y2 = newY[i + 1];
            gc.strokeLine(x1, y1, x2, y2);
        }
        gc.restore();
        DoubleArrayCache.getInstance().add((Object)newX);
        DoubleArrayCache.getInstance().add((Object)newY);
    }

    protected static void drawPolyLineHistogramBezier(GraphicsContext gc, CachedDataPoints localCachedPoints) {
        int n = localCachedPoints.actualDataCount;
        if (n < 2) {
            ErrorDataSetRenderer.drawPolyLineLine(gc, localCachedPoints);
            return;
        }
        double[] xCp1 = DoubleArrayCache.getInstance().getArrayExact(n);
        double[] yCp1 = DoubleArrayCache.getInstance().getArrayExact(n);
        double[] xCp2 = DoubleArrayCache.getInstance().getArrayExact(n);
        double[] yCp2 = DoubleArrayCache.getInstance().getArrayExact(n);
        BezierCurve.calcCurveControlPoints(localCachedPoints.xValues, localCachedPoints.yValues, xCp1, yCp1, xCp2, yCp2, localCachedPoints.actualDataCount);
        gc.save();
        DefaultRenderColorScheme.setLineScheme(gc, localCachedPoints.defaultStyle, localCachedPoints.dataSetIndex + localCachedPoints.dataSetStyleIndex);
        DefaultRenderColorScheme.setGraphicsContextAttributes(gc, localCachedPoints.defaultStyle);
        gc.setFill(gc.getStroke());
        gc.beginPath();
        for (int i = 0; i < n - 1; ++i) {
            double x0 = localCachedPoints.xValues[i];
            double x1 = localCachedPoints.xValues[i + 1];
            double y0 = localCachedPoints.yValues[i];
            double y1 = localCachedPoints.yValues[i + 1];
            double xc0 = xCp1[i];
            double yc0 = yCp1[i];
            double xc1 = xCp2[i];
            double yc1 = yCp2[i];
            gc.moveTo(x0, y0);
            gc.bezierCurveTo(xc0, yc0, xc1, yc1, x1, y1);
        }
        gc.moveTo(localCachedPoints.xValues[n - 1], localCachedPoints.yValues[n - 1]);
        gc.closePath();
        gc.stroke();
        gc.restore();
        DoubleArrayCache.getInstance().add((Object)xCp1);
        DoubleArrayCache.getInstance().add((Object)yCp1);
        DoubleArrayCache.getInstance().add((Object)xCp2);
        DoubleArrayCache.getInstance().add((Object)yCp2);
    }

    protected static void drawPolyLineHistogramFilled(GraphicsContext gc, CachedDataPoints localCachedPoints) {
        int n = localCachedPoints.actualDataCount;
        if (n == 0) {
            return;
        }
        double[] newX = DoubleArrayCache.getInstance().getArrayExact(2 * (n + 1));
        double[] newY = DoubleArrayCache.getInstance().getArrayExact(2 * (n + 1));
        double xRange = localCachedPoints.xMax - localCachedPoints.xMin;
        double diffRight = n > 0 ? 0.5 * (localCachedPoints.xValues[1] - localCachedPoints.xValues[0]) : 0.5 * xRange;
        newX[0] = localCachedPoints.xValues[0] - diffRight;
        newY[0] = localCachedPoints.yZero;
        for (int i = 0; i < n; ++i) {
            double diffLeft = localCachedPoints.xValues[i] - newX[2 * i];
            double d = diffRight = i + 1 < n ? 0.5 * (localCachedPoints.xValues[i + 1] - localCachedPoints.xValues[i]) : diffLeft;
            if (i == 0) {
                diffLeft = diffRight;
            }
            newX[2 * i + 1] = localCachedPoints.xValues[i] - diffLeft;
            newY[2 * i + 1] = localCachedPoints.yValues[i];
            newX[2 * i + 2] = localCachedPoints.xValues[i] + diffRight;
            newY[2 * i + 2] = localCachedPoints.yValues[i];
        }
        newX[2 * (n + 1) - 1] = localCachedPoints.xValues[n - 1] + diffRight;
        newY[2 * (n + 1) - 1] = localCachedPoints.yZero;
        gc.save();
        DefaultRenderColorScheme.setLineScheme(gc, localCachedPoints.defaultStyle, localCachedPoints.dataSetIndex + localCachedPoints.dataSetStyleIndex);
        DefaultRenderColorScheme.setGraphicsContextAttributes(gc, localCachedPoints.defaultStyle);
        gc.setFill(gc.getStroke());
        gc.fillPolygon(newX, newY, 2 * (n + 1));
        gc.restore();
        DoubleArrayCache.getInstance().add((Object)newX);
        DoubleArrayCache.getInstance().add((Object)newY);
    }

    protected static void drawPolyLineLine(GraphicsContext gc, CachedDataPoints localCachedPoints) {
        gc.save();
        DefaultRenderColorScheme.setLineScheme(gc, localCachedPoints.defaultStyle, localCachedPoints.dataSetIndex + localCachedPoints.dataSetStyleIndex);
        DefaultRenderColorScheme.setGraphicsContextAttributes(gc, localCachedPoints.defaultStyle);
        if (localCachedPoints.allowForNaNs) {
            gc.beginPath();
            gc.moveTo(localCachedPoints.xValues[0], localCachedPoints.yValues[0]);
            boolean lastIsFinite = true;
            double xLastValid = 0.0;
            double yLastValid = 0.0;
            for (int i = 0; i < localCachedPoints.actualDataCount; ++i) {
                double x0 = localCachedPoints.xValues[i];
                double y0 = localCachedPoints.yValues[i];
                if (Double.isFinite(x0) && Double.isFinite(y0)) {
                    if (!lastIsFinite) {
                        gc.moveTo(x0, y0);
                        lastIsFinite = true;
                        continue;
                    }
                    gc.lineTo(x0, y0);
                    xLastValid = x0;
                    yLastValid = y0;
                    lastIsFinite = true;
                    continue;
                }
                lastIsFinite = false;
            }
            gc.moveTo(xLastValid, yLastValid);
            gc.closePath();
            gc.stroke();
        } else if (gc.getLineDashes() != null) {
            gc.strokePolyline(localCachedPoints.xValues, localCachedPoints.yValues, localCachedPoints.actualDataCount);
        } else {
            for (int i = 0; i < localCachedPoints.actualDataCount - 1; ++i) {
                double x1 = localCachedPoints.xValues[i];
                double x2 = localCachedPoints.xValues[i + 1];
                double y1 = localCachedPoints.yValues[i];
                double y2 = localCachedPoints.yValues[i + 1];
                gc.strokeLine(x1, y1, x2, y2);
            }
        }
        gc.restore();
    }

    protected static void drawPolyLineStairCase(GraphicsContext gc, CachedDataPoints localCachedPoints) {
        int i;
        int n = localCachedPoints.actualDataCount;
        if (n == 0) {
            return;
        }
        double[] newX = DoubleArrayCache.getInstance().getArrayExact(2 * n);
        double[] newY = DoubleArrayCache.getInstance().getArrayExact(2 * n);
        for (i = 0; i < n - 1; ++i) {
            newX[2 * i] = localCachedPoints.xValues[i];
            newY[2 * i] = localCachedPoints.yValues[i];
            newX[2 * i + 1] = localCachedPoints.xValues[i + 1];
            newY[2 * i + 1] = localCachedPoints.yValues[i];
        }
        newX[2 * (n - 1)] = localCachedPoints.xValues[n - 1];
        newY[2 * (n - 1)] = localCachedPoints.yValues[n - 1];
        newX[2 * n - 1] = localCachedPoints.xMax;
        newY[2 * n - 1] = localCachedPoints.yValues[n - 1];
        gc.save();
        DefaultRenderColorScheme.setLineScheme(gc, localCachedPoints.defaultStyle, localCachedPoints.dataSetIndex + localCachedPoints.dataSetStyleIndex);
        DefaultRenderColorScheme.setGraphicsContextAttributes(gc, localCachedPoints.defaultStyle);
        for (i = 0; i < 2 * n - 1; ++i) {
            double x1 = newX[i];
            double x2 = newX[i + 1];
            double y1 = newY[i];
            double y2 = newY[i + 1];
            gc.strokeLine(x1, y1, x2, y2);
        }
        gc.restore();
        DoubleArrayCache.getInstance().add((Object)newX);
        DoubleArrayCache.getInstance().add((Object)newY);
    }

    private static void compactVector(double[] input, int stopIndex) {
        if (stopIndex >= 0) {
            System.arraycopy(input, input.length - stopIndex, input, stopIndex, stopIndex);
        }
    }
}

