/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.renderer.spi;

import de.gsi.chart.Chart;
import de.gsi.chart.XYChart;
import de.gsi.chart.axes.Axis;
import de.gsi.chart.axes.AxisTransform;
import de.gsi.chart.axes.spi.DefaultNumericAxis;
import de.gsi.chart.renderer.Renderer;
import de.gsi.chart.renderer.spi.AbstractContourDataSetRendererParameter;
import de.gsi.chart.renderer.spi.ContourDataSetCache;
import de.gsi.chart.renderer.spi.hexagon.Hexagon;
import de.gsi.chart.renderer.spi.hexagon.HexagonMap;
import de.gsi.chart.renderer.spi.marchingsquares.GeneralPath;
import de.gsi.chart.renderer.spi.marchingsquares.MarchingSquares;
import de.gsi.chart.renderer.spi.utils.ColorGradient;
import de.gsi.chart.ui.geometry.Side;
import de.gsi.dataset.DataSet;
import de.gsi.dataset.GridDataSet;
import de.gsi.dataset.utils.ProcessingProfiler;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import javafx.collections.ObservableList;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.image.Image;
import javafx.scene.image.PixelWriter;
import javafx.scene.image.WritableImage;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.LinearGradient;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.StrokeType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContourDataSetRenderer
extends AbstractContourDataSetRendererParameter<ContourDataSetRenderer>
implements Renderer {
    private static final Logger LOGGER = LoggerFactory.getLogger(ContourDataSetRenderer.class);
    private ContourDataSetCache localCache;
    private Axis zAxis;
    protected final Rectangle gradientRect = new Rectangle();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drawContour(GraphicsContext gc, ContourDataSetCache lCache) {
        double[] levels = new double[this.getNumberQuantisationLevels()];
        for (int i = 0; i < levels.length; ++i) {
            levels[i] = (double)(i + 1) / (double)levels.length;
        }
        int xSize = lCache.xSize;
        int ySize = lCache.ySize;
        double[][] data = new double[ySize][xSize];
        for (int yIndex = 0; yIndex < ySize; ++yIndex) {
            for (int xIndex = 0; xIndex < xSize; ++xIndex) {
                double offset;
                data[ySize - 1 - yIndex][xIndex] = offset = lCache.reduced[yIndex * xSize + xIndex];
            }
        }
        double zRange = Math.abs(lCache.zMax - lCache.zMin);
        if (zRange <= 0.0) {
            return;
        }
        ColorGradient colorGradient = this.getColorGradient();
        MarchingSquares marchingSquares = new MarchingSquares();
        double scaleX = lCache.xDataPixelRange / (double)xSize;
        double scaleY = lCache.yDataPixelRange / (double)ySize;
        gc.save();
        gc.translate(lCache.xDataPixelMin, lCache.yDataPixelMin);
        gc.scale(scaleX, scaleY);
        try {
            GeneralPath[] isolines = marchingSquares.buildContours(data, levels);
            int levelCount = 0;
            for (GeneralPath path : isolines) {
                if (path.size() > this.getMaxContourSegments()) {
                    ++levelCount;
                    continue;
                }
                Color color = lCache.zInverted ? colorGradient.getColor(1.0 - levels[levelCount++]) : colorGradient.getColor(levels[levelCount++]);
                gc.setStroke((Paint)color);
                gc.setLineDashes(new double[]{1.0});
                gc.setMiterLimit(10.0);
                gc.setFill((Paint)color);
                gc.setLineWidth(0.5);
                path.draw(gc);
            }
        }
        catch (InterruptedException | ExecutionException e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.atError().setCause((Throwable)e).log("marchingSquares algorithm");
            }
        }
        finally {
            gc.restore();
        }
    }

    private void drawContourFast(GraphicsContext gc, AxisTransform axisTransform, ContourDataSetCache lCache) {
        long start = ProcessingProfiler.getTimeStamp();
        int xSize = lCache.xSize;
        int ySize = lCache.ySize;
        double zMin = axisTransform.forward(lCache.zMin);
        double zMax = axisTransform.forward(lCache.zMax);
        gc.setImageSmoothing(this.isSmooth());
        this.getNumberQuantisationLevels();
        double[][] input = new double[xSize][ySize];
        double[][] output = new double[xSize][ySize];
        double[][] output2 = new double[xSize][ySize];
        double[] levels = new double[this.getNumberQuantisationLevels()];
        for (int i = 0; i < levels.length; ++i) {
            levels[i] = (double)(i + 1) / (double)levels.length;
        }
        int length = xSize * ySize;
        for (int i = 0; i < length; ++i) {
            int x = i % xSize;
            int y = i / xSize;
            input[x][y] = lCache.reduced[i];
        }
        WritableImage image = this.localCache.getImage(xSize, ySize);
        PixelWriter pixelWriter = image.getPixelWriter();
        if (pixelWriter == null) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.atError().log("Could not get PixelWriter for image");
            }
            return;
        }
        ColorGradient colorGradient = this.getColorGradient();
        for (double level : levels) {
            ContourDataSetRenderer.sobelOperator(input, output2, zMin, zMax, level);
            ContourDataSetRenderer.erosionOperator(output2, output, zMin, zMax, level);
            for (int yIndex = 0; yIndex < ySize; ++yIndex) {
                int yIndex2 = ySize - 1 - yIndex;
                for (int xIndex = 0; xIndex < xSize; ++xIndex) {
                    double z = output[xIndex][yIndex];
                    if (z <= 0.0) continue;
                    Color color = lCache.zInverted ? colorGradient.getColor(1.0 - level) : colorGradient.getColor(level);
                    pixelWriter.setColor(xIndex, yIndex2, color);
                }
            }
        }
        gc.drawImage((Image)image, lCache.xDataPixelMin, lCache.yDataPixelMin, lCache.xDataPixelRange, lCache.yDataPixelRange);
        this.localCache.add(image);
        ProcessingProfiler.getTimeDiff((long)start, (String)"sobel");
    }

    private void drawHeatMap(GraphicsContext gc, ContourDataSetCache lCache) {
        long start = ProcessingProfiler.getTimeStamp();
        gc.setImageSmoothing(this.isSmooth());
        WritableImage image = this.localCache.convertDataArrayToImage(lCache.reduced, lCache.xSize, lCache.ySize, this.getColorGradient());
        ProcessingProfiler.getTimeDiff((long)start, (String)"color map");
        gc.drawImage((Image)image, lCache.xDataPixelMin, lCache.yDataPixelMin, lCache.xDataPixelRange, lCache.yDataPixelRange);
        this.localCache.add(image);
        ProcessingProfiler.getTimeDiff((long)start, (String)"drawHeatMap");
    }

    private void drawHexagonHeatMap(GraphicsContext gc, ContourDataSetCache lCache) {
        long start = ProcessingProfiler.getTimeStamp();
        WritableImage image = this.localCache.convertDataArrayToImage(lCache.reduced, lCache.xSize, lCache.ySize, this.getColorGradient());
        int tileSize = Math.max(this.getMinHexTileSizeProperty(), (int)lCache.xAxisWidth / lCache.xSize);
        int nWidthInTiles = (int)(lCache.xAxisWidth / ((double)tileSize * Math.sqrt(3.0))) + 1;
        HexagonMap map2 = new HexagonMap(tileSize, (Image)image, nWidthInTiles, (q, r, imagePixelColor, map) -> {
            Hexagon h = new Hexagon(q, r);
            h.setFill((Paint)imagePixelColor);
            h.setStroke((Paint)imagePixelColor);
            h.setStrokeWidth(0.5);
            map.addHexagon(h);
        });
        this.localCache.add(image);
        ProcessingProfiler.getTimeDiff((long)start, (String)"drawHexagonMap - prepare");
        double scaleX = lCache.xDataPixelRange / lCache.xAxisWidth;
        double scaleY = lCache.yDataPixelRange / lCache.yAxisHeight;
        gc.save();
        gc.translate(lCache.xDataPixelMin, lCache.yDataPixelMin);
        gc.scale(scaleX, scaleY);
        map2.render(gc.getCanvas());
        gc.restore();
        ProcessingProfiler.getTimeDiff((long)start, (String)"drawHexagonMap");
    }

    private void drawHexagonMapContour(GraphicsContext gc, ContourDataSetCache lCache) {
        long start = ProcessingProfiler.getTimeStamp();
        WritableImage image = this.localCache.convertDataArrayToImage(lCache.reduced, lCache.xSize, lCache.ySize, this.getColorGradient());
        int tileSize = Math.max(this.getMinHexTileSizeProperty(), (int)lCache.xAxisWidth / lCache.xSize);
        int nWidthInTiles = (int)(lCache.xAxisWidth / ((double)tileSize * Math.sqrt(3.0)));
        HexagonMap hexMap = new HexagonMap(tileSize, (Image)image, nWidthInTiles, (q, r, imagePixelColor, map) -> {
            Hexagon h = new Hexagon(q, r);
            h.setFill((Paint)Color.TRANSPARENT);
            h.setStroke((Paint)imagePixelColor);
            h.setStrokeType(StrokeType.CENTERED);
            h.setStrokeWidth(1.0);
            map.addHexagon(h);
        });
        this.localCache.add(image);
        ProcessingProfiler.getTimeDiff((long)start, (String)"drawHexagonMapContour - prepare");
        double scaleX = lCache.xDataPixelRange / lCache.xAxisWidth;
        double scaleY = lCache.yDataPixelRange / lCache.yAxisHeight;
        gc.save();
        gc.translate(lCache.xDataPixelMin, lCache.yDataPixelMin);
        gc.scale(scaleX, scaleY);
        hexMap.renderContour(gc.getCanvas());
        gc.restore();
        ProcessingProfiler.getTimeDiff((long)start, (String)"drawHexagonMapContour");
    }

    @Override
    public Canvas drawLegendSymbol(DataSet dataSet, int dsIndex, int width, int height) {
        return null;
    }

    @Override
    protected ContourDataSetRenderer getThis() {
        return this;
    }

    public Axis getZAxis() {
        ArrayList<Axis> localAxesList = new ArrayList<Axis>((Collection<Axis>)this.getAxes());
        localAxesList.remove(this.getFirstAxis(Orientation.HORIZONTAL));
        localAxesList.remove(this.getFirstAxis(Orientation.VERTICAL));
        if (localAxesList.isEmpty()) {
            this.zAxis = new DefaultNumericAxis("z-Axis");
            this.zAxis.setAnimated(false);
            this.zAxis.setSide(Side.RIGHT);
            this.getAxes().add((Object)this.zAxis);
        } else {
            this.zAxis = localAxesList.get(0);
            if (this.zAxis.getSide() == null) {
                this.zAxis.setSide(Side.RIGHT);
            }
        }
        this.shiftZAxisToRight();
        return this.zAxis;
    }

    protected void layoutZAxis(Axis localZAxis) {
        if (localZAxis.getSide() == null || !(localZAxis instanceof Node)) {
            return;
        }
        Node zAxisNode = (Node)localZAxis;
        zAxisNode.getProperties().put((Object)"OmitAxisZoom", (Object)Boolean.TRUE);
        if (localZAxis.getSide().isHorizontal()) {
            zAxisNode.setLayoutX(50.0);
            this.gradientRect.setX(0.0);
            this.gradientRect.setWidth(localZAxis.getWidth());
            this.gradientRect.setHeight(20.0);
            zAxisNode.setLayoutX(0.0);
            this.gradientRect.setFill((Paint)new LinearGradient(0.0, 0.0, 1.0, 0.0, true, CycleMethod.NO_CYCLE, this.getColorGradient().getStops()));
            if (!(zAxisNode.getParent() instanceof VBox)) {
                return;
            }
            VBox parent = (VBox)zAxisNode.getParent();
            if (!parent.getChildren().contains((Object)this.gradientRect)) {
                parent.getChildren().add((Object)this.gradientRect);
            }
        } else {
            zAxisNode.setLayoutY(50.0);
            this.gradientRect.setWidth(20.0);
            this.gradientRect.setHeight(localZAxis.getHeight());
            this.gradientRect.setFill((Paint)new LinearGradient(0.0, 1.0, 0.0, 0.0, true, CycleMethod.NO_CYCLE, this.getColorGradient().getStops()));
            this.gradientRect.setLayoutX(10.0);
            if (!(zAxisNode.getParent() instanceof HBox)) {
                return;
            }
            HBox parent = (HBox)zAxisNode.getParent();
            if (!parent.getChildren().contains((Object)this.gradientRect)) {
                parent.getChildren().add(0, (Object)this.gradientRect);
            }
        }
        if (localZAxis instanceof Region) {
            ((Region)zAxisNode).requestLayout();
        }
    }

    private void paintCanvas(GraphicsContext gc) {
        if (this.localCache.xSize == 0 || this.localCache.ySize == 0) {
            return;
        }
        Axis localZAxis = this.getZAxis();
        if (localZAxis == null) {
            return;
        }
        AxisTransform axisTransform = localZAxis.getAxisTransform();
        if (axisTransform == null) {
            return;
        }
        switch (this.getContourType()) {
            case CONTOUR: {
                this.drawContour(gc, this.localCache);
                break;
            }
            case CONTOUR_FAST: {
                this.drawContourFast(gc, axisTransform, this.localCache);
                break;
            }
            case CONTOUR_HEXAGON: {
                this.drawHexagonMapContour(gc, this.localCache);
                break;
            }
            case HEATMAP_HEXAGON: {
                this.drawHexagonHeatMap(gc, this.localCache);
                break;
            }
            default: {
                this.drawHeatMap(gc, this.localCache);
            }
        }
    }

    @Override
    public List<DataSet> render(GraphicsContext gc, Chart chart, int dataSetOffset, ObservableList<DataSet> datasets) {
        long start = ProcessingProfiler.getTimeStamp();
        if (!(chart instanceof XYChart)) {
            throw new InvalidParameterException("must be derivative of XYChart for renderer - " + this.getClass().getSimpleName());
        }
        ArrayList<DataSet> localDataSetList = new ArrayList<DataSet>((Collection<DataSet>)datasets);
        localDataSetList.addAll((Collection<DataSet>)this.getDatasets());
        if (localDataSetList.isEmpty()) {
            return Collections.emptyList();
        }
        XYChart xyChart = (XYChart)chart;
        long mid = ProcessingProfiler.getTimeDiff((long)start, (String)"init");
        ArrayList<DataSet> drawnDataSet = new ArrayList<DataSet>(localDataSetList.size());
        for (int dataSetIndex = localDataSetList.size() - 1; dataSetIndex >= 0; --dataSetIndex) {
            DataSet dataSet = (DataSet)localDataSetList.get(dataSetIndex);
            if (!(dataSet instanceof GridDataSet) || dataSet.getDimension() <= 2) continue;
            boolean result = (Boolean)dataSet.lock().readLockGuard(() -> {
                long stop = ProcessingProfiler.getTimeDiff((long)mid, (String)"dataSet.lock()");
                if (dataSet.getDataCount() == 0) {
                    return false;
                }
                this.localCache = new ContourDataSetCache(xyChart, this, dataSet);
                ProcessingProfiler.getTimeDiff((long)stop, (String)"updateCachedVariables");
                return true;
            });
            if (result) {
                this.layoutZAxis(this.getZAxis());
                this.paintCanvas(gc);
                drawnDataSet.add(dataSet);
                this.localCache.releaseCachedVariables();
            }
            ProcessingProfiler.getTimeDiff((long)mid, (String)"finished drawing");
        }
        ProcessingProfiler.getTimeDiff((long)start);
        return drawnDataSet;
    }

    public void shiftZAxisToLeft() {
        this.gradientRect.toBack();
        if (this.zAxis instanceof Node) {
            ((Node)this.zAxis).toBack();
        }
    }

    public void shiftZAxisToRight() {
        this.gradientRect.toFront();
        if (this.zAxis instanceof Node) {
            ((Node)this.zAxis).toFront();
        }
    }

    public static double convolution(double[][] pixelMatrix) {
        double gy = pixelMatrix[0][0] * -1.0 + pixelMatrix[0][1] * -2.0 + pixelMatrix[0][2] * -1.0 + pixelMatrix[2][0] + pixelMatrix[2][1] * 2.0 + pixelMatrix[2][2] * 1.0;
        double gx = pixelMatrix[0][0] + pixelMatrix[0][2] * -1.0 + pixelMatrix[1][0] * 2.0 + pixelMatrix[1][2] * -2.0 + pixelMatrix[2][0] + pixelMatrix[2][2] * -1.0;
        return Math.sqrt(Math.pow(gy, 2.0) + Math.pow(gx, 2.0));
    }

    public static double erosionConvolution(double[][] pixelMatrix) {
        double sum = 0.0;
        sum += pixelMatrix[0][0];
        sum += pixelMatrix[0][1];
        sum += pixelMatrix[0][2];
        sum += pixelMatrix[1][0];
        sum += pixelMatrix[1][1];
        sum += pixelMatrix[1][2];
        sum += pixelMatrix[2][0];
        sum += pixelMatrix[2][1];
        return sum += pixelMatrix[2][2];
    }

    private static void erosionOperator(double[][] input, double[][] output, double zMin, double zMax, double level) {
        int width = input.length;
        int height = input[0].length;
        double[][] gX = new double[width][height];
        double[][] gY = new double[width][height];
        double[][] pixelMatrix = new double[3][3];
        for (int i = 0; i < width; ++i) {
            for (int j = 0; j < height; ++j) {
                if (i == 0 || i == width - 1 || j == 0 || j == height - 1) {
                    output[i][j] = 0.0;
                    gY[i][j] = 0.0;
                    gX[i][j] = 0.0;
                    continue;
                }
                pixelMatrix[0][0] = input[i - 1][j - 1] > level ? 1.0 : 0.0;
                pixelMatrix[0][1] = input[i - 1][j] > level ? 1.0 : 0.0;
                pixelMatrix[0][2] = input[i - 1][j + 1] > level ? 1.0 : 0.0;
                pixelMatrix[1][0] = input[i][j - 1] > level ? 1.0 : 0.0;
                pixelMatrix[1][2] = input[i][j + 1] > level ? 1.0 : 0.0;
                pixelMatrix[2][0] = input[i + 1][j - 1] > level ? 1.0 : 0.0;
                pixelMatrix[2][1] = input[i + 1][j] > level ? 1.0 : 0.0;
                pixelMatrix[2][2] = input[i + 1][j + 1] > level ? 1.0 : 0.0;
                double zNorm = ContourDataSetRenderer.erosionConvolution(pixelMatrix);
                output[i][j] = zNorm > 4.0 ? 1.0 : 0.0;
            }
        }
    }

    private static double quantize(double value, int nLevels) {
        return (double)((int)(value * (double)nLevels)) / (double)nLevels;
    }

    private static void sobelOperator(double[][] input, double[][] output, double zMin, double zMax, double level) {
        int width = input.length;
        int height = input[0].length;
        double[][] gX = new double[width][height];
        double[][] gY = new double[width][height];
        double[][] pixelMatrix = new double[3][3];
        for (int i = 0; i < width; ++i) {
            for (int j = 0; j < height; ++j) {
                if (i == 0 || i == width - 1 || j == 0 || j == height - 1) {
                    output[i][j] = 0.0;
                    gY[i][j] = 0.0;
                    gX[i][j] = 0.0;
                    continue;
                }
                pixelMatrix[0][0] = input[i - 1][j - 1] > level ? 1.0 : 0.0;
                pixelMatrix[0][1] = input[i - 1][j] > level ? 1.0 : 0.0;
                pixelMatrix[0][2] = input[i - 1][j + 1] > level ? 1.0 : 0.0;
                pixelMatrix[1][0] = input[i][j - 1] > level ? 1.0 : 0.0;
                pixelMatrix[1][2] = input[i][j + 1] > level ? 1.0 : 0.0;
                pixelMatrix[2][0] = input[i + 1][j - 1] > level ? 1.0 : 0.0;
                pixelMatrix[2][1] = input[i + 1][j] > level ? 1.0 : 0.0;
                pixelMatrix[2][2] = input[i + 1][j + 1] > level ? 1.0 : 0.0;
                output[i][j] = ContourDataSetRenderer.convolution(pixelMatrix);
            }
        }
    }
}

