/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.renderer.spi;

import de.gsi.chart.XYChart;
import de.gsi.chart.axes.Axis;
import de.gsi.chart.renderer.Renderer;
import de.gsi.dataset.DataSet;
import de.gsi.dataset.DataSetError;
import de.gsi.dataset.spi.DoubleDataSet;
import de.gsi.dataset.spi.DoubleErrorDataSet;
import de.gsi.dataset.utils.NoDuplicatesList;
import de.gsi.dataset.utils.ProcessingProfiler;
import java.util.List;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.Orientation;

public abstract class AbstractDataSetManagement<R extends Renderer>
implements Renderer {
    private final ObservableList<DataSet> datasets = FXCollections.observableArrayList();
    protected BooleanProperty showInLegend = new SimpleBooleanProperty((Object)this, "showInLegend", true);
    private final ObservableList<Axis> axesList = FXCollections.observableList((List)new NoDuplicatesList());

    @Override
    public ObservableList<Axis> getAxes() {
        return this.axesList;
    }

    @Override
    public ObservableList<DataSet> getDatasets() {
        return this.datasets;
    }

    @Override
    public ObservableList<DataSet> getDatasetsCopy() {
        return this.getDatasetsCopy(this.getDatasets());
    }

    protected ObservableList<DataSet> getDatasetsCopy(ObservableList<DataSet> localDataSets) {
        long start = ProcessingProfiler.getTimeStamp();
        ObservableList dataSets = FXCollections.observableArrayList();
        for (DataSet dataSet : localDataSets) {
            if (dataSet instanceof DataSetError) {
                dataSets.add((Object)new DoubleErrorDataSet(dataSet));
                continue;
            }
            dataSets.add((Object)new DoubleDataSet(dataSet));
        }
        ProcessingProfiler.getTimeDiff((long)start);
        return dataSets;
    }

    public Axis getFirstAxis(Orientation orientation) {
        block3: for (Axis axis : this.getAxes()) {
            if (axis.getSide() == null) continue;
            switch (orientation) {
                case VERTICAL: {
                    if (!axis.getSide().isVertical()) continue block3;
                    return axis;
                }
            }
            if (!axis.getSide().isHorizontal()) continue;
            return axis;
        }
        return null;
    }

    protected Axis getFirstAxis(Orientation orientation, XYChart fallback) {
        Axis axis = this.getFirstAxis(orientation);
        if (axis == null) {
            return fallback.getFirstAxis(orientation);
        }
        return axis;
    }

    protected abstract R getThis();

    public R setShowInLegend(boolean state) {
        this.showInLegend.set(state);
        return this.getThis();
    }

    @Override
    public boolean showInLegend() {
        return this.showInLegend.get();
    }

    @Override
    public final BooleanProperty showInLegendProperty() {
        return this.showInLegend;
    }
}

