/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.renderer.datareduction;

import de.gsi.chart.renderer.RendererDataReducer;
import de.gsi.dataset.utils.ProcessingProfiler;

public class MaxDataReducer
implements RendererDataReducer {
    private static final int DEFAULT_MAX_POINTS_COUNT = 1000;

    private int reduce(double[] xValues, double[] yValues, double[] xPointErrorsPos, double[] xPointErrorsNeg, double[] yPointErrorsPos, double[] yPointErrorsNeg, String[] styles, boolean[] pointSelected, int indexMin, int indexMax, int maxPointsCount) {
        int n;
        long start = ProcessingProfiler.getTimeStamp();
        int size = indexMax - indexMin;
        int count = 0;
        int nLastAdded = n = indexMin;
        MaxDataReducer.moveInPlace(xValues, yValues, xPointErrorsPos, xPointErrorsNeg, yPointErrorsPos, yPointErrorsNeg, styles, pointSelected, n++, count++);
        double d = (double)size / (double)maxPointsCount;
        int b = 1;
        int limit = (int)Math.round((double)b * d);
        double delta = Math.abs(yValues[n] - yValues[count - 1]);
        while (n < indexMax) {
            if (n - nLastAdded >= limit) {
                nLastAdded = n;
                MaxDataReducer.moveInPlace(xValues, yValues, xPointErrorsPos, xPointErrorsNeg, yPointErrorsPos, yPointErrorsNeg, styles, pointSelected, n++, count++);
                ++b;
            } else {
                double delta1 = Math.abs(yValues[n] - yValues[count - 1]);
                if (delta1 > delta) {
                    delta = delta1;
                }
            }
            ++n;
        }
        if (ProcessingProfiler.getDebugState()) {
            ProcessingProfiler.getTimeDiff((long)start, (String)String.format("data reduction (from %d to %d)", indexMax - indexMin, count));
        }
        return count;
    }

    @Override
    public int reducePoints(double[] xValues, double[] yValues, double[] xPointErrorsPos, double[] xPointErrorsNeg, double[] yPointErrorsPos, double[] yPointErrorsNeg, String[] styles, boolean[] pointSelected, int indexMin, int indexMax) {
        int size = indexMax - indexMin;
        if (size <= 1000) {
            MaxDataReducer.shiftDataToFront(xValues, indexMin, indexMax);
            MaxDataReducer.shiftDataToFront(yValues, indexMin, indexMax);
            if (xPointErrorsPos != null) {
                MaxDataReducer.shiftDataToFront(xPointErrorsPos, indexMin, indexMax);
            }
            if (xPointErrorsNeg != null) {
                MaxDataReducer.shiftDataToFront(xPointErrorsNeg, indexMin, indexMax);
            }
            MaxDataReducer.shiftDataToFront(yPointErrorsPos, indexMin, indexMax);
            MaxDataReducer.shiftDataToFront(yPointErrorsNeg, indexMin, indexMax);
            MaxDataReducer.shiftDataToFront(styles, indexMin, indexMax);
            MaxDataReducer.shiftDataToFront(pointSelected, indexMin, indexMax);
            return size;
        }
        return this.reduce(xValues, yValues, xPointErrorsPos == null ? new double[indexMax - indexMin] : xPointErrorsPos, xPointErrorsNeg == null ? new double[indexMax - indexMin] : xPointErrorsNeg, yPointErrorsPos, yPointErrorsNeg, styles, pointSelected, indexMin, indexMax, 1000);
    }

    private static void moveInPlace(double[] xValues, double[] yValues, double[] xPointErrorsPos, double[] xPointErrorsNeg, double[] yPointErrorsPos, double[] yPointErrorsNeg, String[] styles, boolean[] pointSelected, int fromIndex, int toIndex) {
        xValues[toIndex] = xValues[fromIndex];
        yValues[toIndex] = yValues[fromIndex];
        xPointErrorsPos[toIndex] = xPointErrorsPos[fromIndex];
        xPointErrorsNeg[toIndex] = xPointErrorsNeg[fromIndex];
        yPointErrorsPos[toIndex] = yPointErrorsPos[fromIndex];
        yPointErrorsNeg[toIndex] = yPointErrorsNeg[fromIndex];
        styles[toIndex] = styles[fromIndex];
        pointSelected[toIndex] = pointSelected[fromIndex];
    }

    private static void shiftDataToFront(boolean[] data, int indexMin, int indexMax) {
        int size = indexMax - indexMin;
        System.arraycopy(data, indexMin, data, 0, size);
    }

    private static void shiftDataToFront(double[] data, int indexMin, int indexMax) {
        int size = indexMax - indexMin;
        System.arraycopy(data, indexMin, data, 0, size);
    }

    private static void shiftDataToFront(String[] data, int indexMin, int indexMax) {
        int size = indexMax - indexMin;
        System.arraycopy(data, indexMin, data, 0, size);
    }
}

