/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.plugins;

import de.gsi.chart.axes.Axis;
import de.gsi.chart.plugins.AbstractSingleValueIndicator;
import de.gsi.chart.plugins.ValueIndicator;
import de.gsi.chart.ui.geometry.Side;
import de.gsi.dataset.event.EventSource;
import javafx.geometry.BoundingBox;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.input.MouseEvent;

public class XValueIndicator
extends AbstractSingleValueIndicator
implements EventSource,
ValueIndicator {
    public XValueIndicator(Axis axis, double value) {
        this(axis, value, null);
    }

    public XValueIndicator(Axis axis, double value, String text) {
        super(axis, value, text);
        this.setLabelPosition(0.04);
        this.pickLine.setOnMouseDragged(this::handleDragMouseEvent);
        this.triangle.setOnMouseDragged(this::handleDragMouseEvent);
        this.label.setOnMouseDragged(this::handleDragMouseEvent);
    }

    protected void handleDragMouseEvent(MouseEvent mouseEvent) {
        Point2D c = this.getChart().getPlotArea().sceneToLocal(mouseEvent.getSceneX(), mouseEvent.getSceneY());
        double xPosData = this.getAxis().getValueForDisplay(c.getX() + this.dragDelta.x);
        if (this.getAxis().isValueOnAxis(xPosData)) {
            this.valueProperty().set(xPosData);
        }
        mouseEvent.consume();
        this.layoutChildren();
    }

    @Override
    public void layoutChildren() {
        double axisPos;
        if (this.getChart() == null) {
            return;
        }
        Bounds plotAreaBounds = this.getChart().getCanvas().getBoundsInLocal();
        double minX = plotAreaBounds.getMinX();
        double maxX = plotAreaBounds.getMaxX();
        double minY = plotAreaBounds.getMinY();
        double maxY = plotAreaBounds.getMaxY();
        double xPos = minX + this.getAxis().getDisplayPosition(this.getValue());
        if (this.getAxis().getSide().equals((Object)Side.BOTTOM)) {
            this.triangle.getPoints().setAll((Object[])new Double[]{0.0, -8.0, -8.0, 0.0, 8.0, 0.0});
            axisPos = this.getChart().getPlotForeground().sceneToLocal(this.getAxis().getCanvas().localToScene(0.0, 0.0)).getY() + 6.0;
        } else {
            this.triangle.getPoints().setAll((Object[])new Double[]{0.0, 0.0, -8.0, -8.0, 8.0, -8.0});
            axisPos = this.getChart().getPlotForeground().sceneToLocal(this.getAxis().getCanvas().localToScene(0.0, this.getAxis().getHeight())).getY() - 6.0;
        }
        double xPosGlobal = this.getChart().getPlotForeground().sceneToLocal(this.getChart().getCanvas().localToScene(xPos, 0.0)).getX();
        if (xPos < minX || xPos > maxX) {
            this.getChartChildren().clear();
        } else {
            this.layoutLine(xPos, minY, xPos, maxY);
            this.layoutMarker(xPosGlobal, axisPos + 4.0, xPos, maxY);
            this.layoutLabel((Bounds)new BoundingBox(xPos, minY, 0.0, maxY - minY), 0.5, this.getLabelPosition());
        }
    }

    @Override
    public void updateStyleClass() {
        this.setStyleClasses((Node)this.label, "x-", "value-indicator-label");
        this.setStyleClasses((Node)this.line, "x-", "value-indicator-line");
        this.setStyleClasses((Node)this.triangle, "x-", "value-indicator-marker");
    }
}

