/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.plugins;

import de.gsi.chart.Chart;
import de.gsi.chart.axes.Axis;
import de.gsi.chart.plugins.ChartPlugin;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.collections.ListChangeListener;
import javafx.geometry.Bounds;
import javafx.geometry.HPos;
import javafx.geometry.Point2D;
import javafx.geometry.VPos;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyCode;
import javafx.scene.input.MouseButton;

public abstract class AbstractValueIndicator
extends ChartPlugin {
    private final Axis axis;
    private final ChangeListener<? super Number> axisBoundsListener = (obs, oldVal, newVal) -> this.layoutChildren();
    private final ListChangeListener<? super ChartPlugin> pluginsListListener = change -> this.updateStyleClass();
    private double xOffset;
    private double yOffset;
    protected final Label label = new Label();
    protected final TextField labelEdit = new TextField();
    protected final Delta dragDelta = new Delta();
    protected final BooleanProperty editableIndicator = new SimpleBooleanProperty(this, "editableIndicator", true){

        protected void invalidated() {
            AbstractValueIndicator.this.layoutChildren();
        }
    };
    private final ObjectProperty<HPos> labelHorizontalAnchor = new SimpleObjectProperty<HPos>((Object)this, "labelHorizontalAnchor", HPos.CENTER){

        protected void invalidated() {
            AbstractValueIndicator.this.layoutChildren();
        }
    };
    private final ObjectProperty<VPos> labelVerticalAnchor = new SimpleObjectProperty<VPos>((Object)this, "labelVerticalAnchor", VPos.CENTER){

        protected void invalidated() {
            AbstractValueIndicator.this.layoutChildren();
        }
    };

    protected AbstractValueIndicator(Axis axis, String text) {
        this.axis = axis;
        this.setText(text);
        this.label.pickOnBoundsProperty().set(true);
        this.label.toFront();
        this.label.setOnMousePressed(mouseEvent -> {
            if (mouseEvent.isPrimaryButtonDown() && this.isEditable()) {
                Point2D c = this.label.sceneToLocal(mouseEvent.getSceneX(), mouseEvent.getSceneY());
                this.dragDelta.x = -(c.getX() + this.xOffset);
                this.dragDelta.y = c.getY() + this.yOffset;
                this.label.setCursor(Cursor.MOVE);
                mouseEvent.consume();
            }
        });
        this.label.setOnMouseClicked(evt -> {
            if (evt.getButton().equals((Object)MouseButton.SECONDARY)) {
                this.label.setVisible(false);
                this.getChartChildren().add((Object)this.labelEdit);
                this.labelEdit.requestFocus();
                this.labelEdit.setLayoutX(this.label.getLayoutX());
                this.labelEdit.setLayoutY(this.label.getLayoutY());
                this.labelEdit.resizeRelocate(this.label.getLayoutX() - 20.0, this.label.getLayoutY() - 5.0, this.label.getWidth() + 40.0, this.label.getHeight() + 10.0);
                this.labelEdit.setOnAction(actionEvt -> {
                    this.label.setText(this.labelEdit.getText());
                    this.getChartChildren().remove((Object)this.labelEdit);
                    this.label.setVisible(true);
                });
                this.labelEdit.setOnKeyPressed(keyEvt -> {
                    if (keyEvt.getCode().equals((Object)KeyCode.DELETE) && keyEvt.isControlDown()) {
                        this.getChart().getPlugins().remove((Object)this);
                    }
                    if (keyEvt.getCode().equals((Object)KeyCode.ESCAPE)) {
                        this.getChartChildren().remove((Object)this.labelEdit);
                        this.label.setVisible(true);
                    }
                });
            }
        });
        this.editableIndicatorProperty().addListener((ch, o, n) -> this.updateMouseListener((boolean)n));
        this.updateMouseListener(this.isEditable());
        this.chartProperty().addListener((obs, oldChart, newChart) -> {
            if (oldChart != null) {
                this.removeAxisListener();
                this.removePluginsListListener((Chart)((Object)oldChart));
            }
            if (newChart != null) {
                this.addAxisListener();
                this.addPluginsListListener((Chart)((Object)newChart));
            }
        });
        this.textProperty().addListener((obs, oldText, newText) -> this.layoutChildren());
    }

    private void addAxisListener() {
        Axis valueAxis = this.getAxis();
        valueAxis.minProperty().addListener(this.axisBoundsListener);
        valueAxis.maxProperty().addListener(this.axisBoundsListener);
    }

    protected void addChildNodeIfNotPresent(Node node) {
        if (!this.getChartChildren().contains((Object)node)) {
            this.getChartChildren().add(0, (Object)node);
        }
    }

    private void addPluginsListListener(Chart chart) {
        chart.getPlugins().addListener(this.pluginsListListener);
        this.updateStyleClass();
    }

    public final BooleanProperty editableIndicatorProperty() {
        return this.editableIndicator;
    }

    private int getIndicatorInstanceIndex() {
        if (this.getChart() == null) {
            return 0;
        }
        Class<?> thisClass = this.getClass();
        int instanceIndex = -1;
        for (ChartPlugin plugin : this.getChart().getPlugins()) {
            if (plugin.getClass().equals(thisClass)) {
                ++instanceIndex;
            }
            if (plugin != this) continue;
            break;
        }
        return Math.max(instanceIndex, 0);
    }

    public final HPos getLabelHorizontalAnchor() {
        return (HPos)this.labelHorizontalAnchorProperty().get();
    }

    public final VPos getLabelVerticalAnchor() {
        return (VPos)this.labelVerticalAnchorProperty().get();
    }

    public Axis getAxis() {
        return this.axis;
    }

    public final String getText() {
        return (String)this.textProperty().get();
    }

    public final boolean isEditable() {
        return this.editableIndicatorProperty().get();
    }

    public final ObjectProperty<HPos> labelHorizontalAnchorProperty() {
        return this.labelHorizontalAnchor;
    }

    public final ObjectProperty<VPos> labelVerticalAnchorProperty() {
        return this.labelVerticalAnchor;
    }

    protected final void layoutLabel(Bounds bounds, double hPos, double vPos) {
        if (this.label.getText() == null || this.label.getText().isEmpty()) {
            this.getChartChildren().remove((Object)this.label);
            return;
        }
        double xPos = bounds.getMinX();
        double yPos = bounds.getMinY();
        this.xOffset = bounds.getWidth() * hPos;
        this.yOffset = bounds.getHeight() * (1.0 - vPos);
        double width = this.label.prefWidth(-1.0);
        double height = this.label.prefHeight(width);
        if (this.getLabelHorizontalAnchor() == HPos.CENTER) {
            this.xOffset -= width / 2.0;
        } else if (this.getLabelHorizontalAnchor() == HPos.RIGHT) {
            this.xOffset -= width;
        }
        if (this.getLabelVerticalAnchor() == VPos.CENTER) {
            this.yOffset -= height / 2.0;
        } else if (this.getLabelVerticalAnchor() == VPos.BASELINE) {
            this.yOffset -= this.label.getBaselineOffset();
        } else if (this.getLabelVerticalAnchor() == VPos.BOTTOM) {
            this.yOffset -= height;
        }
        this.label.resizeRelocate(xPos + this.xOffset, yPos + this.yOffset, width, height);
        this.addChildNodeIfNotPresent((Node)this.label);
    }

    private void removeAxisListener() {
        Axis valueAxis = this.getAxis();
        valueAxis.minProperty().removeListener(this.axisBoundsListener);
        valueAxis.maxProperty().removeListener(this.axisBoundsListener);
    }

    private void removePluginsListListener(Chart chart) {
        chart.getPlugins().removeListener(this.pluginsListListener);
    }

    public final void setEditable(boolean newState) {
        this.editableIndicatorProperty().set(newState);
    }

    public final void setLabelHorizontalAnchor(HPos anchor) {
        this.labelHorizontalAnchorProperty().set((Object)anchor);
    }

    public final void setLabelVerticalAnchor(VPos anchor) {
        this.labelVerticalAnchorProperty().set((Object)anchor);
    }

    public void setStyleClasses(Node node, String prefix, String root) {
        node.getStyleClass().setAll((Object[])new String[]{root, prefix + root, prefix + root + this.getIndicatorInstanceIndex()});
    }

    public final void setText(String text) {
        this.textProperty().set((Object)text);
    }

    public final StringProperty textProperty() {
        return this.label.textProperty();
    }

    private void updateMouseListener(boolean state) {
        if (state) {
            this.label.setOnMouseReleased(mouseEvent -> this.label.setCursor(Cursor.HAND));
            this.label.setOnMouseEntered(mouseEvent -> this.label.setCursor(Cursor.HAND));
        } else {
            this.label.setOnMouseReleased(null);
            this.label.setOnMouseEntered(null);
        }
    }

    public abstract void updateStyleClass();

    protected static class Delta {
        protected double x;
        protected double y;

        protected Delta() {
        }
    }
}

