/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.axes.spi;

import de.gsi.chart.Chart;
import de.gsi.chart.axes.Axis;
import de.gsi.chart.axes.AxisLabelOverlapPolicy;
import de.gsi.chart.axes.spi.AxisLabel;
import de.gsi.chart.axes.spi.AxisRange;
import de.gsi.chart.axes.spi.MetricPrefix;
import de.gsi.chart.axes.spi.TickMark;
import de.gsi.chart.ui.css.CssPropertyFactory;
import de.gsi.chart.ui.geometry.Side;
import de.gsi.dataset.event.AxisChangeEvent;
import de.gsi.dataset.event.EventListener;
import de.gsi.dataset.event.EventSource;
import de.gsi.dataset.event.UpdateEvent;
import de.gsi.dataset.utils.NoDuplicatesList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.ReadOnlyDoubleWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.css.CssMetaData;
import javafx.css.StyleConverter;
import javafx.css.Styleable;
import javafx.css.StyleableBooleanProperty;
import javafx.css.StyleableDoubleProperty;
import javafx.css.StyleableIntegerProperty;
import javafx.css.StyleableObjectProperty;
import javafx.css.StyleableStringProperty;
import javafx.scene.Node;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Path;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;
import javafx.util.StringConverter;

public abstract class AbstractAxisParameter
extends Pane
implements Axis {
    private static final String CHART_CSS = Chart.class.getResource("chart.css").toExternalForm();
    private static final CssPropertyFactory<AbstractAxisParameter> CSS = new CssPropertyFactory(Region.getClassCssMetaData());
    protected static final int MAX_TICK_COUNT = 20;
    private static final double DEFAULT_MIN_RANGE = -1.0;
    private static final double DEFAULT_MAX_RANGE = 1.0;
    private static final double DEFAULT_TICK_UNIT = 5.0;
    protected static final int DEFAULT_MINOR_TICK_COUNT = 10;
    private final transient AtomicBoolean autoNotification = new AtomicBoolean(true);
    private final transient List<EventListener> updateListeners = Collections.synchronizedList(new LinkedList());
    private final transient StyleableIntegerProperty dimIndex = CSS.createIntegerProperty(this, "dimIndex", -1, this::requestAxisLayout);
    private final transient Path majorTickStyle = new Path();
    private final transient Path minorTickStyle = new Path();
    private final transient AxisLabel axisLabel = new AxisLabel();
    protected double oldAxisLength = -1.0;
    protected double oldAxisMin = -1.7976931348623157E308;
    protected double oldAxisMax = -1.7976931348623157E308;
    protected double oldTickUnit = -1.7976931348623157E308;
    protected final transient BooleanProperty valid = new SimpleBooleanProperty((Object)this, "valid", false);
    protected final transient ObservableList<Double> majorTickMarkValues = FXCollections.observableArrayList((Collection)new NoDuplicatesList());
    protected final transient ObservableList<Double> minorTickMarkValues = FXCollections.observableArrayList((Collection)new NoDuplicatesList());
    protected final transient ObservableList<TickMark> majorTickMarks = FXCollections.observableArrayList((Collection)new NoDuplicatesList());
    protected final transient ObservableList<TickMark> minorTickMarks = FXCollections.observableArrayList((Collection)new NoDuplicatesList());
    private final transient AxisRange autoRange = new AxisRange();
    private final transient AxisRange userRange = new AxisRange();
    private final transient StyleableObjectProperty<Side> side = CSS.createEnumPropertyWithPseudoclasses((Styleable)this, "side", Side.BOTTOM, false, Side.class, null, () -> this.invokeListener((UpdateEvent)new AxisChangeEvent((EventSource)this)));
    private final transient StyleableObjectProperty<AxisLabelOverlapPolicy> overlapPolicy = CSS.createObjectProperty(this, "overlapPolicy", AxisLabelOverlapPolicy.SKIP_ALT, StyleConverter.getEnumConverter(AxisLabelOverlapPolicy.class), () -> this.invokeListener((UpdateEvent)new AxisChangeEvent((EventSource)this)));
    private final transient StyleableDoubleProperty axisCenterPosition = CSS.createDoubleProperty(this, "axisCenterPosition", 0.5, true, (oldVal, newVal) -> Math.max(0.0, Math.min(newVal, 1.0)), this::requestAxisLayout);
    private final transient StyleableObjectProperty<TextAlignment> axisLabelTextAlignment = CSS.createObjectProperty(this, "axisLabelTextAlignment", TextAlignment.CENTER, StyleConverter.getEnumConverter(TextAlignment.class), this::requestAxisLayout);
    private final transient StyleableStringProperty axisName = CSS.createStringProperty(this, "axisName", "", this::requestAxisLayout);
    private final transient StyleableBooleanProperty tickMarkVisible = CSS.createBooleanProperty(this, "tickMarkVisible", true, this::requestAxisLayout);
    private final transient StyleableBooleanProperty tickLabelsVisible = CSS.createBooleanProperty(this, "tickLabelsVisible", true, () -> {
        this.getTickMarks().forEach(tick -> tick.setVisible(this.tickLabelsVisible.get()));
        this.invalidate();
        this.invokeListener((UpdateEvent)new AxisChangeEvent((EventSource)this));
    });
    private final transient StyleableDoubleProperty axisPadding = CSS.createDoubleProperty(this, "axisPadding", 15.0, this::requestAxisLayout);
    private final transient StyleableDoubleProperty tickLength = CSS.createDoubleProperty(this, "tickLength", 8.0, this::requestAxisLayout);
    private final transient StyleableBooleanProperty autoRanging = CSS.createBooleanProperty(this, "autoRanging", true, this::requestAxisLayout);
    private final transient StyleableObjectProperty<Font> tickLabelFont = CSS.createObjectProperty(this, "tickLabelFont", Font.font((String)"System", (double)8.0), false, StyleConverter.getFontConverter(), null, () -> {
        Font f = (Font)this.tickLabelFontProperty().get();
        this.getTickMarks().forEach(tm -> tm.setFont(f));
        this.invalidate();
        this.invokeListener((UpdateEvent)new AxisChangeEvent((EventSource)this));
    });
    private final transient StyleableObjectProperty<Paint> tickLabelFill = CSS.createObjectProperty(this, "tickLabelFill", Color.BLACK, StyleConverter.getPaintConverter(), new Runnable[0]);
    private final transient StyleableDoubleProperty tickLabelGap = CSS.createDoubleProperty(this, "tickLabelGap", 3.0, this::requestAxisLayout);
    private final transient StyleableDoubleProperty tickLabelSpacing = CSS.createDoubleProperty(this, "tickLabelSpacing", 3.0, this::requestAxisLayout);
    private final transient StyleableDoubleProperty axisLabelGap = CSS.createDoubleProperty(this, "axisLabelGap", 3.0, this::requestAxisLayout);
    private final transient StyleableIntegerProperty animationDuration = CSS.createIntegerProperty(this, "animationDuration", 250, this::requestAxisLayout);
    private final transient StyleableIntegerProperty maxMajorTickLabelCount = CSS.createIntegerProperty(this, "maxMajorTickLabelCount", 20, this::requestAxisLayout);
    private final transient BooleanProperty animated = new SimpleBooleanProperty((Object)this, "animated", false);
    protected final transient StyleableDoubleProperty tickLabelRotation = CSS.createDoubleProperty(this, "tickLabelRotation", 0.0, this::requestAxisLayout);
    private final transient StyleableBooleanProperty minorTickVisible = CSS.createBooleanProperty(this, "minorTickVisible", true, this::requestAxisLayout);
    private final transient ReadOnlyDoubleWrapper scale = new ReadOnlyDoubleWrapper((Object)this, "scale", 1.0);
    protected final transient DoubleProperty maxProp = new SimpleDoubleProperty(this, "upperBound", 1.0){

        public void set(double newValue) {
            double oldValue = this.get();
            if (oldValue != newValue) {
                super.set(newValue);
                AbstractAxisParameter.this.invokeListener((UpdateEvent)new AxisChangeEvent((EventSource)AbstractAxisParameter.this));
            }
        }
    };
    protected final transient DoubleProperty minProp = new SimpleDoubleProperty(this, "lowerBound", -1.0){

        public void set(double newValue) {
            double oldValue = this.get();
            if (oldValue != newValue) {
                super.set(newValue);
                AbstractAxisParameter.this.invokeListener((UpdateEvent)new AxisChangeEvent((EventSource)AbstractAxisParameter.this));
            }
        }
    };
    protected double cachedOffset;
    private final transient ObjectProperty<StringConverter<Number>> tickLabelFormatter = new ObjectPropertyBase<StringConverter<Number>>(null){

        public Object getBean() {
            return AbstractAxisParameter.this;
        }

        public String getName() {
            return "tickLabelFormatter";
        }

        protected void invalidated() {
            AbstractAxisParameter.this.invalidate();
            AbstractAxisParameter.this.invokeListener((UpdateEvent)new AxisChangeEvent((EventSource)AbstractAxisParameter.this));
        }
    };
    private final transient StyleableDoubleProperty minorTickLength = CSS.createDoubleProperty(this, "minorTickLength", 5.0, this::requestAxisLayout);
    private final transient StyleableIntegerProperty minorTickCount = CSS.createIntegerProperty(this, "minorTickCount", 10, this::requestAxisLayout);
    private final transient StyleableBooleanProperty autoGrowRanging = CSS.createBooleanProperty(this, "autoGrowRanging", false, this::requestAxisLayout);
    protected boolean isInvertedAxis = false;
    private final transient BooleanProperty invertAxis = new SimpleBooleanProperty(this, "invertAxis", false){

        protected void invalidated() {
            AbstractAxisParameter.this.isInvertedAxis = this.get();
            AbstractAxisParameter.this.invalidate();
            AbstractAxisParameter.this.invokeListener((UpdateEvent)new AxisChangeEvent((EventSource)AbstractAxisParameter.this));
        }
    };
    protected boolean isTimeAxis = false;
    private final transient BooleanProperty timeAxis = new SimpleBooleanProperty(this, "timeAxis", false){

        protected void invalidated() {
            AbstractAxisParameter.this.isTimeAxis = this.get();
            if (AbstractAxisParameter.this.isTimeAxis) {
                AbstractAxisParameter.this.setMinorTickCount(0);
            } else {
                AbstractAxisParameter.this.setMinorTickCount(10);
            }
            AbstractAxisParameter.this.invalidate();
            AbstractAxisParameter.this.invokeListener((UpdateEvent)new AxisChangeEvent((EventSource)AbstractAxisParameter.this));
        }
    };
    private final transient StyleableBooleanProperty autoRangeRounding = CSS.createBooleanProperty(this, "autoRangeRounding", false, this::requestAxisLayout);
    private final transient DoubleProperty autoRangePadding = new SimpleDoubleProperty(0.0);
    private final transient StyleableStringProperty axisUnit = CSS.createStringProperty(this, "axisUnit", "", () -> {
        this.updateAxisLabelAndUnit();
        this.requestAxisLayout();
    });
    private final transient BooleanProperty autoUnitScaling = new SimpleBooleanProperty(this, "autoUnitScaling", false){

        protected void invalidated() {
            AbstractAxisParameter.this.updateAxisLabelAndUnit();
            AbstractAxisParameter.this.invokeListener((UpdateEvent)new AxisChangeEvent((EventSource)AbstractAxisParameter.this));
        }
    };
    private final transient DoubleProperty unitScaling = new SimpleDoubleProperty(this, "unitScaling", 1.0){

        protected void invalidated() {
            AbstractAxisParameter.this.updateAxisLabelAndUnit();
            AbstractAxisParameter.this.invokeListener((UpdateEvent)new AxisChangeEvent((EventSource)AbstractAxisParameter.this));
        }
    };
    protected final transient StyleableDoubleProperty tickUnit = CSS.createDoubleProperty(this, "tickUnit", 5.0, () -> {
        if (this.isAutoRanging() || this.isAutoGrowRanging()) {
            return;
        }
        this.invalidate();
        this.invokeListener((UpdateEvent)new AxisChangeEvent((EventSource)this));
    });
    protected final transient ChangeListener<? super Number> scaleChangeListener = (ch, o, n) -> {
        double newScale;
        double axisLength = this.getSide().isVertical() ? this.getHeight() : this.getWidth();
        double lowerBound = this.getMin();
        double upperBound = this.getMax();
        if (!(Double.isFinite(axisLength) && Double.isFinite(lowerBound) && Double.isFinite(upperBound))) {
            return;
        }
        double diff = upperBound - lowerBound;
        if (this.getSide().isVertical()) {
            newScale = diff == 0.0 ? -axisLength : -(axisLength / diff);
            this.cachedOffset = axisLength;
        } else {
            newScale = diff == 0.0 ? axisLength : axisLength / diff;
            this.cachedOffset = 0.0;
        }
        this.setScale(newScale == 0.0 ? -1.0 : newScale);
    };

    public AbstractAxisParameter() {
        this.getStylesheets().add((Object)CHART_CSS);
        this.getStyleClass().setAll((Object[])new String[]{"axis"});
        this.majorTickStyle.getStyleClass().add((Object)"axis-tick-mark");
        this.minorTickStyle.getStyleClass().add((Object)"axis-minor-tick-mark");
        this.getChildren().addAll((Object[])new Node[]{this.axisLabel, this.majorTickStyle, this.minorTickStyle});
        this.autoRangingProperty().addListener(ch -> {
            if (this.isAutoRanging()) {
                this.setAutoGrowRanging(false);
            }
        });
        this.autoGrowRangingProperty().addListener(ch -> {
            if (this.isAutoGrowRanging()) {
                this.setAutoRanging(false);
            }
        });
        this.nameProperty().addListener(e -> {
            this.updateAxisLabelAndUnit();
            this.invokeListener((UpdateEvent)new AxisChangeEvent((EventSource)this));
        });
        this.axisLabel.textAlignmentProperty().bindBidirectional(this.axisLabelTextAlignmentProperty());
        ChangeListener userLimitChangeListener = (ch, o, n) -> {
            this.getUserRange().set(this.getMin(), this.getMax());
            if (!this.isAutoRanging() && !this.isAutoGrowRanging()) {
                this.invokeListener((UpdateEvent)new AxisChangeEvent((EventSource)this));
            }
            this.invalidate();
        };
        this.minProperty().addListener(userLimitChangeListener);
        this.maxProperty().addListener(userLimitChangeListener);
        this.majorTickStyle.applyCss();
        this.minorTickStyle.applyCss();
        this.axisLabel.applyCss();
        this.minProperty().addListener(this.scaleChangeListener);
        this.maxProperty().addListener(this.scaleChangeListener);
        this.widthProperty().addListener(this.scaleChangeListener);
        this.heightProperty().addListener(this.scaleChangeListener);
    }

    protected void updateCachedVariables() {
    }

    public boolean add(double value) {
        if (this.contains(value)) {
            return false;
        }
        boolean changed = false;
        boolean oldState = this.autoNotification().getAndSet(false);
        if (value > this.getMax()) {
            this.setMax(value);
            changed = true;
        }
        if (value < this.getMin()) {
            this.setMin(value);
            changed = true;
        }
        this.autoNotification().set(oldState);
        if (changed) {
            this.invokeListener((UpdateEvent)new AxisChangeEvent((EventSource)this));
        }
        return changed;
    }

    public boolean add(double[] values, int length) {
        boolean changed = false;
        boolean oldState = this.autoNotification().getAndSet(false);
        for (int i = 0; i < length; ++i) {
            changed |= this.add(values[i]);
        }
        this.autoNotification().set(oldState);
        this.invokeListener((UpdateEvent)new AxisChangeEvent((EventSource)this));
        return changed;
    }

    public BooleanProperty animatedProperty() {
        return this.animated;
    }

    public IntegerProperty animationDurationProperty() {
        return this.animationDuration;
    }

    @Override
    public BooleanProperty autoGrowRangingProperty() {
        return this.autoGrowRanging;
    }

    public AtomicBoolean autoNotification() {
        return this.autoNotification;
    }

    public DoubleProperty autoRangePaddingProperty() {
        return this.autoRangePadding;
    }

    public BooleanProperty autoRangeRoundingProperty() {
        return this.autoRangeRounding;
    }

    @Override
    public BooleanProperty autoRangingProperty() {
        return this.autoRanging;
    }

    @Override
    public BooleanProperty autoUnitScalingProperty() {
        return this.autoUnitScaling;
    }

    public DoubleProperty axisLabelGapProperty() {
        return this.axisLabelGap;
    }

    public ObjectProperty<TextAlignment> axisLabelTextAlignmentProperty() {
        return this.axisLabelTextAlignment;
    }

    public DoubleProperty axisPaddingProperty() {
        return this.axisPadding;
    }

    public DoubleProperty axisCenterPositionProperty() {
        return this.axisCenterPosition;
    }

    public boolean clear() {
        boolean oldState = this.autoNotification().getAndSet(false);
        this.minProp.set(-1.0);
        this.maxProp.set(1.0);
        this.autoNotification().set(oldState);
        this.invokeListener((UpdateEvent)new AxisChangeEvent((EventSource)this));
        return false;
    }

    public boolean contains(double value) {
        return Double.isFinite(value) && value >= this.getMin() && value <= this.getMax();
    }

    public abstract void fireInvalidated();

    public int getAnimationDuration() {
        return this.animationDurationProperty().get();
    }

    @Override
    public AxisRange getAutoRange() {
        return this.autoRange;
    }

    public double getAutoRangePadding() {
        return this.autoRangePaddingProperty().get();
    }

    public double getAxisCenterPosition() {
        return this.axisCenterPositionProperty().get();
    }

    public Text getAxisLabel() {
        return this.axisLabel;
    }

    public double getAxisLabelGap() {
        return this.axisLabelGapProperty().get();
    }

    public TextAlignment getAxisLabelTextAlignment() {
        return (TextAlignment)this.axisLabelTextAlignmentProperty().get();
    }

    public double getAxisPadding() {
        return this.axisPaddingProperty().get();
    }

    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return AbstractAxisParameter.getClassCssMetaData();
    }

    public IntegerProperty dimIndexProperty() {
        return this.dimIndex;
    }

    public void setDimIndex(int dimIndex) {
        this.dimIndexProperty().set(dimIndex);
    }

    public int getDimIndex() {
        return this.dimIndexProperty().get();
    }

    @Override
    public double getLength() {
        if (this.getSide() == null) {
            return Double.NaN;
        }
        return this.getSide().isHorizontal() ? this.getWidth() : this.getHeight();
    }

    public Path getMajorTickStyle() {
        return this.majorTickStyle;
    }

    public double getMax() {
        return this.maxProperty().get();
    }

    public int getMaxMajorTickLabelCount() {
        return this.maxMajorTickLabelCountProperty().get();
    }

    public double getMin() {
        return this.minProperty().get();
    }

    @Override
    public int getMinorTickCount() {
        return this.minorTickCountProperty().get();
    }

    public double getMinorTickLength() {
        return this.minorTickLengthProperty().get();
    }

    @Override
    public ObservableList<TickMark> getMinorTickMarks() {
        return this.minorTickMarks;
    }

    public ObservableList<Double> getMinorTickMarkValues() {
        return this.minorTickMarkValues;
    }

    public Path getMinorTickStyle() {
        return this.minorTickStyle;
    }

    public String getName() {
        return (String)this.nameProperty().get();
    }

    public AxisLabelOverlapPolicy getOverlapPolicy() {
        return (AxisLabelOverlapPolicy)((Object)this.overlapPolicyProperty().get());
    }

    @Override
    public AxisRange getRange() {
        if (this.isAutoRanging() || this.isAutoGrowRanging()) {
            return this.getAutoRange();
        }
        return this.getUserRange();
    }

    public double getScale() {
        return this.scaleProperty().get();
    }

    @Override
    public Side getSide() {
        return (Side)((Object)this.sideProperty().get());
    }

    @Override
    public Paint getTickLabelFill() {
        return (Paint)this.tickLabelFillProperty().get();
    }

    @Override
    public Font getTickLabelFont() {
        return (Font)this.tickLabelFontProperty().get();
    }

    @Override
    public StringConverter<Number> getTickLabelFormatter() {
        return (StringConverter)this.tickLabelFormatterProperty().getValue();
    }

    @Override
    public double getTickLabelGap() {
        return this.tickLabelGapProperty().get();
    }

    public double getTickLabelRotation() {
        return this.tickLabelRotationProperty().getValue();
    }

    @Override
    public double getTickLabelSpacing() {
        return this.tickLabelSpacingProperty().get();
    }

    public double getTickLength() {
        return this.tickLengthProperty().get();
    }

    @Override
    public ObservableList<TickMark> getTickMarks() {
        return this.majorTickMarks;
    }

    public ObservableList<Double> getTickMarkValues() {
        return this.majorTickMarkValues;
    }

    @Override
    public double getTickUnit() {
        return this.tickUnitProperty().get();
    }

    public String getUnit() {
        return (String)this.unitProperty().get();
    }

    @Override
    public double getUnitScaling() {
        return this.unitScalingProperty().get();
    }

    @Override
    public AxisRange getUserRange() {
        return this.userRange;
    }

    public void invalidate() {
        this.validProperty().set(false);
    }

    @Override
    public void invertAxis(boolean value) {
        this.invertAxisProperty().set(value);
    }

    @Override
    public BooleanProperty invertAxisProperty() {
        return this.invertAxis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invokeListener(UpdateEvent updateEvent, boolean executeParallel) {
        AtomicBoolean atomicBoolean = this.autoNotification();
        synchronized (atomicBoolean) {
            if (!this.autoNotification().get()) {
                return;
            }
        }
        this.requestAxisLayout();
        Axis.super.invokeListener(updateEvent, executeParallel);
    }

    public boolean isAnimated() {
        return this.animatedProperty().get();
    }

    @Override
    public boolean isAutoGrowRanging() {
        return this.autoGrowRangingProperty().get();
    }

    public boolean isAutoRangeRounding() {
        return this.autoRangeRoundingProperty().get();
    }

    @Override
    public boolean isAutoRanging() {
        return this.autoRangingProperty().get();
    }

    @Override
    public boolean isAutoUnitScaling() {
        return this.autoUnitScalingProperty().get();
    }

    public boolean isDefined() {
        return Double.isFinite(this.getMin()) && Double.isFinite(this.getMax());
    }

    @Override
    public boolean isInvertedAxis() {
        return this.invertAxisProperty().get();
    }

    public boolean isMinorTickVisible() {
        return this.minorTickVisibleProperty().get();
    }

    public boolean isTickLabelsVisible() {
        return this.tickLabelsVisibleProperty().get();
    }

    public boolean isTickMarkVisible() {
        return this.tickMarkVisibleProperty().get();
    }

    @Override
    public boolean isTimeAxis() {
        return this.timeAxisProperty().get();
    }

    public boolean isValid() {
        return this.validProperty().get();
    }

    public IntegerProperty maxMajorTickLabelCountProperty() {
        return this.maxMajorTickLabelCount;
    }

    @Override
    public DoubleProperty maxProperty() {
        return this.maxProp;
    }

    public IntegerProperty minorTickCountProperty() {
        return this.minorTickCount;
    }

    public DoubleProperty minorTickLengthProperty() {
        return this.minorTickLength;
    }

    public BooleanProperty minorTickVisibleProperty() {
        return this.minorTickVisible;
    }

    @Override
    public DoubleProperty minProperty() {
        return this.minProp;
    }

    @Override
    public StringProperty nameProperty() {
        return this.axisName;
    }

    public ObjectProperty<AxisLabelOverlapPolicy> overlapPolicyProperty() {
        return this.overlapPolicy;
    }

    public ReadOnlyDoubleProperty scaleProperty() {
        return this.scale.getReadOnlyProperty();
    }

    public boolean set(double min, double max) {
        boolean changed;
        double oldMin = this.minProp.get();
        double oldMax = this.maxProp.get();
        boolean oldState = this.autoNotification().getAndSet(false);
        this.minProp.set(min);
        this.maxProp.set(max);
        this.autoNotification().set(oldState);
        boolean bl = changed = oldMin != min || oldMax != max;
        if (changed) {
            this.invalidate();
            this.invokeListener((UpdateEvent)new AxisChangeEvent((EventSource)this));
        }
        return changed;
    }

    public boolean set(String axisName, String ... axisUnit) {
        boolean changed = false;
        boolean oldState = this.autoNotification().getAndSet(false);
        if (!AbstractAxisParameter.equalString(axisName, this.getName())) {
            this.setName(axisName);
            changed = true;
        }
        if (axisUnit != null && axisUnit.length > 0 && !AbstractAxisParameter.equalString(axisUnit[0], this.getUnit())) {
            this.setUnit(axisUnit[0]);
            changed = true;
        }
        this.autoNotification().set(oldState);
        if (changed) {
            this.invokeListener((UpdateEvent)new AxisChangeEvent((EventSource)this));
        }
        return changed;
    }

    public boolean set(String axisName, String axisUnit, double rangeMin, double rangeMax) {
        boolean oldState = this.autoNotification().getAndSet(false);
        boolean changed = this.set(axisName, axisUnit);
        this.autoNotification().set(oldState);
        if (changed |= this.set(rangeMin, rangeMax)) {
            this.invokeListener((UpdateEvent)new AxisChangeEvent((EventSource)this));
        }
        return changed;
    }

    @Override
    public void setAnimated(boolean value) {
        this.animatedProperty().set(value);
    }

    public void setAnimationDuration(int value) {
        this.animationDurationProperty().set(value);
    }

    @Override
    public void setAutoGrowRanging(boolean state) {
        if (state) {
            this.setAutoRanging(false);
            this.invalidate();
            this.requestAxisLayout();
        }
        this.autoGrowRangingProperty().set(state);
    }

    public void setAutoRangePadding(double padding) {
        this.autoRangePaddingProperty().set(padding);
    }

    public void setAutoRangeRounding(boolean round) {
        this.autoRangeRoundingProperty().set(round);
    }

    @Override
    public void setAutoRanging(boolean value) {
        this.autoRangingProperty().set(value);
    }

    @Override
    public void setAutoUnitScaling(boolean value) {
        this.autoUnitScalingProperty().set(value);
    }

    public void setAxisCenterPosition(double value) {
        this.axisCenterPositionProperty().set(value);
    }

    public void setAxisLabelGap(double value) {
        this.axisLabelGapProperty().set(value);
    }

    public void setAxisLabelTextAlignment(TextAlignment value) {
        this.axisLabelTextAlignmentProperty().set((Object)value);
    }

    public void setAxisPadding(double value) {
        this.axisPaddingProperty().set(value);
    }

    public boolean setMax(double value) {
        double oldvalue = this.maxProperty().get();
        this.maxProperty().set(value);
        return oldvalue != value;
    }

    public void setMaxMajorTickLabelCount(int value) {
        this.maxMajorTickLabelCountProperty().set(value);
    }

    public boolean setMin(double value) {
        double oldvalue = this.minProperty().get();
        this.minProperty().set(value);
        return oldvalue != value;
    }

    public void setMinorTickCount(int value) {
        this.minorTickCountProperty().set(value);
    }

    public void setMinorTickLength(double value) {
        this.minorTickLengthProperty().set(value);
    }

    public void setMinorTickVisible(boolean value) {
        this.minorTickVisibleProperty().set(value);
    }

    @Override
    public void setName(String value) {
        this.nameProperty().set((Object)value);
    }

    public void setOverlapPolicy(AxisLabelOverlapPolicy value) {
        this.overlapPolicyProperty().set((Object)value);
    }

    @Override
    public void setSide(Side value) {
        this.sideProperty().set((Object)value);
    }

    public void setTickLabelFill(Paint value) {
        this.tickLabelFillProperty().set((Object)value);
    }

    public void setTickLabelFont(Font value) {
        this.tickLabelFontProperty().set((Object)value);
    }

    public void setTickLabelFormatter(StringConverter<Number> value) {
        this.tickLabelFormatterProperty().setValue(value);
    }

    public void setTickLabelGap(double value) {
        this.tickLabelGapProperty().set(value);
    }

    public void setTickLabelRotation(double value) {
        this.tickLabelRotationProperty().setValue((Number)value);
    }

    public void setTickLabelSpacing(double value) {
        this.tickLabelSpacingProperty().set(value);
    }

    public void setTickLabelsVisible(boolean value) {
        this.tickLabelsVisibleProperty().set(value);
    }

    public void setTickLength(double value) {
        this.tickLengthProperty().set(value);
    }

    public void setTickMarkVisible(boolean value) {
        this.tickMarkVisibleProperty().set(value);
    }

    @Override
    public void setTickUnit(double unit) {
        this.tickUnitProperty().set(unit);
    }

    @Override
    public void setTimeAxis(boolean value) {
        this.timeAxisProperty().set(value);
    }

    @Override
    public void setUnit(String value) {
        this.unitProperty().set((Object)value);
    }

    @Override
    public void setUnitScaling(double value) {
        if (!Double.isFinite(value) || value == 0.0) {
            throw new IllegalArgumentException("provided number is not finite and/or zero: " + value);
        }
        this.setTickUnit(value);
        this.unitScalingProperty().set(value);
    }

    @Override
    public void setUnitScaling(MetricPrefix prefix) {
        this.unitScalingProperty().set(prefix.getPower());
    }

    @Override
    public ObjectProperty<Side> sideProperty() {
        return this.side;
    }

    public ObjectProperty<Paint> tickLabelFillProperty() {
        return this.tickLabelFill;
    }

    public ObjectProperty<Font> tickLabelFontProperty() {
        return this.tickLabelFont;
    }

    public ObjectProperty<StringConverter<Number>> tickLabelFormatterProperty() {
        return this.tickLabelFormatter;
    }

    public DoubleProperty tickLabelGapProperty() {
        return this.tickLabelGap;
    }

    public DoubleProperty tickLabelRotationProperty() {
        return this.tickLabelRotation;
    }

    public DoubleProperty tickLabelSpacingProperty() {
        return this.tickLabelSpacing;
    }

    public BooleanProperty tickLabelsVisibleProperty() {
        return this.tickLabelsVisible;
    }

    public DoubleProperty tickLengthProperty() {
        return this.tickLength;
    }

    public BooleanProperty tickMarkVisibleProperty() {
        return this.tickMarkVisible;
    }

    @Override
    public DoubleProperty tickUnitProperty() {
        return this.tickUnit;
    }

    @Override
    public BooleanProperty timeAxisProperty() {
        return this.timeAxis;
    }

    @Override
    public StringProperty unitProperty() {
        return this.axisUnit;
    }

    @Override
    public DoubleProperty unitScalingProperty() {
        return this.unitScaling;
    }

    public List<EventListener> updateEventListener() {
        return this.updateListeners;
    }

    protected void setScale(double scale) {
        this.scalePropertyImpl().set(scale);
    }

    protected void updateAxisLabelAndUnit() {
        String axisPrimaryLabel = this.getName();
        String localAxisUnit = this.getUnit();
        boolean isAutoScaling = this.isAutoUnitScaling();
        if (isAutoScaling) {
            this.updateScaleAndUnitPrefix();
        }
        String axisPrefix = MetricPrefix.getShortPrefix(this.getUnitScaling());
        if ((localAxisUnit == null || localAxisUnit.isBlank()) && !axisPrefix.isBlank()) {
            localAxisUnit = "";
        }
        if (localAxisUnit == null) {
            this.getAxisLabel().setText(axisPrimaryLabel);
        } else {
            this.getAxisLabel().setText(axisPrimaryLabel + " [" + axisPrefix + localAxisUnit + "]");
        }
        this.invalidate();
    }

    protected void updateScaleAndUnitPrefix() {
        double oldPower;
        double power3Lower;
        double range = Math.abs(this.getMax() - this.getMin());
        double logRange = Math.log10(range);
        double power3Upper = 3.0 * Math.ceil(logRange / 3.0);
        double a = Math.min(power3Upper, power3Lower = 3.0 * Math.floor(logRange / 3.0));
        double power = Math.pow(10.0, a);
        if (power != (oldPower = this.getUnitScaling()) && power != 0.0 && Double.isFinite(power)) {
            this.setUnitScaling(power);
        }
        this.setTickUnit(range / (double)this.getMinorTickCount());
    }

    protected BooleanProperty validProperty() {
        return this.valid;
    }

    ReadOnlyDoubleWrapper scalePropertyImpl() {
        return this.scale;
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return CSS.getCssMetaData();
    }

    protected static boolean equalString(String str1, String str2) {
        return Objects.equals(str1, str2);
    }
}

