/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart;

import de.gsi.chart.axes.Axis;
import de.gsi.chart.axes.spi.AbstractAxis;
import de.gsi.chart.axes.spi.DefaultNumericAxis;
import de.gsi.chart.legend.Legend;
import de.gsi.chart.legend.spi.DefaultLegend;
import de.gsi.chart.plugins.ChartPlugin;
import de.gsi.chart.renderer.Renderer;
import de.gsi.chart.renderer.spi.LabelledMarkerRenderer;
import de.gsi.chart.ui.ChartLayoutAnimator;
import de.gsi.chart.ui.HiddenSidesPane;
import de.gsi.chart.ui.ResizableCanvas;
import de.gsi.chart.ui.ToolBarFlowPane;
import de.gsi.chart.ui.css.CssPropertyFactory;
import de.gsi.chart.ui.geometry.Corner;
import de.gsi.chart.ui.geometry.Side;
import de.gsi.chart.utils.FXUtils;
import de.gsi.dataset.DataSet;
import de.gsi.dataset.event.EventListener;
import de.gsi.dataset.utils.AssertUtils;
import de.gsi.dataset.utils.NoDuplicatesList;
import de.gsi.dataset.utils.ProcessingProfiler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javafx.animation.Animation;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.property.StringPropertyBase;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.css.CssMetaData;
import javafx.css.StyleConverter;
import javafx.css.Styleable;
import javafx.css.StyleableBooleanProperty;
import javafx.css.StyleableObjectProperty;
import javafx.geometry.Bounds;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.geometry.Point2D;
import javafx.geometry.Pos;
import javafx.scene.CacheHint;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.canvas.Canvas;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.RowConstraints;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.stage.Window;
import javafx.util.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Chart
extends HiddenSidesPane
implements Observable {
    private static final Logger LOGGER = LoggerFactory.getLogger(Chart.class);
    private static final String CHART_CSS = Chart.class.getResource("chart.css").toExternalForm();
    private static final CssPropertyFactory<Chart> CSS = new CssPropertyFactory(Control.getClassCssMetaData());
    private static final int DEFAULT_TRIGGER_DISTANCE = 50;
    protected static final boolean DEBUG = false;
    protected BooleanBinding showingBinding;
    protected final BooleanProperty showing = new SimpleBooleanProperty((Object)this, "showing", false);
    protected final ChangeListener<? super Boolean> showingListener = (ch2, o, n) -> this.showing.set(n.booleanValue());
    private final BooleanProperty animated = new SimpleBooleanProperty((Object)this, "animated", true);
    protected final ChartLayoutAnimator animator = new ChartLayoutAnimator((Parent)this);
    private final StyleableBooleanProperty legendVisible = CSS.createBooleanProperty(this, "legendVisible", true, () -> {
        this.updateLegend((List<DataSet>)this.getDatasets(), (List<Renderer>)this.getRenderers());
        this.requestLayout();
    });
    protected boolean isCanvasChangeRequested;
    protected boolean layoutOngoing;
    protected final ObservableList<Axis> axesList = FXCollections.observableList((List)new NoDuplicatesList());
    private final Map<ChartPlugin, Group> pluginGroups = new ConcurrentHashMap<ChartPlugin, Group>();
    private final ObservableList<ChartPlugin> plugins = FXCollections.observableList(new LinkedList());
    private final ObservableList<DataSet> datasets = FXCollections.observableArrayList();
    protected final ObservableList<DataSet> allDataSets = FXCollections.observableArrayList();
    protected final List<InvalidationListener> listeners = new ArrayList<InvalidationListener>();
    protected final BooleanProperty autoNotification = new SimpleBooleanProperty((Object)this, "autoNotification", true);
    private final ObservableList<Renderer> renderers = FXCollections.observableArrayList();
    protected final ResizableCanvas canvas;
    protected final GridPane axesAndCanvasPane;
    protected final Group pluginsArea;
    protected boolean isAxesUpdate;
    protected final ToolBarFlowPane toolBar;
    protected final BooleanProperty toolBarPinned;
    protected final HiddenSidesPane hiddenPane;
    protected final Pane plotBackground;
    protected final Pane plotForeGround;
    protected final Pane canvasForeground;
    protected final Map<Corner, StackPane> axesCorner;
    protected final Map<Side, Pane> axesPane;
    protected final Map<Side, Pane> measurementBar;
    protected final Map<Corner, StackPane> titleLegendCorner;
    protected final Map<Side, Pane> titleLegendPane;
    private final EventListener axisChangeListener;
    protected final ListChangeListener<Axis> axesChangeListenerLocal;
    protected final ListChangeListener<Axis> axesChangeListener;
    protected final ListChangeListener<DataSet> datasetChangeListener;
    protected final EventListener dataSetDataListener;
    protected final ListChangeListener<ChartPlugin> pluginsChangedListener;
    protected final ChangeListener<? super Window> windowPropertyListener;
    private final ChangeListener<? super Scene> scenePropertyListener;
    protected final Label titleLabel;
    protected final StringProperty title;
    private final StyleableObjectProperty<Side> titleSide;
    private final StyleableObjectProperty<Side> measurementBarSide;
    private final StyleableObjectProperty<Side> legendSide;
    private final ObjectProperty<Legend> legend;
    private final StyleableObjectProperty<Side> toolBarSide;

    /*
     * WARNING - void declaration
     */
    public Chart(Axis ... axes) {
        void var5_15;
        this.getRenderers().addListener(this::rendererChanged);
        this.canvas = new ResizableCanvas();
        this.axesAndCanvasPane = new GridPane();
        this.pluginsArea = Chart.createChildGroup();
        this.toolBar = new ToolBarFlowPane(this);
        this.toolBarPinned = new SimpleBooleanProperty((Object)this, "toolBarPinned", false);
        this.hiddenPane = new HiddenSidesPane();
        this.plotBackground = new Pane();
        this.plotForeGround = new Pane();
        this.canvasForeground = new Pane();
        this.axesCorner = new ConcurrentHashMap<Corner, StackPane>(4);
        this.axesPane = new ConcurrentHashMap<Side, Pane>(4);
        this.measurementBar = new ConcurrentHashMap<Side, Pane>(4);
        this.titleLegendCorner = new ConcurrentHashMap<Corner, StackPane>(4);
        this.titleLegendPane = new ConcurrentHashMap<Side, Pane>(4);
        for (Corner corner : Corner.values()) {
            this.axesCorner.put(corner, new StackPane());
            this.titleLegendCorner.put(corner, new StackPane());
        }
        for (Enum enum_ : Side.values()) {
            this.titleLegendPane.put((Side)enum_, (Pane)(((Side)enum_).isVertical() ? new ChartHBox(new Node[0]) : new ChartVBox(new Node[0])));
            this.axesPane.put((Side)enum_, (Pane)(((Side)enum_).isVertical() ? new ChartHBox(new Node[0]) : new ChartVBox(new Node[0])));
            if (enum_ == Side.CENTER_HOR || enum_ == Side.CENTER_VER) {
                this.axesPane.get(enum_).setMouseTransparent(true);
            }
            this.measurementBar.put((Side)enum_, (Pane)(((Side)enum_).isVertical() ? new ChartHBox(new Node[0]) : new ChartVBox(new Node[0])));
        }
        this.axisChangeListener = obs -> FXUtils.runFX(() -> this.axesInvalidated(obs));
        this.axesChangeListenerLocal = this::axesChangedLocal;
        this.axesChangeListener = this::axesChanged;
        this.datasetChangeListener = this::datasetsChanged;
        this.dataSetDataListener = obs -> FXUtils.runFX(this::dataSetInvalidated);
        this.pluginsChangedListener = this::pluginsChanged;
        this.windowPropertyListener = (ch1, oldWindow, newWindow) -> {
            if (oldWindow != null) {
                oldWindow.showingProperty().removeListener(this.showingListener);
            }
            if (newWindow == null) {
                this.showing.set(false);
                return;
            }
            newWindow.showingProperty().addListener(this.showingListener);
        };
        this.scenePropertyListener = (ch, oldScene, newScene) -> {
            if (oldScene == newScene) {
                return;
            }
            if (oldScene != null) {
                oldScene.windowProperty().removeListener(this.windowPropertyListener);
            }
            if (newScene == null) {
                this.showing.set(false);
                return;
            }
            newScene.windowProperty().addListener(this.windowPropertyListener);
        };
        this.getDatasets().addListener(this.datasetChangeListener);
        this.getAxes().addListener(this.axesChangeListener);
        this.getAxes().addListener(this.axesChangeListenerLocal);
        this.titleLabel = new Label();
        this.title = new StringPropertyBase(){

            public Object getBean() {
                return Chart.this;
            }

            public String getName() {
                return "title";
            }

            protected void invalidated() {
                Chart.this.titleLabel.setText(this.get());
            }
        };
        this.titleSide = CSS.createObjectProperty(this, "titleSide", Side.TOP, false, StyleConverter.getEnumConverter(Side.class), (oldVal, newVal) -> {
            AssertUtils.notNull((String)"Side must not be null", (Object)newVal);
            for (Side s : Side.values()) {
                this.getTitleLegendPane(s).getChildren().remove((Object)this.titleLabel);
            }
            this.getTitleLegendPane((Side)((Object)((Object)newVal))).getChildren().add((Object)this.titleLabel);
            return newVal;
        }, this::requestLayout);
        this.measurementBarSide = CSS.createObjectProperty(this, "measurementBarSide", Side.RIGHT, false, StyleConverter.getEnumConverter(Side.class), (oldVal, newVal) -> {
            AssertUtils.notNull((String)"Side must not be null", (Object)newVal);
            return newVal;
        }, this::requestLayout);
        this.legendSide = CSS.createObjectProperty(this, "legendSide", Side.BOTTOM, false, StyleConverter.getEnumConverter(Side.class), (oldVal, newVal) -> {
            AssertUtils.notNull((String)"Side must not be null", (Object)newVal);
            Legend legend = this.getLegend();
            if (legend == null) {
                return newVal;
            }
            for (Side s : Side.values()) {
                this.getTitleLegendPane(s).getChildren().remove((Object)legend.getNode());
            }
            this.getTitleLegendPane((Side)((Object)((Object)newVal))).getChildren().add((Object)legend.getNode());
            legend.setVertical(newVal.isVertical());
            return newVal;
        }, this::requestLayout);
        this.legend = new SimpleObjectProperty<Legend>((Object)this, "legend", (Legend)new DefaultLegend()){
            private Legend oldLegend;
            {
                this.oldLegend = (Legend)this.get();
                Chart.this.getTitleLegendPane(Chart.this.getLegendSide()).getChildren().add((Object)this.oldLegend.getNode());
            }

            protected void invalidated() {
                Legend newLegend = (Legend)this.get();
                if (this.oldLegend != null) {
                    for (Side s : Side.values()) {
                        Chart.this.getTitleLegendPane(s).getChildren().remove((Object)this.oldLegend.getNode());
                    }
                }
                if (newLegend != null) {
                    if (Chart.this.getLegendSide() != null && Chart.this.isLegendVisible()) {
                        Chart.this.getTitleLegendPane(Chart.this.getLegendSide()).getChildren().add((Object)newLegend.getNode());
                    }
                    newLegend.getNode().setVisible(Chart.this.isLegendVisible());
                }
                super.set((Object)newLegend);
                this.oldLegend = newLegend;
                Chart.this.updateLegend((List<DataSet>)Chart.this.getDatasets(), (List<Renderer>)Chart.this.getRenderers());
            }
        };
        this.toolBarSide = CSS.createObjectProperty(this, "toolBarSide", Side.TOP, false, StyleConverter.getEnumConverter(Side.class), (oldVal, newVal) -> {
            AssertUtils.notNull((String)"Side must not be null", (Object)newVal);
            this.setTop(null);
            this.setBottom(null);
            this.setLeft(null);
            this.setRight(null);
            switch (newVal) {
                case LEFT: {
                    this.getToolBar().setOrientation(Orientation.VERTICAL);
                    this.setLeft((Node)this.getToolBar());
                    break;
                }
                case RIGHT: {
                    this.getToolBar().setOrientation(Orientation.VERTICAL);
                    this.setRight((Node)this.getToolBar());
                    break;
                }
                case BOTTOM: {
                    this.getToolBar().setOrientation(Orientation.HORIZONTAL);
                    this.setBottom((Node)this.getToolBar());
                    break;
                }
                default: {
                    this.getToolBar().setOrientation(Orientation.HORIZONTAL);
                    this.setTop((Node)this.getToolBar());
                }
            }
            return newVal;
        }, this::requestLayout);
        for (int dim = 0; dim < axes.length; ++dim) {
            AbstractAxis abstractAxis;
            Axis axis = axes[dim];
            if (!(axis instanceof AbstractAxis) || (abstractAxis = (AbstractAxis)axis).getDimIndex() >= 0) continue;
            abstractAxis.setDimIndex(dim);
        }
        this.getStylesheets().add((Object)CHART_CSS);
        this.setTriggerDistance(50.0);
        this.setMinSize(0.0, 0.0);
        this.setPrefSize(-1.0, -1.0);
        this.setMaxSize(-1.0, -1.0);
        this.setPadding(Insets.EMPTY);
        BorderPane localBorderPane = new BorderPane();
        this.axesAndCanvasPane.setPadding(Insets.EMPTY);
        localBorderPane.setCenter((Node)new StackPane(new Node[]{this.plotBackground, this.axesAndCanvasPane, this.plotForeGround}));
        this.plotBackground.toBack();
        this.plotForeGround.toFront();
        this.plotForeGround.setMouseTransparent(true);
        Side[] axis = Side.values();
        int abstractAxis = axis.length;
        boolean bl = false;
        while (var5_15 < abstractAxis) {
            Side side = axis[var5_15];
            BorderPane.setAlignment((Node)this.getMeasurementBar(side), (Pos)Pos.CENTER);
            ++var5_15;
        }
        localBorderPane.setTop((Node)this.getMeasurementBar(Side.TOP));
        localBorderPane.setBottom((Node)this.getMeasurementBar(Side.BOTTOM));
        localBorderPane.setLeft((Node)this.getMeasurementBar(Side.LEFT));
        localBorderPane.setRight((Node)this.getMeasurementBar(Side.RIGHT));
        super.setContent((Node)localBorderPane);
        this.hiddenPane.triggerDistanceProperty().bindBidirectional((Property)this.triggerDistanceProperty());
        this.hiddenPane.setAnimationDelay(Duration.millis((double)500.0));
        this.hiddenPane.setPickOnBounds(false);
        StackPane stackPane = new StackPane(new Node[]{this.getCanvas(), this.getCanvasForeground(), this.pluginsArea});
        this.hiddenPane.setContent((Node)stackPane);
        this.getCanvasForeground().setManaged(false);
        ChangeListener canvasSizeChangeListener = (ch, o, n) -> {
            double width = this.getCanvas().getWidth();
            double height = this.getCanvas().getHeight();
            if (this.getCanvasForeground().getWidth() != width || this.getCanvasForeground().getHeight() != height) {
                this.getCanvasForeground().resize(width, height);
            }
            if (!this.isCanvasChangeRequested) {
                this.isCanvasChangeRequested = true;
                Platform.runLater(() -> {
                    this.layoutChildren();
                    this.isCanvasChangeRequested = false;
                });
            }
        };
        this.canvas.widthProperty().addListener(canvasSizeChangeListener);
        this.canvas.heightProperty().addListener(canvasSizeChangeListener);
        this.getCanvasForeground().setMouseTransparent(true);
        this.getCanvas().toFront();
        this.getCanvasForeground().toFront();
        this.pluginsArea.toFront();
        this.hiddenPane.getStyleClass().setAll((Object[])new String[]{"plot-content"});
        this.plotBackground.getStyleClass().setAll((Object[])new String[]{"chart-plot-background"});
        if (!this.canvas.isCache()) {
            this.canvas.setCache(true);
            this.canvas.setCacheHint(CacheHint.QUALITY);
        }
        this.axesAndCanvasPane.add((Node)this.hiddenPane, 2, 2);
        this.canvas.setStyle("-fx-background-color: rgba(200, 250, 200, 0.5);");
        boolean bl2 = true;
        boolean colSpan1 = true;
        int rowSpan3 = 3;
        int colSpan3 = 3;
        this.axesAndCanvasPane.add((Node)this.getTitleLegendPane(Side.LEFT), 0, 1, 1, 3);
        this.axesAndCanvasPane.add((Node)this.getTitleLegendPane(Side.RIGHT), 4, 1, 1, 3);
        this.axesAndCanvasPane.add((Node)this.getTitleLegendPane(Side.TOP), 1, 0, 3, 1);
        this.axesAndCanvasPane.add((Node)this.getTitleLegendPane(Side.BOTTOM), 1, 4, 3, 1);
        this.axesAndCanvasPane.add((Node)this.getAxesPane(Side.LEFT), 1, 2);
        this.axesAndCanvasPane.add((Node)this.getAxesPane(Side.RIGHT), 3, 2);
        this.axesAndCanvasPane.add((Node)this.getAxesPane(Side.TOP), 2, 1);
        this.axesAndCanvasPane.add((Node)this.getAxesPane(Side.BOTTOM), 2, 3);
        Pane pane = this.getAxesPane(Side.CENTER_VER);
        GridPane.setFillHeight((Node)pane, (Boolean)true);
        GridPane.setFillWidth((Node)pane, (Boolean)true);
        this.axesAndCanvasPane.add((Node)this.getAxesPane(Side.CENTER_VER), 2, 2);
        this.axesAndCanvasPane.add((Node)this.getAxesPane(Side.CENTER_HOR), 2, 2);
        this.axesAndCanvasPane.add((Node)this.getAxesCornerPane(Corner.TOP_LEFT), 1, 1);
        this.axesAndCanvasPane.add((Node)this.getAxesCornerPane(Corner.TOP_RIGHT), 3, 1);
        this.axesAndCanvasPane.add((Node)this.getAxesCornerPane(Corner.BOTTOM_LEFT), 1, 3);
        this.axesAndCanvasPane.add((Node)this.getAxesCornerPane(Corner.BOTTOM_RIGHT), 3, 3);
        this.axesAndCanvasPane.add((Node)this.getTitleLegendCornerPane(Corner.TOP_LEFT), 0, 0);
        this.axesAndCanvasPane.add((Node)this.getTitleLegendCornerPane(Corner.TOP_RIGHT), 4, 0);
        this.axesAndCanvasPane.add((Node)this.getTitleLegendCornerPane(Corner.BOTTOM_LEFT), 0, 4);
        this.axesAndCanvasPane.add((Node)this.getTitleLegendCornerPane(Corner.BOTTOM_RIGHT), 4, 4);
        for (int i = 0; i < 4; ++i) {
            RowConstraints rowConstraint = new RowConstraints();
            if (i == 2) {
                rowConstraint.setVgrow(Priority.ALWAYS);
                rowConstraint.setFillHeight(true);
            }
            this.axesAndCanvasPane.getRowConstraints().add(i, (Object)rowConstraint);
            ColumnConstraints colConstraint = new ColumnConstraints();
            if (i == 2) {
                colConstraint.setHgrow(Priority.ALWAYS);
                colConstraint.setFillWidth(true);
            }
            this.axesAndCanvasPane.getColumnConstraints().add(i, (Object)colConstraint);
        }
        this.getPlugins().addListener(this.pluginsChangedListener);
        this.titleLabel.setAlignment(Pos.CENTER);
        HBox.setHgrow((Node)this.titleLabel, (Priority)Priority.ALWAYS);
        VBox.setVgrow((Node)this.titleLabel, (Priority)Priority.ALWAYS);
        this.titleLabel.focusTraversableProperty().bind((ObservableValue)Platform.accessibilityActiveProperty());
        this.toolBar.registerListener();
        this.setTop((Node)this.getToolBar());
        this.getTitleLegendPane(Side.TOP).getChildren().add((Object)this.titleLabel);
        this.legendVisibleProperty().addListener((ch, old, visible) -> {
            if (this.getLegend() == null) {
                return;
            }
            this.getLegend().getNode().setVisible(visible.booleanValue());
            if (Boolean.TRUE.equals(visible)) {
                if (!this.getTitleLegendPane(this.getLegendSide()).getChildren().contains((Object)this.getLegend().getNode())) {
                    this.getTitleLegendPane(this.getLegendSide()).getChildren().add((Object)this.getLegend().getNode());
                }
            } else {
                this.getTitleLegendPane(this.getLegendSide()).getChildren().remove((Object)this.getLegend().getNode());
            }
        });
        this.titleLabel.getStyleClass().add((Object)"chart-title");
        this.getStyleClass().add((Object)"chart");
        this.axesAndCanvasPane.getStyleClass().add((Object)"chart-content");
        this.registerShowingListener();
    }

    public void addListener(InvalidationListener listener) {
        Objects.requireNonNull(listener, "InvalidationListener must not be null");
        this.listeners.add(listener);
    }

    public void animate(KeyFrame ... keyFrames) {
        this.animator.animate(keyFrames);
    }

    public final BooleanProperty animatedProperty() {
        return this.animated;
    }

    public BooleanProperty autoNotificationProperty() {
        return this.autoNotification;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Chart fireInvalidated() {
        BooleanProperty booleanProperty = this.autoNotification;
        synchronized (booleanProperty) {
            if (!this.isAutoNotification() || this.listeners.isEmpty()) {
                return this;
            }
        }
        if (Platform.isFxApplicationThread()) {
            this.executeFireInvalidated();
        } else {
            Platform.runLater(this::executeFireInvalidated);
        }
        return this;
    }

    public ObservableList<DataSet> getAllDatasets() {
        if (this.getRenderers() == null) {
            return this.allDataSets;
        }
        this.allDataSets.clear();
        this.allDataSets.addAll(this.getDatasets());
        this.getRenderers().stream().filter(renderer -> !(renderer instanceof LabelledMarkerRenderer)).forEach(renderer -> this.allDataSets.addAll(renderer.getDatasets()));
        return this.allDataSets;
    }

    public ObservableList<Axis> getAxes() {
        return this.axesList;
    }

    public GridPane getAxesAndCanvasPane() {
        return this.axesAndCanvasPane;
    }

    public final StackPane getAxesCornerPane(Corner corner) {
        return this.axesCorner.get((Object)corner);
    }

    public final Pane getAxesPane(Side side) {
        return this.axesPane.get((Object)side);
    }

    public final Canvas getCanvas() {
        return this.canvas;
    }

    public final Pane getCanvasForeground() {
        return this.canvasForeground;
    }

    public ObservableList<DataSet> getDatasets() {
        return this.datasets;
    }

    public Axis getFirstAxis(Orientation orientation) {
        block6: for (Axis axis : this.getAxes()) {
            if (axis.getSide() == null) continue;
            switch (orientation) {
                case VERTICAL: {
                    if (!axis.getSide().isVertical()) continue block6;
                    return axis;
                }
            }
            if (!axis.getSide().isHorizontal()) continue;
            return axis;
        }
        switch (orientation) {
            case HORIZONTAL: {
                DefaultNumericAxis newXAxis = new DefaultNumericAxis("x-Axis");
                newXAxis.setSide(Side.BOTTOM);
                newXAxis.setDimIndex(0);
                this.getAxes().add((Object)newXAxis);
                return newXAxis;
            }
        }
        DefaultNumericAxis newYAxis = new DefaultNumericAxis("y-Axis");
        newYAxis.setSide(Side.LEFT);
        newYAxis.setDimIndex(1);
        this.getAxes().add((Object)newYAxis);
        return newYAxis;
    }

    public final Legend getLegend() {
        return (Legend)this.legend.getValue();
    }

    public final Side getLegendSide() {
        return (Side)((Object)this.legendSide.get());
    }

    public final Pane getMeasurementBar(Side side) {
        return this.measurementBar.get((Object)side);
    }

    public final Side getMeasurementBarSide() {
        return (Side)((Object)this.measurementBarSide.get());
    }

    public final HiddenSidesPane getPlotArea() {
        return this.hiddenPane;
    }

    public final Pane getPlotBackground() {
        return this.plotBackground;
    }

    public final Pane getPlotForeground() {
        return this.plotForeGround;
    }

    public final ObservableList<ChartPlugin> getPlugins() {
        return this.plugins;
    }

    public ObservableList<Renderer> getRenderers() {
        return this.renderers;
    }

    public final String getTitle() {
        return (String)this.title.get();
    }

    public final StackPane getTitleLegendCornerPane(Corner corner) {
        return this.titleLegendCorner.get((Object)corner);
    }

    public final Pane getTitleLegendPane(Side side) {
        return this.titleLegendPane.get((Object)side);
    }

    public final Side getTitleSide() {
        return (Side)((Object)this.titleSide.get());
    }

    public final FlowPane getToolBar() {
        return this.toolBar;
    }

    public final ObjectProperty<Side> getToolBarSideProperty() {
        return this.toolBarSide;
    }

    public final Side getToolBarSide() {
        return (Side)((Object)this.toolBarSideProperty().get());
    }

    public final boolean isAnimated() {
        return this.animated.get();
    }

    public boolean isAutoNotification() {
        return this.autoNotification.get();
    }

    public final boolean isLegendVisible() {
        return this.legendVisible.getValue();
    }

    public boolean isShowing() {
        return this.showing.get();
    }

    public boolean isToolBarPinned() {
        return this.toolBarPinned.get();
    }

    public void layoutChildren() {
        if (this.layoutOngoing) {
            return;
        }
        long start = ProcessingProfiler.getTimeStamp();
        this.layoutOngoing = true;
        this.updateAxisRange();
        ProcessingProfiler.getTimeDiff((long)start, (String)"updateAxisRange()");
        super.layoutChildren();
        this.redrawCanvas();
        ProcessingProfiler.getTimeDiff((long)start, (String)"updateCanvas()");
        this.layoutPluginsChildren();
        ProcessingProfiler.getTimeDiff((long)start, (String)"layoutPluginsChildren()");
        ProcessingProfiler.getTimeDiff((long)start, (String)"end");
        this.layoutOngoing = false;
        this.fireInvalidated();
    }

    public final ObjectProperty<Legend> legendProperty() {
        return this.legend;
    }

    public final ObjectProperty<Side> legendSideProperty() {
        return this.legendSide;
    }

    public final BooleanProperty legendVisibleProperty() {
        return this.legendVisible;
    }

    public final ObjectProperty<Side> measurementBarSideProperty() {
        return this.measurementBarSide;
    }

    public boolean removeFromAllAxesPanes(Axis node) {
        if (!(node instanceof Node)) {
            return false;
        }
        Node axisNode = (Node)node;
        for (Side side : Side.values()) {
            if (!this.getAxesPane(side).getChildren().remove((Object)axisNode)) continue;
            return true;
        }
        return false;
    }

    public void removeListener(InvalidationListener listener) {
        this.listeners.remove(listener);
    }

    public void requestLayout() {
        FXUtils.assertJavaFxThread();
        super.requestLayout();
    }

    public final void setAnimated(boolean value) {
        this.animated.set(value);
    }

    public void setAutoNotification(boolean flag) {
        this.autoNotification.set(flag);
    }

    public final void setLegend(Legend value) {
        this.legend.set((Object)value);
    }

    public final void setLegendSide(Side value) {
        this.legendSide.set((Object)value);
    }

    public final void setLegendVisible(boolean value) {
        this.legendVisible.set(value);
    }

    public final void setMeasurementBarSide(Side value) {
        this.measurementBarSide.set((Object)value);
    }

    public final void setTitle(String value) {
        this.title.set((Object)value);
    }

    public final void setTitleSide(Side value) {
        this.titleSide.set((Object)value);
    }

    public Chart setToolBarPinned(boolean value) {
        this.toolBarPinned.set(value);
        return this;
    }

    public final void setToolBarSide(Side value) {
        this.toolBarSide.set((Object)value);
    }

    public ReadOnlyBooleanProperty showingProperty() {
        return this.showing;
    }

    public final StringProperty titleProperty() {
        return this.title;
    }

    public final ObjectProperty<Side> titleSideProperty() {
        return this.titleSide;
    }

    public BooleanProperty toolBarPinnedProperty() {
        return this.toolBarPinned;
    }

    public final ObjectProperty<Side> toolBarSideProperty() {
        return this.toolBarSide;
    }

    public final Point2D toPlotArea(double xCoord, double yCoord) {
        Bounds plotAreaBounds = this.getCanvas().getBoundsInParent();
        return new Point2D(xCoord - plotAreaBounds.getMinX(), yCoord - plotAreaBounds.getMinY());
    }

    public abstract void updateAxisRange();

    protected void animate(Animation animation) {
        this.animator.animate(animation);
    }

    protected abstract void axesChanged(ListChangeListener.Change<? extends Axis> var1);

    protected void axesChangedLocal(ListChangeListener.Change<? extends Axis> change) {
        while (change.next()) {
            change.getRemoved().forEach(set -> {
                AssertUtils.notNull((String)"to be removed axis is null", (Object)set);
                set.removeListener(this.axisChangeListener);
            });
            for (Axis set2 : change.getAddedSubList()) {
                AssertUtils.notNull((String)"to be added axis is null", (Object)set2);
                set2.addListener(this.axisChangeListener);
            }
        }
        this.requestLayout();
    }

    protected void axesInvalidated(Object axisObj) {
        if (!(axisObj instanceof Axis) || this.layoutOngoing || this.isAxesUpdate) {
            return;
        }
        FXUtils.assertJavaFxThread();
        this.isAxesUpdate = true;
        this.requestLayout();
        this.isAxesUpdate = false;
    }

    protected void dataSetInvalidated() {
        FXUtils.assertJavaFxThread();
        this.requestLayout();
    }

    protected void datasetsChanged(ListChangeListener.Change<? extends DataSet> change) {
        boolean dataSetChanges = false;
        FXUtils.assertJavaFxThread();
        while (change.next()) {
            for (DataSet set : change.getRemoved()) {
                set.removeListener(this.dataSetDataListener);
                dataSetChanges = true;
            }
            for (DataSet set : change.getAddedSubList()) {
                set.addListener(this.dataSetDataListener);
                dataSetChanges = true;
            }
        }
        if (dataSetChanges) {
            this.updateLegend((List<DataSet>)this.getDatasets(), (List<Renderer>)this.getRenderers());
            this.requestLayout();
        }
    }

    protected void executeFireInvalidated() {
        new ArrayList<InvalidationListener>(this.listeners).forEach(listener -> listener.invalidated((Observable)this));
    }

    protected List<CssMetaData<? extends Styleable, ?>> getControlCssMetaData() {
        return Chart.getClassCssMetaData();
    }

    protected void layoutPluginsChildren() {
        this.plugins.forEach(ChartPlugin::layoutChildren);
    }

    protected void pluginAdded(ChartPlugin plugin) {
        plugin.setChart(this);
        Group group = Chart.createChildGroup();
        Bindings.bindContent((List)group.getChildren(), plugin.getChartChildren());
        this.pluginGroups.put(plugin, group);
    }

    protected void pluginRemoved(ChartPlugin plugin) {
        plugin.setChart(null);
        Group group = this.pluginGroups.remove(plugin);
        Bindings.unbindContent((Object)group, plugin.getChartChildren());
        group.getChildren().clear();
        this.pluginsArea.getChildren().remove((Object)group);
    }

    protected void pluginsChanged(ListChangeListener.Change<? extends ChartPlugin> change) {
        while (change.next()) {
            change.getRemoved().forEach(this::pluginRemoved);
            change.getAddedSubList().forEach(this::pluginAdded);
        }
        this.updatePluginsArea();
    }

    protected abstract void redrawCanvas();

    protected void registerShowingListener() {
        this.sceneProperty().addListener(this.scenePropertyListener);
        this.showing.addListener((ch, o, n) -> {
            if (Boolean.TRUE.equals(n)) {
                KeyFrame kf1 = new KeyFrame(Duration.millis((double)20.0), e -> this.requestLayout(), new KeyValue[0]);
                Timeline timeline = new Timeline(new KeyFrame[]{kf1});
                Platform.runLater(() -> ((Timeline)timeline).play());
            }
        });
    }

    protected void rendererChanged(ListChangeListener.Change<? extends Renderer> change) {
        FXUtils.assertJavaFxThread();
        while (change.next()) {
            change.getAddedSubList().forEach(renderer -> {
                renderer.getDatasets().addListener(this.datasetChangeListener);
                renderer.getDatasets().forEach(set -> set.addListener(this.dataSetDataListener));
            });
            change.getRemoved().forEach(renderer -> {
                renderer.getDatasets().removeListener(this.datasetChangeListener);
                renderer.getDatasets().forEach(set -> set.removeListener(this.dataSetDataListener));
            });
        }
        change.reset();
        this.requestLayout();
        this.updateLegend((List<DataSet>)this.getDatasets(), (List<Renderer>)this.getRenderers());
    }

    protected final boolean shouldAnimate() {
        return this.isAnimated() && this.getScene() != null;
    }

    protected void updateLegend(List<DataSet> dataSets, List<Renderer> renderers) {
        Legend legend = this.getLegend();
        if (legend == null) {
            return;
        }
        legend.updateLegend(dataSets, renderers);
    }

    protected void updatePluginsArea() {
        this.pluginsArea.getChildren().setAll((Collection)this.plugins.stream().map(this.pluginGroups::get).collect(Collectors.toList()));
        this.requestLayout();
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return CSS.getCssMetaData();
    }

    protected static Group createChildGroup() {
        Group group = new Group();
        group.setManaged(false);
        group.setAutoSizeChildren(false);
        group.relocate(0.0, 0.0);
        return group;
    }

    protected class ChartVBox
    extends VBox {
        public ChartVBox(Node ... nodes) {
            this.setAlignment(Pos.CENTER);
            this.setPrefSize(-1.0, -1.0);
            this.getChildren().addAll((Object[])nodes);
            this.visibleProperty().addListener((obs, o, n) -> this.getChildren().forEach(node -> node.setVisible(n.booleanValue())));
        }

        public ChartVBox(boolean fill) {
            this(new Node[0]);
            this.setFillWidth(fill);
        }
    }

    protected class ChartHBox
    extends HBox {
        public ChartHBox(Node ... nodes) {
            this.setAlignment(Pos.CENTER);
            this.setPrefSize(-1.0, -1.0);
            this.getChildren().addAll((Object[])nodes);
            this.visibleProperty().addListener((obs, o, n) -> this.getChildren().forEach(node -> node.setVisible(n.booleanValue())));
        }

        public ChartHBox(boolean fill) {
            this(new Node[0]);
            this.setFillHeight(fill);
        }
    }
}

