/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.viewer;

import javafx.beans.value.ChangeListener;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.layout.Region;

public class SquareButton
extends Button {
    private static final int MAX_BUTTON_SIZE = 30;

    public SquareButton(String cssName) {
        this.getStyleClass().setAll((Object[])new String[]{cssName});
        this.setPadding(Insets.EMPTY);
        this.updateListener();
    }

    public SquareButton(String text, Node graphic) {
        super(text, graphic);
        this.setPadding(Insets.EMPTY);
        this.updateListener();
    }

    private void adjustDimension() {
        if (!(this.getParent() instanceof Region)) {
            return;
        }
        Region titlePane = (Region)this.getParent();
        double marginBar = titlePane.getInsets().getTop() + titlePane.getInsets().getBottom();
        double paddingButton = this.getPadding().getTop() + this.getPadding().getBottom();
        double max = titlePane.getHeight() - marginBar - paddingButton;
        this.setPrefSize(max, max);
        this.setMaxSize(30.0, 30.0);
    }

    private void updateListener() {
        ChangeListener listener = (ch, o, n) -> this.adjustDimension();
        this.widthProperty().addListener(listener);
        this.heightProperty().addListener(listener);
        this.parentProperty().addListener((ch, o, n) -> {
            Region titlePane;
            if (o != null) {
                if (!(o instanceof Region)) {
                    return;
                }
                titlePane = (Region)o;
                titlePane.heightProperty().removeListener(listener);
            }
            if (n != null) {
                if (!(n instanceof Region)) {
                    return;
                }
                titlePane = (Region)n;
                titlePane.heightProperty().addListener(listener);
                this.adjustDimension();
            }
        });
        this.adjustDimension();
    }
}

