/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.viewer;

import de.gsi.chart.ui.TilingPane;
import de.gsi.chart.viewer.DataViewWindow;
import de.gsi.dataset.utils.NoDuplicatesList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.stream.Collectors;
import javafx.beans.DefaultProperty;
import javafx.beans.NamedArg;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DefaultProperty(value="visibleChildren")
public class DataView
extends VBox {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataView.class);
    private final StringProperty name = new SimpleStringProperty((Object)this, "name");
    private final ObjectProperty<Node> icon = new SimpleObjectProperty((Object)this, "icon");
    private final boolean standalone;
    private final FlowPane minimisedElements = new FlowPane();
    private final ObjectProperty<Pane> contentPane = new SimpleObjectProperty((Object)this, "contenPane");
    private final ObjectProperty<DataView> activeSubView = new SimpleObjectProperty((Object)this, "activeView");
    private final ObservableList<DataView> subDataViews = FXCollections.observableList((List)new NoDuplicatesList());
    private final ObservableList<Node> visibleNodes = FXCollections.observableList((List)new NoDuplicatesList());
    private final ObservableList<DataViewWindow> visibleChildren = FXCollections.observableList((List)new NoDuplicatesList());
    private final ObservableList<DataViewWindow> minimisedChildren = FXCollections.observableList((List)new NoDuplicatesList());
    private final ObservableList<DataViewWindow> undockedChildren = FXCollections.observableList((List)new NoDuplicatesList());
    private final ObjectProperty<DataViewWindow> maximizedChild = new SimpleObjectProperty<DataViewWindow>((Object)this, "maximizedView"){
        private Optional<DataView> lastActiveView;
        {
            this.lastActiveView = Optional.empty();
        }

        public void set(DataViewWindow newNode) {
            super.set((Object)newNode);
            if (newNode == null) {
                if (this.lastActiveView.isPresent()) {
                    DataView.this.setView(this.lastActiveView.get());
                }
                this.lastActiveView = Optional.empty();
            } else {
                if (this.lastActiveView.isEmpty()) {
                    this.lastActiveView = Optional.of((DataView)((Object)DataView.this.activeSubView.get()));
                }
                DataView.this.setNodeLayout(TilingPane.Layout.MAXIMISE);
            }
        }
    };

    public DataView(@NamedArg(value="name") String name, @NamedArg(value="icon") Node icon) {
        this(name, icon, null, false);
        this.addStandardViews();
    }

    public DataView(@NamedArg(value="name") String name, @NamedArg(value="icon") Node icon, @NamedArg(value="pane") Pane pane) {
        this(name, icon, pane, true);
    }

    protected DataView(String name, Node icon, Pane pane, boolean isStandalone) {
        HBox.setHgrow((Node)this, (Priority)Priority.ALWAYS);
        VBox.setVgrow((Node)this, (Priority)Priority.ALWAYS);
        this.standalone = isStandalone;
        VBox.setVgrow((Node)this.minimisedElements, (Priority)Priority.NEVER);
        HBox.setHgrow((Node)this.minimisedElements, (Priority)Priority.NEVER);
        this.minimisedElements.setPrefWrapLength(0.0);
        ChangeListener widthChange = (ch, o, n) -> this.minimisedElements.setPrefWrapLength(n.doubleValue());
        this.contentPaneProperty().addListener((ch, o, n) -> {
            if (o != null) {
                o.widthProperty().removeListener(widthChange);
            }
            if (n != null) {
                n.widthProperty().addListener(widthChange);
            }
        });
        this.setFillWidth(true);
        this.setActiveSubView(this);
        this.registerListListener();
        this.activeSubView.addListener((ch, o, n) -> {
            if (n == null) {
                this.getChildren().clear();
                return;
            }
            if (!this.getSubDataViews().contains((Object)n)) {
                this.getSubDataViews().add((Object)n);
            }
            if (n.isStandalone()) {
                this.getChildren().setAll((Object[])new Node[]{n});
                return;
            }
            for (DataView subView : this.getSubDataViews()) {
                if (subView.isStandalone()) continue;
                subView.getContentPane().getChildren().clear();
            }
            if (this.getMaximizedChild() == null) {
                this.getVisibleChildren().stream().forEach(child -> {
                    if (!this.getActiveView().getContentPane().getChildren().contains((Object)child)) {
                        this.getActiveView().getContentPane().getChildren().add((Object)child);
                    }
                });
            } else {
                this.getActiveView().getContentPane().getChildren().setAll((Object[])new Node[]{this.getMaximizedChild()});
            }
            this.getChildren().setAll((Object[])new Node[]{this.getActiveView().getContentPane(), this.minimisedElements});
        });
        this.setName(name == null ? "" : name);
        this.setIcon(icon);
        this.setContentPane((Pane)(pane == null ? new StackPane() : pane));
        if (this.standalone) {
            this.getChildren().setAll((Object[])new Node[]{this.getContentPane()});
        }
    }

    public ObjectProperty<DataView> activeSubViewProperty() {
        return this.activeSubView;
    }

    public ObjectProperty<Pane> contentPaneProperty() {
        return this.contentPane;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DataView)) {
            return false;
        }
        DataView other = (DataView)((Object)obj);
        return this.getName().equals(other.getName());
    }

    public DataView getActiveView() {
        return (DataView)((Object)this.activeSubViewProperty().get());
    }

    public Pane getContentPane() {
        return (Pane)this.contentPaneProperty().get();
    }

    public Node getIcon() {
        return (Node)this.iconProperty().get();
    }

    public final DataViewWindow getMaximizedChild() {
        return (DataViewWindow)((Object)this.maximizedChildProperty().get());
    }

    public final ObservableList<DataViewWindow> getMinimisedChildren() {
        return this.minimisedChildren;
    }

    public final Pane getMinimisedElementsPane() {
        return this.minimisedElements;
    }

    public final String getName() {
        return (String)this.nameProperty().get();
    }

    public final ObservableList<DataView> getSubDataViews() {
        return this.subDataViews;
    }

    public final ObservableList<DataViewWindow> getUndockedChildren() {
        return this.undockedChildren;
    }

    public final ObservableList<DataViewWindow> getVisibleChildren() {
        return this.visibleChildren;
    }

    public final ObservableList<Node> getVisibleNodes() {
        return this.visibleNodes;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name.get() == null ? 0 : ((String)this.name.get()).hashCode());
        return result;
    }

    public final ObjectProperty<Node> iconProperty() {
        return this.icon;
    }

    public boolean isStandalone() {
        return this.standalone;
    }

    public final ObjectProperty<DataViewWindow> maximizedChildProperty() {
        return this.maximizedChild;
    }

    public final StringProperty nameProperty() {
        return this.name;
    }

    public void setActiveSubView(DataView pane) {
        this.activeSubViewProperty().set((Object)pane);
    }

    public final void setContentPane(Pane pane) {
        this.contentPaneProperty().set((Object)pane);
    }

    public final void setIcon(Node icon) {
        this.iconProperty().set((Object)icon);
    }

    public final void setMaximizedChild(DataViewWindow view) {
        this.maximizedChildProperty().set((Object)view);
    }

    public final void setName(String name) {
        this.nameProperty().set((Object)name);
    }

    public void setNodeLayout(TilingPane.Layout nodeLayout) {
        Optional<DataView> match = this.getSubDataViews().stream().filter(p -> p.getName().equals(nodeLayout.getName())).findFirst();
        if (match.isPresent()) {
            this.setView(match.get());
            return;
        }
        LOGGER.atWarn().addArgument((Object)nodeLayout).log("could not find view for requested  layout '{}'");
    }

    public void setView(DataView viewerPane) {
        if (viewerPane == null || viewerPane.equals((Object)this.getActiveView())) {
            return;
        }
        this.setActiveSubView(viewerPane);
    }

    public void setView(String viewerPaneName) {
        if (viewerPaneName == null) {
            LOGGER.atWarn().log("viewerPaneName is null");
            return;
        }
        Optional<DataView> match = this.getSubDataViews().stream().filter(c -> c.getName().equals(viewerPaneName)).findFirst();
        if (match.isEmpty()) {
            LOGGER.atWarn().addArgument((Object)viewerPaneName).log("no DataView for viewerPaneName '{}'");
            return;
        }
        this.setView(match.get());
    }

    public void sort() {
        if (this.isStandalone() || this.getContentPane() == null || this.getContentPane().getChildren().isEmpty()) {
            return;
        }
        FXCollections.sort((ObservableList)this.getContentPane().getChildren(), Comparator.comparing(n -> n.toString().toLowerCase(Locale.UK)));
    }

    public String toString() {
        return DataView.class.getSimpleName() + "(\"" + this.getName() + "\")";
    }

    protected void addStandardViews() {
        for (TilingPane.Layout layout : TilingPane.Layout.values()) {
            DataView dataView = new DataView(layout.getName(), null, (Pane)new TilingPane(layout), false);
            this.subDataViews.add((Object)dataView);
        }
        this.setNodeLayout(TilingPane.Layout.GRID);
    }

    protected Collection<Node> getWrappedChildren(Collection<Node> children) {
        ArrayList<Node> newNodes = new ArrayList<Node>();
        for (Node node : children) {
            if (node instanceof DataViewWindow) {
                newNodes.add(node);
                continue;
            }
            DataViewWindow window = new DataViewWindow("", node);
            window.setParentView(this);
            window.setMinimised(true);
            newNodes.add((Node)window);
        }
        return newNodes;
    }

    protected void registerListListener() {
        this.visibleNodes.addListener(change -> {
            while (change.next()) {
                for (Node node : change.getRemoved()) {
                    DataView.removeChildFromList(this.visibleChildren, node);
                    DataView.removeChildFromList(this.minimisedChildren, node);
                    DataView.removeChildFromList(this.undockedChildren, node);
                    if (!node.equals(this.maximizedChild.get())) continue;
                    this.setMaximizedChild(null);
                }
                change.getAddedSubList().forEach(c -> {
                    HBox.setHgrow((Node)c, (Priority)Priority.ALWAYS);
                    VBox.setVgrow((Node)c, (Priority)Priority.ALWAYS);
                    if (c instanceof DataViewWindow) {
                        if (this.getActiveView().isStandalone()) {
                            return;
                        }
                        if (!this.getActiveView().getContentPane().getChildren().contains(c)) {
                            this.getActiveView().getContentPane().getChildren().add(c);
                        }
                        this.visibleChildren.add((Object)((DataViewWindow)((Object)((Object)c))));
                        return;
                    }
                    DataViewWindow child = new DataViewWindow("", (Node)c);
                    child.setParentView(this);
                    this.visibleChildren.add((Object)child);
                });
            }
        });
        this.visibleChildren.addListener(change -> {
            while (change.next()) {
                if (this.getActiveView() == null) continue;
                if (this.getActiveView().isStandalone()) {
                    return;
                }
                change.getRemoved().forEach(c -> this.getActiveView().getContentPane().getChildren().remove((Object)c));
                change.getAddedSubList().stream().filter(o -> !this.getActiveView().getContentPane().getChildren().contains((Object)o)).forEach(c -> {
                    c.setParentView(this);
                    this.getActiveView().getContentPane().getChildren().add((Object)c);
                });
            }
        });
        this.minimisedChildren.addListener(change -> {
            while (change.next()) {
                this.minimisedElements.getChildren().removeAll((Collection)change.getRemoved());
                change.getAddedSubList().stream().forEach(view -> {
                    view.setParentView(this);
                    if (!view.isMinimised() && view.getWindowState().equals((Object)DataViewWindow.WindowState.WINDOW_RESTORED)) {
                        view.setMinimised(true);
                    }
                });
                this.minimisedElements.getChildren().addAll((Collection)change.getAddedSubList().stream().filter(view -> !this.minimisedElements.getChildren().contains((Object)view)).collect(Collectors.toList()));
            }
        });
        this.undockedChildren.addListener(change -> {
            while (change.next()) {
                this.minimisedElements.getChildren().removeAll((Collection)change.getRemoved());
                this.visibleChildren.removeAll((Collection)change.getRemoved());
                this.minimisedChildren.removeAll((Collection)change.getRemoved());
                change.getRemoved().forEach(view -> view.setDetached(false));
                change.getAddedSubList().stream().forEach(view -> {
                    view.setParentView(this);
                    view.setDetached(true);
                });
            }
        });
        this.contentPane.addListener((ch, o, n) -> {
            if (n == null || n.equals(o)) {
                return;
            }
            if (this.isStandalone()) {
                this.getChildren().setAll((Object[])new Node[]{n});
            } else {
                this.getChildren().setAll((Object[])new Node[]{n, this.minimisedElements});
            }
        });
    }

    private static void removeChildFromList(List<DataViewWindow> list, Node node) {
        Optional<DataViewWindow> found = list.stream().filter(content -> node.equals(content.getContent())).findFirst();
        if (found.isPresent()) {
            list.remove((Object)found.get());
        }
    }
}

