/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.utils;

import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import javafx.scene.paint.Color;
import javafx.scene.text.Font;
import javafx.scene.text.FontPosture;
import javafx.scene.text.FontWeight;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StyleParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(StyleParser.class);
    private static final String COULD_NOT_PARSE_INTEGER = "could not parse integer for '{}'='{}' returning null";
    private static final String COULD_NOT_PARSE_COLOR_DESCRIPTION = "could not parse color description for '{}'='{}' returning null";
    private static final String COULD_NOT_PARSE_FLOATING_POINT = "could not parse floating point for '{}'='{}' returning null";
    private static final int DEFAULT_FONT_SIZE = 18;
    private static final String DEFAULT_FONT = "Helvetia";
    private static final Pattern AT_LEAST_ONE_WHITESPACE_PATTERN = Pattern.compile("\\s+");
    private static final Pattern QUOTES_PATTERN = Pattern.compile("[\"']");
    private static final Pattern STYLE_ASSIGNMENT_PATTERN = Pattern.compile("[=:]");

    private StyleParser() {
    }

    public static Boolean getBooleanPropertyValue(String style, String key) {
        if (style == null || key == null) {
            return null;
        }
        Map<String, String> map = StyleParser.splitIntoMap(style);
        String value = map.get(key.toLowerCase(Locale.UK));
        if (value == null) {
            return null;
        }
        return Boolean.parseBoolean(value);
    }

    public static Color getColorPropertyValue(String style, String key) {
        if (style == null || key == null) {
            return null;
        }
        Map<String, String> map = StyleParser.splitIntoMap(style);
        String value = map.get(key.toLowerCase(Locale.UK));
        if (value == null) {
            return null;
        }
        try {
            return Color.web((String)value);
        }
        catch (IllegalArgumentException ex) {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.atTrace().setCause((Throwable)ex).addArgument((Object)key).addArgument((Object)value).log(COULD_NOT_PARSE_COLOR_DESCRIPTION);
            }
            if (LOGGER.isErrorEnabled()) {
                LOGGER.atError().addArgument((Object)key).addArgument((Object)value).log(COULD_NOT_PARSE_COLOR_DESCRIPTION);
            }
            return null;
        }
    }

    public static double[] getFloatingDecimalArrayPropertyValue(String style, String key) {
        if (style == null || key == null) {
            return null;
        }
        Map<String, String> map = StyleParser.splitIntoMap(style);
        String value = map.get(key.toLowerCase(Locale.UK));
        if (value == null) {
            return null;
        }
        try {
            String[] splitValues = value.split(",");
            double[] retArray = new double[splitValues.length];
            for (int i = 0; i < splitValues.length; ++i) {
                retArray[i] = Double.parseDouble(splitValues[i]);
            }
            return retArray;
        }
        catch (NumberFormatException ex) {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.atTrace().setCause((Throwable)ex).addArgument((Object)key).addArgument((Object)value).log(COULD_NOT_PARSE_FLOATING_POINT);
            }
            if (LOGGER.isErrorEnabled()) {
                LOGGER.atError().addArgument((Object)key).addArgument((Object)value).log(COULD_NOT_PARSE_FLOATING_POINT);
            }
            return null;
        }
    }

    public static Double getFloatingDecimalPropertyValue(String style, String key) {
        if (style == null || key == null) {
            return null;
        }
        Map<String, String> map = StyleParser.splitIntoMap(style);
        String value = map.get(key.toLowerCase(Locale.UK));
        if (value == null) {
            return null;
        }
        try {
            return Double.parseDouble(value);
        }
        catch (NumberFormatException ex) {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.atTrace().setCause((Throwable)ex).addArgument((Object)key).addArgument((Object)value).log(COULD_NOT_PARSE_FLOATING_POINT);
            }
            if (LOGGER.isErrorEnabled()) {
                LOGGER.atError().addArgument((Object)key).addArgument((Object)value).log(COULD_NOT_PARSE_FLOATING_POINT);
            }
            return null;
        }
    }

    public static Font getFontPropertyValue(String style) {
        String font;
        if (style == null) {
            return Font.font((String)DEFAULT_FONT, (double)18.0);
        }
        double fontSize = 18.0;
        Double fontSizeObj = StyleParser.getFloatingDecimalPropertyValue(style, "fontSize");
        if (fontSizeObj != null) {
            fontSize = fontSizeObj;
        }
        FontWeight fontWeight = null;
        String fontW = StyleParser.getPropertyValue(style, "fontWeight");
        if (fontW != null) {
            fontWeight = FontWeight.findByName((String)fontW);
        }
        FontPosture fontPosture = null;
        String fontP = StyleParser.getPropertyValue(style, "fontPosture");
        if (fontP != null) {
            fontPosture = FontPosture.findByName((String)fontP);
        }
        if ((font = StyleParser.getPropertyValue(style, "font")) == null) {
            return Font.font((String)DEFAULT_FONT, (FontWeight)fontWeight, (FontPosture)fontPosture, (double)fontSize);
        }
        return Font.font((String)font, (FontWeight)fontWeight, (FontPosture)fontPosture, (double)fontSize);
    }

    public static Integer getIntegerPropertyValue(String style, String key) {
        if (style == null || key == null) {
            return null;
        }
        Map<String, String> map = StyleParser.splitIntoMap(style);
        String value = map.get(key.toLowerCase(Locale.UK));
        if (value == null) {
            return null;
        }
        try {
            return Integer.decode(value);
        }
        catch (NumberFormatException ex) {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.atTrace().setCause((Throwable)ex).addArgument((Object)key).addArgument((Object)value).log(COULD_NOT_PARSE_INTEGER);
            }
            if (LOGGER.isErrorEnabled()) {
                LOGGER.atError().addArgument((Object)key).addArgument((Object)value).log(COULD_NOT_PARSE_INTEGER);
            }
            return null;
        }
    }

    public static String getPropertyValue(String style, String key) {
        if (style == null || key == null) {
            return null;
        }
        Map<String, String> map = StyleParser.splitIntoMap(style);
        return map.get(key.toLowerCase(Locale.UK));
    }

    public static double[] getStrokeDashPropertyValue(String style, String key) {
        if (style == null || key == null) {
            return null;
        }
        Map<String, String> map = StyleParser.splitIntoMap(style);
        String value = map.get(key.toLowerCase(Locale.UK));
        if (value == null) {
            return null;
        }
        try {
            return Arrays.asList(value.split(",\\s*")).stream().map(String::trim).mapToDouble(Double::parseDouble).toArray();
        }
        catch (IllegalArgumentException ex) {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.atTrace().setCause((Throwable)ex).addArgument((Object)key).addArgument((Object)value).log(COULD_NOT_PARSE_COLOR_DESCRIPTION);
            }
            if (LOGGER.isErrorEnabled()) {
                LOGGER.atError().addArgument((Object)key).addArgument((Object)value).log(COULD_NOT_PARSE_COLOR_DESCRIPTION);
            }
            return null;
        }
    }

    public static String mapToString(Map<String, String> map) {
        String ret = "";
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            ret = ret.concat(key).concat("=").concat(value).concat(";");
        }
        return ret;
    }

    public static Map<String, String> splitIntoMap(String style) {
        String[] keyVals;
        ConcurrentHashMap<String, String> retVal = new ConcurrentHashMap<String, String>();
        if (style == null) {
            return retVal;
        }
        for (String keyVal : keyVals = AT_LEAST_ONE_WHITESPACE_PATTERN.matcher(style.toLowerCase(Locale.UK)).replaceAll("").split(";")) {
            String[] parts = STYLE_ASSIGNMENT_PATTERN.split(keyVal, 2);
            if (parts.length <= 1) continue;
            retVal.put(parts[0], QUOTES_PATTERN.matcher(parts[1]).replaceAll(""));
        }
        return retVal;
    }
}

