/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.utils;

import com.sun.javafx.perf.PerformanceTracker;
import com.sun.management.OperatingSystemMXBean;
import de.gsi.chart.utils.FXUtils;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Field;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicInteger;
import javafx.animation.AnimationTimer;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.scene.Node;
import javafx.scene.Scene;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimplePerformanceMeter {
    private static final Logger LOGGER = LoggerFactory.getLogger(SimplePerformanceMeter.class);
    private static final int MIN_UPDATE_PERIOD = 40;
    private static final int MAX_UPDATE_PERIOD = 10000;
    private static final OperatingSystemMXBean OS_BEAN = ManagementFactory.getPlatformMXBean(OperatingSystemMXBean.class);
    private static final int N_CORES = OS_BEAN.getAvailableProcessors();
    private final DoubleProperty averageFactor = new SimpleDoubleProperty((Object)this, "averageFactor", 0.01);
    private final DoubleProperty pulseRate = new SimpleDoubleProperty((Object)this, "pulseRate", 0.0);
    private final DoubleProperty pulseRateAvg = new SimpleDoubleProperty((Object)this, "pulseRateAvg", 0.0);
    private final DoubleProperty trackerFrameRate = new SimpleDoubleProperty((Object)this, "trackerFrameRate", 0.0);
    private final DoubleProperty avgTrackerFrameRate = new SimpleDoubleProperty((Object)this, "avgTrackerFrameRate", 0.0);
    private final DoubleProperty processCpuLoad = new SimpleDoubleProperty((Object)this, "processCpuLoad", 0.0);
    private final DoubleProperty minProcessCpuLoad = new SimpleDoubleProperty((Object)this, "minProcessCpuLoad", -1.0);
    private final DoubleProperty avgProcessCpuLoad = new SimpleDoubleProperty((Object)this, "avgProcessCpuLoad", -1.0);
    private final DoubleProperty maxProcessCpuLoad = new SimpleDoubleProperty((Object)this, "maxProcessCpuLoad", -1.0);
    private final DoubleProperty systemCpuLoad = new SimpleDoubleProperty((Object)this, "systemCpuLoad", 0.0);
    private final DoubleProperty avgSystemCpuLoad = new SimpleDoubleProperty((Object)this, "avgSystemCpuLoad", -1.0);
    private double pulseRateInternal;
    private double pulseRateAvgInternal = -1.0;
    private double frameRateInternal;
    private double frameRateAvgInternal = -1.0;
    private double cpuLoadProcessInternal;
    private double cpuLoadProcessAvgInternal;
    private double cpuLoadSystemInternal;
    private double cpuLoadSystemAvgInternal = -1.0;
    private final Scene scene;
    private final Field dirtyRootBits;
    private final Field dirtyNodesSize;
    private final long updateDuration;
    private final PerformanceTracker fxPerformanceTracker;
    private Timer timer;
    private final AnimationTimer animationTimer;
    private long timerIterationLast = System.currentTimeMillis();
    private final AtomicInteger pulseCounter = new AtomicInteger(0);
    private final AtomicInteger frameCounter = new AtomicInteger(0);
    private final Runnable pulseListener = () -> {
        if (this.isSceneDirty()) {
            this.frameCounter.getAndIncrement();
        }
    };

    public SimplePerformanceMeter(Scene scene, long updateDuration) {
        if (scene == null) {
            throw new IllegalArgumentException("scene must not be null");
        }
        this.scene = scene;
        this.updateDuration = Math.max(40L, Math.min(updateDuration, 10000L));
        this.fxPerformanceTracker = PerformanceTracker.getSceneTracker((Scene)scene);
        this.animationTimer = new AnimationTimer(){

            public void handle(long now) {
                SimplePerformanceMeter.this.pulseCounter.getAndIncrement();
            }
        };
        Field field1 = null;
        Field field2 = null;
        try {
            field1 = Node.class.getDeclaredField("dirtyBits");
            field1.setAccessible(true);
            field2 = Scene.class.getDeclaredField("dirtyNodesSize");
            field2.setAccessible(true);
        }
        catch (NoSuchFieldException | SecurityException e) {
            LOGGER.atError().setCause((Throwable)e).log("cannot access scene root's dirtyBits field");
        }
        this.dirtyRootBits = field1;
        this.dirtyNodesSize = field2;
        this.registerListener();
    }

    public ReadOnlyDoubleProperty actualFrameRateProperty() {
        return this.trackerFrameRate;
    }

    public DoubleProperty averageFactorProperty() {
        return this.averageFactor;
    }

    public ReadOnlyDoubleProperty averageFrameRateProperty() {
        return this.avgTrackerFrameRate;
    }

    public ReadOnlyDoubleProperty averageFxFrameRateProperty() {
        return this.pulseRateAvg;
    }

    public ReadOnlyDoubleProperty averageProcessCpuLoadProperty() {
        return this.avgProcessCpuLoad;
    }

    public ReadOnlyDoubleProperty averageSystemCpuLoadProperty() {
        return this.avgSystemCpuLoad;
    }

    public void deregisterListener() {
        this.animationTimer.stop();
        this.scene.removePostLayoutPulseListener(this.pulseListener);
        this.timer.cancel();
    }

    public ReadOnlyDoubleProperty fxFrameRateProperty() {
        return this.pulseRate;
    }

    public double getActualFrameRate() {
        return this.actualFrameRateProperty().get();
    }

    public double getAverageFrameRate() {
        return this.averageFrameRateProperty().get();
    }

    public double getAverageFxFrameRate() {
        return this.averageFxFrameRateProperty().get();
    }

    public double getAverageProcessCpuLoad() {
        return this.averageProcessCpuLoadProperty().get();
    }

    public double getAverageSystemCpuLoad() {
        return this.averageSystemCpuLoadProperty().get();
    }

    public double getFxFrameRate() {
        return this.fxFrameRateProperty().get();
    }

    @Deprecated
    public double getMaxProcessCpuLoad() {
        return this.minProcessCpuLoadProperty().get();
    }

    @Deprecated
    public double getMinProcessCpuLoad() {
        return this.minProcessCpuLoadProperty().get();
    }

    public double getProcessCpuLoad() {
        return this.processCpuLoadProperty().get();
    }

    public double getSystemCpuLoad() {
        return this.systemCpuLoadProperty().get();
    }

    @Deprecated
    public ReadOnlyDoubleProperty maxProcessCpuLoadProperty() {
        return this.maxProcessCpuLoad;
    }

    @Deprecated
    public ReadOnlyDoubleProperty minProcessCpuLoadProperty() {
        return this.minProcessCpuLoad;
    }

    public ReadOnlyDoubleProperty processCpuLoadProperty() {
        return this.processCpuLoad;
    }

    public void registerListener() {
        this.animationTimer.start();
        this.timer = new Timer("SimplePerformanceMeter-timer", true);
        this.timer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                long timerIterationThis = System.currentTimeMillis();
                int pulseCount = SimplePerformanceMeter.this.pulseCounter.getAndSet(0);
                int frameCount = SimplePerformanceMeter.this.frameCounter.getAndSet(0);
                double diff = (double)(timerIterationThis - SimplePerformanceMeter.this.timerIterationLast) * 0.001;
                SimplePerformanceMeter.this.timerIterationLast = timerIterationThis;
                SimplePerformanceMeter.this.pulseRateInternal = diff > 0.0 ? (double)pulseCount / diff : -1.0;
                SimplePerformanceMeter.this.frameRateInternal = diff > 0.0 ? (double)frameCount / diff : -1.0;
                SimplePerformanceMeter.this.pulseRateInternal = SimplePerformanceMeter.this.fxPerformanceTracker.getInstantPulses();
                SimplePerformanceMeter.this.frameRateInternal = SimplePerformanceMeter.this.fxPerformanceTracker.getInstantFPS();
                SimplePerformanceMeter.this.cpuLoadProcessInternal = OS_BEAN.getProcessCpuLoad() * 100.0 * (double)N_CORES;
                SimplePerformanceMeter.this.cpuLoadSystemInternal = OS_BEAN.getSystemCpuLoad() * 100.0 * (double)N_CORES;
                double alpha = SimplePerformanceMeter.this.averageFactor.get();
                SimplePerformanceMeter.this.pulseRateAvgInternal = SimplePerformanceMeter.computeAverage(SimplePerformanceMeter.this.pulseRateInternal, SimplePerformanceMeter.this.pulseRateAvgInternal, alpha);
                SimplePerformanceMeter.this.frameRateAvgInternal = SimplePerformanceMeter.computeAverage(SimplePerformanceMeter.this.frameRateInternal, SimplePerformanceMeter.this.frameRateAvgInternal, alpha);
                SimplePerformanceMeter.this.cpuLoadProcessAvgInternal = SimplePerformanceMeter.computeAverage(SimplePerformanceMeter.this.cpuLoadProcessInternal, SimplePerformanceMeter.this.cpuLoadProcessAvgInternal, alpha);
                SimplePerformanceMeter.this.cpuLoadSystemAvgInternal = SimplePerformanceMeter.computeAverage(SimplePerformanceMeter.this.cpuLoadSystemInternal, SimplePerformanceMeter.this.cpuLoadSystemAvgInternal, alpha);
                FXUtils.runFX(() -> SimplePerformanceMeter.this.updateProperties());
            }
        }, 0L, this.updateDuration);
        this.scene.addPostLayoutPulseListener(this.pulseListener);
    }

    public void resetAverages() {
        this.pulseRateInternal = -1.0;
        this.pulseRateAvgInternal = -1.0;
        this.frameRateInternal = -1.0;
        this.frameRateAvgInternal = -1.0;
        this.cpuLoadProcessInternal = -1.0;
        this.cpuLoadProcessAvgInternal = -1.0;
        this.cpuLoadSystemInternal = -1.0;
        this.cpuLoadSystemAvgInternal = -1.0;
    }

    public ReadOnlyDoubleProperty systemCpuLoadProperty() {
        return this.systemCpuLoad;
    }

    private void updateProperties() {
        this.pulseRate.set(this.pulseRateInternal);
        this.pulseRateAvg.set(this.pulseRateAvgInternal);
        this.trackerFrameRate.set(this.frameRateInternal);
        this.avgTrackerFrameRate.set(this.frameRateAvgInternal);
        this.processCpuLoad.set(this.cpuLoadProcessInternal);
        this.avgProcessCpuLoad.set(this.cpuLoadProcessAvgInternal);
        this.systemCpuLoad.set(this.cpuLoadSystemInternal);
        this.avgSystemCpuLoad.set(this.cpuLoadSystemAvgInternal);
        if (this.minProcessCpuLoad.get() < 0.0) {
            this.minProcessCpuLoad.set(this.processCpuLoad.get());
        } else {
            this.minProcessCpuLoad.set(Math.min(this.minProcessCpuLoad.get(), this.processCpuLoad.get()));
        }
        if (this.maxProcessCpuLoad.get() < 0.0) {
            this.maxProcessCpuLoad.set(this.processCpuLoad.get());
        } else {
            this.maxProcessCpuLoad.set(Math.max(this.maxProcessCpuLoad.get(), this.processCpuLoad.get()));
        }
    }

    public boolean isSceneDirty() {
        if (this.scene.getRoot() == null) {
            return false;
        }
        try {
            return this.dirtyNodesSize.getInt(this.scene) != 0 || this.dirtyRootBits.getInt(this.scene.getRoot()) != 0;
        }
        catch (IllegalAccessException | IllegalArgumentException ignoreException) {
            LOGGER.atError().setCause((Throwable)ignoreException).log("cannot access scene root's dirtyBits field");
            return true;
        }
    }

    protected static double computeAverage(double newValue, double oldValue, double alpha) {
        if (oldValue < 0.0) {
            return newValue;
        }
        return (1.0 - alpha) * oldValue + alpha * newValue;
    }

    public static double getProcessCpuLoadInternal() {
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        try {
            ObjectName name = ObjectName.getInstance("java.lang:type=OperatingSystem");
            AttributeList list = mbs.getAttributes(name, new String[]{"ProcessCpuLoad"});
            if (list.isEmpty()) {
                return Double.NaN;
            }
            Attribute att = (Attribute)list.get(0);
            Double value = (Double)att.getValue();
            if (value == -1.0) {
                return Double.NaN;
            }
            return (double)((int)(value * 1000.0)) / 10.0;
        }
        catch (NullPointerException | InstanceNotFoundException | MalformedObjectNameException | ReflectionException e) {
            return Double.NaN;
        }
    }
}

